/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class NullAnnotationMatching {
    public static final NullAnnotationMatching NULL_ANNOTATIONS_OK = new NullAnnotationMatching(Severity.OK, 1, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_OK_NONNULL = new NullAnnotationMatching(Severity.OK, 4, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_UNCHECKED = new NullAnnotationMatching(Severity.UNCHECKED, 1, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_MISMATCH = new NullAnnotationMatching(Severity.MISMATCH, 1, null);
    private final Severity severity;
    public final TypeBinding superTypeHint;
    public final int nullStatus;

    NullAnnotationMatching(Severity severity, int n, TypeBinding typeBinding) {
        this.severity = severity;
        this.superTypeHint = typeBinding;
        this.nullStatus = n;
    }

    public NullAnnotationMatching withNullStatus(int n) {
        return n == this.nullStatus ? this : new NullAnnotationMatching(this.severity, n, this.superTypeHint);
    }

    public boolean isAnyMismatch() {
        return this.severity.isAnyMismatch();
    }

    public boolean isUnchecked() {
        return this.severity == Severity.UNCHECKED || this.severity == Severity.UNCHECKED_TO_UNANNOTATED;
    }

    public boolean isAnnotatedToUnannotated() {
        return this.severity == Severity.UNCHECKED_TO_UNANNOTATED;
    }

    public boolean isDefiniteMismatch() {
        return this.severity == Severity.MISMATCH;
    }

    public boolean wantToReport() {
        return this.severity == Severity.LEGACY_WARNING;
    }

    public boolean isPotentiallyNullMismatch() {
        return !this.isDefiniteMismatch() && this.nullStatus != -1 && (this.nullStatus & 0x10) != 0;
    }

    public String superTypeHintName(CompilerOptions compilerOptions, boolean bl) {
        return String.valueOf(this.superTypeHint.nullAnnotatedReadableName(compilerOptions, bl));
    }

    public static int checkAssignment(BlockScope blockScope, FlowContext flowContext, VariableBinding variableBinding, FlowInfo flowInfo, int n, Expression expression, TypeBinding typeBinding) {
        if (typeBinding == null) {
            return 1;
        }
        long l = 0L;
        boolean bl = false;
        boolean bl2 = blockScope.environment().usesNullTypeAnnotations();
        if (!bl2) {
            l = variableBinding.tagBits & 0x180000000000000L;
        } else {
            if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
                int n2;
                ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
                int n3 = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, conditionalExpression.ifTrueNullStatus, conditionalExpression.valueIfTrue, conditionalExpression.valueIfTrue.resolvedType);
                if (n3 == (n2 = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, conditionalExpression.ifFalseNullStatus, conditionalExpression.valueIfFalse, conditionalExpression.valueIfFalse.resolvedType))) {
                    return n3;
                }
                return n;
            }
            if (expression instanceof SwitchExpression && expression.isPolyExpression()) {
                SwitchExpression switchExpression = (SwitchExpression)expression;
                Expression[] expressionArray = switchExpression.resultExpressions.toArray(new Expression[0]);
                Expression expression2 = expressionArray[0];
                int n4 = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, expression2.nullStatus(flowInfo, flowContext), expression2, expression2.resolvedType);
                boolean bl3 = true;
                int n5 = expressionArray.length;
                for (int i = 1; i < n5; ++i) {
                    expression2 = expressionArray[i];
                    int n6 = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, expression2.nullStatus(flowInfo, flowContext), expression2, expression2.resolvedType);
                    bl3 &= n4 == n6;
                }
                return bl3 ? n4 : n;
            }
            l = variableBinding.type.tagBits & 0x180000000000000L;
            NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(variableBinding.type, typeBinding, null, null, n, expression, CheckMode.COMPATIBLE);
            if (nullAnnotationMatching.isAnyMismatch()) {
                flowContext.recordNullityMismatch(blockScope, expression, typeBinding, variableBinding.type, flowInfo, n, nullAnnotationMatching);
                bl = true;
            } else {
                if (nullAnnotationMatching.wantToReport()) {
                    nullAnnotationMatching.report(blockScope);
                }
                if (nullAnnotationMatching.nullStatus != 1) {
                    return nullAnnotationMatching.nullStatus;
                }
            }
        }
        if (l == 0x100000000000000L && n != 4) {
            if (!bl) {
                flowContext.recordNullityMismatch(blockScope, expression, typeBinding, variableBinding.type, flowInfo, n, null);
            }
            return 4;
        }
        if (l == 0x80000000000000L && n == 1) {
            if (bl2 && typeBinding.isTypeVariable() && (typeBinding.tagBits & 0x180000000000000L) == 0L) {
                return 48;
            }
            return 24;
        }
        return n;
    }

    public static NullAnnotationMatching analyse(TypeBinding typeBinding, TypeBinding typeBinding2, int n) {
        return NullAnnotationMatching.analyse(typeBinding, typeBinding2, null, null, n, null, CheckMode.COMPATIBLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NullAnnotationMatching analyse(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, Substitution substitution, int n, Expression expression, CheckMode checkMode) {
        if (!typeBinding.enterRecursiveFunction()) {
            return NULL_ANNOTATIONS_OK;
        }
        try {
            Object object;
            int n2;
            Object object2;
            Severity severity = Severity.OK;
            TypeBinding typeBinding4 = null;
            TypeBinding typeBinding5 = typeBinding;
            NullAnnotationMatching nullAnnotationMatching = NULL_ANNOTATIONS_OK;
            if (NullAnnotationMatching.areSameTypes(typeBinding, typeBinding2, typeBinding3)) {
                if ((typeBinding.tagBits & 0x100000000000000L) != 0L) {
                    NullAnnotationMatching nullAnnotationMatching2 = NullAnnotationMatching.okNonNullStatus(expression);
                    return nullAnnotationMatching2;
                }
                NullAnnotationMatching nullAnnotationMatching3 = nullAnnotationMatching;
                return nullAnnotationMatching3;
            }
            if (typeBinding instanceof TypeVariableBinding && substitution != null && (checkMode == CheckMode.EXACT || checkMode == CheckMode.COMPATIBLE || checkMode == CheckMode.BOUND_SUPER_CHECK)) {
                typeBinding.exitRecursiveFunction();
                typeBinding = Scope.substitute(substitution, typeBinding);
                if (!typeBinding.enterRecursiveFunction()) {
                    NullAnnotationMatching nullAnnotationMatching4 = NULL_ANNOTATIONS_OK;
                    return nullAnnotationMatching4;
                }
                if (NullAnnotationMatching.areSameTypes(typeBinding, typeBinding2, typeBinding3)) {
                    if ((typeBinding.tagBits & 0x100000000000000L) != 0L) {
                        NullAnnotationMatching nullAnnotationMatching5 = NullAnnotationMatching.okNonNullStatus(expression);
                        return nullAnnotationMatching5;
                    }
                    NullAnnotationMatching nullAnnotationMatching6 = nullAnnotationMatching;
                    return nullAnnotationMatching6;
                }
            }
            if (checkMode == CheckMode.BOUND_CHECK && typeBinding instanceof TypeVariableBinding) {
                boolean bl;
                boolean bl2 = bl = substitution instanceof ParameterizedTypeBinding && (((ParameterizedTypeBinding)substitution).tagBits & 0x400000L) != 0L;
                if (!bl) {
                    ReferenceBinding referenceBinding = typeBinding.superclass();
                    if (referenceBinding != null && (referenceBinding.hasNullTypeAnnotations() || substitution != null)) {
                        object2 = NullAnnotationMatching.analyse(referenceBinding, typeBinding2, null, substitution, n, expression, CheckMode.BOUND_SUPER_CHECK);
                        if ((severity = severity.max(object2.severity)) == Severity.MISMATCH) {
                            NullAnnotationMatching nullAnnotationMatching7 = new NullAnnotationMatching(severity, n, typeBinding4);
                            return nullAnnotationMatching7;
                        }
                    }
                    if ((object2 = typeBinding.superInterfaces()) != null) {
                        for (n2 = 0; n2 < ((ReferenceBinding[])object2).length; ++n2) {
                            if (!object2[n2].hasNullTypeAnnotations() && substitution == null) continue;
                            object = NullAnnotationMatching.analyse(object2[n2], typeBinding2, null, substitution, n, expression, CheckMode.BOUND_SUPER_CHECK);
                            if ((severity = severity.max(object.severity)) != Severity.MISMATCH) continue;
                            NullAnnotationMatching nullAnnotationMatching8 = new NullAnnotationMatching(severity, n, typeBinding4);
                            return nullAnnotationMatching8;
                        }
                    }
                }
            }
            if (typeBinding instanceof ArrayBinding) {
                long[] lArray = ((ArrayBinding)typeBinding).nullTagBitsPerDimension;
                if (lArray != null) {
                    int n3 = typeBinding.dimensions();
                    if (typeBinding.dimensions() == typeBinding2.dimensions()) {
                        object2 = ((ArrayBinding)typeBinding2).nullTagBitsPerDimension;
                        if (object2 == null) {
                            object2 = new long[n3 + 1];
                        }
                        n2 = n;
                        for (int i = 0; i <= n3; ++i) {
                            long l = NullAnnotationMatching.validNullTagBits(lArray[i]);
                            long l2 = NullAnnotationMatching.validNullTagBits((long)object2[i]);
                            if (i == 0 && l == 0x80000000000000L && n != -1 && checkMode.requiredNullableMatchesAll()) {
                                if (n == 2) {
                                    break;
                                }
                            } else {
                                Expression[] expressionArray;
                                Expression expression2;
                                if (i > 0) {
                                    n2 = -1;
                                }
                                Severity severity2 = NullAnnotationMatching.computeNullProblemSeverity(l, l2, n2, i == 0 ? checkMode : checkMode.toDetail(), null);
                                if (i > 0 && severity2 == Severity.UNCHECKED && expression instanceof ArrayAllocationExpression && l2 == 0L && l != 0L && (expression2 = (expressionArray = ((ArrayAllocationExpression)expression).dimensions)[i - 1]) instanceof IntLiteral && expression2.constant.intValue() == 0) {
                                    severity2 = Severity.OK;
                                    n = -1;
                                    break;
                                }
                                if ((severity = severity.max(severity2)) == Severity.MISMATCH) {
                                    if (n == 2) {
                                        expressionArray = new NullAnnotationMatching(severity, n, null);
                                        return expressionArray;
                                    }
                                    expressionArray = NULL_ANNOTATIONS_MISMATCH;
                                    return expressionArray;
                                }
                            }
                            if (severity != Severity.OK) continue;
                            n = -1;
                        }
                    } else if (typeBinding2.id == 12 && n3 > 0 && lArray[0] == 0x100000000000000L) {
                        object2 = NULL_ANNOTATIONS_MISMATCH;
                        return object2;
                    }
                }
            } else if (typeBinding.hasNullTypeAnnotations() || typeBinding2.hasNullTypeAnnotations() || typeBinding.isTypeVariable()) {
                TypeBinding[] typeBindingArray;
                long l = NullAnnotationMatching.requiredNullTagBits(typeBinding, checkMode);
                if (l != 0x80000000000000L || n == -1 || !checkMode.requiredNullableMatchesAll()) {
                    long l3 = NullAnnotationMatching.providedNullTagBits(typeBinding2);
                    object = NullAnnotationMatching.computeNullProblemSeverity(l, l3, n, checkMode, typeBinding5);
                    if (object.isAnyMismatch() && typeBinding.isWildcard() && l != 0L && ((WildcardBinding)typeBinding).determineNullBitsFromDeclaration(null, null) == 0L) {
                        typeBindingArray = ((WildcardBinding)typeBinding).typeVariable();
                        if ((typeBindingArray.tagBits & 0x180000000000000L) != 0L) {
                            object = Severity.OK;
                        }
                    }
                    if (!(severity = severity.max((Severity)((Object)object))).isAnyMismatch() && (l3 & 0x180000000000000L) == 0x100000000000000L) {
                        nullAnnotationMatching = NullAnnotationMatching.okNonNullStatus(expression);
                    }
                }
                if (severity != Severity.MISMATCH && n != 2) {
                    ReferenceBinding referenceBinding;
                    TypeBinding typeBinding6;
                    TypeBinding typeBinding7 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                    TypeBinding typeBinding8 = typeBinding6 = typeBinding3 != null ? typeBinding3.findSuperTypeOriginatingFrom(typeBinding) : null;
                    if (severity == Severity.UNCHECKED && typeBinding.isTypeVariable() && typeBinding2.isTypeVariable() && (typeBinding7 == typeBinding || typeBinding6 == typeBinding)) {
                        severity = Severity.OK;
                    }
                    if (typeBinding7 != typeBinding2) {
                        typeBinding4 = typeBinding7;
                    }
                    if (typeBinding.isParameterizedType() && typeBinding7 instanceof ParameterizedTypeBinding) {
                        object = ((ParameterizedTypeBinding)typeBinding).arguments;
                        typeBindingArray = ((ParameterizedTypeBinding)typeBinding7).arguments;
                        Object object3 = referenceBinding = typeBinding6 instanceof ParameterizedTypeBinding ? ((ParameterizedTypeBinding)typeBinding6).arguments : null;
                        if (object != null && typeBindingArray != null && ((TypeBinding[])object).length == typeBindingArray.length) {
                            for (int i = 0; i < ((TypeBinding[])object).length; ++i) {
                                ReferenceBinding referenceBinding2 = referenceBinding != null ? referenceBinding[i] : null;
                                NullAnnotationMatching nullAnnotationMatching9 = NullAnnotationMatching.analyse(object[i], typeBindingArray[i], referenceBinding2, substitution, -1, expression, checkMode.toDetail());
                                if ((severity = severity.max(nullAnnotationMatching9.severity)) != Severity.MISMATCH) continue;
                                NullAnnotationMatching nullAnnotationMatching10 = new NullAnnotationMatching(severity, n, typeBinding4);
                                return nullAnnotationMatching10;
                            }
                        }
                    }
                    object = typeBinding.enclosingType();
                    typeBindingArray = typeBinding2.enclosingType();
                    if (object != null && typeBindingArray != null) {
                        referenceBinding = typeBinding3 != null ? typeBinding3.enclosingType() : null;
                        NullAnnotationMatching nullAnnotationMatching11 = NullAnnotationMatching.analyse((TypeBinding)object, (TypeBinding)typeBindingArray, referenceBinding, substitution, -1, expression, checkMode);
                        severity = severity.max(nullAnnotationMatching11.severity);
                    }
                }
            }
            if (!severity.isAnyMismatch()) {
                NullAnnotationMatching nullAnnotationMatching12 = nullAnnotationMatching;
                return nullAnnotationMatching12;
            }
            NullAnnotationMatching nullAnnotationMatching13 = new NullAnnotationMatching(severity, n, typeBinding4);
            return nullAnnotationMatching13;
        }
        finally {
            typeBinding.exitRecursiveFunction();
        }
    }

    public void report(Scope scope) {
    }

    public static NullAnnotationMatching okNonNullStatus(final Expression expression) {
        MethodBinding methodBinding;
        if (expression instanceof MessageSend && (methodBinding = ((MessageSend)expression).binding) != null && methodBinding.isValidBinding()) {
            MethodBinding methodBinding2 = methodBinding.original();
            ReferenceBinding referenceBinding = methodBinding2.declaringClass;
            if (referenceBinding instanceof BinaryTypeBinding && ((BinaryTypeBinding)referenceBinding).externalAnnotationStatus.isPotentiallyUnannotatedLib() && methodBinding2.returnType.isTypeVariable() && (methodBinding2.returnType.tagBits & 0x180000000000000L) == 0L) {
                final int n = ((BinaryTypeBinding)referenceBinding).externalAnnotationStatus == BinaryTypeBinding.ExternalAnnotationStatus.NO_EEA_FILE ? 0 : 1024;
                return new NullAnnotationMatching(Severity.LEGACY_WARNING, 1, null){

                    @Override
                    public void report(Scope scope) {
                        scope.problemReporter().nonNullTypeVariableInUnannotatedBinary(scope.environment(), methodBinding, expression, n);
                    }
                };
            }
        }
        return NULL_ANNOTATIONS_OK_NONNULL;
    }

    protected static boolean areSameTypes(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding.isParameterizedType() || typeBinding.isArrayType()) {
            return false;
        }
        if (TypeBinding.notEquals(typeBinding, typeBinding2)) {
            if (typeBinding instanceof CaptureBinding) {
                TypeBinding typeBinding4 = ((CaptureBinding)typeBinding).lowerBound;
                if (typeBinding4 != null && NullAnnotationMatching.areSameTypes(typeBinding4, typeBinding2, typeBinding3)) {
                    return (typeBinding.tagBits & 0x180000000000000L) == (typeBinding2.tagBits & 0x180000000000000L);
                }
            } else {
                TypeBinding typeBinding5;
                if (typeBinding.kind() == 4100 && typeBinding == typeBinding3) {
                    return true;
                }
                if (typeBinding2 instanceof CaptureBinding && (typeBinding5 = ((CaptureBinding)typeBinding2).upperBound()) != null && NullAnnotationMatching.areSameTypes(typeBinding, typeBinding5, typeBinding3)) {
                    return (typeBinding.tagBits & 0x180000000000000L) == (typeBinding2.tagBits & 0x180000000000000L);
                }
            }
            return false;
        }
        return (typeBinding.tagBits & 0x180000000000000L) == (typeBinding2.tagBits & 0x180000000000000L);
    }

    static long requiredNullTagBits(TypeBinding typeBinding, CheckMode checkMode) {
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l != 0L) {
            return NullAnnotationMatching.validNullTagBits(l);
        }
        if (typeBinding.isWildcard()) {
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            TypeBinding typeBinding2 = wildcardBinding.bound;
            l = typeBinding2 != null ? typeBinding2.tagBits & 0x180000000000000L : 0L;
            switch (wildcardBinding.boundKind) {
                case 2: {
                    if (l != 0x80000000000000L) break;
                    return 0x80000000000000L;
                }
                case 1: {
                    if (l != 0x100000000000000L) break;
                    return l;
                }
            }
            return 0x180000000000000L;
        }
        if (typeBinding.isTypeVariable()) {
            TypeBinding typeBinding3;
            if (typeBinding.isCapture() && (typeBinding3 = ((CaptureBinding)typeBinding).lowerBound) != null && (l = typeBinding3.tagBits & 0x180000000000000L) == 0x80000000000000L) {
                return 0x80000000000000L;
            }
            switch (checkMode) {
                case BOUND_CHECK: 
                case BOUND_SUPER_CHECK: 
                case OVERRIDE: 
                case OVERRIDE_RETURN: {
                    break;
                }
                default: {
                    return 0x100000000000000L;
                }
            }
        }
        return 0L;
    }

    static long providedNullTagBits(TypeBinding typeBinding) {
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l != 0L) {
            return NullAnnotationMatching.validNullTagBits(l);
        }
        if (typeBinding.isWildcard()) {
            return 0x180000000000000L;
        }
        if (typeBinding.isTypeVariable()) {
            TypeBinding typeBinding2;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
            boolean bl = false;
            if (typeVariableBinding.isCapture() && (typeBinding2 = ((CaptureBinding)typeVariableBinding).lowerBound) != null) {
                l = typeBinding2.tagBits & 0x180000000000000L;
                if (l == 0x80000000000000L) {
                    return 0x80000000000000L;
                }
                bl |= l != 0L;
            }
            if (typeVariableBinding.firstBound != null) {
                long l2 = typeVariableBinding.firstBound.tagBits & 0x180000000000000L;
                if (l2 == 0x100000000000000L) {
                    return 0x100000000000000L;
                }
                bl |= l2 != 0L;
            }
            if (bl) {
                return 0x180000000000000L;
            }
        }
        return 0L;
    }

    public static int nullStatusFromExpressionType(TypeBinding typeBinding) {
        if (typeBinding.isFreeTypeVariable()) {
            return 48;
        }
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l == 0L) {
            return 1;
        }
        if (l == 0x100000000000000L) {
            return 4;
        }
        return 48;
    }

    public static long validNullTagBits(long l) {
        return (l &= 0x180000000000000L) == 0x180000000000000L ? 0L : l;
    }

    public static TypeBinding moreDangerousType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        long l;
        if (typeBinding == null) {
            return null;
        }
        long l2 = NullAnnotationMatching.validNullTagBits(typeBinding.tagBits);
        if (l2 != (l = NullAnnotationMatching.validNullTagBits(typeBinding2.tagBits))) {
            if (l2 == 0x80000000000000L) {
                return typeBinding;
            }
            if (l == 0x80000000000000L) {
                return typeBinding2;
            }
            if (l2 == 0L) {
                return typeBinding;
            }
            return typeBinding2;
        }
        if (typeBinding != typeBinding2 && NullAnnotationMatching.analyse(typeBinding, typeBinding2, -1).isAnyMismatch()) {
            return typeBinding2;
        }
        return typeBinding;
    }

    private static Severity computeNullProblemSeverity(long l, long l2, int n, CheckMode checkMode, TypeBinding typeBinding) {
        if (l == l2) {
            return Severity.OK;
        }
        if (l == 0L) {
            switch (checkMode) {
                case EXACT: {
                    if (l2 == 0x100000000000000L && !(typeBinding instanceof TypeVariableBinding)) {
                        return Severity.UNCHECKED_TO_UNANNOTATED;
                    }
                    return Severity.OK;
                }
                case BOUND_CHECK: 
                case BOUND_SUPER_CHECK: 
                case COMPATIBLE: {
                    return Severity.OK;
                }
                case OVERRIDE_RETURN: {
                    if (l2 == 0x100000000000000L) {
                        return Severity.OK;
                    }
                    if (!(typeBinding instanceof TypeVariableBinding)) {
                        return Severity.OK;
                    }
                    return Severity.UNCHECKED;
                }
                case OVERRIDE: {
                    return Severity.UNCHECKED;
                }
            }
        } else {
            if (l == 0x180000000000000L) {
                if (checkMode == CheckMode.EXACT && l2 == 0x100000000000000L && typeBinding instanceof WildcardBinding) {
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                    if (wildcardBinding.boundKind == 2 && l2 == 0x100000000000000L) {
                        TypeBinding typeBinding2 = wildcardBinding.bound;
                        if (typeBinding2 != null && (typeBinding2.tagBits & 0x180000000000000L) != 0L) {
                            return Severity.OK;
                        }
                        return Severity.UNCHECKED_TO_UNANNOTATED;
                    }
                }
                return Severity.OK;
            }
            if (l == 0x100000000000000L) {
                switch (checkMode) {
                    case COMPATIBLE: {
                        if (n == 2) {
                            return Severity.MISMATCH;
                        }
                    }
                    case BOUND_SUPER_CHECK: {
                        if (n == 4) {
                            return Severity.OK;
                        }
                    }
                    case BOUND_CHECK: 
                    case OVERRIDE: 
                    case OVERRIDE_RETURN: 
                    case EXACT: {
                        if (l2 == 0L) {
                            return Severity.UNCHECKED;
                        }
                        return Severity.MISMATCH;
                    }
                }
            } else if (l == 0x80000000000000L) {
                switch (checkMode) {
                    case BOUND_SUPER_CHECK: 
                    case OVERRIDE_RETURN: 
                    case COMPATIBLE: {
                        return Severity.OK;
                    }
                    case BOUND_CHECK: 
                    case EXACT: {
                        if (l2 == 0L) {
                            return Severity.UNCHECKED;
                        }
                        return Severity.MISMATCH;
                    }
                    case OVERRIDE: {
                        return Severity.MISMATCH;
                    }
                }
            }
        }
        return Severity.OK;
    }

    public static MethodBinding checkForContradictions(MethodBinding methodBinding, Object object, Scope scope) {
        int n = 0;
        int n2 = 0;
        if (object instanceof InvocationSite) {
            n = ((InvocationSite)object).sourceStart();
            n2 = ((InvocationSite)object).sourceEnd();
        } else if (object instanceof ASTNode) {
            n = ((ASTNode)object).sourceStart;
            n2 = ((ASTNode)object).sourceEnd;
        }
        SearchContradictions searchContradictions = new SearchContradictions();
        TypeBindingVisitor.visit((TypeBindingVisitor)searchContradictions, methodBinding.returnType);
        if (searchContradictions.typeWithContradiction != null) {
            if (scope == null) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 25);
            }
            scope.problemReporter().contradictoryNullAnnotationsInferred(methodBinding, n, n2, object instanceof FunctionalExpression);
            return methodBinding;
        }
        Expression[] expressionArray = null;
        if (object instanceof Invocation) {
            expressionArray = ((Invocation)object).arguments();
        }
        for (int i = 0; i < methodBinding.parameters.length; ++i) {
            TypeBindingVisitor.visit((TypeBindingVisitor)searchContradictions, methodBinding.parameters[i]);
            if (searchContradictions.typeWithContradiction == null) continue;
            if (scope == null) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 25);
            }
            if (expressionArray != null && i < expressionArray.length) {
                scope.problemReporter().contradictoryNullAnnotationsInferred(methodBinding, expressionArray[i]);
            } else {
                scope.problemReporter().contradictoryNullAnnotationsInferred(methodBinding, n, n2, object instanceof FunctionalExpression);
            }
            return methodBinding;
        }
        return methodBinding;
    }

    public static boolean hasContradictions(TypeBinding typeBinding) {
        SearchContradictions searchContradictions = new SearchContradictions();
        TypeBindingVisitor.visit((TypeBindingVisitor)searchContradictions, typeBinding);
        return searchContradictions.typeWithContradiction != null;
    }

    public static TypeBinding strongerType(TypeBinding typeBinding, TypeBinding typeBinding2, LookupEnvironment lookupEnvironment) {
        if ((typeBinding.tagBits & 0x100000000000000L) != 0L) {
            return NullAnnotationMatching.mergeTypeAnnotations(typeBinding, typeBinding2, true, lookupEnvironment);
        }
        return NullAnnotationMatching.mergeTypeAnnotations(typeBinding2, typeBinding, true, lookupEnvironment);
    }

    public static TypeBinding[] weakerTypes(TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2, LookupEnvironment lookupEnvironment) {
        TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray.length];
        for (int i = 0; i < typeBindingArray3.length; ++i) {
            long l = typeBindingArray[i].tagBits;
            long l2 = typeBindingArray2[i].tagBits;
            typeBindingArray3[i] = (l & 0x80000000000000L) != 0L ? NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray[i], typeBindingArray2[i], true, lookupEnvironment) : ((l2 & 0x80000000000000L) != 0L ? NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray2[i], typeBindingArray[i], true, lookupEnvironment) : ((l & 0x100000000000000L) == 0L ? NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray[i], typeBindingArray2[i], true, lookupEnvironment) : NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray2[i], typeBindingArray[i], true, lookupEnvironment)));
        }
        return typeBindingArray3;
    }

    private static TypeBinding mergeTypeAnnotations(TypeBinding typeBinding, TypeBinding typeBinding2, boolean bl, LookupEnvironment lookupEnvironment) {
        Object object;
        TypeBinding typeBinding3 = typeBinding;
        if (!bl && (object = typeBinding2.getTypeAnnotations()) != Binding.NO_ANNOTATIONS) {
            typeBinding3 = lookupEnvironment.createAnnotatedType(typeBinding, (AnnotationBinding[])object);
        }
        if (typeBinding3.isParameterizedType() && typeBinding2.isParameterizedType()) {
            object = (ParameterizedTypeBinding)typeBinding;
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding2;
            TypeBinding[] typeBindingArray = ((ParameterizedTypeBinding)object).arguments;
            TypeBinding[] typeBindingArray2 = parameterizedTypeBinding.arguments;
            TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray.length];
            for (int i = 0; i < typeBindingArray.length; ++i) {
                typeBindingArray3[i] = NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray[i], typeBindingArray2[i], false, lookupEnvironment);
            }
            return lookupEnvironment.createParameterizedType(((ParameterizedTypeBinding)object).genericType(), typeBindingArray3, ((ParameterizedTypeBinding)object).enclosingType());
        }
        return typeBinding3;
    }

    public String toString() {
        if (this == NULL_ANNOTATIONS_OK) {
            return "OK";
        }
        if (this == NULL_ANNOTATIONS_MISMATCH) {
            return "MISMATCH";
        }
        if (this == NULL_ANNOTATIONS_OK_NONNULL) {
            return "OK NonNull";
        }
        if (this == NULL_ANNOTATIONS_UNCHECKED) {
            return "UNCHECKED";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Analysis result: severity=" + (Object)((Object)this.severity));
        stringBuilder.append(" nullStatus=" + this.nullStatus);
        return stringBuilder.toString();
    }

    private static enum Severity {
        OK,
        LEGACY_WARNING,
        UNCHECKED,
        UNCHECKED_TO_UNANNOTATED,
        MISMATCH;


        public Severity max(Severity severity) {
            if (this.compareTo(severity) < 0) {
                return severity;
            }
            return this;
        }

        public boolean isAnyMismatch() {
            return this.compareTo(LEGACY_WARNING) > 0;
        }
    }

    public static enum CheckMode {
        COMPATIBLE{

            @Override
            boolean requiredNullableMatchesAll() {
                return true;
            }
        }
        ,
        EXACT,
        BOUND_CHECK,
        BOUND_SUPER_CHECK,
        OVERRIDE_RETURN{

            @Override
            CheckMode toDetail() {
                return OVERRIDE;
            }
        }
        ,
        OVERRIDE{

            @Override
            boolean requiredNullableMatchesAll() {
                return true;
            }

            @Override
            CheckMode toDetail() {
                return OVERRIDE;
            }
        };


        boolean requiredNullableMatchesAll() {
            return false;
        }

        CheckMode toDetail() {
            return EXACT;
        }
    }

    static class SearchContradictions
    extends TypeBindingVisitor {
        ReferenceBinding typeWithContradiction;

        SearchContradictions() {
        }

        @Override
        public boolean visit(ReferenceBinding referenceBinding) {
            if ((referenceBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                this.typeWithContradiction = referenceBinding;
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(TypeVariableBinding typeVariableBinding) {
            if (!this.visit((ReferenceBinding)typeVariableBinding)) {
                return false;
            }
            long l = typeVariableBinding.tagBits & 0x180000000000000L;
            if (typeVariableBinding.firstBound != null) {
                l = typeVariableBinding.firstBound.tagBits & 0x180000000000000L;
            }
            for (TypeBinding typeBinding : typeVariableBinding.otherUpperBounds()) {
                l |= typeBinding.tagBits & 0x180000000000000L;
            }
            if (l == 0x180000000000000L) {
                this.typeWithContradiction = typeVariableBinding;
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(RawTypeBinding rawTypeBinding) {
            return this.visit((ReferenceBinding)rawTypeBinding);
        }

        @Override
        public boolean visit(WildcardBinding wildcardBinding) {
            long l = wildcardBinding.tagBits & 0x180000000000000L;
            switch (wildcardBinding.boundKind) {
                case 1: {
                    l |= wildcardBinding.bound.tagBits & 0x100000000000000L;
                    break;
                }
                case 2: {
                    l |= wildcardBinding.bound.tagBits & 0x80000000000000L;
                }
            }
            if (l == 0x180000000000000L) {
                this.typeWithContradiction = wildcardBinding;
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(ParameterizedTypeBinding parameterizedTypeBinding) {
            if (!this.visit((ReferenceBinding)parameterizedTypeBinding)) {
                return false;
            }
            return super.visit(parameterizedTypeBinding);
        }
    }
}

