/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts;

import eu.hansolo.enzo.charts.SimpleRadarChart;
import java.time.LocalDate;
import java.util.Random;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class DemoSimpleRadarChart
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private SimpleRadarChart chart;

    public void init() {
        this.chart = new SimpleRadarChart();
        this.chart.setTitle("Temperature\n" + LocalDate.now());
        this.chart.setUnit("\u00b0C");
        this.chart.setScaleVisible(true);
        this.chart.setMinValue(-15.0);
        this.chart.setMaxValue(40.0);
        this.chart.setZeroLineVisible(true);
        this.chart.setFilled(true);
        this.chart.setNoOfSectors(24);
        for (int i = 0; i <= 24; ++i) {
            this.chart.addData(i, (XYChart.Data<String, Double>)new XYChart.Data((Object)(i < 10 ? "0" + i + ":00" : i + ":00"), (Object)(RND.nextDouble() * 55.0 - 15.0)));
        }
        this.chart.setGradientStops(new Stop(0.0, Color.web((String)"#3552a0")), new Stop(0.0909, Color.web((String)"#456acf")), new Stop(0.27272, Color.web((String)"#45a1cf")), new Stop(0.36363, Color.web((String)"#30c8c9")), new Stop(0.45454, Color.web((String)"#30c9af")), new Stop(0.50909, Color.web((String)"#56d483")), new Stop(0.72727, Color.web((String)"#9adb49")), new Stop(0.81818, Color.web((String)"#efd750")), new Stop(0.90909, Color.web((String)"#ef9850")), new Stop(1.0, Color.web((String)"#ef6050")));
        this.chart.setPolygonMode(true);
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        pane.getChildren().addAll((Object[])new Node[]{this.chart});
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Demo SimpleRadarChart");
        stage.setScene(scene);
        stage.show();
        DemoSimpleRadarChart.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        DemoSimpleRadarChart.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoSimpleRadarChart.calcNoOfNodes(n);
            }
        }
    }
}

