/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts;

import eu.hansolo.enzo.charts.skin.SimpleRadarChartSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.util.Duration;

public class SimpleRadarChart
extends Control {
    private static final int MAX_NO_OF_SECTORS = 24;
    private static final Color DEFAULT_CHART_BACKGROUND = Color.web((String)"#ffffff");
    private static final Color DEFAULT_CHART_FOREGROUND = Color.web((String)"#dddddd");
    private static final Color DEFAULT_CHART_TEXT = Color.web((String)"#5c7490");
    private static final Paint DEFAULT_CHART_FILL = Color.web((String)"#8b8a8f");
    private static final Color DEFAULT_CHART_STROKE = Color.web((String)"#8b8a8f");
    private static final Color DEFAULT_ZERO_LINE_COLOR = Color.web((String)"#f00000");
    private IntegerProperty noOfSectors;
    private ObservableMap<Integer, XYChart.Data<String, Double>> data;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private StringProperty title;
    private StringProperty unit;
    private BooleanProperty scaleVisible;
    private BooleanProperty polygonMode;
    private ObservableList<Stop> gradientStops;
    private BooleanProperty zeroLineVisible;
    private BooleanProperty filled;
    private ObjectProperty<Color> chartBackground;
    private ObjectProperty<Color> chartForeground;
    private ObjectProperty<Color> chartText;
    private ObjectProperty<Paint> chartFill;
    private ObjectProperty<Color> chartStroke;
    private ObjectProperty<Color> zeroLineColor;

    public SimpleRadarChart() {
        this.getStyleClass().add((Object)"simple-pie-chart");
        this.minValue = new DoublePropertyBase(0.0){

            public void set(double MIN_VALUE) {
                super.set(SimpleRadarChart.this.clamp(-1.7976931348623157E308, SimpleRadarChart.this.getMaxValue(), MIN_VALUE));
            }

            public Object getBean() {
                return SimpleRadarChart.this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(100.0){

            public void set(double MAX_VALUE) {
                super.set(SimpleRadarChart.this.clamp(SimpleRadarChart.this.getMinValue(), Double.MAX_VALUE, MAX_VALUE));
            }

            public Object getBean() {
                return SimpleRadarChart.this;
            }

            public String getName() {
                return "maxValue";
            }
        };
        this.gradientStops = FXCollections.observableArrayList();
        this.initData();
    }

    private void initData() {
        this.data = FXCollections.observableHashMap();
        for (int i = 0; i < this.getNoOfSectors() + 1; ++i) {
            this.data.put((Object)i, (Object)new XYChart.Data((Object)(i < 10 ? "0" + i + ":00" : i + ":00"), (Object)0.0));
        }
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final ReadOnlyDoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final ReadOnlyDoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final ObservableList<Stop> getGradientStops() {
        return this.gradientStops;
    }

    public final void setGradientStops(List<Stop> GRADIENT_STOPS) {
        this.gradientStops.setAll(GRADIENT_STOPS);
    }

    public final void setGradientStops(Stop ... GRADIENT_STOPS) {
        this.gradientStops.setAll((Object[])GRADIENT_STOPS);
    }

    public final void addGradientStop(Stop GRADIENT_STOP) {
        this.gradientStops.add((Object)GRADIENT_STOP);
    }

    public final String getTitle() {
        return null == this.title ? "" : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        this.titleProperty().set((Object)TITLE);
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", "");
        }
        return this.title;
    }

    public final String getUnit() {
        return null == this.unit ? "" : (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        this.unitProperty().set((Object)UNIT);
    }

    public final StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new SimpleStringProperty((Object)this, "unit", "");
        }
        return this.unit;
    }

    public final boolean isScaleVisible() {
        return null == this.scaleVisible ? false : this.scaleVisible.get();
    }

    public final void setScaleVisible(boolean SCALE_VISIBLE) {
        this.scaleVisibleProperty().set(SCALE_VISIBLE);
    }

    public final BooleanProperty scaleVisibleProperty() {
        if (null == this.scaleVisible) {
            this.scaleVisible = new SimpleBooleanProperty((Object)this, "scaleVisible", false);
        }
        return this.scaleVisible;
    }

    public final boolean isPolygonMode() {
        return null == this.polygonMode ? true : this.polygonMode.get();
    }

    public final void setPolygonMode(boolean POLYGON_MODE) {
        this.polygonModeProperty().set(POLYGON_MODE);
    }

    public final BooleanProperty polygonModeProperty() {
        if (null == this.polygonMode) {
            this.polygonMode = new SimpleBooleanProperty((Object)this, "polygonMode", true);
        }
        return this.polygonMode;
    }

    public int getNoOfSectors() {
        return null == this.noOfSectors ? 24 : this.noOfSectors.get();
    }

    public void setNoOfSectors(int NO_OF_SECTORS) {
        this.noOfSectorsProperty().set(NO_OF_SECTORS);
    }

    public IntegerProperty noOfSectorsProperty() {
        if (null == this.noOfSectors) {
            this.noOfSectors = new IntegerPropertyBase(24){

                public void set(int NO_OF_SECTORS) {
                    super.set(SimpleRadarChart.this.clamp(1, 24, NO_OF_SECTORS));
                }

                public Object getBean() {
                    return SimpleRadarChart.this;
                }

                public String getName() {
                    return "noOfSectors";
                }
            };
        }
        return this.noOfSectors;
    }

    public final ObservableMap<Integer, XYChart.Data<String, Double>> getData() {
        return this.data;
    }

    public final void setData(Map<Integer, XYChart.Data<String, Double>> DATA) {
        if (DATA.size() > 24) {
            throw new IllegalArgumentException("Too many sectors (max. " + this.getNoOfSectors() + " sectors allowed)");
        }
        for (Integer key : DATA.keySet()) {
            this.addData(key, DATA.get(key));
        }
    }

    public final void addData(int KEY, XYChart.Data<String, Double> DATA) {
        if (KEY < 0 || KEY > this.getNoOfSectors() + 1) {
            throw new IllegalArgumentException("Too many sectors (max. " + this.getNoOfSectors() + " sectors allowed)");
        }
        DATA.setYValue((Object)this.clamp(this.getMinValue(), this.getMaxValue(), (Double)DATA.getYValue()));
        this.data.put((Object)KEY, DATA);
    }

    public final XYChart.Data<String, Double> getData(int KEY) {
        return this.data.containsKey((Object)KEY) ? (XYChart.Data)this.data.get((Object)KEY) : new XYChart.Data((Object)"", (Object)this.getMinValue());
    }

    public final void reset() {
        for (int i = 0; i < 25; ++i) {
            ((XYChart.Data)this.data.get((Object)i)).setYValue((Object)0.0);
        }
    }

    public final boolean isZeroLineVisible() {
        return null == this.zeroLineVisible ? false : this.zeroLineVisible.get();
    }

    public final void setZeroLineVisible(boolean ZERO_LINE_VISIBLE) {
        this.zeroLineVisibleProperty().set(ZERO_LINE_VISIBLE);
    }

    public final BooleanProperty zeroLineVisibleProperty() {
        if (null == this.zeroLineVisible) {
            this.zeroLineVisible = new SimpleBooleanProperty((Object)this, "zeroLineVisible", false);
        }
        return this.zeroLineVisible;
    }

    public final boolean isFilled() {
        return null == this.filled ? true : this.filled.get();
    }

    public final void setFilled(boolean FILLED) {
        this.filledProperty().set(FILLED);
    }

    public final BooleanProperty filledProperty() {
        if (null == this.filled) {
            this.filled = new SimpleBooleanProperty((Object)this, "filled", true);
        }
        return this.filled;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private Duration clamp(Duration MIN_VALUE, Duration MAX_VALUE, Duration VALUE) {
        if (VALUE.lessThan(MIN_VALUE)) {
            return MIN_VALUE;
        }
        if (VALUE.greaterThan(MAX_VALUE)) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public final Color getChartBackground() {
        return null == this.chartBackground ? DEFAULT_CHART_BACKGROUND : (Color)this.chartBackground.get();
    }

    public final void setChartBackground(Color CHART_BACKGROUND) {
        this.chartBackgroundProperty().set((Object)CHART_BACKGROUND);
    }

    public final ObjectProperty<Color> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new StyleableObjectProperty<Color>(DEFAULT_CHART_BACKGROUND){

                public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                    return StyleableProperties.CHART_BACKGROUND;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
        }
        return this.chartBackground;
    }

    public final Color getChartForeground() {
        return null == this.chartForeground ? DEFAULT_CHART_FOREGROUND : (Color)this.chartForeground.get();
    }

    public final void setChartForeground(Color CHART_FOREGROUND) {
        this.chartForegroundProperty().set((Object)CHART_FOREGROUND);
    }

    public final ObjectProperty<Color> chartForegroundProperty() {
        if (null == this.chartForeground) {
            this.chartForeground = new StyleableObjectProperty<Color>(DEFAULT_CHART_FOREGROUND){

                public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                    return StyleableProperties.CHART_FOREGROUND;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "chartForeground";
                }
            };
        }
        return this.chartBackground;
    }

    public final Color getChartText() {
        return null == this.chartText ? DEFAULT_CHART_TEXT : (Color)this.chartText.get();
    }

    public final void setChartText(Color value) {
        this.chartTextProperty().set((Object)value);
    }

    public final ObjectProperty<Color> chartTextProperty() {
        if (null == this.chartText) {
            this.chartText = new StyleableObjectProperty<Color>(DEFAULT_CHART_TEXT){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.CHART_TEXT;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "chartText";
                }
            };
        }
        return this.chartText;
    }

    public final Paint getChartFill() {
        return null == this.chartFill ? DEFAULT_CHART_FILL : (Paint)this.chartFill.get();
    }

    public final void setChartFill(Paint CHART_FILL) {
        this.chartFillProperty().set((Object)CHART_FILL);
    }

    public final ObjectProperty<Paint> chartFillProperty() {
        if (null == this.chartFill) {
            this.chartFill = new StyleableObjectProperty<Paint>(DEFAULT_CHART_FILL){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.CHART_FILL;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "chartFill";
                }
            };
        }
        return this.chartFill;
    }

    public final Color getChartStroke() {
        return null == this.chartStroke ? DEFAULT_CHART_STROKE : (Color)this.chartStroke.get();
    }

    public final void setChartStroke(Color CHART_STROKE) {
        this.chartStrokeProperty().set((Object)CHART_STROKE);
    }

    public final ObjectProperty<Color> chartStrokeProperty() {
        if (null == this.chartStroke) {
            this.chartStroke = new StyleableObjectProperty<Color>(DEFAULT_CHART_STROKE){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.CHART_STROKE;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "chartStroke";
                }
            };
        }
        return this.chartStroke;
    }

    public final Color getZeroLineColor() {
        return null == this.zeroLineColor ? DEFAULT_ZERO_LINE_COLOR : (Color)this.zeroLineColor.get();
    }

    public final void setZeroLineColor(Color ZERO_LINE_COLOR) {
        this.zeroLineColorProperty().set((Object)ZERO_LINE_COLOR);
    }

    public final ObjectProperty<Color> zeroLineColorProperty() {
        if (null == this.zeroLineColor) {
            this.zeroLineColor = new StyleableObjectProperty<Color>(DEFAULT_ZERO_LINE_COLOR){

                public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                    return StyleableProperties.ZERO_LINE_COLOR;
                }

                public Object getBean() {
                    return SimpleRadarChart.this;
                }

                public String getName() {
                    return "zeroLineColor";
                }
            };
        }
        return this.zeroLineColor;
    }

    protected Skin createDefaultSkin() {
        return new SimpleRadarChartSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("simpleradarchart.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return SimpleRadarChart.getClassCssMetaData();
    }

    static /* synthetic */ Color access$800() {
        return DEFAULT_CHART_BACKGROUND;
    }

    static /* synthetic */ Color access$1000() {
        return DEFAULT_CHART_FOREGROUND;
    }

    static /* synthetic */ Color access$1200() {
        return DEFAULT_CHART_TEXT;
    }

    static /* synthetic */ Paint access$1400() {
        return DEFAULT_CHART_FILL;
    }

    static /* synthetic */ Color access$1600() {
        return DEFAULT_CHART_STROKE;
    }

    static /* synthetic */ Color access$1800() {
        return DEFAULT_ZERO_LINE_COLOR;
    }

    private static class StyleableProperties {
        private static final CssMetaData<SimpleRadarChart, Color> CHART_BACKGROUND = new CssMetaData<SimpleRadarChart, Color>("-chart-background", StyleConverter.getColorConverter(), SimpleRadarChart.access$800()){

            public boolean isSettable(SimpleRadarChart chart) {
                return null == chart.chartBackground || !chart.chartBackground.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(SimpleRadarChart chart) {
                return (StyleableProperty)chart.chartBackgroundProperty();
            }

            public Color getInitialValue(SimpleRadarChart chart) {
                return chart.getChartBackground();
            }
        };
        private static final CssMetaData<SimpleRadarChart, Color> CHART_FOREGROUND = new CssMetaData<SimpleRadarChart, Color>("-chart-foreground", StyleConverter.getColorConverter(), SimpleRadarChart.access$1000()){

            public boolean isSettable(SimpleRadarChart chart) {
                return null == chart.chartForeground || !chart.chartForeground.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(SimpleRadarChart chart) {
                return (StyleableProperty)chart.chartForegroundProperty();
            }

            public Color getInitialValue(SimpleRadarChart chart) {
                return chart.getChartForeground();
            }
        };
        private static final CssMetaData<SimpleRadarChart, Color> CHART_TEXT = new CssMetaData<SimpleRadarChart, Color>("-chart-text", StyleConverter.getColorConverter(), SimpleRadarChart.access$1200()){

            public boolean isSettable(SimpleRadarChart chart) {
                return null == chart.chartText || !chart.chartText.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(SimpleRadarChart chart) {
                return (StyleableProperty)chart.chartTextProperty();
            }

            public Color getInitialValue(SimpleRadarChart chart) {
                return chart.getChartText();
            }
        };
        private static final CssMetaData<SimpleRadarChart, Paint> CHART_FILL = new CssMetaData<SimpleRadarChart, Paint>("-chart-fill", StyleConverter.getPaintConverter(), SimpleRadarChart.access$1400()){

            public boolean isSettable(SimpleRadarChart chart) {
                return null == chart.chartFill || !chart.chartFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleRadarChart chart) {
                return (StyleableProperty)chart.chartFillProperty();
            }

            public Paint getInitialValue(SimpleRadarChart chart) {
                return chart.getChartFill();
            }
        };
        private static final CssMetaData<SimpleRadarChart, Color> CHART_STROKE = new CssMetaData<SimpleRadarChart, Color>("-chart-stroke", StyleConverter.getColorConverter(), SimpleRadarChart.access$1600()){

            public boolean isSettable(SimpleRadarChart chart) {
                return null == chart.chartStroke || chart.chartStroke.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(SimpleRadarChart simpleRadarChart) {
                return (StyleableProperty)simpleRadarChart.chartStrokeProperty();
            }

            public Color getInitialValue(SimpleRadarChart chart) {
                return chart.getChartStroke();
            }
        };
        private static final CssMetaData<SimpleRadarChart, Color> ZERO_LINE_COLOR = new CssMetaData<SimpleRadarChart, Color>("-zero-line-color", StyleConverter.getColorConverter(), SimpleRadarChart.access$1800()){

            public boolean isSettable(SimpleRadarChart chart) {
                return null == chart.zeroLineColor || !chart.zeroLineColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(SimpleRadarChart chart) {
                return (StyleableProperty)chart.zeroLineColorProperty();
            }

            public Color getInitialValue(SimpleRadarChart chart) {
                return chart.getZeroLineColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, CHART_BACKGROUND, CHART_FOREGROUND, CHART_TEXT, CHART_FILL, CHART_STROKE, ZERO_LINE_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

