/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.SimpleGauge;
import java.time.Instant;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class SimpleGaugeSkin
extends SkinBase<SimpleGauge>
implements Skin<SimpleGauge> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private Pane pane;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Canvas measuredRangeCanvas;
    private GraphicsContext measuredRangeCtx;
    private Path needle;
    private Rotate needleRotate;
    private Text value;
    private Text title;
    private double angleStep;
    private Timeline timeline;
    private boolean isFirstTime;
    private Instant lastCall;
    private boolean withinSpeedLimit;

    public SimpleGaugeSkin(SimpleGauge gauge) {
        super((Control)gauge);
        this.angleStep = gauge.getAngleRange() / (gauge.getMaxValue() - gauge.getMinValue());
        this.lastCall = Instant.now();
        this.withinSpeedLimit = true;
        this.timeline = new Timeline();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.isFirstTime = true;
    }

    private void init() {
        if (Double.compare(((SimpleGauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SimpleGauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SimpleGauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SimpleGauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SimpleGauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((SimpleGauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SimpleGauge)this.getSkinnable()).setPrefSize(((SimpleGauge)this.getSkinnable()).getPrefWidth(), ((SimpleGauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((SimpleGauge)this.getSkinnable()).setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(((SimpleGauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SimpleGauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SimpleGauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((SimpleGauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SimpleGauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SimpleGauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.sectionsCanvas = new Canvas(200.0, 200.0);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.measuredRangeCanvas = new Canvas(200.0, 200.0);
        this.measuredRangeCanvas.setManaged(((SimpleGauge)this.getSkinnable()).isMeasuredRangeVisible());
        this.measuredRangeCanvas.setVisible(((SimpleGauge)this.getSkinnable()).isMeasuredRangeVisible());
        this.measuredRangeCtx = this.measuredRangeCanvas.getGraphicsContext2D();
        this.needleRotate = new Rotate(180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle());
        this.angleStep = ((SimpleGauge)this.getSkinnable()).getAngleRange() / (((SimpleGauge)this.getSkinnable()).getMaxValue() - ((SimpleGauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + (((SimpleGauge)this.getSkinnable()).getValue() - ((SimpleGauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + ((SimpleGauge)this.getSkinnable()).getAngleRange(), targetAngle);
        this.setRotationAngle(targetAngle);
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getStyleClass().setAll((Object[])new String[]{"needle"});
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setStyle(String.join((CharSequence)"", "-needle-color: ", Util.colorToCss((Color)((SimpleGauge)this.getSkinnable()).getNeedleColor()), ";", "-border-color: ", Util.colorToCss((Color)((SimpleGauge)this.getSkinnable()).getBorderColor()), ";"));
        this.value = new Text(String.format(Locale.US, "%." + ((SimpleGauge)this.getSkinnable()).getDecimals() + "f", ((SimpleGauge)this.getSkinnable()).getMinValue()) + ((SimpleGauge)this.getSkinnable()).getUnit());
        this.value.setMouseTransparent(true);
        this.value.setTextOrigin(VPos.CENTER);
        this.value.getStyleClass().setAll((Object[])new String[]{"value"});
        this.title = new Text(((SimpleGauge)this.getSkinnable()).getTitle());
        this.title.setTextOrigin(VPos.CENTER);
        this.title.getStyleClass().setAll((Object[])new String[]{"title"});
        this.pane = new Pane();
        this.pane.getStyleClass().add((Object)"simple-gauge");
        this.pane.getChildren().setAll((Object[])new Node[]{this.sectionsCanvas, this.measuredRangeCanvas, this.needle, this.value, this.title});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((SimpleGauge)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("TITLE"));
        ((SimpleGauge)this.getSkinnable()).needleColorProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_STYLE"));
        ((SimpleGauge)this.getSkinnable()).borderColorProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_STYLE"));
        ((SimpleGauge)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((SimpleGauge)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        ((SimpleGauge)this.getSkinnable()).valueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).titleVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).sectionTextVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).sectionIconVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).sectionTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).valueTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).titleTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).measuredRangeVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MEASURED_RANGE_VISIBLE"));
        ((SimpleGauge)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleGauge)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((SimpleGauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.rotateNeedle();
        });
        ((SimpleGauge)this.getSkinnable()).minValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((SimpleGauge)this.getSkinnable()).getAngleRange() / (((SimpleGauge)this.getSkinnable()).getMaxValue() - NEW_VALUE.doubleValue());
            this.needleRotate.setAngle(180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + (((SimpleGauge)this.getSkinnable()).getValue() - NEW_VALUE.doubleValue()) * this.angleStep);
        });
        ((SimpleGauge)this.getSkinnable()).maxValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((SimpleGauge)this.getSkinnable()).getAngleRange() / (NEW_VALUE.doubleValue() - ((SimpleGauge)this.getSkinnable()).getMinValue());
            this.needleRotate.setAngle(180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + (((SimpleGauge)this.getSkinnable()).getValue() - ((SimpleGauge)this.getSkinnable()).getMinValue()) * this.angleStep);
        });
        this.needleRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
        this.timeline.setOnFinished(actionEvent -> {
            if (this.isFirstTime) {
                this.isFirstTime = false;
                ((SimpleGauge)this.getSkinnable()).setMinMeasuredValue(((SimpleGauge)this.getSkinnable()).getValue());
                ((SimpleGauge)this.getSkinnable()).setMaxMeasuredValue(((SimpleGauge)this.getSkinnable()).getValue());
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = (this.needleRotate.getAngle() + ((SimpleGauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((SimpleGauge)this.getSkinnable()).getMinValue();
            this.value.setText(String.format(Locale.US, "%." + ((SimpleGauge)this.getSkinnable()).getDecimals() + "f", currentValue) + ((SimpleGauge)this.getSkinnable()).getUnit());
            this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
            if (this.value.getLayoutBounds().getWidth() > 0.395 * this.size) {
                this.resizeText();
            }
            for (Section section : ((SimpleGauge)this.getSkinnable()).getSections()) {
                if (!section.contains(currentValue)) continue;
                section.fireSectionEvent(new Section.SectionEvent(section, null, Section.SectionEvent.ENTERING_SECTION));
                break;
            }
            if (this.isFirstTime) {
                return;
            }
            if (currentValue < ((SimpleGauge)this.getSkinnable()).getMinMeasuredValue()) {
                ((SimpleGauge)this.getSkinnable()).setMinMeasuredValue(currentValue);
            }
            if (currentValue > ((SimpleGauge)this.getSkinnable()).getMaxMeasuredValue()) {
                ((SimpleGauge)this.getSkinnable()).setMaxMeasuredValue(currentValue);
            }
            if (((SimpleGauge)this.getSkinnable()).isMeasuredRangeVisible()) {
                this.drawMeasuredRange();
            }
        } else if ("MEASURED_RANGE_VISIBLE".equals(PROPERTY)) {
            this.measuredRangeCanvas.setManaged(((SimpleGauge)this.getSkinnable()).isMeasuredRangeVisible());
            this.measuredRangeCanvas.setVisible(((SimpleGauge)this.getSkinnable()).isMeasuredRangeVisible());
        } else if ("NEEDLE_STYLE".equals(PROPERTY)) {
            this.needle.setStyle(String.join((CharSequence)"", "-needle-color: ", Util.colorToCss((Color)((SimpleGauge)this.getSkinnable()).getNeedleColor()), ";", "-border-color: ", Util.colorToCss((Color)((SimpleGauge)this.getSkinnable()).getBorderColor()), ";"));
        } else if ("TITLE".equals(PROPERTY)) {
            this.title.setText(((SimpleGauge)this.getSkinnable()).getTitle());
            this.title.setTranslateX((this.size - this.title.getLayoutBounds().getWidth()) * 0.5);
            if (this.title.getLayoutBounds().getWidth() > 0.395 * this.size) {
                this.resizeText();
            }
        }
    }

    public void resetNeedle() {
        this.timeline.stop();
        boolean wasAnimated = ((SimpleGauge)this.getSkinnable()).isAnimated();
        ((SimpleGauge)this.getSkinnable()).setAnimated(false);
        ((SimpleGauge)this.getSkinnable()).setValue(((SimpleGauge)this.getSkinnable()).getMinValue());
        if (wasAnimated) {
            ((SimpleGauge)this.getSkinnable()).setAnimated(true);
        }
    }

    private void setRotationAngle(double ANGLE) {
        this.needleRotate.setAngle(this.clamp(180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + ((SimpleGauge)this.getSkinnable()).getAngleRange(), ANGLE));
    }

    private void rotateNeedle() {
        this.timeline.stop();
        this.angleStep = ((SimpleGauge)this.getSkinnable()).getAngleRange() / (((SimpleGauge)this.getSkinnable()).getMaxValue() - ((SimpleGauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + (((SimpleGauge)this.getSkinnable()).getValue() - ((SimpleGauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((SimpleGauge)this.getSkinnable()).getStartAngle() + ((SimpleGauge)this.getSkinnable()).getAngleRange(), targetAngle);
        if (this.withinSpeedLimit && ((SimpleGauge)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((SimpleGauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.setRotationAngle(targetAngle);
        }
    }

    private final void drawSections() {
        this.sectionsCtx.clearRect(0.0, 0.0, this.size, this.size);
        double MIN_VALUE = ((SimpleGauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((SimpleGauge)this.getSkinnable()).getMaxValue();
        double OFFSET = ((SimpleGauge)this.getSkinnable()).getStartAngle() - 90.0;
        int NO_OF_SECTIONS = ((SimpleGauge)this.getSkinnable()).getSections().size();
        double SECTIONS_OFFSET = this.size * 0.015;
        double SECTIONS_SIZE = this.size - this.size * 0.03;
        this.angleStep = ((SimpleGauge)this.getSkinnable()).getAngleRange() / (((SimpleGauge)this.getSkinnable()).getMaxValue() - ((SimpleGauge)this.getSkinnable()).getMinValue());
        for (int i = 0; i < NO_OF_SECTIONS; ++i) {
            double cosValue;
            double sinValue;
            Section SECTION = (Section)((SimpleGauge)this.getSkinnable()).getSections().get(i);
            if (SECTION.getStart() > MAX_VALUE || SECTION.getStop() < MIN_VALUE) continue;
            double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
            double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? (MAX_VALUE - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
            this.sectionsCtx.save();
            switch (i) {
                case 0: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill0());
                    break;
                }
                case 1: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill1());
                    break;
                }
                case 2: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill2());
                    break;
                }
                case 3: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill3());
                    break;
                }
                case 4: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill4());
                    break;
                }
                case 5: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill5());
                    break;
                }
                case 6: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill6());
                    break;
                }
                case 7: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill7());
                    break;
                }
                case 8: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill8());
                    break;
                }
                case 9: {
                    this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionFill9());
                }
            }
            this.sectionsCtx.fillArc(SECTIONS_OFFSET, SECTIONS_OFFSET, SECTIONS_SIZE, SECTIONS_SIZE, OFFSET - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.ROUND);
            if (((SimpleGauge)this.getSkinnable()).isSectionTextVisible()) {
                sinValue = -Math.sin(Math.toRadians(OFFSET - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(OFFSET - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D textPoint = new Point2D(this.size * 0.5 + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                if (((SimpleGauge)this.getSkinnable()).isCustomFontEnabled()) {
                    this.sectionsCtx.setFont(Font.font((String)((SimpleGauge)this.getSkinnable()).getCustomFont().getFamily(), (FontWeight)FontWeight.NORMAL, (double)(0.08 * this.size)));
                } else {
                    this.sectionsCtx.setFont(Fonts.robotoMedium(0.08 * this.size));
                }
                this.sectionsCtx.setTextAlign(TextAlignment.CENTER);
                this.sectionsCtx.setTextBaseline(VPos.CENTER);
                this.sectionsCtx.setFill(((SimpleGauge)this.getSkinnable()).getSectionTextColor());
                this.sectionsCtx.fillText(SECTION.getText(), textPoint.getX(), textPoint.getY());
            }
            if (this.size > 0.0 && ((SimpleGauge)this.getSkinnable()).isSectionIconVisible() && !((SimpleGauge)this.getSkinnable()).isSectionTextVisible() && null != SECTION.getImage()) {
                Image icon = SECTION.getImage();
                sinValue = -Math.sin(Math.toRadians(OFFSET - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(OFFSET - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D iconPoint = new Point2D(this.size * 0.5 + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                this.sectionsCtx.drawImage(icon, iconPoint.getX() - this.size * 0.06, iconPoint.getY() - this.size * 0.06, this.size * 0.12, this.size * 0.12);
            }
            this.sectionsCtx.restore();
        }
        this.sectionsCtx.setStroke(((SimpleGauge)this.getSkinnable()).getBorderColor());
        this.sectionsCtx.setLineWidth(this.size * 0.025);
        this.sectionsCtx.strokeArc(SECTIONS_OFFSET, SECTIONS_OFFSET, SECTIONS_SIZE, SECTIONS_SIZE, OFFSET + 90.0, ((SimpleGauge)this.getSkinnable()).getAngleRange(), ArcType.ROUND);
    }

    private final void drawMeasuredRange() {
        double MIN_VALUE = ((SimpleGauge)this.getSkinnable()).getMinValue();
        double OFFSET = ((SimpleGauge)this.getSkinnable()).getStartAngle() - 90.0;
        double START_ANGLE = (((SimpleGauge)this.getSkinnable()).getMinMeasuredValue() - MIN_VALUE) * this.angleStep;
        double ANGLE_EXTEND = (((SimpleGauge)this.getSkinnable()).getMaxMeasuredValue() - ((SimpleGauge)this.getSkinnable()).getMinMeasuredValue()) * this.angleStep;
        double RANGE_OFFSET = this.size * 0.015;
        double RANGE_SIZE = this.size - this.size * 0.03;
        this.measuredRangeCtx.save();
        this.measuredRangeCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.measuredRangeCtx.setFill(((SimpleGauge)this.getSkinnable()).getRangeFill());
        this.measuredRangeCtx.fillArc(RANGE_OFFSET, RANGE_OFFSET, RANGE_SIZE, RANGE_SIZE, OFFSET - START_ANGLE, -ANGLE_EXTEND, ArcType.ROUND);
        this.measuredRangeCtx.setStroke((Paint)Color.WHITE);
        this.measuredRangeCtx.setLineWidth(this.size * 0.025);
        this.measuredRangeCtx.strokeArc(RANGE_OFFSET, RANGE_OFFSET, RANGE_SIZE, RANGE_SIZE, OFFSET - START_ANGLE, -ANGLE_EXTEND, ArcType.ROUND);
        this.measuredRangeCtx.restore();
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void resizeText() {
        double decrement;
        if (((SimpleGauge)this.getSkinnable()).isCustomFontEnabled()) {
            this.value.setFont(Font.font((String)((SimpleGauge)this.getSkinnable()).getCustomFont().getFamily(), (double)(this.size * 0.145)));
        } else {
            this.value.setFont(Fonts.robotoMedium(this.size * 0.145));
        }
        if (this.value.getLayoutBounds().getWidth() > 0.395 * this.size) {
            decrement = 0.0;
            while (this.value.getLayoutBounds().getWidth() > 0.395 * this.size && this.value.getFont().getSize() > 0.0) {
                if (((SimpleGauge)this.getSkinnable()).isCustomFontEnabled()) {
                    this.value.setFont(Font.font((String)((SimpleGauge)this.getSkinnable()).getCustomFont().getFamily(), (double)(this.size * (0.15 - decrement))));
                } else {
                    this.value.setFont(Fonts.robotoMedium(this.size * (0.15 - decrement)));
                }
                decrement += 0.01;
            }
        }
        this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
        this.value.setTranslateY(this.size * (this.title.getText().isEmpty() ? 0.5 : 0.48));
        if (((SimpleGauge)this.getSkinnable()).isCustomFontEnabled()) {
            this.title.setFont(Font.font((String)((SimpleGauge)this.getSkinnable()).getCustomFont().getFamily(), (double)(this.size * 0.045)));
        } else {
            this.title.setFont(Fonts.robotoMedium(this.size * 0.045));
        }
        if (this.title.getLayoutBounds().getWidth() > 0.395 * this.size) {
            decrement = 0.0;
            while (this.title.getLayoutBounds().getWidth() > 0.395 * this.size && this.title.getFont().getSize() > 0.0) {
                if (((SimpleGauge)this.getSkinnable()).isCustomFontEnabled()) {
                    this.title.setFont(Font.font((String)((SimpleGauge)this.getSkinnable()).getCustomFont().getFamily(), (double)(this.size * (0.05 - decrement))));
                } else {
                    this.title.setFont(Fonts.robotoMedium(this.size * (0.05 - decrement)));
                }
                decrement += 0.01;
            }
        }
        this.title.setTranslateX((this.size - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.title.setTranslateY(this.size * 0.5 + this.value.getFont().getSize() * 0.7);
    }

    private void resize() {
        double d = this.size = ((SimpleGauge)this.getSkinnable()).getWidth() < ((SimpleGauge)this.getSkinnable()).getHeight() ? ((SimpleGauge)this.getSkinnable()).getWidth() : ((SimpleGauge)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((SimpleGauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((SimpleGauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.sectionsCanvas.setWidth(this.size);
            this.sectionsCanvas.setHeight(this.size);
            this.drawSections();
            this.sectionsCanvas.setCache(true);
            this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.measuredRangeCanvas.setWidth(this.size);
            this.measuredRangeCanvas.setHeight(this.size);
            this.drawMeasuredRange();
            double currentValue = (this.needleRotate.getAngle() + ((SimpleGauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((SimpleGauge)this.getSkinnable()).getMinValue();
            this.value.setText(String.format(Locale.US, "%." + ((SimpleGauge)this.getSkinnable()).getDecimals() + "f", currentValue) + ((SimpleGauge)this.getSkinnable()).getUnit());
            this.value.setVisible(((SimpleGauge)this.getSkinnable()).isValueVisible());
            this.title.setText(((SimpleGauge)this.getSkinnable()).getTitle());
            this.title.setVisible(((SimpleGauge)this.getSkinnable()).isTitleVisible());
            this.needle.getElements().clear();
            this.needle.getElements().add((Object)new MoveTo(0.275 * this.size, 0.5 * this.size));
            this.needle.getElements().add((Object)new CubicCurveTo(0.275 * this.size, 0.62426575 * this.size, 0.37573425 * this.size, 0.725 * this.size, 0.5 * this.size, 0.725 * this.size));
            this.needle.getElements().add((Object)new CubicCurveTo(0.62426575 * this.size, 0.725 * this.size, 0.725 * this.size, 0.62426575 * this.size, 0.725 * this.size, 0.5 * this.size));
            this.needle.getElements().add((Object)new CubicCurveTo(0.725 * this.size, 0.3891265 * this.size, 0.6448105 * this.size, 0.296985 * this.size, 0.5392625 * this.size, 0.2784125 * this.size));
            this.needle.getElements().add((Object)new LineTo(0.5 * this.size, 0.0225 * this.size));
            this.needle.getElements().add((Object)new LineTo(0.4607375 * this.size, 0.2784125 * this.size));
            this.needle.getElements().add((Object)new CubicCurveTo(0.3551895 * this.size, 0.296985 * this.size, 0.275 * this.size, 0.3891265 * this.size, 0.275 * this.size, 0.5 * this.size));
            this.needle.getElements().add((Object)new ClosePath());
            this.needle.setStrokeWidth(this.size * 0.025);
            this.needle.relocate(this.needle.getLayoutBounds().getMinX(), this.needle.getLayoutBounds().getMinY());
            this.needleRotate.setPivotX(this.size * 0.5);
            this.needleRotate.setPivotY(this.size * 0.5);
            this.resizeText();
        }
    }
}

