/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.imgsplitflap;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.animation.AnimationTimer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class SplitFlap
extends Region {
    public static final String[] TIME_0_TO_5 = new String[]{"1", "2", "3", "4", "5", "0"};
    public static final String[] TIME_0_TO_9 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    public static final String[] NUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    public static final String[] ALPHANUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] ALPHA = new String[]{" ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] EXTENDED = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", "/", ":", ",", "", ";", "@", "#", "+", "?", "!", "%", "$", "=", "<", ">"};
    private static final double PREFERRED_WIDTH = 117.0;
    private static final double PREFERRED_HEIGHT = 201.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double MIN_FLIP_TIME = 1.66666666666667E7;
    private double ASPECT_RATIO = 1.7179487179487178;
    private Image bkgImg = new Image(SplitFlap.class.getResource("background.png").toExternalForm());
    private Image flpImg = new Image(SplitFlap.class.getResource("flap.png").toExternalForm());
    private String[] selection;
    private ArrayList<String> selectedSet;
    private int currentSelectionIndex;
    private int nextSelectionIndex;
    private int previousSelectionIndex;
    private StringProperty text;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private double width;
    private double height;
    private Pane pane;
    private ImageView background;
    private ImageView flap;
    private Font font;
    private Canvas upperBackgroundText;
    private GraphicsContext ctxUpperBackgroundText;
    private Canvas lowerBackgroundText;
    private GraphicsContext ctxLowerBackgroundText;
    private Canvas flapTextFront;
    private GraphicsContext ctxTextFront;
    private Canvas flapTextBack;
    private GraphicsContext ctxTextBack;
    private Rotate rotateFlap;
    private Duration flipTime;
    private boolean flipping;
    private double angleStep;
    private double currentAngle;
    private AnimationTimer timer;

    public SplitFlap() {
        this(EXTENDED, " ");
    }

    public SplitFlap(String[] SELECTION, String TEXT) {
        this.selection = SELECTION;
        this.selectedSet = new ArrayList(64);
        this.selectedSet.addAll(Arrays.asList(this.selection));
        this._textColor = Color.WHITE;
        this.currentSelectionIndex = 0;
        this.nextSelectionIndex = 1;
        this.previousSelectionIndex = this.selectedSet.size() - 1;
        this.rotateFlap = new Rotate(0.0, Rotate.X_AXIS);
        this.flipTime = Duration.millis((double)100.0);
        this.flipping = false;
        this.angleStep = 180.0 / (this.flipTime.toMillis() * 1000000.0 / 1.66666666666667E7);
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                SplitFlap.this.flip(SplitFlap.this.angleStep);
            }
        };
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(117.0, 201.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(5.0, 5.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new ImageView(this.bkgImg);
        this.background.setFitWidth(117.0);
        this.background.setFitHeight(201.0);
        this.background.setPreserveRatio(true);
        this.background.setSmooth(true);
        this.background.setCache(true);
        this.flap = new ImageView(this.flpImg);
        this.flap.setFitWidth(99.0000000054);
        this.flap.setFitHeight(81.99999999900001);
        this.flap.setPreserveRatio(true);
        this.flap.setSmooth(true);
        this.flap.setTranslateX(8.9999999994);
        this.flap.setTranslateY(8.9999999994);
        this.flap.setCache(true);
        this.flap.setCacheHint(CacheHint.ROTATE);
        this.flap.getTransforms().add((Object)this.rotateFlap);
        this.rotateFlap.setPivotY(92.500000005);
        this.flap.setCache(true);
        this.flap.setCacheHint(CacheHint.SPEED);
        this.upperBackgroundText = new Canvas();
        this.ctxUpperBackgroundText = this.upperBackgroundText.getGraphicsContext2D();
        this.ctxUpperBackgroundText.setTextBaseline(VPos.CENTER);
        this.ctxUpperBackgroundText.setTextAlign(TextAlignment.CENTER);
        this.lowerBackgroundText = new Canvas();
        this.ctxLowerBackgroundText = this.lowerBackgroundText.getGraphicsContext2D();
        this.ctxLowerBackgroundText.setTextBaseline(VPos.CENTER);
        this.ctxLowerBackgroundText.setTextAlign(TextAlignment.CENTER);
        this.flapTextFront = new Canvas();
        this.flapTextFront.getTransforms().add((Object)this.rotateFlap);
        this.ctxTextFront = this.flapTextFront.getGraphicsContext2D();
        this.ctxTextFront.setTextBaseline(VPos.CENTER);
        this.ctxTextFront.setTextAlign(TextAlignment.CENTER);
        this.flapTextBack = new Canvas();
        this.flapTextBack.getTransforms().add((Object)this.rotateFlap);
        this.flapTextBack.setOpacity(0.0);
        this.ctxTextBack = this.flapTextBack.getGraphicsContext2D();
        this.ctxTextBack.setTextBaseline(VPos.CENTER);
        this.ctxTextBack.setTextAlign(TextAlignment.CENTER);
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.upperBackgroundText, this.lowerBackgroundText, this.flap, this.flapTextFront, this.flapTextBack});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> this.resize());
        this.heightProperty().addListener(observable -> this.resize());
    }

    public final String[] getSelection() {
        return this.selection;
    }

    public final void setSelection(String[] SELECTION) {
        this.selection = SELECTION;
        this.selectedSet.clear();
        this.selectedSet.addAll(Arrays.asList(this.selection));
    }

    public double getFlipTime() {
        return this.flipTime.toMillis();
    }

    public void setFlipTime(double FLIP_TIME) {
        this.flipTime = Duration.millis((double)FLIP_TIME);
        this.angleStep = 180.0 / (this.flipTime.toMillis() * 1000000.0 / 1.66666666666667E7);
    }

    public final String getText() {
        return (String)this.textProperty().get();
    }

    public final void setText(char CHAR) {
        this.setText(Character.toString(CHAR));
    }

    public final void setText(String TEXT) {
        this.textProperty().set((Object)TEXT);
    }

    public final StringProperty textProperty() {
        if (null == this.text) {
            this.text = new StringPropertyBase(" "){

                public void set(String TEXT) {
                    if (TEXT.equals(SplitFlap.this.getText())) {
                        return;
                    }
                    if (!TEXT.isEmpty() && SplitFlap.this.selectedSet.contains(TEXT)) {
                        super.set(TEXT);
                        SplitFlap.this.flipping = true;
                        SplitFlap.this.timer.start();
                    } else {
                        super.set((String)SplitFlap.this.selectedSet.get(0));
                        SplitFlap.this.currentSelectionIndex = 0;
                        SplitFlap.this.nextSelectionIndex = SplitFlap.this.currentSelectionIndex + 1 > SplitFlap.this.selectedSet.size() ? 0 : SplitFlap.this.currentSelectionIndex + 1;
                    }
                }

                public Object getBean() {
                    return SplitFlap.this;
                }

                public String getName() {
                    return "text";
                }
            };
        }
        return this.text;
    }

    public final String getNextText() {
        return this.selectedSet.get(this.nextSelectionIndex);
    }

    public final String getPreviousText() {
        return this.selectedSet.get(this.previousSelectionIndex);
    }

    public final Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public final void setTextColor(Color TEXT_COLOR) {
        if (null == this.textColor) {
            this._textColor = TEXT_COLOR;
        } else {
            this.textColor.set((Object)TEXT_COLOR);
        }
    }

    public final ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new SimpleObjectProperty((Object)this, "textColor", (Object)this._textColor);
        }
        return this.textColor;
    }

    public final void setBackgroundImage(Image BACKGROUND_IMAGE) {
        this.background.setImage(BACKGROUND_IMAGE);
    }

    public final void setFlapImage(Image FLAP_IMAGE) {
        this.flap.setImage(FLAP_IMAGE);
    }

    private void flip(double ANGLE_STEP) {
        this.currentAngle += ANGLE_STEP;
        if (Double.compare(this.currentAngle, 180.0) >= 0) {
            this.currentAngle = 0.0;
            this.flapTextBack.setOpacity(0.0);
            this.flapTextFront.setOpacity(1.0);
            ++this.currentSelectionIndex;
            if (this.currentSelectionIndex >= this.selectedSet.size()) {
                this.currentSelectionIndex = 0;
            }
            this.nextSelectionIndex = this.currentSelectionIndex + 1;
            if (this.nextSelectionIndex >= this.selectedSet.size()) {
                this.nextSelectionIndex = 0;
            }
            if (this.selectedSet.get(this.currentSelectionIndex).equals(this.getText())) {
                this.timer.stop();
                this.flipping = false;
                this.rotateFlap.setAngle(this.currentAngle);
            }
            this.refreshTextCtx();
        }
        if (this.currentAngle > 90.0) {
            this.flapTextFront.setOpacity(0.0);
            this.flapTextBack.setOpacity(1.0);
        }
        if (this.flipping) {
            this.rotateFlap.setAngle(this.currentAngle);
        }
    }

    private void refreshTextCtx() {
        double flapWidth = this.flap.getLayoutBounds().getWidth();
        double flapHeight = this.flap.getLayoutBounds().getHeight();
        double textX = flapWidth * 0.5;
        double textY = this.height * 0.4;
        this.ctxUpperBackgroundText.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxUpperBackgroundText.setFill((Paint)this.getTextColor());
        this.ctxUpperBackgroundText.fillText(this.selectedSet.get(this.nextSelectionIndex), textX, textY);
        this.ctxLowerBackgroundText.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxLowerBackgroundText.setFill((Paint)this.getTextColor());
        this.ctxLowerBackgroundText.fillText(this.selectedSet.get(this.currentSelectionIndex), textX, -this.height * 0.03);
        this.ctxTextFront.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxTextFront.setFill((Paint)this.getTextColor());
        this.ctxTextFront.fillText(this.selectedSet.get(this.currentSelectionIndex), textX, textY);
        this.ctxTextBack.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxTextBack.setFill((Paint)this.getTextColor());
        this.ctxTextBack.save();
        this.ctxTextBack.scale(1.0, -1.0);
        this.ctxTextBack.fillText(this.selectedSet.get(this.nextSelectionIndex), textX, this.flapTextBack.getLayoutY() - this.background.getFitHeight() * 0.435);
        this.ctxTextBack.restore();
    }

    private void resize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.ASPECT_RATIO * this.width > this.height) {
            this.width = 1.0 / (this.ASPECT_RATIO / this.height);
        } else if (1.0 / (this.ASPECT_RATIO / this.height) > this.width) {
            this.height = this.ASPECT_RATIO * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.background.setTranslateX((this.getWidth() - this.width) * 0.5);
            this.background.setTranslateY((this.getHeight() - this.height) * 0.5);
            this.background.setCache(false);
            this.flap.setCache(false);
            this.background.setFitWidth(this.width);
            this.background.setFitHeight(this.height);
            this.flap.setFitWidth(this.background.getFitWidth() * 0.8461538462);
            this.flap.setFitHeight(this.background.getFitHeight() * 0.407960199);
            if (this.width < this.height) {
                this.flap.setTranslateX(this.background.getTranslateX() + this.background.getFitWidth() * 0.0769230769);
                this.flap.setTranslateY(this.background.getTranslateY() + this.background.getFitWidth() * 0.0769230769);
                this.rotateFlap.setPivotY(this.background.getFitWidth() * 0.715);
            } else {
                this.flap.setTranslateX(this.background.getTranslateX() + this.background.getFitHeight() * 0.0447761194);
                this.flap.setTranslateY(this.background.getTranslateY() + this.background.getFitHeight() * 0.0447761194);
                this.rotateFlap.setPivotY(this.background.getFitHeight() * 0.460199005);
            }
            this.background.setCache(true);
            this.flap.setCache(true);
            this.flap.setCacheHint(CacheHint.ROTATE);
            this.font = Font.font((String)"Droid Sans Mono", (double)(this.background.getLayoutBounds().getHeight() * 0.7));
            this.upperBackgroundText.setWidth(this.flap.getLayoutBounds().getWidth());
            this.upperBackgroundText.setHeight(this.flap.getLayoutBounds().getHeight());
            this.upperBackgroundText.setTranslateX(this.flap.getTranslateX());
            this.upperBackgroundText.setTranslateY(this.flap.getTranslateY());
            this.lowerBackgroundText.setWidth(this.flap.getLayoutBounds().getWidth());
            this.lowerBackgroundText.setHeight(this.flap.getLayoutBounds().getHeight());
            this.lowerBackgroundText.setTranslateX(this.flap.getTranslateX());
            this.lowerBackgroundText.setTranslateY(this.background.getTranslateY() + 0.4701492537 * this.background.getLayoutBounds().getHeight());
            this.flapTextFront.setWidth(this.flap.getLayoutBounds().getWidth());
            this.flapTextFront.setHeight(this.flap.getLayoutBounds().getHeight());
            this.flapTextFront.setTranslateX(this.flap.getTranslateX());
            this.flapTextFront.setTranslateY(this.flap.getTranslateY());
            this.flapTextBack.setWidth(this.flap.getLayoutBounds().getWidth());
            this.flapTextBack.setHeight(this.flap.getLayoutBounds().getHeight());
            this.flapTextBack.setTranslateX(this.flap.getTranslateX());
            this.flapTextBack.setTranslateY(this.flap.getTranslateY());
            this.ctxUpperBackgroundText.setFont(this.font);
            this.ctxLowerBackgroundText.setFont(this.font);
            this.ctxTextFront.setFont(this.font);
            this.ctxTextBack.setFont(this.font);
            this.refreshTextCtx();
        }
    }
}

