/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import eu.hansolo.enzo.lcd.Alarm;
import eu.hansolo.enzo.lcd.skin.LcdClockSkin;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class LcdClock
extends Control {
    public static final String STYLE_CLASS_BEIGE = "lcd-beige";
    public static final String STYLE_CLASS_BLUE = "lcd-blue";
    public static final String STYLE_CLASS_ORANGE = "lcd-orange";
    public static final String STYLE_CLASS_RED = "lcd-red";
    public static final String STYLE_CLASS_YELLOW = "lcd-yellow";
    public static final String STYLE_CLASS_WHITE = "lcd-white";
    public static final String STYLE_CLASS_GRAY = "lcd-gray";
    public static final String STYLE_CLASS_BLACK = "lcd-black";
    public static final String STYLE_CLASS_GREEN = "lcd-green";
    public static final String STYLE_CLASS_GREEN_DARKGREEN = "lcd-green-darkgreen";
    public static final String STYLE_CLASS_BLUE2 = "lcd-blue2";
    public static final String STYLE_CLASS_BLUE_BLACK = "lcd-blue-black";
    public static final String STYLE_CLASS_BLUE_DARKBLUE = "lcd-blue-darkblue";
    public static final String STYLE_CLASS_BLUE_LIGHTBLUE = "lcd-blue-lightblue";
    public static final String STYLE_CLASS_BLUE_GRAY = "lcd-blue-gray";
    public static final String STYLE_CLASS_STANDARD = "lcd-standard";
    public static final String STYLE_CLASS_LIGHTGREEN = "lcd-lightgreen";
    public static final String STYLE_CLASS_STANDARD_GREEN = "lcd-standard-green";
    public static final String STYLE_CLASS_BLUE_BLUE = "lcd-blue-blue";
    public static final String STYLE_CLASS_RED_DARKRED = "lcd-red-darkred";
    public static final String STYLE_CLASS_DARKBLUE = "lcd-darkblue";
    public static final String STYLE_CLASS_PURPLE = "lcd-purple";
    public static final String STYLE_CLASS_BLACK_RED = "lcd-black-red";
    public static final String STYLE_CLASS_DARKGREEN = "lcd-darkgreen";
    public static final String STYLE_CLASS_AMBER = "lcd-amber";
    public static final String STYLE_CLASS_LIGHTBLUE = "lcd-lightblue";
    public static final String STYLE_CLASS_GREEN_BLACK = "lcd-green-black";
    public static final String STYLE_CLASS_YELLOW_BLACK = "lcd-yellow-black";
    public static final String STYLE_CLASS_BLACK_YELLOW = "lcd-black-yellow";
    public static final String STYLE_CLASS_LIGHTGREEN_BLACK = "lcd-lightgreen-black";
    public static final String STYLE_CLASS_DARKPURPLE = "lcd-darkpurple";
    public static final String STYLE_CLASS_DARKAMBER = "lcd-darkamber";
    public static final String STYLE_CLASS_BLUE_LIGHTBLUE2 = "lcd-blue-lightblue2";
    public static final String STYLE_CLASS_GRAY_PURPLE = "lcd-gray-purple";
    public static final String STYLE_CLASS_SECTIONS = "lcd-sections";
    public static final String STYLE_CLASS_YOCTOPUCE = "lcd-yoctopuce";
    public static final String STYLE_CLASS_FLAT_TURQOISE = "lcd-flat-turqoise";
    public static final String STYLE_CLASS_FLAT_GREEN_SEA = "lcd-flat-green-sea";
    public static final String STYLE_CLASS_FLAT_EMERLAND = "lcd-flat-emerland";
    public static final String STYLE_CLASS_FLAT_NEPHRITIS = "lcd-flat-nephritis";
    public static final String STYLE_CLASS_FLAT_PETER_RIVER = "lcd-flat-peter-river";
    public static final String STYLE_CLASS_FLAT_BELIZE_HOLE = "lcd-flat-belize-hole";
    public static final String STYLE_CLASS_FLAT_AMETHYST = "lcd-flat-amethyst";
    public static final String STYLE_CLASS_FLAT_WISTERIA = "lcd-flat-wisteria";
    public static final String STYLE_CLASS_FLAT_SUNFLOWER = "lcd-flat-sunflower";
    public static final String STYLE_CLASS_FLAT_ORANGE = "lcd-flat-orange";
    public static final String STYLE_CLASS_FLAT_CARROT = "lcd-flat-carrot";
    public static final String STYLE_CLASS_FLAT_PUMPKIN = "lcd-flat-pumpkin";
    public static final String STYLE_CLASS_FLAT_ALIZARIN = "lcd-flat-alizarin";
    public static final String STYLE_CLASS_FLAT_POMEGRANATE = "lcd-flat-pomegranate";
    public static final String STYLE_CLASS_FLAT_CLOUDS = "lcd-flat-clouds";
    public static final String STYLE_CLASS_FLAT_SILVER = "lcd-flat-silver";
    public static final String STYLE_CLASS_FLAT_CONCRETE = "lcd-flat-concrete";
    public static final String STYLE_CLASS_FLAT_ASBESTOS = "lcd-flat-asbestos";
    public static final String STYLE_CLASS_FLAT_WET_ASPHALT = "lcd-flat-wet-asphalt";
    public static final String STYLE_CLASS_FLAT_MIDNIGHT_BLUE = "lcd-flat-midnight-blue";
    private static final PseudoClass NO_FRAME_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"no-frame");
    private BooleanProperty noFrame;
    private boolean initialized;
    private boolean firstTime;
    private boolean keepAspect;
    private String _title = "";
    private StringProperty title;
    private String _titleFont = "Roboto";
    private StringProperty titleFont;
    private LcdFont _timeFont = LcdFont.LCD;
    private ObjectProperty<LcdFont> timeFont;
    private String _smallFont = "Roboto";
    private StringProperty smallFont;
    private boolean _backgroundVisible = true;
    private BooleanProperty backgroundVisible;
    private boolean _crystalOverlayVisible = false;
    private BooleanProperty crystalOverlayVisible;
    private boolean _mainInnerShadowVisible = false;
    private BooleanProperty mainInnerShadowVisible;
    private boolean _foregroundShadowVisible = false;
    private BooleanProperty foregroundShadowVisible;
    private ObjectProperty<Locale> locale;
    private ObservableList<Alarm> alarms;
    private List<Alarm> alarmsToRemove;
    private ObjectProperty<Clock> clock;
    private ObjectProperty<LocalDateTime> time;
    private ObjectProperty<DateFormat> dateFormat;
    private ObjectProperty<DateSeparator> dateSeparator;
    private long lastTimerCall;
    private AnimationTimer timer;

    public LcdClock() {
        this.getStyleClass().add((Object)"lcd-clock");
        this.clock = new SimpleObjectProperty((Object)this, "clock", (Object)Clock.systemDefaultZone());
        this.time = new SimpleObjectProperty((Object)this, "time", (Object)LocalDateTime.now((Clock)this.clock.get()));
        this.alarms = FXCollections.observableArrayList();
        this.alarmsToRemove = new ArrayList<Alarm>();
        this.initialized = false;
        this.firstTime = true;
        this.keepAspect = true;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LcdClock.this.lastTimerCall + 1000000000L) {
                    LcdClock.this.time.set((Object)LocalDateTime.now((Clock)LcdClock.this.clock.get()));
                    LcdClock.this.lastTimerCall = NOW;
                }
            }
        };
        this.init();
        this.initialized = true;
        this.timer.start();
    }

    private void init() {
        this.timeProperty().addListener(observable -> {
            this.alarmsToRemove.clear();
            for (Alarm alarm : this.alarms) {
                switch (alarm.getRepetition()) {
                    case ONCE: {
                        if (!this.getTime().isAfter(alarm.getTime())) break;
                        if (alarm.isArmed()) {
                            this.fireEvent(new Alarm.AlarmEvent(alarm, (Object)this, (EventTarget)this, Alarm.AlarmEvent.ALARM));
                            alarm.executeCommand();
                        }
                        this.alarmsToRemove.add(alarm);
                        break;
                    }
                    case HOURLY: {
                        if (alarm.getTime().getHour() != this.getTime().getMinute() || alarm.getTime().getMinute() != this.getTime().getSecond() || !alarm.isArmed()) break;
                        this.fireEvent(new Alarm.AlarmEvent(alarm, (Object)this, (EventTarget)this, Alarm.AlarmEvent.ALARM));
                        alarm.executeCommand();
                        break;
                    }
                    case DAILY: {
                        if (alarm.getTime().getHour() != this.getTime().getHour() || alarm.getTime().getMinute() != this.getTime().getMinute() || alarm.getTime().getSecond() != this.getTime().getSecond() || !alarm.isArmed()) break;
                        this.fireEvent(new Alarm.AlarmEvent(alarm, (Object)this, (EventTarget)this, Alarm.AlarmEvent.ALARM));
                        alarm.executeCommand();
                        break;
                    }
                    case WEEKLY: {
                        if (alarm.getTime().getDayOfWeek() != this.getTime().getDayOfWeek() || alarm.getTime().getHour() != this.getTime().getHour() || alarm.getTime().getMinute() != this.getTime().getMinute() || alarm.getTime().getSecond() != this.getTime().getSecond() || !alarm.isArmed()) break;
                        this.fireEvent(new Alarm.AlarmEvent(alarm, (Object)this, (EventTarget)this, Alarm.AlarmEvent.ALARM));
                        alarm.executeCommand();
                    }
                }
            }
            for (Alarm alarm : this.alarmsToRemove) {
                this.removeAlarm(alarm);
            }
        });
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final void setKeepAspect(boolean KEEP_ASPECT) {
        this.keepAspect = KEEP_ASPECT;
    }

    public boolean isResizable() {
        return true;
    }

    public final Clock getClock() {
        return (Clock)this.clock.get();
    }

    public final void setClock(Clock CLOCK) {
        this.clock.set((Object)CLOCK);
    }

    public final ObjectProperty<Clock> clockProperty() {
        return this.clock;
    }

    public final LocalDateTime getTime() {
        return (LocalDateTime)this.time.get();
    }

    public final ReadOnlyObjectProperty timeProperty() {
        return this.time;
    }

    public final String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", this._title);
        }
        return this.title;
    }

    public final boolean isNoFrame() {
        return null == this.noFrame ? true : this.noFrame.get();
    }

    public final void setNoFrame(boolean NO_FRAME) {
        this.noFrameProperty().set(NO_FRAME);
    }

    public final BooleanProperty noFrameProperty() {
        if (null == this.noFrame) {
            this.noFrame = new BooleanPropertyBase(false){

                protected void invalidated() {
                    LcdClock.this.pseudoClassStateChanged(NO_FRAME_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "noFrame";
                }
            };
        }
        return this.noFrame;
    }

    public final boolean isBackgroundVisible() {
        return null == this.backgroundVisible ? this._backgroundVisible : this.backgroundVisible.get();
    }

    public final void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        if (null == this.backgroundVisible) {
            this._backgroundVisible = BACKGROUND_VISIBLE;
        } else {
            this.backgroundVisible.set(BACKGROUND_VISIBLE);
        }
    }

    public final BooleanProperty backgroundVisibleProperty() {
        if (null == this.backgroundVisible) {
            this.backgroundVisible = new SimpleBooleanProperty((Object)this, "backgroundVisible", this._backgroundVisible);
        }
        return this.backgroundVisible;
    }

    public final boolean isCrystalOverlayVisible() {
        return null == this.crystalOverlayVisible ? this._crystalOverlayVisible : this.crystalOverlayVisible.get();
    }

    public final void setCrystalOverlayVisible(boolean CRYSTAL_OVERLAY_VISIBLE) {
        if (null == this.crystalOverlayVisible) {
            this._crystalOverlayVisible = CRYSTAL_OVERLAY_VISIBLE;
        } else {
            this.crystalOverlayVisible.set(CRYSTAL_OVERLAY_VISIBLE);
        }
    }

    public final BooleanProperty crystalOverlayVisibleProperty() {
        if (null == this.crystalOverlayVisible) {
            this.crystalOverlayVisible = new SimpleBooleanProperty((Object)this, "crystalOverlayVisible", this._crystalOverlayVisible);
        }
        return this.crystalOverlayVisible;
    }

    public final boolean isMainInnerShadowVisible() {
        return null == this.mainInnerShadowVisible ? this._mainInnerShadowVisible : this.mainInnerShadowVisible.get();
    }

    public final void setMainInnerShadowVisible(boolean MAIN_INNER_SHADOW_VISIBLE) {
        if (null == this.mainInnerShadowVisible) {
            this._mainInnerShadowVisible = MAIN_INNER_SHADOW_VISIBLE;
        } else {
            this.mainInnerShadowVisible.set(MAIN_INNER_SHADOW_VISIBLE);
        }
    }

    public final BooleanProperty mainInnerShadowVisibleProperty() {
        if (null == this.mainInnerShadowVisible) {
            this.mainInnerShadowVisible = new SimpleBooleanProperty((Object)this, "mainInnerShadowVisible", this._mainInnerShadowVisible);
        }
        return this.mainInnerShadowVisible;
    }

    public final boolean isForegroundShadowVisible() {
        return null == this.foregroundShadowVisible ? this._foregroundShadowVisible : this.foregroundShadowVisible.get();
    }

    public final void setForegroundShadowVisible(boolean FOREGROUND_SHADOW_VISIBLE) {
        if (null == this.foregroundShadowVisible) {
            this._foregroundShadowVisible = FOREGROUND_SHADOW_VISIBLE;
        } else {
            this.foregroundShadowVisible.set(FOREGROUND_SHADOW_VISIBLE);
        }
    }

    public final BooleanProperty foregroundShadowVisibleProperty() {
        if (null == this.foregroundShadowVisible) {
            this.foregroundShadowVisible = new SimpleBooleanProperty((Object)this, "foregroundShadowVisible", this._foregroundShadowVisible);
        }
        return this.foregroundShadowVisible;
    }

    public final String getTitleFont() {
        return null == this.titleFont ? this._titleFont : (String)this.titleFont.get();
    }

    public final void setTitleFont(String TITLE_FONT) {
        if (null == this.titleFont) {
            this._titleFont = TITLE_FONT;
        } else {
            this.titleFont.set((Object)TITLE_FONT);
        }
    }

    public final StringProperty titleFontProperty() {
        if (null == this.titleFont) {
            this.titleFont = new SimpleStringProperty((Object)this, "titleFont", this._titleFont);
        }
        return this.titleFont;
    }

    public final LcdFont getTimeFont() {
        return null == this.timeFont ? this._timeFont : (LcdFont)((Object)this.timeFont.get());
    }

    public final void setTimeFont(LcdFont TIME_FONT) {
        if (null == this.timeFont) {
            this._timeFont = TIME_FONT;
        } else {
            this.timeFont.set((Object)TIME_FONT);
        }
    }

    public final ObjectProperty<LcdFont> timeFontProperty() {
        if (null == this.timeFont) {
            this.timeFont = new SimpleObjectProperty((Object)this, "timeFont", (Object)this._timeFont);
        }
        return this.timeFont;
    }

    public final String getSmallFont() {
        return null == this.smallFont ? this._smallFont : (String)this.smallFont.get();
    }

    public final void setSmallFont(String SMALL_FONT) {
        if (null == this.smallFont) {
            this._smallFont = SMALL_FONT;
        } else {
            this.smallFont.set((Object)SMALL_FONT);
        }
    }

    public final StringProperty smallFontProperty() {
        if (null == this.smallFont) {
            this.smallFont = new SimpleStringProperty((Object)this, "smallFont", this._smallFont);
        }
        return this.smallFont;
    }

    public final Locale getLocale() {
        return null == this.locale ? Locale.US : (Locale)this.locale.get();
    }

    public final void setLocale(Locale LOCALE) {
        this.localeProperty().set((Object)LOCALE);
    }

    public final ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.US);
        }
        return this.locale;
    }

    public final DateFormat getDateFormat() {
        return null == this.dateFormat ? DateFormat.YEAR_MONTH_DAY : (DateFormat)((Object)this.dateFormat.get());
    }

    public final void setDateFormat(DateFormat DATE_FORMAT) {
        this.dateFormatProperty().set((Object)DATE_FORMAT);
    }

    public final ObjectProperty<DateFormat> dateFormatProperty() {
        if (null == this.dateFormat) {
            this.dateFormat = new SimpleObjectProperty((Object)this, "dateFormat", (Object)DateFormat.YEAR_MONTH_DAY);
        }
        return this.dateFormat;
    }

    public final DateSeparator getDateSeparator() {
        return null == this.dateSeparator ? DateSeparator.SLASH : (DateSeparator)((Object)this.dateSeparator.get());
    }

    public final void setDateSeparator(DateSeparator DATE_SEPARATOR) {
        this.dateSeparatorProperty().set((Object)DATE_SEPARATOR);
    }

    public final ObjectProperty<DateSeparator> dateSeparatorProperty() {
        if (null == this.dateSeparator) {
            this.dateSeparator = new SimpleObjectProperty((Object)this, "dateSeparator", (Object)DateSeparator.SLASH);
        }
        return this.dateSeparator;
    }

    public final ObservableList<Alarm> getAlarms() {
        return this.alarms;
    }

    public final void setAlarms(List<Alarm> ALARMS) {
        this.alarms.setAll(ALARMS);
    }

    public final void setAlarms(Alarm ... ALARMS) {
        this.setAlarms(Arrays.asList(ALARMS));
    }

    public final void addAlarm(Alarm ALARM) {
        if (!this.alarms.contains((Object)ALARM)) {
            this.alarms.add((Object)ALARM);
        }
    }

    public final void removeAlarm(Alarm ALARM) {
        if (this.alarms.contains((Object)ALARM)) {
            this.alarms.remove((Object)ALARM);
        }
    }

    public static double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    protected Skin createDefaultSkin() {
        return new LcdClockSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".css").toExternalForm();
    }

    public static enum DateSeparator {
        DOT("."),
        SLASH("/"),
        MINUS("-");

        public final String chr;

        private DateSeparator(String CHR) {
            this.chr = CHR;
        }
    }

    public static enum DateFormat {
        YEAR_MONTH_DAY,
        DAY_MONTH_YEAR;

    }

    public static enum LcdFont {
        STANDARD,
        LCD,
        DIGITAL,
        DIGITAL_BOLD,
        ELEKTRA;

    }
}

