/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.led.skin;

import eu.hansolo.enzo.led.Led;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class LedSkin
extends SkinBase<Led>
implements Skin<Led> {
    private static final double PREFERRED_SIZE = 16.0;
    private static final double MINIMUM_SIZE = 8.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    private double size;
    private Region frame;
    private Region led;
    private Region highlight;
    private InnerShadow innerShadow;
    private DropShadow glow;

    public LedSkin(Led CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Led)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Led)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Led)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Led)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Led)this.getSkinnable()).getPrefWidth() > 0.0 && ((Led)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Led)this.getSkinnable()).setPrefSize(((Led)this.getSkinnable()).getPrefWidth(), ((Led)this.getSkinnable()).getPrefHeight());
            } else {
                ((Led)this.getSkinnable()).setPrefSize(16.0, 16.0);
            }
        }
        if (Double.compare(((Led)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Led)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Led)this.getSkinnable()).setMinSize(8.0, 8.0);
        }
        if (Double.compare(((Led)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Led)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Led)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.frame = new Region();
        this.frame.setOpacity(((Led)this.getSkinnable()).isFrameVisible() ? 1.0 : 0.0);
        this.led = new Region();
        this.led.setStyle("-led-color: " + LedSkin.colorToCss((Color)((Led)this.getSkinnable()).getLedColor()) + ";");
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 8.0, 0.0, 0.0, 0.0);
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, (Color)((Led)this.getSkinnable()).getLedColor(), 20.0, 0.0, 0.0, 0.0);
        this.glow.setInput((Effect)this.innerShadow);
        this.highlight = new Region();
        this.changeStyle();
        this.getChildren().setAll((Object[])new Node[]{this.frame, this.led, this.highlight});
    }

    private void registerListeners() {
        ((Led)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Led)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Led)this.getSkinnable()).ledColorProperty().addListener(observable -> this.handleControlPropertyChanged("COLOR"));
        ((Led)this.getSkinnable()).ledTypeProperty().addListener(observable -> this.handleControlPropertyChanged("STYLE"));
        ((Led)this.getSkinnable()).onProperty().addListener(observable -> this.handleControlPropertyChanged("ON"));
        ((Led)this.getSkinnable()).frameVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("FRAME_VISIBLE"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("COLOR".equals(PROPERTY)) {
            this.led.setStyle("-led-color: " + LedSkin.colorToCss((Color)((Led)this.getSkinnable()).getLedColor()) + ";");
            this.changeStyle();
        } else if ("STYLE".equals(PROPERTY)) {
            this.changeStyle();
        } else if ("ON".equals(PROPERTY)) {
            this.led.setEffect((Effect)(((Led)this.getSkinnable()).isOn() ? this.glow : this.innerShadow));
        } else if ("FRAME_VISIBLE".equals(PROPERTY)) {
            this.frame.setOpacity(((Led)this.getSkinnable()).isFrameVisible() ? 1.0 : 0.0);
            this.frame.setManaged(((Led)this.getSkinnable()).isFrameVisible());
        }
    }

    private static String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void changeStyle() {
        switch (((Led)this.getSkinnable()).getLedType()) {
            case HORIZONTAL: {
                this.frame.getStyleClass().setAll((Object[])new String[]{"horizontal-frame"});
                this.led.getStyleClass().setAll((Object[])new String[]{"horizontal"});
                this.highlight.getStyleClass().setAll((Object[])new String[]{"horizontal-highlight"});
                break;
            }
            case VERTICAL: {
                this.frame.getStyleClass().setAll((Object[])new String[]{"vertical-frame"});
                this.led.getStyleClass().setAll((Object[])new String[]{"vertical"});
                this.highlight.getStyleClass().setAll((Object[])new String[]{"vertical-highlight"});
                break;
            }
            case SQUARE: {
                this.frame.getStyleClass().setAll((Object[])new String[]{"square-frame"});
                this.led.getStyleClass().setAll((Object[])new String[]{"square"});
                this.highlight.getStyleClass().setAll((Object[])new String[]{"square-highlight"});
                break;
            }
            default: {
                this.frame.getStyleClass().setAll((Object[])new String[]{"round-frame"});
                this.led.getStyleClass().setAll((Object[])new String[]{"round"});
                this.highlight.getStyleClass().setAll((Object[])new String[]{"round-highlight"});
            }
        }
        this.glow.setColor((Color)((Led)this.getSkinnable()).getLedColor());
        this.led.setEffect((Effect)(((Led)this.getSkinnable()).isOn() ? this.glow : this.innerShadow));
        this.resize();
    }

    private void resize() {
        double d = this.size = ((Led)this.getSkinnable()).getWidth() < ((Led)this.getSkinnable()).getHeight() ? ((Led)this.getSkinnable()).getWidth() : ((Led)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.innerShadow.setRadius(0.07 * this.size);
            this.glow.setRadius(0.36 * this.size);
            switch (((Led)this.getSkinnable()).getLedType()) {
                case HORIZONTAL: {
                    this.frame.setMaxSize(this.size, 0.56 * this.size);
                    this.led.setMaxSize(0.72 * this.size, 0.28 * this.size);
                    this.highlight.setMaxSize(0.68 * this.size, 0.12 * this.size);
                    this.highlight.setTranslateY(-0.06 * this.size);
                    break;
                }
                case VERTICAL: {
                    this.frame.setMaxSize(0.56 * this.size, this.size);
                    this.led.setMaxSize(0.28 * this.size, 0.72 * this.size);
                    this.highlight.setMaxSize(0.24 * this.size, 0.23 * this.size);
                    this.highlight.setTranslateY(-0.22 * this.size);
                    break;
                }
                case SQUARE: {
                    this.frame.setMaxSize(this.size, this.size);
                    this.led.setMaxSize(0.72 * this.size, 0.72 * this.size);
                    this.highlight.setMaxSize(0.66 * this.size, 0.66 * this.size);
                    break;
                }
                default: {
                    this.frame.setMaxSize(this.size, this.size);
                    this.led.setMaxSize(0.72 * this.size, 0.72 * this.size);
                    this.highlight.setMaxSize(0.58 * this.size, 0.58 * this.size);
                }
            }
        }
    }
}

