/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.ledbargraph;

import eu.hansolo.enzo.led.Led;
import eu.hansolo.enzo.ledbargraph.skin.LedBargraphSkin;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class LedBargraph
extends Control {
    private Led.LedType _ledType = Led.LedType.ROUND;
    private ObjectProperty<Led.LedType> ledType;
    private BooleanProperty frameVisible;
    private DoubleProperty ledSize;
    private ObjectProperty<Orientation> orientation;
    private IntegerProperty noOfLeds;
    private ListProperty<Color> ledColors;
    private BooleanProperty peakValueVisible;
    private DoubleProperty value;

    public LedBargraph() {
        this.getStyleClass().add((Object)"bargraph");
        this.ledColors = new SimpleListProperty((Object)this, "ledColors", FXCollections.observableArrayList());
        this.value = new SimpleDoubleProperty((Object)this, "value", 0.0);
        IntStream.range(0, 16).parallel().forEachOrdered(i -> {
            if (i < 11) {
                ((ObservableList)this.ledColors.get()).add((Object)Color.LIME);
            } else if (i > 10 && i < 13) {
                ((ObservableList)this.ledColors.get()).add((Object)Color.YELLOW);
            } else {
                ((ObservableList)this.ledColors.get()).add((Object)Color.RED);
            }
        });
    }

    public final Led.LedType getLedType() {
        return null == this.ledType ? this._ledType : (Led.LedType)((Object)this.ledType.get());
    }

    public final void setLedType(Led.LedType LED_TYPE) {
        if (null == this.ledType) {
            this._ledType = LED_TYPE;
        } else {
            this.ledType.set((Object)LED_TYPE);
        }
    }

    public final ObjectProperty<Led.LedType> ledTypeProperty() {
        if (null == this.ledType) {
            this.ledType = new SimpleObjectProperty((Object)this, "ledType", (Object)this._ledType);
        }
        return this.ledType;
    }

    public final boolean isFrameVisible() {
        return null == this.frameVisible ? false : this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        this.frameVisibleProperty().set(FRAME_VISIBLE);
    }

    public final BooleanProperty frameVisibleProperty() {
        if (null == this.frameVisible) {
            this.frameVisible = new SimpleBooleanProperty((Object)this, "frameVisible", false);
        }
        return this.frameVisible;
    }

    public final double getLedSize() {
        return null == this.ledSize ? 16.0 : this.ledSize.get();
    }

    public final void setLedSize(double LED_SIZE) {
        this.ledSizeProperty().set(LED_SIZE);
    }

    public final DoubleProperty ledSizeProperty() {
        if (null == this.ledSize) {
            this.ledSize = new DoublePropertyBase(16.0){

                public void set(double LED_SIZE) {
                    super.set(LED_SIZE < 10.0 ? 10.0 : (LED_SIZE > 50.0 ? 50.0 : LED_SIZE));
                }

                public Object getBean() {
                    return LedBargraph.this;
                }

                public String getName() {
                    return "ledBargraph";
                }
            };
        }
        return this.ledSize;
    }

    public final Orientation getOrientation() {
        return null == this.orientation ? Orientation.HORIZONTAL : (Orientation)this.orientation.get();
    }

    public final void setOrientation(Orientation ORIENTATION) {
        this.orientationProperty().set((Object)ORIENTATION);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)Orientation.HORIZONTAL);
        }
        return this.orientation;
    }

    public final int getNoOfLeds() {
        return null == this.noOfLeds ? 16 : this.noOfLeds.get();
    }

    public final void setNoOfLeds(int NO_OF_LEDS) {
        this.noOfLedsProperty().set(NO_OF_LEDS);
    }

    public final IntegerProperty noOfLedsProperty() {
        if (null == this.noOfLeds) {
            this.noOfLeds = new IntegerPropertyBase(16){

                public void set(int NO_OF_LEDS) {
                    int amount;
                    int n = amount = NO_OF_LEDS < 5 ? 5 : NO_OF_LEDS;
                    if (amount > LedBargraph.this.getNoOfLeds()) {
                        for (int i = 0; i < amount - LedBargraph.this.getNoOfLeds(); ++i) {
                            ((ObservableList)LedBargraph.this.ledColors.get()).add((Object)Color.RED);
                        }
                    }
                    super.set(amount);
                }

                public Object getBean() {
                    return LedBargraph.this;
                }

                public String getName() {
                    return "noOfLeds";
                }
            };
        }
        return this.noOfLeds;
    }

    public final List<Color> getLedColors() {
        return (List)this.ledColors.get();
    }

    public final void setLedColors(Color ... LED_COLORS) {
        this.setLedColors(Arrays.asList(LED_COLORS));
    }

    public final void setLedColors(List<Color> LED_COLORS) {
        ((ObservableList)this.ledColors.get()).setAll(LED_COLORS);
        if (this.ledColors.size() < this.getNoOfLeds()) {
            int delta = this.getNoOfLeds() - this.ledColors.size();
            Color lastColor = this.getLedColors().get(this.ledColors.size() - 1);
            for (int i = 0; i < delta; ++i) {
                this.ledColors.add((Object)lastColor);
            }
        }
    }

    public final ReadOnlyListProperty<Color> ledColorsProperty() {
        return this.ledColors;
    }

    public final Color getLedColor(int INDEX) {
        Color ledColor = INDEX < 0 ? (Color)((ObservableList)this.ledColors.get()).get(0) : (INDEX > this.getNoOfLeds() - 1 ? (Color)((ObservableList)this.ledColors.get()).get(this.getNoOfLeds() - 1) : (Color)((ObservableList)this.ledColors.get()).get(INDEX));
        return ledColor;
    }

    public final void setLedColor(int INDEX, Color COLOR) {
        int realIndex = INDEX - 1;
        if (realIndex < 0) {
            ((ObservableList)this.ledColors.get()).set(0, (Object)COLOR);
        } else if (realIndex > this.noOfLeds.get() - 1) {
            ((ObservableList)this.ledColors.get()).set(this.noOfLeds.get() - 1, (Object)COLOR);
        } else {
            ((ObservableList)this.ledColors.get()).set(realIndex, (Object)COLOR);
        }
    }

    public final boolean isPeakValueVisible() {
        return null == this.peakValueVisible ? true : this.peakValueVisible.get();
    }

    public final void setPeakValueVisible(boolean PEAK_VALUE_VISIBLE) {
        this.peakValueVisibleProperty().set(PEAK_VALUE_VISIBLE);
    }

    public final BooleanProperty peakValueVisibleProperty() {
        if (null == this.peakValueVisible) {
            this.peakValueVisible = new SimpleBooleanProperty((Object)this, "peakValueVisible", true);
        }
        return this.peakValueVisible;
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        double val = VALUE < 0.0 ? 0.0 : (VALUE > 1.0 ? 1.0 : VALUE);
        this.value.set(val);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    protected Skin createDefaultSkin() {
        return new LedBargraphSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("ledbargraph.css").toExternalForm();
    }
}

