/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.qlocktwo;

import eu.hansolo.enzo.qlocktwo.Qlock;
import eu.hansolo.enzo.qlocktwo.QlockTwo;
import eu.hansolo.enzo.qlocktwo.QlockWord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class QlockDutch
implements Qlock {
    private static final QlockTwo.Language LANGUAGE = QlockTwo.Language.DUTCH;
    private static final String[][] MATRIX = new String[][]{{"H", "E", "T", "K", "I", "S", "A", "V", "I", "I", "F"}, {"T", "I", "E", "N", "B", "T", "Z", "V", "O", "O", "R"}, {"O", "V", "E", "R", "M", "E", "K", "W", "A", "R", "T"}, {"H", "A", "L", "F", "S", "P", "W", "O", "V", "E", "R"}, {"V", "O", "O", "R", "T", "H", "G", "\u00c9", "\u00c9", "N", "S"}, {"T", "W", "E", "E", "P", "V", "C", "D", "R", "I", "E"}, {"V", "I", "E", "R", "V", "I", "I", "F", "Z", "E", "S"}, {"Z", "E", "V", "E", "N", "O", "N", "E", "G", "E", "N"}, {"A", "C", "H", "T", "T", "I", "E", "N", "E", "L", "F"}, {"T", "W", "A", "A", "L", "F", "B", "F", "U", "U", "R"}};
    private final ConcurrentHashMap<Integer, String> LOOKUP = new ConcurrentHashMap();
    private List<QlockWord> timeList;

    public QlockDutch() {
        this.LOOKUP.putAll(QlockTwo.Language.DUTCH.getLookup());
        this.timeList = new ArrayList<QlockWord>(10);
    }

    @Override
    public String[][] getMatrix() {
        return MATRIX;
    }

    @Override
    public List<QlockWord> getTime(int minute, int hour) {
        if (hour > 12) {
            hour -= 12;
        }
        if (hour <= 0) {
            hour += 12;
        }
        if (minute > 60) {
            minute -= 60;
            ++hour;
        }
        if (minute < 0) {
            minute += 60;
            --hour;
        }
        minute -= minute % 5;
        this.timeList.clear();
        this.timeList.add(QlockLanguage.HET);
        this.timeList.add(QlockLanguage.IS);
        switch (minute) {
            case 0: {
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.UUR);
                break;
            }
            case 5: {
                this.timeList.add(QlockLanguage.VIJF1);
                this.timeList.add(QlockLanguage.OVER);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 10: {
                this.timeList.add(QlockLanguage.TIEN);
                this.timeList.add(QlockLanguage.OVER);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 15: {
                this.timeList.add(QlockLanguage.KWART);
                this.timeList.add(QlockLanguage.OVER1);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 20: {
                this.timeList.add(QlockLanguage.TIEN);
                this.timeList.add(QlockLanguage.VOOR);
                this.timeList.add(QlockLanguage.HALF);
                this.addHour(this.timeList, hour);
                break;
            }
            case 25: {
                this.timeList.add(QlockLanguage.VIJF1);
                this.timeList.add(QlockLanguage.VOOR);
                this.timeList.add(QlockLanguage.HALF);
                this.addHour(this.timeList, hour);
                break;
            }
            case 30: {
                this.timeList.add(QlockLanguage.HALF);
                this.addHour(this.timeList, hour);
                break;
            }
            case 35: {
                this.timeList.add(QlockLanguage.VIJF1);
                this.timeList.add(QlockLanguage.OVER);
                this.timeList.add(QlockLanguage.HALF);
                this.addHour(this.timeList, hour);
                break;
            }
            case 40: {
                this.timeList.add(QlockLanguage.TIEN);
                this.timeList.add(QlockLanguage.OVER);
                this.timeList.add(QlockLanguage.HALF);
                this.addHour(this.timeList, hour);
                break;
            }
            case 45: {
                this.timeList.add(QlockLanguage.KWART);
                this.timeList.add(QlockLanguage.VOOR1);
                this.addHour(this.timeList, hour);
                break;
            }
            case 50: {
                this.timeList.add(QlockLanguage.TIEN);
                this.timeList.add(QlockLanguage.VOOR);
                this.addHour(this.timeList, hour);
                break;
            }
            case 55: {
                this.timeList.add(QlockLanguage.VIJF1);
                this.timeList.add(QlockLanguage.VOOR);
                this.addHour(this.timeList, hour);
            }
        }
        return this.timeList;
    }

    @Override
    public QlockTwo.Language getLanguage() {
        return LANGUAGE;
    }

    private void addHour(List<QlockWord> timeList, int HOUR) {
        if (HOUR == 12) {
            timeList.add(QlockLanguage.EEN);
        } else if (HOUR == 10 || HOUR + 1 == 10) {
            timeList.add(QlockLanguage.TIEN1);
        } else if (HOUR + 1 == 5) {
            timeList.add(QlockLanguage.VIJF);
        } else {
            timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(HOUR + 1)));
        }
    }

    private static enum QlockLanguage implements QlockWord
    {
        EEN(4, 7, 9),
        TWEE(5, 0, 3),
        DRIE(5, 7, 10),
        VIER(6, 0, 3),
        VIJF1(0, 7, 10),
        VIJF(6, 4, 7),
        ZES(6, 8, 10),
        ZEVEN(7, 0, 4),
        ACHT(8, 0, 3),
        NEGEN(7, 6, 10),
        TIEN(1, 0, 3),
        TIEN1(8, 4, 7),
        ELF(8, 9, 10),
        TWAALF(9, 0, 5),
        HET(0, 0, 2),
        IS(0, 4, 5),
        OVER(2, 0, 3),
        OVER1(3, 7, 10),
        KWART(2, 6, 10),
        VOOR(1, 7, 10),
        VOOR1(4, 0, 3),
        HALF(3, 0, 3),
        UUR(9, 8, 10);

        private final int ROW;
        private final int START;
        private final int STOP;

        private QlockLanguage(int ROW, int START, int STOP) {
            this.ROW = ROW;
            this.START = START;
            this.STOP = STOP;
        }

        @Override
        public int getRow() {
            return this.ROW;
        }

        @Override
        public int getStart() {
            return this.START;
        }

        @Override
        public int getStop() {
            return this.STOP;
        }
    }
}

