/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.qlocktwo;

import eu.hansolo.enzo.qlocktwo.Qlock;
import eu.hansolo.enzo.qlocktwo.QlockTwo;
import eu.hansolo.enzo.qlocktwo.QlockWord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class QlockEnglish
implements Qlock {
    private static final QlockTwo.Language LANGUAGE = QlockTwo.Language.ENGLISH;
    private static final String[][] MATRIX = new String[][]{{"I", "T", "L", "I", "S", "A", "S", "T", "I", "M", "E"}, {"A", "C", "Q", "U", "A", "R", "T", "E", "R", "D", "C"}, {"T", "W", "E", "N", "T", "Y", "F", "I", "V", "E", "X"}, {"H", "A", "L", "F", "B", "T", "E", "N", "F", "T", "O"}, {"P", "A", "S", "T", "E", "R", "U", "N", "I", "N", "E"}, {"O", "N", "E", "S", "I", "X", "T", "H", "R", "E", "E"}, {"F", "O", "U", "R", "F", "I", "V", "E", "T", "W", "O"}, {"E", "I", "G", "H", "T", "E", "L", "E", "V", "E", "N"}, {"S", "E", "V", "E", "N", "T", "W", "E", "L", "V", "E"}, {"T", "E", "N", "S", "E", "O'", "C", "L", "O", "C", "K"}};
    private final ConcurrentHashMap<Integer, String> LOOKUP = new ConcurrentHashMap();
    private List<QlockWord> timeList;

    public QlockEnglish() {
        this.LOOKUP.putAll(QlockTwo.Language.ENGLISH.getLookup());
        this.timeList = new ArrayList<QlockWord>(10);
    }

    @Override
    public String[][] getMatrix() {
        return MATRIX;
    }

    @Override
    public List<QlockWord> getTime(int minute, int hour) {
        if (hour > 12) {
            hour -= 12;
        }
        if (hour <= 0) {
            hour += 12;
        }
        if (minute > 60) {
            minute -= 60;
            ++hour;
        }
        if (minute < 0) {
            minute += 60;
            --hour;
        }
        minute -= minute % 5;
        this.timeList.clear();
        this.timeList.add(QlockLanguage.IT);
        this.timeList.add(QlockLanguage.IS);
        switch (minute) {
            case 0: {
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.OCLOCK);
                break;
            }
            case 5: {
                this.timeList.add(QlockLanguage.FIVE1);
                this.timeList.add(QlockLanguage.PAST);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 10: {
                this.timeList.add(QlockLanguage.TEN1);
                this.timeList.add(QlockLanguage.PAST);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 15: {
                this.timeList.add(QlockLanguage.A);
                this.timeList.add(QlockLanguage.QUARTER);
                this.timeList.add(QlockLanguage.PAST);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 20: {
                this.timeList.add(QlockLanguage.TWENTY);
                this.timeList.add(QlockLanguage.PAST);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 25: {
                this.timeList.add(QlockLanguage.TWENTYFIVE);
                this.timeList.add(QlockLanguage.PAST);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 30: {
                this.timeList.add(QlockLanguage.HALF);
                this.timeList.add(QlockLanguage.PAST);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 35: {
                this.timeList.add(QlockLanguage.TWENTYFIVE);
                this.timeList.add(QlockLanguage.TO);
                this.addHour(this.timeList, hour);
                break;
            }
            case 40: {
                this.timeList.add(QlockLanguage.TWENTY);
                this.timeList.add(QlockLanguage.TO);
                this.addHour(this.timeList, hour);
                break;
            }
            case 45: {
                this.timeList.add(QlockLanguage.A);
                this.timeList.add(QlockLanguage.QUARTER);
                this.timeList.add(QlockLanguage.TO);
                this.addHour(this.timeList, hour);
                break;
            }
            case 50: {
                this.timeList.add(QlockLanguage.TEN1);
                this.timeList.add(QlockLanguage.TO);
                this.addHour(this.timeList, hour);
                break;
            }
            case 55: {
                this.timeList.add(QlockLanguage.FIVE1);
                this.timeList.add(QlockLanguage.TO);
                this.addHour(this.timeList, hour);
            }
        }
        return this.timeList;
    }

    @Override
    public QlockTwo.Language getLanguage() {
        return LANGUAGE;
    }

    private void addHour(List<QlockWord> timeList, int HOUR) {
        if (HOUR == 12) {
            timeList.add(QlockLanguage.ONE);
        } else if (HOUR == 10) {
            timeList.add(QlockLanguage.TEN2);
        } else {
            timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(HOUR + 1)));
        }
    }

    private static enum QlockLanguage implements QlockWord
    {
        ONE(5, 0, 2),
        TWO(6, 8, 10),
        THREE(5, 6, 10),
        FOUR(6, 0, 3),
        FIVE(6, 4, 7),
        FIVE1(2, 6, 9),
        SIX(5, 3, 5),
        SEVEN(8, 0, 4),
        EIGHT(7, 0, 4),
        NINE(4, 7, 10),
        TEN(9, 0, 2),
        TEN1(3, 5, 7),
        TEN2(9, 0, 2),
        ELEVEN(7, 5, 10),
        TWELVE(8, 5, 10),
        IT(0, 0, 1),
        IS(0, 3, 4),
        A(1, 0, 0),
        TO(3, 9, 10),
        PAST(4, 0, 3),
        QUARTER(1, 2, 8),
        HALF(3, 0, 3),
        TWENTY(2, 0, 5),
        TWENTYFIVE(2, 0, 9),
        OCLOCK(9, 5, 10);

        private final int ROW;
        private final int START;
        private final int STOP;

        private QlockLanguage(int ROW, int START, int STOP) {
            this.ROW = ROW;
            this.START = START;
            this.STOP = STOP;
        }

        @Override
        public int getRow() {
            return this.ROW;
        }

        @Override
        public int getStart() {
            return this.START;
        }

        @Override
        public int getStop() {
            return this.STOP;
        }
    }
}

