/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.qlocktwo;

import eu.hansolo.enzo.qlocktwo.Qlock;
import eu.hansolo.enzo.qlocktwo.QlockTwo;
import eu.hansolo.enzo.qlocktwo.QlockWord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class QlockSpanish
implements Qlock {
    private static final QlockTwo.Language LANGUAGE = QlockTwo.Language.SPANISH;
    private static final String[][] MATRIX = new String[][]{{"E", "S", "O", "N", "E", "L", "A", "S", "U", "N", "A"}, {"D", "O", "S", "I", "T", "R", "E", "S", "O", "R", "E"}, {"C", "U", "A", "T", "R", "O", "C", "I", "N", "C", "O"}, {"S", "E", "I", "S", "A", "S", "I", "E", "T", "E", "N"}, {"O", "C", "H", "O", "N", "U", "E", "V", "E", "Y", "O"}, {"L", "A", "D", "I", "E", "Z", "S", "O", "N", "C", "E"}, {"D", "O", "C", "E", "L", "Y", "M", "E", "N", "O", "S"}, {"O", "V", "E", "I", "N", "T", "E", "D", "I", "E", "Z"}, {"V", "E", "I", "N", "T", "I", "C", "I", "N", "C", "O"}, {"M", "E", "D", "I", "A", "C", "U", "A", "R", "T", "O"}};
    private final ConcurrentHashMap<Integer, String> LOOKUP = new ConcurrentHashMap();
    private List<QlockWord> timeList;

    public QlockSpanish() {
        this.LOOKUP.putAll(QlockTwo.Language.SPANISH.getLookup());
        this.timeList = new ArrayList<QlockWord>(10);
    }

    @Override
    public String[][] getMatrix() {
        return MATRIX;
    }

    @Override
    public List<QlockWord> getTime(int minute, int hour) {
        if (hour > 12) {
            hour -= 12;
        }
        if (hour <= 0) {
            hour += 12;
        }
        if (minute > 60) {
            minute -= 60;
            ++hour;
        }
        if (minute < 0) {
            minute += 60;
            --hour;
        }
        minute -= minute % 5;
        this.timeList.clear();
        switch (minute) {
            case 0: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 5: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.Y);
                this.timeList.add(QlockLanguage.CINCO1);
                break;
            }
            case 10: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.Y);
                this.timeList.add(QlockLanguage.DIEZ1);
                break;
            }
            case 15: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.Y);
                this.timeList.add(QlockLanguage.CUARTO);
                break;
            }
            case 20: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.Y);
                this.timeList.add(QlockLanguage.VEINTE);
                break;
            }
            case 25: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.Y);
                this.timeList.add(QlockLanguage.VEINTICINCO);
                break;
            }
            case 30: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(QlockLanguage.Y);
                this.timeList.add(QlockLanguage.MEDIA);
                break;
            }
            case 35: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.MENOS);
                this.timeList.add(QlockLanguage.VEINTICINCO);
                this.addHour(this.timeList, hour);
                break;
            }
            case 40: {
                this.timeList.add(hour == 1 ? QlockLanguage.ES : QlockLanguage.SON);
                this.timeList.add(hour == 1 ? QlockLanguage.LA : QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.MENOS);
                this.timeList.add(QlockLanguage.VEINTE);
                this.addHour(this.timeList, hour);
                break;
            }
            case 45: {
                this.timeList.add(QlockLanguage.SON);
                this.timeList.add(QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.MENOS);
                this.timeList.add(QlockLanguage.CUARTO);
                this.addHour(this.timeList, hour);
                break;
            }
            case 50: {
                this.timeList.add(QlockLanguage.SON);
                this.timeList.add(QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.MENOS);
                this.timeList.add(QlockLanguage.DIEZ1);
                this.addHour(this.timeList, hour);
                break;
            }
            case 55: {
                this.timeList.add(QlockLanguage.SON);
                this.timeList.add(QlockLanguage.LAS);
                this.timeList.add(QlockLanguage.MENOS);
                this.timeList.add(QlockLanguage.CINCO1);
                this.addHour(this.timeList, hour);
            }
        }
        return this.timeList;
    }

    @Override
    public QlockTwo.Language getLanguage() {
        return LANGUAGE;
    }

    private void addHour(List<QlockWord> timeList, int HOUR) {
        if (HOUR == 12) {
            timeList.add(QlockLanguage.UNA);
        } else if (HOUR == 10) {
            timeList.add(QlockLanguage.DIEZ1);
        } else {
            timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(HOUR + 1)));
        }
    }

    private static enum QlockLanguage implements QlockWord
    {
        UNA(0, 8, 10),
        DOS(1, 0, 2),
        TRES(1, 4, 7),
        CUATRO(2, 0, 5),
        CINCO(2, 6, 10),
        CINCO1(8, 6, 10),
        SEIS(3, 0, 3),
        SIETE(3, 5, 9),
        OCHO(4, 0, 3),
        NUEVE(4, 4, 8),
        DIEZ(5, 2, 5),
        DIEZ1(7, 7, 10),
        ONCE(7, 5, 10),
        DOCE(6, 0, 3),
        SON(0, 1, 3),
        ES(0, 0, 1),
        LA(0, 5, 6),
        LAS(0, 5, 7),
        Y(6, 5, 5),
        MENOS(6, 6, 10),
        CUARTO(9, 5, 10),
        VEINTE(7, 1, 6),
        VEINTICINCO(8, 0, 10),
        MEDIA(9, 0, 4);

        private final int ROW;
        private final int START;
        private final int STOP;

        private QlockLanguage(int ROW, int START, int STOP) {
            this.ROW = ROW;
            this.START = START;
            this.STOP = STOP;
        }

        @Override
        public int getRow() {
            return this.ROW;
        }

        @Override
        public int getStart() {
            return this.START;
        }

        @Override
        public int getStop() {
            return this.STOP;
        }
    }
}

