/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.qlocktwo.skin;

import eu.hansolo.enzo.common.BrushedMetalPaint;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.qlocktwo.QlockTwo;
import eu.hansolo.enzo.qlocktwo.QlockWord;
import java.time.LocalTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class QlockTwoSkin
extends SkinBase<QlockTwo>
implements Skin<QlockTwo> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private QlockTwo.SecondsLeft secondLeft = QlockTwo.SecondsLeft.ZERO;
    private QlockTwo.SecondsRight secondRight = QlockTwo.SecondsRight.ZERO;
    private BrushedMetalPaint texture = new BrushedMetalPaint(Color.web((String)"#888888"));
    private Pane pane;
    private Region background;
    private ImageView stainlessBackground = new ImageView();
    private Region p1;
    private Region p2;
    private Region p3;
    private Region p4;
    private Label[][] matrix;
    private Region highlight;
    private Font font;
    private double startX;
    private double startY;
    private double stepX;
    private double stepY;
    private volatile ScheduledFuture<?> periodicClockTask;
    private static ScheduledExecutorService periodicClockExecutorService;

    public QlockTwoSkin(QlockTwo CONTROL) {
        super((Control)CONTROL);
        this.pane = new Pane();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.scheduleClockTask();
    }

    private void init() {
        if (Double.compare(((QlockTwo)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((QlockTwo)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((QlockTwo)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((QlockTwo)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((QlockTwo)this.getSkinnable()).getPrefWidth() > 0.0 && ((QlockTwo)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((QlockTwo)this.getSkinnable()).setPrefSize(((QlockTwo)this.getSkinnable()).getPrefWidth(), ((QlockTwo)this.getSkinnable()).getPrefHeight());
            } else {
                ((QlockTwo)this.getSkinnable()).setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(((QlockTwo)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((QlockTwo)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((QlockTwo)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((QlockTwo)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((QlockTwo)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((QlockTwo)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.startX = 22.8;
        this.startY = 22.400000000000002;
        this.stepX = 14.399999999999999;
        this.stepY = 16.0;
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
        this.stainlessBackground.setImage(this.texture.getImage(200.0, 200.0));
        this.stainlessBackground.setVisible(((QlockTwo)this.getSkinnable()).getColor() == QlockTwo.QlockColor.STAINLESS_STEEL);
        this.stainlessBackground.setManaged(((QlockTwo)this.getSkinnable()).getColor() == QlockTwo.QlockColor.STAINLESS_STEEL);
        this.p1 = new Region();
        this.p1.getStyleClass().add((Object)"dot-off");
        this.p2 = new Region();
        this.p2.getStyleClass().add((Object)"dot-off");
        this.p3 = new Region();
        this.p3.getStyleClass().add((Object)"dot-off");
        this.p4 = new Region();
        this.p4.getStyleClass().add((Object)"dot-off");
        this.highlight = new Region();
        this.highlight.getStyleClass().add((Object)"highlight");
        this.matrix = new Label[11][10];
        IntStream.range(0, 10).parallel().forEachOrdered(y -> IntStream.range(0, 11).parallel().forEachOrdered(x -> {
            this.matrix[x][y] = new Label();
            this.matrix[x][y].setAlignment(Pos.CENTER);
            this.matrix[x][y].setPrefWidth(9.6);
            this.matrix[x][y].setPrefHeight(9.6);
            this.matrix[x][y].setText(((QlockTwo)this.getSkinnable()).getQlock().getMatrix()[y][x]);
            this.matrix[x][y].getStyleClass().add((Object)"text-off");
        }));
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.stainlessBackground, this.p4, this.p3, this.p2, this.p1});
        IntStream.range(0, 10).parallel().forEachOrdered(y -> IntStream.range(0, 11).parallel().forEachOrdered(x -> this.pane.getChildren().add((Object)this.matrix[x][y])));
        this.pane.getChildren().add((Object)this.highlight);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((QlockTwo)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((QlockTwo)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((QlockTwo)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((QlockTwo)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((QlockTwo)this.getSkinnable()).colorProperty().addListener(observable -> this.handleControlPropertyChanged("COLOR"));
        ((QlockTwo)this.getSkinnable()).languageProperty().addListener(observable -> this.handleControlPropertyChanged("LANGUAGE"));
        ((QlockTwo)this.getSkinnable()).highlightVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("HIGHLIGHT"));
        ((QlockTwo)this.getSkinnable()).getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                QlockTwoSkin.this.resize();
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("COLOR".equals(PROPERTY)) {
            this.background.getStyleClass().setAll((Object[])new String[]{"background", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.stainlessBackground.setVisible(((QlockTwo)this.getSkinnable()).getColor() == QlockTwo.QlockColor.STAINLESS_STEEL);
            this.stainlessBackground.setManaged(((QlockTwo)this.getSkinnable()).getColor() == QlockTwo.QlockColor.STAINLESS_STEEL);
            IntStream.range(0, 10).parallel().forEachOrdered(y -> IntStream.range(0, 11).parallel().forEachOrdered(x -> {
                if (this.matrix[x][y].getStyleClass().contains((Object)"text-off")) {
                    this.matrix[x][y].getStyleClass().setAll((Object[])new String[]{"text-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
                }
            }));
            if (this.p1.getStyleClass().contains((Object)"dot-off")) {
                this.p1.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            }
            if (this.p2.getStyleClass().contains((Object)"dot-off")) {
                this.p2.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            }
            if (this.p3.getStyleClass().contains((Object)"dot-off")) {
                this.p3.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            }
            if (this.p4.getStyleClass().contains((Object)"dot-off")) {
                this.p4.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            }
        } else if ("LANGUAGE".equals(PROPERTY)) {
            IntStream.range(0, 10).parallel().forEachOrdered(y -> IntStream.range(0, 11).parallel().forEachOrdered(x -> this.matrix[x][y].setText(((QlockTwo)this.getSkinnable()).getQlock().getMatrix()[y][x])));
        } else if ("HIGHLIGHT".equals(PROPERTY)) {
            this.highlight.setOpacity(((QlockTwo)this.getSkinnable()).isHighlightVisible() ? 1.0 : 0.0);
        }
    }

    private static synchronized void enableClockExecutorService() {
        if (null == periodicClockExecutorService) {
            periodicClockExecutorService = new ScheduledThreadPoolExecutor(1, QlockTwoSkin.getThreadFactory("QlockTwo", true));
        }
    }

    private synchronized void scheduleClockTask() {
        QlockTwoSkin.enableClockExecutorService();
        this.stopTask(this.periodicClockTask);
        this.periodicClockTask = periodicClockExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (((QlockTwo)QlockTwoSkin.this.getSkinnable()).isVisible()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            QlockTwoSkin.this.updateClock();
                        }
                    });
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private static ThreadFactory getThreadFactory(final String THREAD_NAME, final boolean IS_DAEMON) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, THREAD_NAME);
                thread.setDaemon(IS_DAEMON);
                return thread;
            }
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    private void updateClock() {
        int min;
        this.hour = LocalTime.now().getHour();
        this.minute = LocalTime.now().getMinute();
        this.second = LocalTime.now().getSecond();
        if (((QlockTwo)this.getSkinnable()).isSecondsMode()) {
            if (this.second < 10) {
                this.secondLeft = QlockTwo.SecondsLeft.ZERO;
                this.secondRight = QlockTwo.SecondsRight.values()[this.second];
            } else {
                this.secondLeft = QlockTwo.SecondsLeft.values()[Integer.parseInt(Integer.toString(this.second).substring(0, 1))];
                this.secondRight = QlockTwo.SecondsRight.values()[Integer.parseInt(Integer.toString(this.second).substring(1, 2))];
            }
            IntStream.range(0, 10).forEachOrdered(y -> IntStream.range(0, 11).forEachOrdered(x -> {
                if (this.secondLeft.dots.containsKey(y) || this.secondRight.dots.containsKey(y)) {
                    if (this.secondLeft.dots.containsKey(y) && this.secondLeft.dots.get(y).contains(x)) {
                        this.matrix[x][y].getStyleClass().setAll((Object[])new String[]{"text-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
                    } else if (this.secondRight.dots.containsKey(y) && this.secondRight.dots.get(y).contains(x)) {
                        this.matrix[x][y].getStyleClass().setAll((Object[])new String[]{"text-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
                    } else {
                        this.matrix[x][y].getStyleClass().setAll((Object[])new String[]{"text-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
                    }
                } else {
                    this.matrix[x][y].getStyleClass().setAll((Object[])new String[]{"text-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
                }
            }));
        } else {
            IntStream.range(0, 10).forEachOrdered(y -> IntStream.range(0, 11).forEachOrdered(x -> this.matrix[x][y].getStyleClass().setAll((Object[])new String[]{"text-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS})));
            for (QlockWord word : ((QlockTwo)this.getSkinnable()).getQlock().getTime(this.minute, this.hour)) {
                for (int col = word.getStart(); col <= word.getStop(); ++col) {
                    this.matrix[col][word.getRow()].getStyleClass().setAll((Object[])new String[]{"text-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
                }
            }
        }
        int n = this.minute > 60 ? this.minute - 60 : (min = this.minute < 0 ? this.minute + 60 : this.minute);
        if (min % 5 == 0) {
            this.p1.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p2.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p3.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p4.getStyleClass().setAll((Object[])new String[]{"dot-off", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
        } else if (min % 10 == 1 || min % 10 == 6) {
            this.p1.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
        } else if (min % 10 == 2 || min % 10 == 7) {
            this.p1.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p2.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
        } else if (min % 10 == 3 || min % 10 == 8) {
            this.p1.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p2.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p3.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
        } else if (min % 10 == 4 || min % 10 == 9) {
            this.p1.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p2.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p3.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
            this.p4.getStyleClass().setAll((Object[])new String[]{"dot-on", ((QlockTwo)this.getSkinnable()).getColor().STYLE_CLASS});
        }
    }

    private void resize() {
        double d = this.size = ((QlockTwo)this.getSkinnable()).getWidth() < ((QlockTwo)this.getSkinnable()).getHeight() ? ((QlockTwo)this.getSkinnable()).getWidth() : ((QlockTwo)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((QlockTwo)this.getSkinnable()).getWidth() - this.size) * 0.5, (((QlockTwo)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.background.setPrefSize(this.size, this.size);
            if (((QlockTwo)this.getSkinnable()).getColor() == QlockTwo.QlockColor.STAINLESS_STEEL) {
                this.stainlessBackground.setImage(this.texture.getImage(this.size, this.size));
            }
            this.p4.setPrefSize(0.012 * this.size, 0.012 * this.size);
            this.p4.setTranslateX(0.044 * this.size);
            this.p4.setTranslateY(0.944 * this.size);
            this.p3.setPrefSize(0.012 * this.size, 0.012 * this.size);
            this.p3.setTranslateX(0.944 * this.size);
            this.p3.setTranslateY(0.944 * this.size);
            this.p2.setPrefSize(0.012 * this.size, 0.012 * this.size);
            this.p2.setTranslateX(0.944 * this.size);
            this.p2.setTranslateY(0.044 * this.size);
            this.p1.setPrefSize(0.012 * this.size, 0.012 * this.size);
            this.p1.setTranslateX(0.044 * this.size);
            this.p1.setTranslateY(0.044 * this.size);
            this.startX = this.size * 0.114;
            this.startY = this.size * 0.112;
            this.stepX = this.size * 0.072;
            this.stepY = this.size * 0.08;
            this.font = Fonts.dinFun(this.size * 0.048);
            IntStream.range(0, 10).parallel().forEachOrdered(y -> IntStream.range(0, 11).parallel().forEachOrdered(x -> {
                this.matrix[x][y].setFont(this.font);
                this.matrix[x][y].setPrefSize(this.size * 0.048, this.size * 0.048);
                this.matrix[x][y].setTranslateY(this.startY + (double)y * this.stepY);
                this.matrix[x][y].setTranslateX(this.startX + (double)x * this.stepX);
                this.matrix[x][y].setTranslateY(this.startY + (double)y * this.stepY);
            }));
            this.highlight.setPrefSize(0.8572706909179687 * this.size, 0.7135147094726563 * this.size);
            this.highlight.setTranslateX(0.14224906921386718 * this.size);
            this.highlight.setTranslateY(0.28614569091796876 * this.size);
        }
    }
}

