/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.radialmenu;

import eu.hansolo.enzo.common.Symbol;
import eu.hansolo.enzo.common.SymbolType;
import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.radialmenu.RadialMenuButton;
import eu.hansolo.enzo.radialmenu.RadialMenuItem;
import eu.hansolo.enzo.radialmenu.RadialMenuOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class RadialMenu
extends Region {
    private ObservableMap<Parent, RadialMenuItem> items;
    private State defaultState;
    private ObjectProperty<State> state;
    private double degrees;
    private int positions;
    private Timeline[] openTimeLines;
    private Timeline[] closeTimeLines;
    private RadialMenuOptions options;
    private RadialMenuButton mainMenuButton;
    private Group cross;
    private boolean firstTime;
    private EventHandler<MouseEvent> mouseHandler;
    private ObjectProperty<EventHandler<ItemEvent>> onItemClicked = new ObjectPropertyBase<EventHandler<ItemEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onItemClicked";
        }
    };
    private ObjectProperty<EventHandler<ItemEvent>> onItemSelected = new ObjectPropertyBase<EventHandler<ItemEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onItemSelected";
        }
    };
    private ObjectProperty<EventHandler<ItemEvent>> onItemDeselected = new ObjectPropertyBase<EventHandler<ItemEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onItemDeselected";
        }
    };
    private ObjectProperty<EventHandler<MenuEvent>> onMenuOpenStarted = new ObjectPropertyBase<EventHandler<MenuEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onMenuOpenStarted";
        }
    };
    private ObjectProperty<EventHandler<MenuEvent>> onMenuOpenFinished = new ObjectPropertyBase<EventHandler<MenuEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onMenuOpenFinished";
        }
    };
    private ObjectProperty<EventHandler<MenuEvent>> onMenuCloseStarted = new ObjectPropertyBase<EventHandler<MenuEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onMenuCloseStarted";
        }
    };
    private ObjectProperty<EventHandler<MenuEvent>> onMenuCloseFinished = new ObjectPropertyBase<EventHandler<MenuEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onMenuCloseFinished";
        }
    };

    public RadialMenu(RadialMenuOptions OPTIONS, RadialMenuItem ... ITEMS) {
        this(OPTIONS, Arrays.asList(ITEMS));
    }

    public RadialMenu(RadialMenuOptions OPTIONS, List<RadialMenuItem> ITEMS) {
        this.options = OPTIONS;
        this.items = FXCollections.observableHashMap();
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("radialmenu.css").toExternalForm());
        this.getStyleClass().addAll((Object[])new String[]{"radial-menu"});
        this.state = new SimpleObjectProperty((Object)this, "state", (Object)State.CLOSED);
        this.degrees = Math.max(Math.min(360.0, this.options.getDegrees()), 0.0);
        this.cross = new Group();
        this.firstTime = true;
        this.initHandler();
        this.initMainButton();
        this.initMenuItems(ITEMS);
        this.initGraphics();
        this.registerListeners();
    }

    private void initMainButton() {
        this.mainMenuButton = new RadialMenuButton(this);
        this.mainMenuButton.setPrefSize(this.options.getButtonSize(), this.options.getButtonSize());
        this.mainMenuButton.setStyle("-button-color: " + Util.colorToCss(this.options.getButtonFillColor()));
        this.mainMenuButton.setOpacity(this.options.getButtonAlpha());
    }

    private void initMenuItems(List<RadialMenuItem> ITEMS) {
        HashMap<StackPane, RadialMenuItem> itemMap = new HashMap<StackPane, RadialMenuItem>(ITEMS.size());
        this.positions = Double.compare(this.degrees, 360.0) == 0 ? ITEMS.size() : ITEMS.size() - 1;
        this.openTimeLines = new Timeline[ITEMS.size()];
        this.closeTimeLines = new Timeline[ITEMS.size()];
        for (int i = 0; i < ITEMS.size(); ++i) {
            RadialMenuItem item = ITEMS.get(i);
            StackPane ITEM_CONTAINER = new StackPane();
            ITEM_CONTAINER.setPrefSize(item.getSize(), item.getSize());
            ITEM_CONTAINER.setMaxSize(item.getSize(), item.getSize());
            ITEM_CONTAINER.getChildren().add((Object)item);
            if (SymbolType.NONE == item.getSymbolType() && item.getThumbnailImageName().isEmpty()) {
                Text text = new Text(item.getText());
                text.setFont(Font.font((String)"Open Sans", (FontWeight)FontWeight.BOLD, (double)(item.getSize() * 0.5)));
                text.setFill((Paint)item.getForegroundColor());
                text.setMouseTransparent(true);
                ITEM_CONTAINER.getChildren().add((Object)text);
            } else if (!item.getThumbnailImageName().isEmpty()) {
                try {
                    ITEM_CONTAINER.getChildren().add((Object)this.createThumbnail(item));
                }
                catch (IllegalArgumentException exception) {
                    Text text = new Text(Integer.toString(i));
                    text.setFont(Font.font((String)"Open Sans", (FontWeight)FontWeight.BOLD, (double)(item.getSize() * 0.5)));
                    text.setFill((Paint)item.getForegroundColor());
                    text.setMouseTransparent(true);
                    ITEM_CONTAINER.getChildren().add((Object)text);
                }
            } else {
                Symbol symbol = new Symbol(item.getSymbolType(), 0.65 * item.getSize(), Color.WHITE, false);
                symbol.setMouseTransparent(true);
                ITEM_CONTAINER.getChildren().add((Object)symbol);
            }
            ITEM_CONTAINER.setPickOnBounds(false);
            ITEM_CONTAINER.setOpacity(0.0);
            double degree = (this.degrees / (double)this.positions * (double)i + this.options.getOffset()) % 360.0;
            Point2D position = new Point2D(Math.cos(Math.toRadians(degree)), Math.sin(Math.toRadians(degree)));
            double x = Math.round(position.getX() * this.options.getRadius());
            double y = Math.round(position.getY() * this.options.getRadius());
            double delay = 200 / ITEMS.size() * i;
            this.openTimeLines[i] = this.options.isSimpleMode() ? this.createSimpleItemOpenTimeLine(ITEM_CONTAINER, x, y, delay) : this.createItemOpenTimeLine(ITEM_CONTAINER, x, y, delay);
            this.closeTimeLines[i] = this.options.isSimpleMode() ? this.createSimpleItemCloseTimeLine(ITEM_CONTAINER, x, y, delay) : this.createItemCloseTimeLine(ITEM_CONTAINER, x, y, delay);
            ITEM_CONTAINER.setOnMousePressed(this.mouseHandler);
            ITEM_CONTAINER.setOnMouseReleased(this.mouseHandler);
            itemMap.put(ITEM_CONTAINER, item);
        }
        this.items.putAll(itemMap);
    }

    private void initGraphics() {
        this.getChildren().setAll((Collection)this.items.keySet());
        this.getChildren().add((Object)this.mainMenuButton);
    }

    private void initHandler() {
        this.mouseHandler = mouseEvent -> {
            Object SOURCE = mouseEvent.getSource();
            if (MouseEvent.MOUSE_PRESSED == mouseEvent.getEventType()) {
                RadialMenuItem menuItem = (RadialMenuItem)((Object)((Object)this.items.get(SOURCE)));
                if (menuItem.isSelectable()) {
                    menuItem.setSelected(!menuItem.isSelected());
                    if (menuItem.isSelected()) {
                        this.fireItemEvent(new ItemEvent(menuItem, (Object)this, null, ItemEvent.ITEM_SELECTED));
                    } else {
                        this.fireItemEvent(new ItemEvent(menuItem, (Object)this, null, ItemEvent.ITEM_DESELECTED));
                    }
                } else {
                    this.click(menuItem);
                    this.fireItemEvent(new ItemEvent(menuItem, (Object)this, null, ItemEvent.ITEM_CLICKED));
                }
            }
        };
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> this.resize());
        this.heightProperty().addListener(observable -> this.resize());
        this.mainMenuButton.openProperty().addListener(observable -> {
            if (this.mainMenuButton.isOpen()) {
                this.fireMenuEvent(new MenuEvent((Object)this, (EventTarget)this, MenuEvent.MENU_OPEN_STARTED));
                this.open();
            } else {
                this.fireMenuEvent(new MenuEvent((Object)this, (EventTarget)this, MenuEvent.MENU_CLOSE_STARTED));
                this.close();
            }
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
        if (this.firstTime) {
            this.resize();
            this.firstTime = false;
        }
    }

    public final State getState() {
        return null == this.state ? this.defaultState : (State)((Object)this.state.get());
    }

    private final void setState(State STATE) {
        if (null == this.state) {
            this.defaultState = STATE;
        } else {
            this.state.set((Object)STATE);
        }
    }

    public final ReadOnlyObjectProperty<State> stateProperty() {
        if (null == this.state) {
            this.state = new SimpleObjectProperty((Object)this, "state", (Object)this.defaultState);
        }
        return this.state;
    }

    public RadialMenuItem getItem(int INDEX) {
        if (INDEX < 0 || INDEX > this.items.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getItems().get(INDEX);
    }

    public void addItem(RadialMenuItem ITEM) {
        LinkedList<RadialMenuItem> tmpItems = new LinkedList<RadialMenuItem>(this.items.values());
        tmpItems.add(ITEM);
        this.initMenuItems(tmpItems);
        this.initGraphics();
    }

    public void removeItem(RadialMenuItem ITEM) {
        if (!this.items.values().contains((Object)ITEM)) {
            return;
        }
        List tmpItems = (List)this.items.values();
        tmpItems.remove((Object)ITEM);
        this.initMenuItems(tmpItems);
        this.initGraphics();
    }

    public List<RadialMenuItem> getItems() {
        ArrayList<RadialMenuItem> tmpList = new ArrayList<RadialMenuItem>(this.items.size());
        for (RadialMenuItem item : this.items.values()) {
            tmpList.add(item);
        }
        return tmpList;
    }

    protected RadialMenuOptions getOptions() {
        return this.options;
    }

    public void open() {
        if (!this.mainMenuButton.isOpen()) {
            this.mainMenuButton.setOpen(true);
        }
        if (!this.options.isButtonHideOnSelect()) {
            this.show();
        }
        if (State.OPENED == this.getState()) {
            return;
        }
        this.setState(State.OPENED);
        this.mainMenuButton.setOpacity(1.0);
        this.openTimeLines[this.openTimeLines.length - 1].setOnFinished(actionEvent -> this.fireMenuEvent(new MenuEvent((Object)this, null, MenuEvent.MENU_OPEN_FINISHED)));
        for (int i = 0; i < this.openTimeLines.length; ++i) {
            this.openTimeLines[i].play();
        }
    }

    public void close() {
        if (State.CLOSED == this.getState()) {
            return;
        }
        this.setState(State.CLOSED);
        RotateTransition rotate = new RotateTransition();
        rotate.setNode((Node)this.cross);
        rotate.setToAngle(0.0);
        rotate.setDuration(Duration.millis((double)200.0));
        rotate.setInterpolator(Interpolator.EASE_BOTH);
        rotate.play();
        this.closeTimeLines[this.closeTimeLines.length - 1].setOnFinished(actionEvent -> {
            FadeTransition buttonFadeOut = new FadeTransition();
            buttonFadeOut.setNode((Node)this.mainMenuButton);
            buttonFadeOut.setDuration(Duration.millis((double)100.0));
            buttonFadeOut.setToValue(this.options.getButtonAlpha());
            buttonFadeOut.play();
            buttonFadeOut.setOnFinished(event -> {
                if (this.options.isButtonHideOnClose()) {
                    this.hide();
                }
                this.fireMenuEvent(new MenuEvent((Object)this, null, MenuEvent.MENU_CLOSE_FINISHED));
            });
        });
        IntStream.range(0, this.closeTimeLines.length).forEach(i -> this.closeTimeLines[i].play());
    }

    public void show() {
        if (this.options.isButtonHideOnSelect() && this.mainMenuButton.getOpacity() > 0.0) {
            return;
        }
        if (this.options.isButtonHideOnSelect() || this.mainMenuButton.getOpacity() == 0.0) {
            this.mainMenuButton.setScaleX(1.0);
            this.mainMenuButton.setScaleY(1.0);
            this.cross.setRotate(0.0);
            this.mainMenuButton.setRotate(0.0);
            FadeTransition buttonFadeIn = new FadeTransition();
            buttonFadeIn.setNode((Node)this.mainMenuButton);
            buttonFadeIn.setDuration(Duration.millis((double)200.0));
            buttonFadeIn.setToValue(this.options.getButtonAlpha());
            buttonFadeIn.play();
        }
        for (Parent node : this.items.keySet()) {
            node.setScaleX(1.0);
            node.setScaleY(1.0);
            node.setTranslateX(0.0);
            node.setTranslateY(0.0);
            node.setRotate(0.0);
        }
    }

    public void hide() {
        this.setState(State.CLOSED);
        this.mainMenuButton.setOpacity(0.0);
        this.mainMenuButton.setOpen(false);
        for (Parent node : this.items.keySet()) {
            node.setOpacity(0.0);
        }
    }

    public void click(RadialMenuItem CLICKED_ITEM) {
        ArrayList<Object> transitions = new ArrayList<Object>(this.items.size() * 2);
        for (Parent node : this.items.keySet()) {
            if (((Object)((Object)((RadialMenuItem)((Object)this.items.get((Object)node))))).equals((Object)CLICKED_ITEM)) {
                ScaleTransition enlargeItem = new ScaleTransition(Duration.millis((double)300.0), (Node)node);
                enlargeItem.setToX(5.0);
                enlargeItem.setToY(5.0);
                enlargeItem.setOnFinished(event -> {
                    node.setScaleX(1.0);
                    node.setScaleY(1.0);
                });
                transitions.add(enlargeItem);
            } else {
                ScaleTransition shrinkItem = new ScaleTransition(Duration.millis((double)300.0), (Node)node);
                shrinkItem.setToX(0.0);
                shrinkItem.setToY(0.0);
                transitions.add(shrinkItem);
            }
            FadeTransition fadeOutItem = new FadeTransition(Duration.millis((double)300.0), (Node)node);
            fadeOutItem.setToValue(0.0);
            fadeOutItem.setOnFinished(event -> {
                node.setTranslateX(0.0);
                node.setTranslateY(0.0);
            });
            transitions.add(fadeOutItem);
        }
        if (this.options.isButtonHideOnSelect()) {
            RotateTransition rotateMainButton = new RotateTransition(Duration.millis((double)300.0), (Node)this.mainMenuButton);
            rotateMainButton.setToAngle(225.0);
            transitions.add(rotateMainButton);
            FadeTransition fadeOutMainButton = new FadeTransition(Duration.millis((double)300.0), (Node)this.mainMenuButton);
            fadeOutMainButton.setToValue(0.0);
            transitions.add(fadeOutMainButton);
            ScaleTransition shrinkMainButton = new ScaleTransition(Duration.millis((double)300.0), (Node)this.mainMenuButton);
            shrinkMainButton.setToX(0.0);
            shrinkMainButton.setToY(0.0);
            transitions.add(shrinkMainButton);
        } else {
            RotateTransition rotateBackMainButton = new RotateTransition();
            rotateBackMainButton.setNode((Node)this.cross);
            rotateBackMainButton.setToAngle(0.0);
            rotateBackMainButton.setDuration(Duration.millis((double)200.0));
            rotateBackMainButton.setInterpolator(Interpolator.EASE_BOTH);
            transitions.add(rotateBackMainButton);
            FadeTransition mainButtonFadeOut = new FadeTransition();
            mainButtonFadeOut.setNode((Node)this.mainMenuButton);
            mainButtonFadeOut.setDuration(Duration.millis((double)100.0));
            mainButtonFadeOut.setToValue(this.options.getButtonAlpha());
            transitions.add(mainButtonFadeOut);
        }
        ParallelTransition selectTransition = new ParallelTransition();
        selectTransition.getChildren().addAll(transitions);
        selectTransition.play();
        this.setState(State.CLOSED);
        this.mainMenuButton.setOpen(false);
    }

    private ImageView createThumbnail(RadialMenuItem ITEM) {
        ImageView imageItem = new ImageView(new Image(ITEM.getThumbnailImageName()));
        imageItem.setFitWidth(ITEM.getSize() * 0.65);
        imageItem.setFitHeight(ITEM.getSize() * 0.65);
        imageItem.setMouseTransparent(true);
        return imageItem;
    }

    private Timeline createItemOpenTimeLine(StackPane NODE, double X, double Y, double DELAY) {
        KeyValue kvX1 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvY1 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvR1 = new KeyValue((WritableValue)NODE.rotateProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvO1 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)0.0, Interpolator.EASE_OUT);
        KeyValue kvX2 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0.0);
        KeyValue kvY2 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0.0);
        KeyValue kvX3 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)(1.1 * X), Interpolator.EASE_IN);
        KeyValue kvY3 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)(1.1 * Y), Interpolator.EASE_IN);
        KeyValue kvX4 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)(0.95 * X), Interpolator.EASE_OUT);
        KeyValue kvY4 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)(0.95 * Y), Interpolator.EASE_OUT);
        KeyValue kvRO4 = new KeyValue((WritableValue)NODE.rotateProperty(), (Object)360);
        KeyValue kvO4 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)1.0, Interpolator.EASE_OUT);
        KeyValue kvX5 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X);
        KeyValue kvY5 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y);
        KeyFrame kfO1 = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{kvX1, kvY1, kvR1, kvO1});
        KeyFrame kfO2 = new KeyFrame(Duration.millis((double)(50.0 + DELAY)), new KeyValue[]{kvX2, kvY2});
        KeyFrame kfO3 = new KeyFrame(Duration.millis((double)(250.0 + DELAY)), new KeyValue[]{kvX3, kvY3});
        KeyFrame kfO4 = new KeyFrame(Duration.millis((double)(400.0 + DELAY)), new KeyValue[]{kvX4, kvY4, kvRO4, kvO4});
        KeyFrame kfO5 = new KeyFrame(Duration.millis((double)(550.0 + DELAY)), new KeyValue[]{kvX5, kvY5});
        return new Timeline(new KeyFrame[]{kfO1, kfO2, kfO3, kfO4, kfO5});
    }

    private Timeline createItemCloseTimeLine(StackPane NODE, double X, double Y, double DELAY) {
        KeyValue kvX1 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X);
        KeyValue kvY1 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y);
        KeyValue kvRC2 = new KeyValue((WritableValue)NODE.rotateProperty(), (Object)720);
        KeyValue kvX3 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X, Interpolator.EASE_IN);
        KeyValue kvY3 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y, Interpolator.EASE_IN);
        KeyValue kvX4 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0);
        KeyValue kvY4 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0);
        KeyValue kvX5 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvY5 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvR5 = new KeyValue((WritableValue)NODE.rotateProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvO5 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)0.5);
        KeyValue kvO6 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)0);
        KeyFrame kfC1 = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{kvX1, kvY1});
        KeyFrame kfC2 = new KeyFrame(Duration.millis((double)(50.0 + DELAY)), new KeyValue[]{kvRC2});
        KeyFrame kfC3 = new KeyFrame(Duration.millis((double)(250.0 + DELAY)), new KeyValue[]{kvX3, kvY3});
        KeyFrame kfC4 = new KeyFrame(Duration.millis((double)(400.0 + DELAY)), new KeyValue[]{kvX4, kvY4});
        KeyFrame kfC5 = new KeyFrame(Duration.millis((double)(550.0 + DELAY)), new KeyValue[]{kvX5, kvY5, kvR5, kvO5});
        KeyFrame kfC6 = new KeyFrame(Duration.millis((double)(551.0 + DELAY)), new KeyValue[]{kvO6});
        return new Timeline(new KeyFrame[]{kfC1, kfC2, kfC3, kfC4, kfC5, kfC6});
    }

    private Timeline createSimpleItemOpenTimeLine(StackPane NODE, double X, double Y, double DELAY) {
        KeyValue kvX1 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvY1 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvO1 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvX2 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0.0);
        KeyValue kvY2 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0.0);
        KeyValue kvX4 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X, Interpolator.EASE_OUT);
        KeyValue kvY4 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y, Interpolator.EASE_OUT);
        KeyValue kvO4 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)1.0, Interpolator.EASE_OUT);
        KeyValue kvX5 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X);
        KeyValue kvY5 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y);
        KeyFrame kfO1 = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{kvX1, kvY1, kvO1});
        KeyFrame kfO2 = new KeyFrame(Duration.millis((double)(50.0 + DELAY)), new KeyValue[]{kvX2, kvY2});
        KeyFrame kfO4 = new KeyFrame(Duration.millis((double)(400.0 + DELAY)), new KeyValue[]{kvX4, kvY4, kvO4});
        KeyFrame kfO5 = new KeyFrame(Duration.millis((double)(500.0 + DELAY)), new KeyValue[]{kvX5, kvY5});
        return new Timeline(new KeyFrame[]{kfO1, kfO2, kfO4, kfO5});
    }

    private Timeline createSimpleItemCloseTimeLine(StackPane NODE, double X, double Y, double DELAY) {
        KeyValue kvX1 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X);
        KeyValue kvY1 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y);
        KeyValue kvX3 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)X, Interpolator.EASE_IN);
        KeyValue kvY3 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)Y, Interpolator.EASE_IN);
        KeyValue kvX4 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0.0);
        KeyValue kvY4 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0.0);
        KeyValue kvX5 = new KeyValue((WritableValue)NODE.translateXProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvY5 = new KeyValue((WritableValue)NODE.translateYProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvO5 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)0.5);
        KeyValue kvO6 = new KeyValue((WritableValue)NODE.opacityProperty(), (Object)0);
        KeyFrame kfC1 = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{kvX1, kvY1});
        KeyFrame kfC3 = new KeyFrame(Duration.millis((double)(0.0 + DELAY)), new KeyValue[]{kvX3, kvY3});
        KeyFrame kfC4 = new KeyFrame(Duration.millis((double)(350.0 + DELAY)), new KeyValue[]{kvX4, kvY4});
        KeyFrame kfC5 = new KeyFrame(Duration.millis((double)(500.0 + DELAY)), new KeyValue[]{kvX5, kvY5, kvO5});
        KeyFrame kfC6 = new KeyFrame(Duration.millis((double)(501.0 + DELAY)), new KeyValue[]{kvO6});
        return new Timeline(new KeyFrame[]{kfC1, kfC3, kfC4, kfC5, kfC6});
    }

    private void resize() {
        this.mainMenuButton.relocate((this.getPrefWidth() - this.options.getButtonSize()) * 0.5, (this.getPrefHeight() - this.options.getButtonSize()) * 0.5);
        for (Parent node : this.items.keySet()) {
            node.setLayoutX((this.getPrefWidth() - node.getLayoutBounds().getWidth()) * 0.5);
            node.setLayoutY((this.getPrefHeight() - node.getLayoutBounds().getHeight()) * 0.5);
        }
    }

    public final ObjectProperty<EventHandler<ItemEvent>> onItemClickedProperty() {
        return this.onItemClicked;
    }

    public final void setOnItemClicked(EventHandler<ItemEvent> value) {
        this.onItemClickedProperty().set(value);
    }

    public final EventHandler<ItemEvent> getOnItemClicked() {
        return (EventHandler)this.onItemClickedProperty().get();
    }

    public final ObjectProperty<EventHandler<ItemEvent>> onItemSelectedProperty() {
        return this.onItemSelected;
    }

    public final void setOnItemSelected(EventHandler<ItemEvent> value) {
        this.onItemSelectedProperty().set(value);
    }

    public final EventHandler<ItemEvent> getOnItemSelected() {
        return (EventHandler)this.onItemSelectedProperty().get();
    }

    public final ObjectProperty<EventHandler<ItemEvent>> onItemDeselectedProperty() {
        return this.onItemDeselected;
    }

    public final void setOnItemDeselected(EventHandler<ItemEvent> value) {
        this.onItemDeselectedProperty().set(value);
    }

    public final EventHandler<ItemEvent> getOnItemDeselected() {
        return (EventHandler)this.onItemDeselectedProperty().get();
    }

    public void fireItemEvent(ItemEvent EVENT) {
        this.fireEvent(EVENT);
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = ItemEvent.ITEM_CLICKED == TYPE ? this.getOnItemClicked() : (ItemEvent.ITEM_SELECTED == TYPE ? this.getOnItemSelected() : (ItemEvent.ITEM_DESELECTED == TYPE ? this.getOnItemDeselected() : null));
        if (HANDLER != null) {
            HANDLER.handle((Event)EVENT);
        }
    }

    public final ObjectProperty<EventHandler<MenuEvent>> onMenuOpenStartedProperty() {
        return this.onMenuOpenStarted;
    }

    public final void setOnMenuOpenStarted(EventHandler<MenuEvent> value) {
        this.onMenuOpenStartedProperty().set(value);
    }

    public final EventHandler<MenuEvent> getOnMenuOpenStarted() {
        return (EventHandler)this.onMenuOpenStartedProperty().get();
    }

    public final ObjectProperty<EventHandler<MenuEvent>> onMenuOpenFinishedProperty() {
        return this.onMenuOpenFinished;
    }

    public final void setOnMenuOpenFinished(EventHandler<MenuEvent> value) {
        this.onMenuOpenFinishedProperty().set(value);
    }

    public final EventHandler<MenuEvent> getOnMenuOpenFinished() {
        return (EventHandler)this.onMenuOpenFinishedProperty().get();
    }

    public final ObjectProperty<EventHandler<MenuEvent>> onMenuCloseStartedProperty() {
        return this.onMenuCloseStarted;
    }

    public final void setOnMenuCloseStarted(EventHandler<MenuEvent> value) {
        this.onMenuCloseStartedProperty().set(value);
    }

    public final EventHandler<MenuEvent> getOnMenuCloseStarted() {
        return (EventHandler)this.onMenuCloseStartedProperty().get();
    }

    public final ObjectProperty<EventHandler<MenuEvent>> onMenuCloseFinishedProperty() {
        return this.onMenuCloseFinished;
    }

    public final void setOnMenuCloseFinished(EventHandler<MenuEvent> value) {
        this.onMenuCloseFinishedProperty().set(value);
    }

    public final EventHandler<MenuEvent> getOnMenuCloseFinished() {
        return (EventHandler)this.onMenuCloseFinishedProperty().get();
    }

    public void fireMenuEvent(MenuEvent EVENT) {
        this.fireEvent(EVENT);
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = MenuEvent.MENU_OPEN_STARTED == TYPE ? this.getOnMenuOpenStarted() : (MenuEvent.MENU_OPEN_FINISHED == TYPE ? this.getOnMenuOpenFinished() : (MenuEvent.MENU_CLOSE_STARTED == TYPE ? this.getOnMenuCloseStarted() : (MenuEvent.MENU_CLOSE_FINISHED == TYPE ? this.getOnMenuCloseFinished() : null)));
        if (HANDLER != null) {
            HANDLER.handle((Event)EVENT);
        }
    }

    public static class MenuEvent
    extends Event {
        public static final EventType<MenuEvent> MENU_OPEN_STARTED = new EventType(ANY, "menuOpenStarted");
        public static final EventType<MenuEvent> MENU_OPEN_FINISHED = new EventType(ANY, "menuOpenFinished");
        public static final EventType<MenuEvent> MENU_CLOSE_STARTED = new EventType(ANY, "menuCloseStarted");
        public static final EventType<MenuEvent> MENU_CLOSE_FINISHED = new EventType(ANY, "menuCloseFinished");

        public MenuEvent(Object SOURCE, EventTarget TARGET, EventType<MenuEvent> EVENT_TYPE) {
            super(SOURCE, TARGET, EVENT_TYPE);
        }
    }

    public static class ItemEvent
    extends Event {
        public static final EventType<ItemEvent> ITEM_CLICKED = new EventType(ANY, "itemClicked");
        public static final EventType<ItemEvent> ITEM_SELECTED = new EventType(ANY, "itemSelected");
        public static final EventType<ItemEvent> ITEM_DESELECTED = new EventType(ANY, "itemDeselected");
        public RadialMenuItem item;

        public ItemEvent(RadialMenuItem ITEM, Object SOURCE, EventTarget TARGET, EventType<ItemEvent> EVENT_TYPE) {
            super(SOURCE, TARGET, EVENT_TYPE);
            this.item = ITEM;
        }
    }

    public static enum State {
        OPENED,
        CLOSED;

    }
}

