/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.sevensegment;

import eu.hansolo.enzo.sevensegment.skin.SevenSegmentSkin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class SevenSegment
extends Control {
    public static final String STYLE_CLASS_RED = "red";
    public static final String STYLE_CLASS_GREEN = "green";
    public static final String STYLE_CLASS_BLUE = "blue";
    public static final String STYLE_CLASS_YELLOW = "yellow";
    public static final String STYLE_CLASS_ORANGE = "orange";
    public static final String STYLE_CLASS_CYAN = "cyan";
    public static final String STYLE_CLASS_MAGENTA = "magenta";
    public static final String STYLE_CLASS_WHITE = "white";
    public static final String STYLE_CLASS_BLACK = "black";
    private boolean keepAspect;
    private String _character = " ";
    private StringProperty character;
    private boolean _dotOn = false;
    private BooleanProperty dotOn;
    private SegmentStyle _segmentStyle;
    private ObjectProperty<SegmentStyle> segmentStyle;
    private Map<Integer, List<Segment>> mapping;

    public SevenSegment() {
        this(" ", SegmentStyle.RED);
    }

    public SevenSegment(String CHARACTER) {
        this(CHARACTER, SegmentStyle.RED);
    }

    public SevenSegment(Character CHARACTER) {
        this(CHARACTER, SegmentStyle.RED);
    }

    public SevenSegment(int CHARACTER) {
        this(Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER)), SegmentStyle.RED);
    }

    public SevenSegment(Character CHARACTER, SegmentStyle SEGMENT_STYLE) {
        this(String.valueOf(CHARACTER), SEGMENT_STYLE);
    }

    public SevenSegment(int CHARACTER, SegmentStyle SEGMENT_STYLE) {
        this(Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER)), SEGMENT_STYLE);
    }

    public SevenSegment(String CHARACTER, SegmentStyle SEGMENT_STYLE) {
        this.getStyleClass().add((Object)"seven-segment");
        this.keepAspect = true;
        this._character = CHARACTER.substring(0, 1);
        this._segmentStyle = SEGMENT_STYLE;
        this.mapping = new HashMap<Integer, List<Segment>>(48);
        this.initMapping();
    }

    private void initMapping() {
        this.mapping.put(20, Arrays.asList(new Segment[0]));
        this.mapping.put(46, Arrays.asList(Segment.DOT));
        this.mapping.put(48, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.E, Segment.F));
        this.mapping.put(49, Arrays.asList(Segment.B, Segment.C));
        this.mapping.put(50, Arrays.asList(Segment.A, Segment.B, Segment.D, Segment.E, Segment.G));
        this.mapping.put(51, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.G));
        this.mapping.put(52, Arrays.asList(Segment.B, Segment.C, Segment.F, Segment.G));
        this.mapping.put(53, Arrays.asList(Segment.A, Segment.C, Segment.D, Segment.F, Segment.G));
        this.mapping.put(54, Arrays.asList(Segment.A, Segment.C, Segment.D, Segment.E, Segment.F, Segment.G));
        this.mapping.put(55, Arrays.asList(Segment.A, Segment.B, Segment.C));
        this.mapping.put(56, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.E, Segment.F, Segment.G));
        this.mapping.put(57, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.F, Segment.G));
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final void setKeepAspect(boolean KEEP_ASPECT) {
        this.keepAspect = KEEP_ASPECT;
    }

    public final String getCharacter() {
        return null == this.character ? this._character : (String)this.character.get();
    }

    public final void setCharacter(String CHARACTER) {
        if (null == this.character) {
            this._character = CHARACTER.substring(0, 1);
        } else {
            this.character.set((Object)CHARACTER.substring(0, 1));
        }
    }

    public final void setCharacter(Character CHARACTER) {
        if (null == this.character) {
            this._character = String.valueOf(CHARACTER);
        } else {
            this.character.set((Object)String.valueOf(CHARACTER));
        }
    }

    public final void setCharacter(int CHARACTER) {
        if (null == this.character) {
            this._character = Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER));
        } else {
            this.character.set((Object)Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER)));
        }
    }

    public final ReadOnlyStringProperty characterProperty() {
        if (null == this.character) {
            this.character = new SimpleStringProperty((Object)this, "character", this._character);
        }
        return this.character;
    }

    public final boolean isDotOn() {
        return null == this.dotOn ? this._dotOn : this.dotOn.get();
    }

    public final void setDotOn(boolean DOT_ON) {
        if (null == this.dotOn) {
            this._dotOn = DOT_ON;
        } else {
            this.dotOn.set(DOT_ON);
        }
    }

    public final BooleanProperty dotOnProperty() {
        if (null == this.dotOn) {
            this.dotOn = new SimpleBooleanProperty((Object)this, "dotOn", this._dotOn);
        }
        return this.dotOn;
    }

    public final SegmentStyle getSegmentStyle() {
        return null == this.segmentStyle ? this._segmentStyle : (SegmentStyle)((Object)this.segmentStyle.get());
    }

    public final void setSegmentStyle(SegmentStyle SEGMENT_STYLE) {
        if (null == this.segmentStyle) {
            this._segmentStyle = SEGMENT_STYLE;
        } else {
            this.segmentStyle.set((Object)SEGMENT_STYLE);
        }
    }

    public final ObjectProperty<SegmentStyle> segmentStyleProperty() {
        if (null == this.segmentStyle) {
            this.segmentStyle = new SimpleObjectProperty((Object)this, "segmentStyle", (Object)this._segmentStyle);
        }
        return this.segmentStyle;
    }

    public final Map<Integer, List<Segment>> getSegmentMapping() {
        HashMap<Integer, List<Segment>> segmentMapping = new HashMap<Integer, List<Segment>>(48);
        for (int key : this.mapping.keySet()) {
            segmentMapping.put(key, this.mapping.get(key));
        }
        return segmentMapping;
    }

    public boolean isResizable() {
        return true;
    }

    protected Skin createDefaultSkin() {
        return new SevenSegmentSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".css").toExternalForm();
    }

    public static enum SegmentStyle {
        RED("red"),
        GREEN("green"),
        BLUE("blue"),
        YELLOW("yellow"),
        ORANGE("orange"),
        CYAN("cyan"),
        MAGENTA("magenta"),
        WHITE("white"),
        BLACK("black");

        public final String ON_CLASS;
        public final String OFF_CLASS;

        private SegmentStyle(String CLASS_NAME) {
            this.ON_CLASS = CLASS_NAME;
            this.OFF_CLASS = CLASS_NAME + "-off";
        }
    }

    public static enum Segment {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        DOT;

    }
}

