/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.vumeter;

import eu.hansolo.enzo.common.SectionBuilder;
import eu.hansolo.enzo.vumeter.VuMeter;
import eu.hansolo.enzo.vumeter.VuMeterBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static int noOfNodes = 0;
    private static final Random RND = new Random();
    private VuMeter control;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.control = VuMeterBuilder.create().noOfLeds(25).peakValueVisible(true).orientation(Orientation.HORIZONTAL).sections(SectionBuilder.create().start(0.0).stop(0.6).styleClass("led-section-0").build(), SectionBuilder.create().start(0.6).stop(0.8).styleClass("led-section-1").build(), SectionBuilder.create().start(0.8).stop(1.0).styleClass("led-section-2").build()).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > Demo.this.lastTimerCall + 100000000L) {
                    Demo.this.control.setValue(RND.nextDouble());
                    Demo.this.lastTimerCall = NOW;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKGRAY, CornerRadii.EMPTY, Insets.EMPTY)}));
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.getChildren().add((Object)this.control);
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("VuMeter Demo");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        Demo.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Demo.calcNoOfNodes(n);
            }
        }
    }
}

