/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJep247;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJep247Jdk12
extends ClasspathJep247 {
    Map<String, IModule> modules;
    static String MODULE_INFO = "module-info.sig";

    public ClasspathJep247Jdk12(File file2, String string, AccessRuleSet accessRuleSet) {
        super(file2, string, accessRuleSet);
    }

    @Override
    public List<FileSystem.Classpath> fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3) {
        return this.findClass(cArray, string, string2, string3, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3, boolean bl) {
        if (!this.isPackage(string, string2)) {
            return null;
        }
        try {
            byte[] byArray;
            ClassFileReader classFileReader;
            block18: {
                classFileReader = null;
                byArray = null;
                string3 = string3.replace(".class", ".sig");
                if (this.subReleases != null && this.subReleases.length > 0) {
                    for (String string4 : this.subReleases) {
                        Path path;
                        if (string2 == null) {
                            path = this.fs.getPath(string4, new String[0]);
                            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                                for (Path path2 : directoryStream) {
                                    Path path3 = this.fs.getPath(string4, JRTUtil.sanitizedFileName(path2), string3);
                                    if (!Files.exists(path3, new LinkOption[0]) || (byArray = JRTUtil.safeReadBytes(path3)) == null) {
                                        continue;
                                    }
                                    break block18;
                                }
                                continue;
                            }
                        }
                        path = this.fs.getPath(string4, string2, string3);
                        if (!Files.exists(path, new LinkOption[0]) || (byArray = JRTUtil.safeReadBytes(path)) == null) {
                            continue;
                        }
                        break;
                    }
                } else {
                    byArray = JRTUtil.safeReadBytes(this.fs.getPath(this.releaseInHex, string3));
                }
            }
            if (byArray != null) {
                classFileReader = new ClassFileReader(byArray, string3.toCharArray());
                char[] cArray2 = string2 != null ? string2.toCharArray() : null;
                return new NameEnvironmentAnswer(classFileReader, this.fetchAccessRestriction(string3), cArray2);
            }
        }
        catch (IOException | ClassFormatException exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        Cloneable cloneable;
        if (this.compliance == null) {
            return;
        }
        if (this.fs != null) {
            super.initialize();
            return;
        }
        this.releaseInHex = Integer.toHexString(Integer.parseInt(this.compliance)).toUpperCase();
        Path path = this.jdkHome.toPath().resolve("lib").resolve("ct.sym");
        URI uRI = path.toUri();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        URI uRI2 = URI.create("jar:file:" + uRI.getRawPath());
        try {
            this.fs = FileSystems.getFileSystem(uRI2);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        if (this.fs == null) {
            cloneable = new HashMap();
            this.fs = FileSystems.newFileSystem(uRI2, cloneable);
        }
        this.releasePath = this.fs.getPath("/", new String[0]);
        if (!Files.exists(this.fs.getPath(this.releaseInHex, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("release " + this.compliance + " is not found in the system");
        }
        cloneable = new ArrayList();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.releasePath);){
            for (Path path2 : directoryStream) {
                String string = JRTUtil.sanitizedFileName(path2);
                if (!string.contains(this.releaseInHex)) continue;
                cloneable.add(string);
            }
            this.subReleases = cloneable.toArray(new String[cloneable.size()]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadModules() {
        if (this.jdklevel <= 0x340000L) {
            super.loadModules();
            return;
        }
        Path path = this.fs.getPath(this.releaseInHex, new String[0]);
        this.modulePath = this.file.getPath() + "|" + path.toString();
        this.modules = (Map)ModulesCache.get(this.modulePath);
        if (this.modules == null) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.releasePath);){
                final HashMap hashMap = new HashMap();
                for (Path path2 : directoryStream) {
                    String string = JRTUtil.sanitizedFileName(path2);
                    if (!string.contains(this.releaseInHex)) continue;
                    Files.walkFileTree(path2, Collections.EMPTY_SET, 2, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            if (basicFileAttributes.isDirectory() || path.getNameCount() < 3) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (path.getFileName().toString().equals(MODULE_INFO) && Files.exists(path, new LinkOption[0])) {
                                byte[] byArray = JRTUtil.safeReadBytes(path);
                                if (byArray == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                Path path2 = path.subpath(1, path.getNameCount() - 1);
                                String string = JRTUtil.sanitizedFileName(path2);
                                ClasspathJep247Jdk12.this.acceptModule(string, byArray, hashMap);
                                ClasspathJep247Jdk12.this.moduleNamesCache.add(string);
                            }
                            return FileVisitResult.SKIP_SIBLINGS;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                HashMap hashMap2 = ModulesCache;
                synchronized (hashMap2) {
                    if (ModulesCache.get(this.modulePath) == null) {
                        this.modules = Collections.unmodifiableMap(hashMap);
                        ModulesCache.put(this.modulePath, this.modules);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.moduleNamesCache.addAll(this.modules.keySet());
        }
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> collection, Function<String, IModule> function) {
        return this.selectModules(this.moduleNamesCache, collection, function);
    }

    @Override
    public IModule getModule(char[] cArray) {
        if (this.modules != null) {
            return this.modules.get(String.valueOf(cArray));
        }
        return null;
    }

    void acceptModule(String string, byte[] byArray, Map<String, IModule> map) {
        if (byArray == null) {
            return;
        }
        if (map.containsKey(string)) {
            return;
        }
        ClassFileReader classFileReader = null;
        try {
            classFileReader = new ClassFileReader(byArray, "module-info.class".toCharArray());
        }
        catch (ClassFormatException classFormatException) {
            classFormatException.printStackTrace();
        }
        if (classFileReader != null) {
            this.acceptModule(classFileReader, map);
        }
    }

    @Override
    void acceptModule(ClassFileReader classFileReader, Map<String, IModule> map) {
        IBinaryModule iBinaryModule;
        if (this.jdklevel <= 0x340000L) {
            super.acceptModule(classFileReader, map);
            return;
        }
        if (classFileReader != null && (iBinaryModule = classFileReader.getModuleDeclaration()) != null) {
            map.put(String.valueOf(iBinaryModule.name()), iBinaryModule);
        }
    }

    @Override
    public synchronized char[][] getModulesDeclaringPackage(String string, String string2) {
        Iterable<Object> iterable;
        if (this.packageCache == null) {
            this.packageCache = new HashSet(41);
            this.packageCache.add(Util.EMPTY_STRING);
            try {
                iterable = Files.newDirectoryStream(this.releasePath);
                try {
                    for (Path path : iterable) {
                        String string3 = JRTUtil.sanitizedFileName(path);
                        if (!string3.contains(this.releaseInHex)) continue;
                        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                        try {
                            for (Path path2 : directoryStream) {
                                Files.walkFileTree(path2, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                        if (path.getNameCount() <= 2) {
                                            return FileVisitResult.CONTINUE;
                                        }
                                        Path path2 = path.subpath(2, path.getNameCount());
                                        ClasspathJep247Jdk12.this.addToPackageCache(path2.toString(), false);
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                            }
                        }
                        finally {
                            if (directoryStream == null) continue;
                            directoryStream.close();
                        }
                    }
                }
                finally {
                    if (iterable != null) {
                        iterable.close();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string2 == null) {
            iterable = JRTUtil.getModulesDeclaringPackage(this.file, string, string2);
            return CharOperation.toCharArrays(iterable);
        }
        return this.singletonModuleNameIf(this.packageCache.contains(string));
    }
}

