/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationMethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.InnerClassInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ModuleInfo;
import org.eclipse.jdt.internal.compiler.classfmt.RecordComponentInfo;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationInfo;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IRecordComponent;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFileReader
extends ClassFileStruct
implements IBinaryType {
    private int accessFlags;
    private char[] classFileName;
    private char[] className;
    private int classNameIndex;
    private int constantPoolCount;
    private AnnotationInfo[] annotations;
    private TypeAnnotationInfo[] typeAnnotations;
    private FieldInfo[] fields;
    private ModuleInfo moduleDeclaration;
    public char[] moduleName;
    private int fieldsCount;
    private InnerClassInfo innerInfo;
    private InnerClassInfo[] innerInfos;
    private char[][] interfaceNames;
    private int interfacesCount;
    private char[][] permittedSubtypesNames;
    private int permittedSubtypesCount;
    private MethodInfo[] methods;
    private int methodsCount;
    private char[] signature;
    private char[] sourceName;
    private char[] sourceFileName;
    private char[] superclassName;
    private long tagBits;
    private long version;
    private char[] enclosingTypeName;
    private char[][][] missingTypeNames;
    private int enclosingNameAndTypeIndex;
    private char[] enclosingMethod;
    private char[] nestHost;
    private int nestMembersCount;
    private char[][] nestMembers;
    private boolean isRecord;
    private int recordComponentsCount;
    private RecordComponentInfo[] recordComponents;

    private static String printTypeModifiers(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if ((n & 1) != 0) {
            printWriter.print("public ");
        }
        if ((n & 2) != 0) {
            printWriter.print("private ");
        }
        if ((n & 0x10) != 0) {
            printWriter.print("final ");
        }
        if ((n & 0x20) != 0) {
            printWriter.print("super ");
        }
        if ((n & 0x200) != 0) {
            printWriter.print("interface ");
        }
        if ((n & 0x400) != 0) {
            printWriter.print("abstract ");
        }
        if ((n & 0x10000000) != 0) {
            printWriter.print("sealed ");
        }
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    public static ClassFileReader read(File file2) throws ClassFormatException, IOException {
        return ClassFileReader.read(file2, false);
    }

    public static ClassFileReader read(File file2, boolean bl) throws ClassFormatException, IOException {
        byte[] byArray = Util.getFileByteContent(file2);
        ClassFileReader classFileReader = new ClassFileReader(byArray, file2.getAbsolutePath().toCharArray());
        if (bl) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(InputStream inputStream, String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(inputStream, string, false);
    }

    public static ClassFileReader read(InputStream inputStream, String string, boolean bl) throws ClassFormatException, IOException {
        byte[] byArray = Util.getInputStreamAsByteArray(inputStream, -1);
        ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
        if (bl) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(ZipFile zipFile, String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(zipFile, string, false);
    }

    public static ClassFileReader readFromJrt(File file2, IModule iModule, String string) throws ClassFormatException, IOException {
        return JRTUtil.getClassfile(file2, string, iModule);
    }

    public static ClassFileReader readFromModule(File file2, String string, String string2, Predicate<String> predicate) throws ClassFormatException, IOException {
        return JRTUtil.getClassfile(file2, string2, string, predicate);
    }

    public static ClassFileReader read(ZipFile zipFile, String string, boolean bl) throws ClassFormatException, IOException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        byte[] byArray = Util.getZipEntryByteContent(zipEntry, zipFile);
        ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
        if (bl) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(string, false);
    }

    public static ClassFileReader read(String string, boolean bl) throws ClassFormatException, IOException {
        return ClassFileReader.read(new File(string), bl);
    }

    public ClassFileReader(byte[] byArray, char[] cArray) throws ClassFormatException {
        this(byArray, cArray, false);
    }

    public ClassFileReader(byte[] byArray, char[] cArray, boolean bl) throws ClassFormatException {
        super(byArray, null, 0);
        this.classFileName = cArray;
        int n = 10;
        try {
            int n2;
            int n3;
            int n4;
            this.version = ((long)this.u2At(6) << 16) + (long)this.u2At(4);
            this.constantPoolCount = this.u2At(8);
            this.constantPoolOffsets = new int[this.constantPoolCount];
            block37: for (n4 = 1; n4 < this.constantPoolCount; ++n4) {
                n3 = this.u1At(n);
                switch (n3) {
                    case 1: {
                        this.constantPoolOffsets[n4] = n;
                        n += this.u2At(n + 1);
                        n += 3;
                        continue block37;
                    }
                    case 3: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 4: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 5: {
                        this.constantPoolOffsets[n4] = n;
                        n += 9;
                        ++n4;
                        continue block37;
                    }
                    case 6: {
                        this.constantPoolOffsets[n4] = n;
                        n += 9;
                        ++n4;
                        continue block37;
                    }
                    case 7: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        continue block37;
                    }
                    case 8: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        continue block37;
                    }
                    case 9: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 10: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 11: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 12: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 15: {
                        this.constantPoolOffsets[n4] = n;
                        n += 4;
                        continue block37;
                    }
                    case 16: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        continue block37;
                    }
                    case 17: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 18: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        continue block37;
                    }
                    case 19: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        continue block37;
                    }
                    case 20: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                    }
                }
            }
            this.accessFlags = this.u2At(n);
            this.classNameIndex = this.u2At(n += 2);
            if (this.classNameIndex != 0) {
                this.className = this.getConstantClassNameAt(this.classNameIndex);
            }
            n4 = this.u2At(n += 2);
            n += 2;
            if (n4 != 0) {
                this.superclassName = this.getConstantClassNameAt(n4);
                if (CharOperation.equals(this.superclassName, TypeConstants.CharArray_JAVA_LANG_RECORD_SLASH)) {
                    this.accessFlags |= 0x1000000;
                }
            }
            this.interfacesCount = this.u2At(n);
            n += 2;
            if (this.interfacesCount != 0) {
                this.interfaceNames = new char[this.interfacesCount][];
                for (n3 = 0; n3 < this.interfacesCount; ++n3) {
                    this.interfaceNames[n3] = this.getConstantClassNameAt(this.u2At(n));
                    n += 2;
                }
            }
            this.fieldsCount = this.u2At(n);
            n += 2;
            if (this.fieldsCount != 0) {
                this.fields = new FieldInfo[this.fieldsCount];
                for (n2 = 0; n2 < this.fieldsCount; ++n2) {
                    FieldInfo fieldInfo;
                    this.fields[n2] = fieldInfo = FieldInfo.createField(this.reference, this.constantPoolOffsets, n, this.version);
                    n += fieldInfo.sizeInBytes();
                }
            }
            this.methodsCount = this.u2At(n);
            n += 2;
            if (this.methodsCount != 0) {
                this.methods = new MethodInfo[this.methodsCount];
                boolean bl2 = (this.accessFlags & 0x2000) != 0;
                for (n2 = 0; n2 < this.methodsCount; ++n2) {
                    this.methods[n2] = bl2 ? AnnotationMethodInfo.createAnnotationMethod(this.reference, this.constantPoolOffsets, n, this.version) : MethodInfo.createMethod(this.reference, this.constantPoolOffsets, n, this.version);
                    n += this.methods[n2].sizeInBytes();
                }
            }
            int n5 = this.u2At(n);
            n += 2;
            for (n2 = 0; n2 < n5; ++n2) {
                int n6 = this.constantPoolOffsets[this.u2At(n)];
                char[] cArray2 = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                if (cArray2.length == 0) {
                    n = (int)((long)n + (6L + this.u4At(n + 2)));
                    continue;
                }
                switch (cArray2[0]) {
                    case 'E': {
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.EnclosingMethodName)) break;
                        n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n + 6)] + 1)];
                        this.enclosingTypeName = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                        this.enclosingNameAndTypeIndex = this.u2At(n + 8);
                        break;
                    }
                    case 'D': {
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'I': {
                        int n7;
                        int n8;
                        int n9;
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.InnerClassName)) {
                            char[] cArray3;
                            n9 = n + 6;
                            n8 = this.u2At(n9);
                            if (n8 == 0) break;
                            n9 += 2;
                            this.innerInfos = new InnerClassInfo[n8];
                            for (n7 = 0; n7 < n8; ++n7) {
                                this.innerInfos[n7] = new InnerClassInfo(this.reference, this.constantPoolOffsets, n9);
                                if (this.classNameIndex == this.innerInfos[n7].innerClassNameIndex) {
                                    this.innerInfo = this.innerInfos[n7];
                                }
                                n9 += 8;
                            }
                            if (this.innerInfo == null || (cArray3 = this.innerInfo.getEnclosingTypeName()) == null) break;
                            this.enclosingTypeName = cArray3;
                            break;
                        }
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.InconsistentHierarchy)) break;
                        this.tagBits |= 0x20000L;
                        break;
                    }
                    case 'S': {
                        if (cArray2.length <= 2) break;
                        switch (cArray2[1]) {
                            case 'o': {
                                if (!CharOperation.equals(cArray2, AttributeNamesConstants.SourceName)) break;
                                n6 = this.constantPoolOffsets[this.u2At(n + 6)];
                                this.sourceFileName = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                                break;
                            }
                            case 'y': {
                                if (!CharOperation.equals(cArray2, AttributeNamesConstants.SyntheticName)) break;
                                this.accessFlags |= 0x1000;
                                break;
                            }
                            case 'i': {
                                if (!CharOperation.equals(cArray2, AttributeNamesConstants.SignatureName)) break;
                                n6 = this.constantPoolOffsets[this.u2At(n + 6)];
                                this.signature = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                            }
                        }
                        break;
                    }
                    case 'R': {
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                            this.decodeAnnotations(n, true);
                            break;
                        }
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                            this.decodeAnnotations(n, false);
                            break;
                        }
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName)) {
                            this.decodeTypeAnnotations(n, true);
                            break;
                        }
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName)) {
                            this.decodeTypeAnnotations(n, false);
                            break;
                        }
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.RecordClass)) break;
                        this.decodeRecords(n, cArray2);
                        break;
                    }
                    case 'M': {
                        int n7;
                        int n8;
                        int n9;
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.MissingTypesName)) {
                            n9 = n + 6;
                            n8 = this.u2At(n9);
                            if (n8 == 0) break;
                            this.missingTypeNames = new char[n8][][];
                            n9 += 2;
                            for (n7 = 0; n7 < n8; ++n7) {
                                n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n9)] + 1)];
                                char[] cArray4 = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                                this.missingTypeNames[n7] = CharOperation.splitOn('/', cArray4);
                                n9 += 2;
                            }
                            break;
                        }
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.ModuleName)) break;
                        this.moduleDeclaration = ModuleInfo.createModule(this.reference, this.constantPoolOffsets, n);
                        this.moduleName = this.moduleDeclaration.name();
                        break;
                    }
                    case 'N': {
                        int n8;
                        if (CharOperation.equals(cArray2, AttributeNamesConstants.NestHost)) {
                            n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n + 6)] + 1)];
                            this.nestHost = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                            break;
                        }
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.NestMembers)) break;
                        int n9 = n + 6;
                        this.nestMembersCount = this.u2At(n9);
                        if (this.nestMembersCount == 0) break;
                        n9 += 2;
                        this.nestMembers = new char[this.nestMembersCount][];
                        for (n8 = 0; n8 < this.nestMembersCount; ++n8) {
                            n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n9)] + 1)];
                            this.nestMembers[n8] = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                            n9 += 2;
                        }
                        break;
                    }
                    case 'P': {
                        int n8;
                        if (!CharOperation.equals(cArray2, AttributeNamesConstants.PermittedSubclasses)) break;
                        int n9 = n + 6;
                        this.permittedSubtypesCount = this.u2At(n9);
                        if (this.permittedSubtypesCount == 0) break;
                        this.accessFlags |= 0x10000000;
                        n9 += 2;
                        this.permittedSubtypesNames = new char[this.permittedSubtypesCount][];
                        for (n8 = 0; n8 < this.permittedSubtypesCount; ++n8) {
                            n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n9)] + 1)];
                            this.permittedSubtypesNames[n8] = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                            n9 += 2;
                        }
                        break;
                    }
                }
                n = (int)((long)n + (6L + this.u4At(n + 2)));
            }
            if (this.moduleDeclaration != null && this.annotations != null) {
                this.moduleDeclaration.setAnnotations(this.annotations, this.tagBits, bl);
                this.annotations = null;
            }
            if (bl) {
                this.initialize();
            }
        }
        catch (ClassFormatException classFormatException) {
            throw classFormatException;
        }
        catch (Exception exception) {
            throw new ClassFormatException(exception, this.classFileName, 21, n);
        }
    }

    private void decodeRecords(int n, char[] cArray) {
        if (CharOperation.equals(cArray, AttributeNamesConstants.RecordClass)) {
            this.isRecord = true;
            int n2 = n + 6;
            this.recordComponentsCount = this.u2At(n2);
            if (this.recordComponentsCount != 0) {
                n2 += 2;
                this.recordComponents = new RecordComponentInfo[this.recordComponentsCount];
                for (int i = 0; i < this.recordComponentsCount; ++i) {
                    RecordComponentInfo recordComponentInfo;
                    this.recordComponents[i] = recordComponentInfo = RecordComponentInfo.createComponent(this.reference, this.constantPoolOffsets, n2, this.version);
                    n2 += recordComponentInfo.sizeInBytes();
                }
            }
        }
    }

    public char[] getNestHost() {
        return this.nestHost;
    }

    @Override
    public BinaryTypeBinding.ExternalAnnotationStatus getExternalAnnotationStatus() {
        return BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED;
    }

    @Override
    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker iTypeAnnotationWalker, Object object, LookupEnvironment lookupEnvironment) {
        return iTypeAnnotationWalker;
    }

    public int accessFlags() {
        return this.accessFlags;
    }

    private void decodeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            AnnotationInfo[] annotationInfoArray;
            int n3;
            int n4 = n + 8;
            AnnotationInfo[] annotationInfoArray2 = null;
            int n5 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                annotationInfoArray = new AnnotationInfo(this.reference, this.constantPoolOffsets, n4, bl, false);
                n4 += annotationInfoArray.readOffset;
                long l2 = annotationInfoArray.standardAnnotationTagBits;
                if (l2 != 0L) {
                    this.tagBits |= l2;
                    if (this.version < 0x350000L || (l2 & 0x400000000000L) == 0L) continue;
                }
                if (annotationInfoArray2 == null) {
                    annotationInfoArray2 = new AnnotationInfo[n2 - n3];
                }
                annotationInfoArray2[n5++] = annotationInfoArray;
            }
            if (annotationInfoArray2 == null) {
                return;
            }
            if (this.annotations == null) {
                if (n5 != annotationInfoArray2.length) {
                    AnnotationInfo[] annotationInfoArray3 = annotationInfoArray2;
                    annotationInfoArray2 = new AnnotationInfo[n5];
                    System.arraycopy(annotationInfoArray3, 0, annotationInfoArray2, 0, n5);
                }
                this.annotations = annotationInfoArray2;
            } else {
                n3 = this.annotations.length;
                annotationInfoArray = new AnnotationInfo[n3 + n5];
                System.arraycopy(this.annotations, 0, annotationInfoArray, 0, n3);
                System.arraycopy(annotationInfoArray2, 0, annotationInfoArray, n3, n5);
                this.annotations = annotationInfoArray;
            }
        }
    }

    private void decodeTypeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            TypeAnnotationInfo[] typeAnnotationInfoArray;
            int n3;
            int n4 = n + 8;
            TypeAnnotationInfo[] typeAnnotationInfoArray2 = null;
            typeAnnotationInfoArray2 = new TypeAnnotationInfo[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                typeAnnotationInfoArray = new TypeAnnotationInfo(this.reference, this.constantPoolOffsets, n4, bl, false);
                n4 += typeAnnotationInfoArray.readOffset;
                typeAnnotationInfoArray2[n3] = typeAnnotationInfoArray;
            }
            if (this.typeAnnotations == null) {
                this.typeAnnotations = typeAnnotationInfoArray2;
            } else {
                n3 = this.typeAnnotations.length;
                typeAnnotationInfoArray = new TypeAnnotationInfo[n3 + n2];
                System.arraycopy(this.typeAnnotations, 0, typeAnnotationInfoArray, 0, n3);
                System.arraycopy(typeAnnotationInfoArray2, 0, typeAnnotationInfoArray, n3, n2);
                this.typeAnnotations = typeAnnotationInfoArray;
            }
        }
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return this.typeAnnotations;
    }

    private char[] getConstantClassNameAt(int n) {
        int n2 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[n] + 1)];
        return this.utf8At(n2 + 3, this.u2At(n2 + 1));
    }

    public int[] getConstantPoolOffsets() {
        return this.constantPoolOffsets;
    }

    @Override
    public char[] getEnclosingMethod() {
        if (this.enclosingNameAndTypeIndex <= 0) {
            return null;
        }
        if (this.enclosingMethod == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.constantPoolOffsets[this.enclosingNameAndTypeIndex];
            int n2 = this.constantPoolOffsets[this.u2At(n + 1)];
            stringBuffer.append(this.utf8At(n2 + 3, this.u2At(n2 + 1)));
            n2 = this.constantPoolOffsets[this.u2At(n + 3)];
            stringBuffer.append(this.utf8At(n2 + 3, this.u2At(n2 + 1)));
            this.enclosingMethod = String.valueOf(stringBuffer).toCharArray();
        }
        return this.enclosingMethod;
    }

    @Override
    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    @Override
    public IBinaryField[] getFields() {
        return this.fields;
    }

    @Override
    public char[] getModule() {
        return this.moduleName;
    }

    public IBinaryModule getModuleDeclaration() {
        return this.moduleDeclaration;
    }

    @Override
    public char[] getFileName() {
        return this.classFileName;
    }

    @Override
    public char[] getGenericSignature() {
        return this.signature;
    }

    public char[] getInnerSourceName() {
        if (this.innerInfo != null) {
            return this.innerInfo.getSourceName();
        }
        return null;
    }

    @Override
    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    @Override
    public char[][] getPermittedSubtypeNames() {
        return this.permittedSubtypesNames;
    }

    @Override
    public IBinaryNestedType[] getMemberTypes() {
        if (this.innerInfos == null) {
            return null;
        }
        int n = this.innerInfos.length - (this.innerInfo != null ? 1 : 0);
        if (n != 0) {
            IBinaryNestedType[] iBinaryNestedTypeArray = new IBinaryNestedType[n];
            int n2 = 0;
            for (InnerClassInfo innerClassInfo : this.innerInfos) {
                int n3 = innerClassInfo.outerClassNameIndex;
                int n4 = innerClassInfo.innerNameIndex;
                if (n3 == 0 || n4 == 0 || n3 != this.classNameIndex || innerClassInfo.getSourceName().length == 0) continue;
                iBinaryNestedTypeArray[n2++] = innerClassInfo;
            }
            if (n2 == 0) {
                return null;
            }
            if (n2 != iBinaryNestedTypeArray.length) {
                IBinaryNestedType[] iBinaryNestedTypeArray2 = iBinaryNestedTypeArray;
                iBinaryNestedTypeArray = new IBinaryNestedType[n2];
                System.arraycopy(iBinaryNestedTypeArray2, 0, iBinaryNestedTypeArray, 0, n2);
            }
            return iBinaryNestedTypeArray;
        }
        return null;
    }

    @Override
    public IBinaryMethod[] getMethods() {
        return this.methods;
    }

    @Override
    public char[][][] getMissingTypeNames() {
        return this.missingTypeNames;
    }

    @Override
    public int getModifiers() {
        int n = this.innerInfo != null ? this.innerInfo.getModifiers() | this.accessFlags & 0x100000 | this.accessFlags & 0x1000 : this.accessFlags;
        if (this.permittedSubtypesCount > 0) {
            n |= 0x10000000;
        }
        return n;
    }

    @Override
    public char[] getName() {
        return this.className;
    }

    @Override
    public char[] getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        char[] cArray = this.getInnerSourceName();
        if (cArray == null) {
            cArray = this.getName();
            int n = this.isAnonymous() ? CharOperation.indexOf('$', cArray, CharOperation.lastIndexOf('/', cArray) + 1) + 1 : CharOperation.lastIndexOf('/', cArray) + 1;
            if (n > 0) {
                char[] cArray2 = new char[cArray.length - n];
                System.arraycopy(cArray, n, cArray2, 0, cArray2.length);
                cArray = cArray2;
            }
        }
        this.sourceName = cArray;
        return cArray;
    }

    @Override
    public char[] getSuperclassName() {
        return this.superclassName;
    }

    @Override
    public long getTagBits() {
        return this.tagBits;
    }

    public long getVersion() {
        return this.version;
    }

    private boolean hasNonSyntheticFieldChanges(FieldInfo[] fieldInfoArray, FieldInfo[] fieldInfoArray2) {
        int n = fieldInfoArray == null ? 0 : fieldInfoArray.length;
        int n2 = fieldInfoArray2 == null ? 0 : fieldInfoArray2.length;
        int n3 = 0;
        int n4 = 0;
        block0: while (n3 < n && n4 < n2) {
            while (fieldInfoArray[n3].isSynthetic()) {
                if (++n3 < n) continue;
                break block0;
            }
            while (fieldInfoArray2[n4].isSynthetic()) {
                if (++n4 < n2) continue;
                break block0;
            }
            if (!this.hasStructuralFieldChanges(fieldInfoArray[n3++], fieldInfoArray2[n4++])) continue;
            return true;
        }
        while (n3 < n) {
            if (fieldInfoArray[n3++].isSynthetic()) continue;
            return true;
        }
        while (n4 < n2) {
            if (fieldInfoArray2[n4++].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonSyntheticMethodChanges(MethodInfo[] methodInfoArray, MethodInfo[] methodInfoArray2) {
        MethodInfo methodInfo;
        int n = methodInfoArray == null ? 0 : methodInfoArray.length;
        int n2 = methodInfoArray2 == null ? 0 : methodInfoArray2.length;
        int n3 = 0;
        int n4 = 0;
        block0: while (n3 < n && n4 < n2) {
            while ((methodInfo = methodInfoArray[n3]).isSynthetic() || methodInfo.isClinit()) {
                if (++n3 < n) continue;
                break block0;
            }
            while ((methodInfo = methodInfoArray2[n4]).isSynthetic() || methodInfo.isClinit()) {
                if (++n4 < n2) continue;
                break block0;
            }
            if (!this.hasStructuralMethodChanges(methodInfoArray[n3++], methodInfoArray2[n4++])) continue;
            return true;
        }
        while (n3 < n) {
            if ((methodInfo = methodInfoArray[n3++]).isSynthetic() || methodInfo.isClinit()) continue;
            return true;
        }
        while (n4 < n2) {
            if ((methodInfo = methodInfoArray2[n4++]).isSynthetic() || methodInfo.isClinit()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStructuralChanges(byte[] byArray) {
        return this.hasStructuralChanges(byArray, true, true);
    }

    public boolean hasStructuralChanges(byte[] byArray, boolean bl, boolean bl2) {
        try {
            int n;
            Object[] objectArray;
            int n2;
            Object[] objectArray2;
            int n3;
            int n4;
            IBinaryNestedType[] iBinaryNestedTypeArray;
            IBinaryNestedType[] iBinaryNestedTypeArray2;
            int n5;
            char[][] cArray;
            int n6;
            int n7;
            ClassFileReader classFileReader = new ClassFileReader(byArray, this.classFileName);
            if (this.getModifiers() != classFileReader.getModifiers()) {
                return true;
            }
            long l2 = 2333005311180406784L;
            if ((this.getTagBits() & l2) != (classFileReader.getTagBits() & l2)) {
                return true;
            }
            if (this.hasStructuralAnnotationChanges(this.getAnnotations(), classFileReader.getAnnotations())) {
                return true;
            }
            if (this.version >= 0x340000L && this.hasStructuralTypeAnnotationChanges(this.getTypeAnnotations(), classFileReader.getTypeAnnotations())) {
                return true;
            }
            if (!CharOperation.equals(this.getGenericSignature(), classFileReader.getGenericSignature())) {
                return true;
            }
            if (!CharOperation.equals(this.getSuperclassName(), classFileReader.getSuperclassName())) {
                return true;
            }
            char[][] cArray2 = classFileReader.getInterfaceNames();
            if (this.interfaceNames != cArray2) {
                int n8;
                int n9 = n8 = cArray2 == null ? 0 : cArray2.length;
                if (n8 != this.interfacesCount) {
                    return true;
                }
                n7 = this.interfacesCount;
                for (n6 = 0; n6 < n7; ++n6) {
                    if (CharOperation.equals(this.interfaceNames[n6], cArray2[n6])) continue;
                    return true;
                }
            }
            if (this.permittedSubtypesNames != (cArray = classFileReader.getPermittedSubtypeNames())) {
                int n10 = n6 = cArray == null ? 0 : cArray.length;
                if (n6 != this.permittedSubtypesCount) {
                    return true;
                }
                n5 = this.permittedSubtypesCount;
                for (n7 = 0; n7 < n5; ++n7) {
                    if (CharOperation.equals(this.permittedSubtypesNames[n7], cArray[n7])) continue;
                    return true;
                }
            }
            if ((iBinaryNestedTypeArray2 = this.getMemberTypes()) != (iBinaryNestedTypeArray = classFileReader.getMemberTypes())) {
                n5 = iBinaryNestedTypeArray2 == null ? 0 : iBinaryNestedTypeArray2.length;
                int n11 = n4 = iBinaryNestedTypeArray == null ? 0 : iBinaryNestedTypeArray.length;
                if (n5 != n4) {
                    return true;
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    if (CharOperation.equals(iBinaryNestedTypeArray2[n3].getName(), iBinaryNestedTypeArray[n3].getName()) && iBinaryNestedTypeArray2[n3].getModifiers() == iBinaryNestedTypeArray[n3].getModifiers()) continue;
                    return true;
                }
            }
            n4 = (objectArray2 = (FieldInfo[])classFileReader.getFields()) == null ? 0 : objectArray2.length;
            n3 = 1;
            if (this.fieldsCount == n4) {
                for (n2 = 0; n2 < this.fieldsCount && !this.hasStructuralFieldChanges(this.fields[n2], objectArray2[n2]); ++n2) {
                }
                n3 = n2 != this.fieldsCount ? 1 : 0;
                if (n3 != 0 && !bl && !bl2) {
                    return true;
                }
            }
            if (n3 != 0) {
                if (this.fieldsCount != n4 && !bl2) {
                    return true;
                }
                if (bl) {
                    if (this.fieldsCount != 0) {
                        Arrays.sort(this.fields);
                    }
                    if (n4 != 0) {
                        Arrays.sort(objectArray2);
                    }
                }
                if (bl2) {
                    if (this.hasNonSyntheticFieldChanges(this.fields, (FieldInfo[])objectArray2)) {
                        return true;
                    }
                } else {
                    for (n2 = 0; n2 < this.fieldsCount; ++n2) {
                        if (!this.hasStructuralFieldChanges(this.fields[n2], (FieldInfo)objectArray2[n2])) continue;
                        return true;
                    }
                }
            }
            int n12 = (objectArray = (MethodInfo[])classFileReader.getMethods()) == null ? 0 : objectArray.length;
            boolean bl3 = true;
            if (this.methodsCount == n12) {
                for (n = 0; n < this.methodsCount && !this.hasStructuralMethodChanges(this.methods[n], objectArray[n]); ++n) {
                }
                bl3 = n != this.methodsCount;
                if (bl3 && !bl && !bl2) {
                    return true;
                }
            }
            if (bl3) {
                if (this.methodsCount != n12 && !bl2) {
                    return true;
                }
                if (bl) {
                    if (this.methodsCount != 0) {
                        Arrays.sort(this.methods);
                    }
                    if (n12 != 0) {
                        Arrays.sort(objectArray);
                    }
                }
                if (bl2) {
                    if (this.hasNonSyntheticMethodChanges(this.methods, (MethodInfo[])objectArray)) {
                        return true;
                    }
                } else {
                    for (n = 0; n < this.methodsCount; ++n) {
                        if (!this.hasStructuralMethodChanges(this.methods[n], (MethodInfo)objectArray[n])) continue;
                        return true;
                    }
                }
            }
            char[][][] cArray3 = this.getMissingTypeNames();
            char[][][] cArray4 = classFileReader.getMissingTypeNames();
            if (cArray3 != null) {
                if (cArray4 == null) {
                    return true;
                }
                int n13 = cArray3.length;
                if (n13 != cArray4.length) {
                    return true;
                }
                for (int i = 0; i < n13; ++i) {
                    if (CharOperation.equals(cArray3[i], cArray4[i])) continue;
                    return true;
                }
            } else if (cArray4 != null) {
                return true;
            }
            return false;
        }
        catch (ClassFormatException classFormatException) {
            return true;
        }
    }

    private boolean hasStructuralAnnotationChanges(IBinaryAnnotation[] iBinaryAnnotationArray, IBinaryAnnotation[] iBinaryAnnotationArray2) {
        int n;
        if (iBinaryAnnotationArray == iBinaryAnnotationArray2) {
            return false;
        }
        int n2 = iBinaryAnnotationArray == null ? 0 : iBinaryAnnotationArray.length;
        int n3 = n = iBinaryAnnotationArray2 == null ? 0 : iBinaryAnnotationArray2.length;
        if (n2 != n) {
            return true;
        }
        for (int i = 0; i < n2; ++i) {
            Boolean bl = this.matchAnnotations(iBinaryAnnotationArray[i], iBinaryAnnotationArray2[i]);
            if (bl == null) continue;
            return bl;
        }
        return false;
    }

    private Boolean matchAnnotations(IBinaryAnnotation iBinaryAnnotation, IBinaryAnnotation iBinaryAnnotation2) {
        int n;
        if (!CharOperation.equals(iBinaryAnnotation.getTypeName(), iBinaryAnnotation2.getTypeName())) {
            return true;
        }
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        IBinaryElementValuePair[] iBinaryElementValuePairArray2 = iBinaryAnnotation2.getElementValuePairs();
        int n2 = iBinaryElementValuePairArray == null ? 0 : iBinaryElementValuePairArray.length;
        int n3 = n = iBinaryElementValuePairArray2 == null ? 0 : iBinaryElementValuePairArray2.length;
        if (n2 != n) {
            return Boolean.TRUE;
        }
        for (int i = 0; i < n2; ++i) {
            if (!CharOperation.equals(iBinaryElementValuePairArray[i].getName(), iBinaryElementValuePairArray2[i].getName())) {
                return Boolean.TRUE;
            }
            Object object = iBinaryElementValuePairArray[i].getValue();
            Object object2 = iBinaryElementValuePairArray2[i].getValue();
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (object2 instanceof Object[]) {
                    int n4 = objectArray.length;
                    Object[] objectArray2 = (Object[])object2;
                    if (n4 != objectArray2.length) {
                        return Boolean.TRUE;
                    }
                    for (int j = 0; j < n4; ++j) {
                        if (objectArray[j].equals(objectArray2[j])) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (object.equals(object2)) continue;
            return Boolean.TRUE;
        }
        return null;
    }

    private boolean hasStructuralFieldChanges(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
        if (!CharOperation.equals(fieldInfo.getGenericSignature(), fieldInfo2.getGenericSignature())) {
            return true;
        }
        if (fieldInfo.getModifiers() != fieldInfo2.getModifiers()) {
            return true;
        }
        if ((fieldInfo.getTagBits() & 0x400000000000L) != (fieldInfo2.getTagBits() & 0x400000000000L)) {
            return true;
        }
        if (this.hasStructuralAnnotationChanges(fieldInfo.getAnnotations(), fieldInfo2.getAnnotations())) {
            return true;
        }
        if (this.version >= 0x340000L && this.hasStructuralTypeAnnotationChanges(fieldInfo.getTypeAnnotations(), fieldInfo2.getTypeAnnotations())) {
            return true;
        }
        if (!CharOperation.equals(fieldInfo.getName(), fieldInfo2.getName())) {
            return true;
        }
        if (!CharOperation.equals(fieldInfo.getTypeName(), fieldInfo2.getTypeName())) {
            return true;
        }
        if (fieldInfo.hasConstant() != fieldInfo2.hasConstant()) {
            return true;
        }
        if (fieldInfo.hasConstant()) {
            Constant constant = fieldInfo.getConstant();
            Constant constant2 = fieldInfo2.getConstant();
            if (constant.typeID() != constant2.typeID()) {
                return true;
            }
            if (!constant.getClass().equals(constant2.getClass())) {
                return true;
            }
            switch (constant.typeID()) {
                case 10: {
                    return constant.intValue() != constant2.intValue();
                }
                case 3: {
                    return constant.byteValue() != constant2.byteValue();
                }
                case 4: {
                    return constant.shortValue() != constant2.shortValue();
                }
                case 2: {
                    return constant.charValue() != constant2.charValue();
                }
                case 7: {
                    return constant.longValue() != constant2.longValue();
                }
                case 9: {
                    return constant.floatValue() != constant2.floatValue();
                }
                case 8: {
                    return constant.doubleValue() != constant2.doubleValue();
                }
                case 5: {
                    return constant.booleanValue() != constant2.booleanValue();
                }
                case 11: {
                    return !constant.stringValue().equals(constant2.stringValue());
                }
            }
        }
        return false;
    }

    private boolean hasStructuralMethodChanges(MethodInfo methodInfo, MethodInfo methodInfo2) {
        char[][] cArray;
        int n;
        if (!CharOperation.equals(methodInfo.getGenericSignature(), methodInfo2.getGenericSignature())) {
            return true;
        }
        if (methodInfo.getModifiers() != methodInfo2.getModifiers()) {
            return true;
        }
        if ((methodInfo.getTagBits() & 0x400000000000L) != (methodInfo2.getTagBits() & 0x400000000000L)) {
            return true;
        }
        if (this.hasStructuralAnnotationChanges(methodInfo.getAnnotations(), methodInfo2.getAnnotations())) {
            return true;
        }
        int n2 = methodInfo.getAnnotatedParametersCount();
        if (n2 != (n = methodInfo2.getAnnotatedParametersCount())) {
            return true;
        }
        for (int i = 0; i < n2; ++i) {
            if (!this.hasStructuralAnnotationChanges(methodInfo.getParameterAnnotations(i, this.classFileName), methodInfo2.getParameterAnnotations(i, this.classFileName))) continue;
            return true;
        }
        if (this.version >= 0x340000L && this.hasStructuralTypeAnnotationChanges(methodInfo.getTypeAnnotations(), methodInfo2.getTypeAnnotations())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getSelector(), methodInfo2.getSelector())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getMethodDescriptor(), methodInfo2.getMethodDescriptor())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getGenericSignature(), methodInfo2.getGenericSignature())) {
            return true;
        }
        char[][] cArray2 = methodInfo.getExceptionTypeNames();
        if (cArray2 != (cArray = methodInfo2.getExceptionTypeNames())) {
            int n3;
            int n4 = cArray2 == null ? 0 : cArray2.length;
            int n5 = n3 = cArray == null ? 0 : cArray.length;
            if (n4 != n3) {
                return true;
            }
            for (int i = 0; i < n4; ++i) {
                if (CharOperation.equals(cArray2[i], cArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasStructuralTypeAnnotationChanges(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray, IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray2) {
        if (iBinaryTypeAnnotationArray2 != null) {
            int n = iBinaryTypeAnnotationArray2.length;
            IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray3 = iBinaryTypeAnnotationArray2;
            iBinaryTypeAnnotationArray2 = new IBinaryTypeAnnotation[n];
            System.arraycopy(iBinaryTypeAnnotationArray3, 0, iBinaryTypeAnnotationArray2, 0, n);
        }
        if (iBinaryTypeAnnotationArray != null) {
            block0: for (IBinaryTypeAnnotation iBinaryTypeAnnotation : iBinaryTypeAnnotationArray) {
                if (!this.affectsSignature(iBinaryTypeAnnotation)) continue;
                if (iBinaryTypeAnnotationArray2 == null) {
                    return true;
                }
                for (int i = 0; i < iBinaryTypeAnnotationArray2.length; ++i) {
                    IBinaryTypeAnnotation iBinaryTypeAnnotation2 = iBinaryTypeAnnotationArray2[i];
                    if (iBinaryTypeAnnotation2 == null || this.matchAnnotations(iBinaryTypeAnnotation.getAnnotation(), iBinaryTypeAnnotation2.getAnnotation()) != Boolean.TRUE) continue;
                    iBinaryTypeAnnotationArray2[i] = null;
                    continue block0;
                }
                return true;
            }
        }
        if (iBinaryTypeAnnotationArray2 != null) {
            for (IBinaryTypeAnnotation iBinaryTypeAnnotation : iBinaryTypeAnnotationArray2) {
                if (!this.affectsSignature(iBinaryTypeAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean affectsSignature(IBinaryTypeAnnotation iBinaryTypeAnnotation) {
        if (iBinaryTypeAnnotation == null) {
            return false;
        }
        int n = iBinaryTypeAnnotation.getTargetType();
        return n < 64 || n > 75;
    }

    private void initialize() throws ClassFormatException {
        try {
            int n;
            int n2 = this.fieldsCount;
            for (n = 0; n < n2; ++n) {
                this.fields[n].initialize();
            }
            n2 = this.methodsCount;
            for (n = 0; n < n2; ++n) {
                this.methods[n].initialize();
            }
            if (this.innerInfos != null) {
                n2 = this.innerInfos.length;
                for (n = 0; n < n2; ++n) {
                    this.innerInfos[n].initialize();
                }
            }
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].initialize();
                }
            }
            this.getEnclosingMethod();
            this.reset();
        }
        catch (RuntimeException runtimeException) {
            ClassFormatException classFormatException = new ClassFormatException(runtimeException, this.classFileName);
            throw classFormatException;
        }
    }

    @Override
    public boolean isAnonymous() {
        if (this.innerInfo == null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray == null || cArray.length == 0;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLocal() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() != null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray != null && cArray.length > 0;
    }

    @Override
    public boolean isMember() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() == null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray != null && cArray.length > 0;
    }

    public boolean isNestedType() {
        return this.innerInfo != null;
    }

    @Override
    public char[] sourceFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(this.getClass().getName() + "{");
        printWriter.println(" this.className: " + new String(this.getName()));
        printWriter.println(" this.superclassName: " + (this.getSuperclassName() == null ? "null" : new String(this.getSuperclassName())));
        if (this.moduleName != null) {
            printWriter.println(" this.moduleName: " + new String(this.moduleName));
        }
        printWriter.println(" access_flags: " + ClassFileReader.printTypeModifiers(this.accessFlags()) + "(" + this.accessFlags() + ")");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    @Override
    public boolean isRecord() {
        return this.isRecord;
    }

    @Override
    public IRecordComponent[] getRecordComponents() {
        return this.recordComponents;
    }
}

