/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.IRecordComponent;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ExternalAnnotationDecorator
implements IBinaryType {
    private IBinaryType inputType;
    private ExternalAnnotationProvider annotationProvider;
    private boolean isFromSource;

    public ExternalAnnotationDecorator(IBinaryType iBinaryType, ExternalAnnotationProvider externalAnnotationProvider) {
        if (iBinaryType == null) {
            throw new NullPointerException("toDecorate");
        }
        this.inputType = iBinaryType;
        this.annotationProvider = externalAnnotationProvider;
    }

    public ExternalAnnotationDecorator(IBinaryType iBinaryType, boolean bl) {
        if (iBinaryType == null) {
            throw new NullPointerException("toDecorate");
        }
        this.isFromSource = bl;
        this.inputType = iBinaryType;
    }

    @Override
    public char[] getFileName() {
        return this.inputType.getFileName();
    }

    @Override
    public boolean isBinaryType() {
        return this.inputType.isBinaryType();
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return this.inputType.getAnnotations();
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return this.inputType.getTypeAnnotations();
    }

    @Override
    public char[] getEnclosingMethod() {
        return this.inputType.getEnclosingMethod();
    }

    @Override
    public char[] getEnclosingTypeName() {
        return this.inputType.getEnclosingTypeName();
    }

    @Override
    public IBinaryField[] getFields() {
        return this.inputType.getFields();
    }

    @Override
    public IRecordComponent[] getRecordComponents() {
        return this.inputType.getRecordComponents();
    }

    @Override
    public char[] getGenericSignature() {
        return this.inputType.getGenericSignature();
    }

    @Override
    public char[][] getInterfaceNames() {
        return this.inputType.getInterfaceNames();
    }

    @Override
    public IBinaryNestedType[] getMemberTypes() {
        return this.inputType.getMemberTypes();
    }

    @Override
    public IBinaryMethod[] getMethods() {
        return this.inputType.getMethods();
    }

    @Override
    public char[][][] getMissingTypeNames() {
        return this.inputType.getMissingTypeNames();
    }

    @Override
    public char[] getName() {
        return this.inputType.getName();
    }

    @Override
    public char[] getSourceName() {
        return this.inputType.getSourceName();
    }

    @Override
    public char[] getSuperclassName() {
        return this.inputType.getSuperclassName();
    }

    @Override
    public long getTagBits() {
        return this.inputType.getTagBits();
    }

    @Override
    public boolean isAnonymous() {
        return this.inputType.isAnonymous();
    }

    @Override
    public boolean isLocal() {
        return this.inputType.isLocal();
    }

    @Override
    public boolean isRecord() {
        return this.inputType.isRecord();
    }

    @Override
    public boolean isMember() {
        return this.inputType.isMember();
    }

    @Override
    public char[] sourceFileName() {
        return this.inputType.sourceFileName();
    }

    @Override
    public int getModifiers() {
        return this.inputType.getModifiers();
    }

    @Override
    public char[] getModule() {
        return this.inputType.getModule();
    }

    public static ZipFile getAnnotationZipFile(String string, ZipFileProducer zipFileProducer) throws IOException {
        File file2 = new File(string);
        if (!file2.isFile()) {
            return null;
        }
        return zipFileProducer != null ? zipFileProducer.produce() : new ZipFile(file2);
    }

    public static ExternalAnnotationProvider externalAnnotationProvider(String string, String string2, ZipFile zipFile) throws IOException {
        String string3 = string2 + ".eea";
        if (zipFile == null) {
            File file2 = new File(string);
            if (file2.isDirectory()) {
                String string4 = file2.getAbsolutePath() + '/' + string3;
                try {
                    return new ExternalAnnotationProvider(new FileInputStream(string4), string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        } else {
            ZipEntry zipEntry = zipFile.getEntry(string3);
            if (zipEntry != null) {
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    ExternalAnnotationProvider externalAnnotationProvider = new ExternalAnnotationProvider(inputStream, string2);
                    return externalAnnotationProvider;
                }
            }
        }
        return null;
    }

    public static IBinaryType create(IBinaryType iBinaryType, String string, String string2, ZipFile zipFile) throws IOException {
        ExternalAnnotationProvider externalAnnotationProvider = ExternalAnnotationDecorator.externalAnnotationProvider(string, string2, zipFile);
        if (externalAnnotationProvider == null) {
            return iBinaryType;
        }
        return new ExternalAnnotationDecorator(iBinaryType, externalAnnotationProvider);
    }

    @Override
    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker iTypeAnnotationWalker, Object object, LookupEnvironment lookupEnvironment) {
        if (iTypeAnnotationWalker == ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER && this.annotationProvider != null) {
            if (object == null) {
                return this.annotationProvider.forTypeHeader(lookupEnvironment);
            }
            if (object instanceof IBinaryField) {
                IBinaryField iBinaryField = (IBinaryField)object;
                char[] cArray = iBinaryField.getGenericSignature();
                if (cArray == null) {
                    cArray = iBinaryField.getTypeName();
                }
                return this.annotationProvider.forField(iBinaryField.getName(), cArray, lookupEnvironment);
            }
            if (object instanceof IBinaryMethod) {
                IBinaryMethod iBinaryMethod = (IBinaryMethod)object;
                char[] cArray = iBinaryMethod.getGenericSignature();
                if (cArray == null) {
                    cArray = iBinaryMethod.getMethodDescriptor();
                }
                return this.annotationProvider.forMethod(iBinaryMethod.isConstructor() ? TypeConstants.INIT : iBinaryMethod.getSelector(), cArray, lookupEnvironment);
            }
        }
        return iTypeAnnotationWalker;
    }

    @Override
    public BinaryTypeBinding.ExternalAnnotationStatus getExternalAnnotationStatus() {
        if (this.annotationProvider == null) {
            if (this.isFromSource) {
                return BinaryTypeBinding.ExternalAnnotationStatus.FROM_SOURCE;
            }
            return BinaryTypeBinding.ExternalAnnotationStatus.NO_EEA_FILE;
        }
        return BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
    }

    public static interface ZipFileProducer {
        public ZipFile produce() throws IOException;
    }
}

