/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class SplitPackageBinding
extends PackageBinding {
    Set<ModuleBinding> declaringModules = new HashSet<ModuleBinding>();
    public Set<PlainPackageBinding> incarnations = new HashSet<PlainPackageBinding>();

    public static PackageBinding combine(PackageBinding packageBinding, PackageBinding packageBinding2, ModuleBinding moduleBinding) {
        int n;
        int n2 = SplitPackageBinding.rank(packageBinding2);
        if (n2 < (n = SplitPackageBinding.rank(packageBinding))) {
            return packageBinding;
        }
        if (n2 > n) {
            return packageBinding2;
        }
        if (packageBinding2 == null) {
            return null;
        }
        if (packageBinding2.subsumes(packageBinding)) {
            return packageBinding2;
        }
        if (packageBinding.subsumes(packageBinding2)) {
            return packageBinding;
        }
        SplitPackageBinding splitPackageBinding = new SplitPackageBinding(packageBinding2, moduleBinding);
        splitPackageBinding.add(packageBinding);
        return splitPackageBinding;
    }

    private static int rank(PackageBinding packageBinding) {
        if (packageBinding == null) {
            return 0;
        }
        if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
            return 1;
        }
        if (!packageBinding.isValidBinding()) {
            return 2;
        }
        return 3;
    }

    public SplitPackageBinding(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        super(packageBinding.compoundName, packageBinding.parent, moduleBinding.environment, moduleBinding);
        this.add(packageBinding);
    }

    public void add(PackageBinding packageBinding) {
        if (packageBinding instanceof SplitPackageBinding) {
            SplitPackageBinding splitPackageBinding = (SplitPackageBinding)packageBinding;
            this.declaringModules.addAll(splitPackageBinding.declaringModules);
            for (PlainPackageBinding plainPackageBinding : splitPackageBinding.incarnations) {
                if (!this.incarnations.add(plainPackageBinding)) continue;
                plainPackageBinding.addWrappingSplitPackageBinding(this);
            }
        } else if (packageBinding instanceof PlainPackageBinding) {
            this.declaringModules.add(packageBinding.enclosingModule);
            if (this.incarnations.add((PlainPackageBinding)packageBinding)) {
                packageBinding.addWrappingSplitPackageBinding(this);
            }
        }
    }

    @Override
    PackageBinding addPackage(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        PlainPackageBinding plainPackageBinding;
        char[] cArray = packageBinding.compoundName[packageBinding.compoundName.length - 1];
        packageBinding = this.combineWithSiblings(packageBinding, cArray, moduleBinding);
        Object object = this.knownPackages.get(cArray);
        object = SplitPackageBinding.combine(packageBinding, object, this.enclosingModule);
        this.knownPackages.put(cArray, (PackageBinding)object);
        PlainPackageBinding plainPackageBinding2 = this.getIncarnation(packageBinding.enclosingModule);
        if (plainPackageBinding2 != null && (plainPackageBinding = packageBinding.getIncarnation(packageBinding.enclosingModule)) != null) {
            plainPackageBinding2.addPackage(plainPackageBinding, moduleBinding);
        }
        return packageBinding;
    }

    PackageBinding combineWithSiblings(PackageBinding packageBinding, char[] cArray, ModuleBinding moduleBinding) {
        ModuleBinding moduleBinding2 = packageBinding.enclosingModule;
        char[] cArray2 = CharOperation.concatWith(packageBinding.compoundName, '.');
        for (PackageBinding packageBinding2 : this.incarnations) {
            ModuleBinding moduleBinding3 = packageBinding2.enclosingModule;
            if (moduleBinding3 == moduleBinding || packageBinding.isDeclaredIn(moduleBinding3)) continue;
            PlainPackageBinding plainPackageBinding = moduleBinding3.getDeclaredPackage(cArray2);
            packageBinding = SplitPackageBinding.combine(plainPackageBinding, packageBinding, moduleBinding2);
        }
        return packageBinding;
    }

    @Override
    ModuleBinding[] getDeclaringModules() {
        return this.declaringModules.toArray(new ModuleBinding[this.declaringModules.size()]);
    }

    @Override
    PackageBinding getPackage0(char[] cArray) {
        PackageBinding packageBinding = super.getPackage0(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        PackageBinding packageBinding2 = null;
        for (PackageBinding packageBinding3 : this.incarnations) {
            PackageBinding packageBinding4 = packageBinding3.getPackage0(cArray);
            if (packageBinding4 == null) {
                return null;
            }
            packageBinding2 = SplitPackageBinding.combine(packageBinding4, packageBinding2, this.enclosingModule);
        }
        if (packageBinding2 != null) {
            this.knownPackages.put(cArray, packageBinding2);
        }
        return packageBinding2;
    }

    @Override
    PackageBinding getPackage0Any(char[] cArray) {
        PackageBinding packageBinding = super.getPackage0(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        PackageBinding packageBinding2 = null;
        for (PackageBinding packageBinding3 : this.incarnations) {
            PackageBinding packageBinding4 = packageBinding3.getPackage0(cArray);
            if (packageBinding4 == null) continue;
            packageBinding2 = SplitPackageBinding.combine(packageBinding4, packageBinding2, this.enclosingModule);
        }
        return packageBinding2;
    }

    @Override
    protected PackageBinding findPackage(char[] cArray, ModuleBinding moduleBinding) {
        Object object;
        Binding binding2;
        char[][] cArray2 = CharOperation.arrayConcat(this.compoundName, cArray);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Binding binding2 : this.declaringModules) {
            object = binding2.getVisiblePackage(cArray2);
            if (object == null || object == LookupEnvironment.TheNotFoundPackage || (((PackageBinding)object).tagBits & 0x80L) != 0L) continue;
            hashSet.add(object);
        }
        int n = hashSet.size();
        binding2 = null;
        if (n == 1) {
            binding2 = (PackageBinding)hashSet.iterator().next();
        } else if (n > 1) {
            object = hashSet.iterator();
            SplitPackageBinding splitPackageBinding = new SplitPackageBinding((PackageBinding)object.next(), this.enclosingModule);
            while (object.hasNext()) {
                splitPackageBinding.add((PackageBinding)object.next());
            }
            binding2 = splitPackageBinding;
        }
        if (binding2 == null) {
            this.addNotFoundPackage(cArray);
        } else {
            this.addPackage((PackageBinding)binding2, moduleBinding);
        }
        return binding2;
    }

    @Override
    public PlainPackageBinding getIncarnation(ModuleBinding moduleBinding) {
        for (PlainPackageBinding plainPackageBinding : this.incarnations) {
            if (plainPackageBinding.enclosingModule != moduleBinding) continue;
            return plainPackageBinding;
        }
        return null;
    }

    @Override
    public boolean subsumes(PackageBinding packageBinding) {
        if (!CharOperation.equals(this.compoundName, packageBinding.compoundName)) {
            return false;
        }
        if (packageBinding instanceof SplitPackageBinding) {
            return this.declaringModules.containsAll(((SplitPackageBinding)packageBinding).declaringModules);
        }
        return this.declaringModules.contains(packageBinding.enclosingModule);
    }

    @Override
    boolean hasType0Any(char[] cArray) {
        if (super.hasType0Any(cArray)) {
            return true;
        }
        for (PackageBinding packageBinding : this.incarnations) {
            if (!packageBinding.hasType0Any(cArray)) continue;
            return true;
        }
        return false;
    }

    ReferenceBinding getType0ForModule(ModuleBinding moduleBinding, char[] cArray) {
        if (this.declaringModules.contains(moduleBinding)) {
            return this.getIncarnation(moduleBinding).getType0(cArray);
        }
        return null;
    }

    @Override
    ReferenceBinding getType(char[] cArray, ModuleBinding moduleBinding) {
        ReferenceBinding referenceBinding = null;
        boolean bl = false;
        for (PackageBinding packageBinding : this.incarnations) {
            ReferenceBinding referenceBinding2 = packageBinding.getType(cArray, moduleBinding);
            if (referenceBinding2 == null) continue;
            if (referenceBinding == null || !bl) {
                referenceBinding = referenceBinding2;
                bl = moduleBinding.canAccess(packageBinding);
                continue;
            }
            if (!moduleBinding.canAccess(packageBinding)) continue;
            return new ProblemReferenceBinding(referenceBinding2.compoundName, referenceBinding, 3);
        }
        if (referenceBinding != null && !bl) {
            return new ProblemReferenceBinding(referenceBinding.compoundName, referenceBinding, 30);
        }
        return referenceBinding;
    }

    @Override
    public boolean isDeclaredIn(ModuleBinding moduleBinding) {
        return this.declaringModules.contains(moduleBinding);
    }

    @Override
    public PackageBinding getVisibleFor(ModuleBinding moduleBinding, boolean bl) {
        int n = 0;
        PlainPackageBinding plainPackageBinding = null;
        for (PlainPackageBinding plainPackageBinding2 : this.incarnations) {
            if (!plainPackageBinding2.hasCompilationUnit(false)) continue;
            if (bl && plainPackageBinding2.enclosingModule == moduleBinding) {
                return plainPackageBinding2;
            }
            if (!moduleBinding.canAccess(plainPackageBinding2)) continue;
            ++n;
            plainPackageBinding = plainPackageBinding2;
        }
        if (n > 1) {
            return this;
        }
        return plainPackageBinding;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(" (from ");
        String string = "";
        for (ModuleBinding moduleBinding : this.declaringModules) {
            stringBuilder.append(string).append(moduleBinding.readableName());
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

