/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;

public class RecoveredAnnotation
extends RecoveredElement {
    public static final int MARKER = 0;
    public static final int NORMAL = 1;
    public static final int SINGLE_MEMBER = 2;
    private int kind = 0;
    private int identifierPtr;
    private int identifierLengthPtr;
    private int sourceStart;
    public boolean hasPendingMemberValueName;
    public int memberValuPairEqualEnd = -1;
    public Annotation annotation;

    public RecoveredAnnotation(int n, int n2, int n3, RecoveredElement recoveredElement, int n4) {
        super(recoveredElement, n4);
        this.identifierPtr = n;
        this.identifierLengthPtr = n2;
        this.sourceStart = n3;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.annotation == null && (typeDeclaration.bits & 0x200) != 0) {
            return this;
        }
        return super.add(typeDeclaration, n);
    }

    @Override
    public RecoveredElement addAnnotationName(int n, int n2, int n3, int n4) {
        RecoveredAnnotation recoveredAnnotation = new RecoveredAnnotation(n, n2, n3, this, n4);
        return recoveredAnnotation;
    }

    public RecoveredElement addAnnotation(Annotation annotation, int n) {
        this.annotation = annotation;
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    @Override
    public void updateFromParserState() {
        Parser parser = this.parser();
        if (this.annotation == null && this.identifierPtr <= parser.identifierPtr) {
            int n;
            int n2;
            Object object;
            Annotation annotation = null;
            boolean bl = false;
            MemberValuePair memberValuePair = null;
            if (this.hasPendingMemberValueName && this.identifierPtr < parser.identifierPtr) {
                object = parser.identifierStack[this.identifierPtr + 1];
                long l2 = parser.identifierPositionStack[this.identifierPtr + 1];
                n2 = (int)(l2 >>> 32);
                n = (int)l2;
                int n3 = this.memberValuPairEqualEnd > -1 ? this.memberValuPairEqualEnd : n;
                SingleNameReference singleNameReference = new SingleNameReference(RecoveryScanner.FAKE_IDENTIFIER, ((long)n3 + 1L << 32) + (long)n3);
                memberValuePair = new MemberValuePair((char[])object, n2, n, singleNameReference);
            }
            parser.identifierPtr = this.identifierPtr;
            parser.identifierLengthPtr = this.identifierLengthPtr;
            object = parser.getAnnotationType();
            switch (this.kind) {
                case 1: {
                    if (parser.astPtr <= -1 || !(parser.astStack[parser.astPtr] instanceof MemberValuePair)) break;
                    MemberValuePair[] memberValuePairArray = null;
                    int n4 = parser.astLengthStack[parser.astLengthPtr];
                    n2 = parser.astPtr - n4 + 1;
                    if (n4 <= 0) break;
                    if (memberValuePair != null) {
                        memberValuePairArray = new MemberValuePair[n4 + 1];
                        System.arraycopy(parser.astStack, n2, memberValuePairArray, 0, n4);
                        --parser.astLengthPtr;
                        parser.astPtr -= n4;
                        memberValuePairArray[n4] = memberValuePair;
                        n = memberValuePair.sourceEnd;
                    } else {
                        memberValuePairArray = new MemberValuePair[n4];
                        System.arraycopy(parser.astStack, n2, memberValuePairArray, 0, n4);
                        --parser.astLengthPtr;
                        parser.astPtr -= n4;
                        MemberValuePair memberValuePair2 = memberValuePairArray[memberValuePairArray.length - 1];
                        n = memberValuePair2.value != null ? (memberValuePair2.value instanceof Annotation ? ((Annotation)memberValuePair2.value).declarationSourceEnd : memberValuePair2.value.sourceEnd) : memberValuePair2.sourceEnd;
                    }
                    NormalAnnotation normalAnnotation = new NormalAnnotation((TypeReference)object, this.sourceStart);
                    normalAnnotation.memberValuePairs = memberValuePairArray;
                    normalAnnotation.declarationSourceEnd = n;
                    normalAnnotation.bits |= 0x20;
                    annotation = normalAnnotation;
                    bl = true;
                    break;
                }
                case 2: {
                    if (parser.expressionPtr <= -1) break;
                    Expression expression = parser.expressionStack[parser.expressionPtr--];
                    SingleMemberAnnotation singleMemberAnnotation = new SingleMemberAnnotation((TypeReference)object, this.sourceStart);
                    singleMemberAnnotation.memberValue = expression;
                    singleMemberAnnotation.declarationSourceEnd = expression.sourceEnd;
                    singleMemberAnnotation.bits |= 0x20;
                    annotation = singleMemberAnnotation;
                    bl = true;
                }
            }
            if (!bl) {
                if (memberValuePair != null) {
                    NormalAnnotation normalAnnotation = new NormalAnnotation((TypeReference)object, this.sourceStart);
                    normalAnnotation.memberValuePairs = new MemberValuePair[]{memberValuePair};
                    normalAnnotation.declarationSourceEnd = memberValuePair.value.sourceEnd;
                    normalAnnotation.bits |= 0x20;
                    annotation = normalAnnotation;
                } else {
                    MarkerAnnotation markerAnnotation = new MarkerAnnotation((TypeReference)object, this.sourceStart);
                    markerAnnotation.declarationSourceEnd = markerAnnotation.sourceEnd;
                    markerAnnotation.bits |= 0x20;
                    annotation = markerAnnotation;
                }
            }
            parser.currentElement = this.addAnnotation(annotation, this.identifierPtr);
            parser.annotationRecoveryCheckPoint(annotation.sourceStart, annotation.declarationSourceEnd);
            if (this.parent != null) {
                this.parent.updateFromParserState();
            }
        }
    }

    @Override
    public ASTNode parseTree() {
        return this.annotation;
    }

    @Override
    public void resetPendingModifiers() {
        if (this.parent != null) {
            this.parent.resetPendingModifiers();
        }
    }

    public void setKind(int n) {
        this.kind = n;
    }

    @Override
    public int sourceEnd() {
        if (this.annotation == null) {
            Parser parser = this.parser();
            if (this.identifierPtr < parser.identifierPositionStack.length) {
                return (int)parser.identifierPositionStack[this.identifierPtr];
            }
            return this.sourceStart;
        }
        return this.annotation.declarationSourceEnd;
    }

    @Override
    public String toString(int n) {
        if (this.annotation != null) {
            return this.tabString(n) + "Recovered annotation:\n" + this.annotation.print(n + 1, new StringBuffer(10));
        }
        return this.tabString(n) + "Recovered annotation: identiferPtr=" + this.identifierPtr + " identiferlengthPtr=" + this.identifierLengthPtr + "\n";
    }

    public Annotation updatedAnnotationReference() {
        return this.annotation;
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            return this;
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n, n2);
        }
        return this;
    }

    @Override
    public void updateParseTree() {
        this.updatedAnnotationReference();
    }
}

