/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompilerImpl;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.ExceptionDiagnostic;
import org.eclipse.jdt.internal.compiler.tool.Options;

public class EclipseCompiler
implements JavaCompiler {
    private static Set<SourceVersion> SupportedSourceVersions;
    WeakHashMap<Thread, EclipseCompilerImpl> threadCache = new WeakHashMap();
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return SupportedSourceVersions;
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        this.diagnosticListener = diagnosticListener;
        return new EclipseFileManager(locale, charset);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JavaCompiler.CompilationTask getTask(Writer writer2, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3) {
        StandardJavaFileManager standardJavaFileManager;
        Object object;
        Object object2;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        if (writer2 == null) {
            printWriter = new PrintWriter(System.err);
            printWriter2 = new PrintWriter(System.err);
        } else {
            printWriter = new PrintWriter(writer2);
            printWriter2 = new PrintWriter(writer2);
        }
        Thread thread = Thread.currentThread();
        EclipseCompilerImpl eclipseCompilerImpl = this.threadCache.get(thread);
        if (eclipseCompilerImpl == null) {
            eclipseCompilerImpl = new EclipseCompilerImpl(printWriter, printWriter2, false);
            this.threadCache.put(thread, eclipseCompilerImpl);
        } else {
            eclipseCompilerImpl.initialize(printWriter, printWriter2, false, null, null);
        }
        final EclipseCompilerImpl eclipseCompilerImpl2 = new EclipseCompilerImpl(printWriter, printWriter2, false);
        eclipseCompilerImpl2.compilationUnits = iterable3;
        eclipseCompilerImpl2.diagnosticListener = diagnosticListener;
        eclipseCompilerImpl2.fileManager = javaFileManager != null ? javaFileManager : this.getStandardFileManager(diagnosticListener, null, null);
        String string = CompilerOptions.getLatestVersion();
        eclipseCompilerImpl2.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
        eclipseCompilerImpl2.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
        eclipseCompilerImpl2.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iterable != null) {
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                eclipseCompilerImpl2.fileManager.handleOption((String)object2.next(), (Iterator<String>)object2);
            }
            for (String object3 : iterable) {
                arrayList.add(object3);
            }
        }
        if (iterable3 != null) {
            for (JavaFileObject illegalArgumentException : iterable3) {
                object = illegalArgumentException.toUri();
                if (!((URI)object).isAbsolute()) {
                    object = URI.create("file://" + ((URI)object).toString());
                }
                if (((URI)object).getScheme().equals("file")) {
                    arrayList.add(new File((URI)object).getAbsolutePath());
                    continue;
                }
                arrayList.add(((URI)object).toString());
            }
        }
        if (iterable2 != null) {
            arrayList.add("-classNames");
            object2 = new StringBuilder();
            boolean standardJavaFileManager2 = false;
            object = iterable2.iterator();
            while (object.hasNext()) {
                void var15_19;
                String string2 = (String)object.next();
                if (var15_19 != false) {
                    ((StringBuilder)object2).append(',');
                }
                ((StringBuilder)object2).append(string2);
                ++var15_19;
            }
            arrayList.add(String.valueOf(object2));
        }
        object2 = new String[arrayList.size()];
        arrayList.toArray((T[])object2);
        try {
            eclipseCompilerImpl2.configure((String[])object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (null != diagnosticListener) {
                diagnosticListener.report(new ExceptionDiagnostic(illegalArgumentException));
            }
            throw illegalArgumentException;
        }
        if (eclipseCompilerImpl2.fileManager instanceof StandardJavaFileManager && (object = (standardJavaFileManager = (StandardJavaFileManager)eclipseCompilerImpl2.fileManager).getLocation(StandardLocation.CLASS_OUTPUT)) != null) {
            eclipseCompilerImpl2.setDestinationPath(object.iterator().next().getAbsolutePath());
        }
        return new JavaCompiler.CompilationTask(){
            private boolean hasRun = false;

            @Override
            public Boolean call() {
                if (this.hasRun) {
                    throw new IllegalStateException("This task has already been run");
                }
                Boolean bl = eclipseCompilerImpl2.call() ? Boolean.TRUE : Boolean.FALSE;
                this.hasRun = true;
                return bl;
            }

            @Override
            public void setLocale(Locale locale) {
                eclipseCompilerImpl2.setLocale(locale);
            }

            @Override
            public void setProcessors(Iterable<? extends Processor> iterable) {
                ArrayList<Processor> arrayList = new ArrayList<Processor>();
                for (Processor processor : iterable) {
                    arrayList.add(processor);
                }
                Processor[] processorArray = new Processor[arrayList.size()];
                arrayList.toArray(processorArray);
                eclipseCompilerImpl2.processors = processorArray;
            }

            @Override
            public void addModules(Iterable<String> iterable) {
                if (eclipseCompilerImpl2.rootModules == Collections.EMPTY_SET) {
                    eclipseCompilerImpl2.rootModules = new HashSet();
                }
                for (String string : iterable) {
                    eclipseCompilerImpl2.rootModules.add(string);
                }
            }
        };
    }

    @Override
    public int isSupportedOption(String string) {
        return Options.processOptions(string);
    }

    @Override
    public int run(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, String ... stringArray) {
        boolean bl = new Main(new PrintWriter(new OutputStreamWriter(outputStream != null ? outputStream : System.out)), new PrintWriter(new OutputStreamWriter(outputStream2 != null ? outputStream2 : System.err)), true, null, null).compile(stringArray);
        return bl ? 0 : -1;
    }

    static {
        EnumSet<SourceVersion> enumSet = EnumSet.range(SourceVersion.RELEASE_0, SourceVersion.latest());
        SupportedSourceVersions = Collections.unmodifiableSet(enumSet);
    }
}

