/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.util.Hashtable;
import java.util.Vector;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxField;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;

public class RxProxy {
    private static final String $0 = "RxProxy.nrx";
    protected static final int majorVersion = 45;
    protected static final int minorVersion = 3;
    protected static final String voidsig = "()V";
    protected static final String proxyInitsig = "(I)V";
    protected static final String callMethodsig = "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;";
    protected static final String cinitname = "<clinit>";
    protected static final String oinitname = "<init>";
    protected static final String dollarname = "$0";
    protected static final RxType interpreterType = new RxType(Rexx.toRexx("org.netrexx.process"), Rexx.toRexx("RxInterpreter"), 0);
    protected static final RxType translatorType = new RxType(Rexx.toRexx("org.netrexx.process"), Rexx.toRexx("RxTranslator"), 0);
    protected static final RxType doubleType = new RxType(Rexx.toRexx("java.lang"), Rexx.toRexx("Double"), 0);
    protected static final RxType floatType = new RxType(Rexx.toRexx("java.lang"), Rexx.toRexx("Float"), 0);
    protected static final RxType longType = new RxType(Rexx.toRexx("java.lang"), Rexx.toRexx("Long"), 0);
    protected static final RxType intType = new RxType(Rexx.toRexx("java.lang"), Rexx.toRexx("Integer"), 0);
    protected static final RxType oArrayType = new RxType(Rexx.toRexx("java.lang"), Rexx.toRexx("Object"), 1);
    RxTranslator rxt;
    RxClassInfo info;
    int dollarref;
    int thisref;
    int refPI = 0;
    int refCM = 0;
    int refiv = 0;
    int reffv = 0;
    int refdv = 0;
    int reflv = 0;
    private int thisclass = 0;
    private int superclass = 0;
    private int conlength = 0;
    private int conindex = 0;
    private Vector conlist = new Vector(50);
    private Hashtable constants = new Hashtable(50);
    private int[] impclasses;
    private int propcount = 0;
    private int[] propnameid;
    private int[] proptypeid;
    private int[] propflags;
    private Vector[] propatts;
    private int propattlen = 0;
    private int methcount = 0;
    private int[] methnameid;
    private int[] methtypeid;
    private int[] methflags;
    private Vector[] methatts;
    private int methattlen = 0;
    private Vector clasatts;
    private int clasattlen = 0;
    private int classlength;

    public RxProxy(RxTranslator rxTranslator, RxClassInfo rxClassInfo) {
        int n;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        RxField rxField = null;
        AttribCV attribCV = null;
        Vector<Attrib> vector2 = null;
        this.rxt = rxTranslator;
        this.info = rxClassInfo;
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# Building Proxy for: " + this.info.type.toString());
        }
        this.thisclass = this.conClass(this.info.type);
        if (this.info.superinfo != null) {
            this.superclass = this.conClass(this.info.superinfo.type);
        }
        if (this.info.impinfos == null) {
            this.impclasses = new int[0];
        } else {
            this.impclasses = new int[this.info.impinfos.length];
            n = this.impclasses.length;
            n2 = 0;
            while (n > 0) {
                this.impclasses[n2] = this.conClass(this.info.impinfos[n2].type);
                --n;
                ++n2;
            }
        }
        this.propcount = this.info.proplist.size();
        int n4 = 1 + (this.info.isdependent ? 1 : 0);
        this.propnameid = new int[this.propcount + n4];
        this.proptypeid = new int[this.propcount + n4];
        this.propflags = new int[this.propcount + n4];
        this.propatts = new Vector[this.propcount + n4];
        this.propflags[0] = 24;
        this.propflags[0] = !this.info.isinterface ? this.propflags[0] + 2 : this.propflags[0] + 1;
        this.propnameid[0] = this.addutf8(dollarname.toCharArray());
        this.proptypeid[0] = this.addSig(interpreterType);
        this.dollarref = this.conRef(9, this.info.type, dollarname, interpreterType);
        if (this.info.isdependent) {
            this.propflags[1] = 17;
            string = "this$" + (this.info.parents - 1);
            this.propnameid[1] = this.addutf8(string.toCharArray());
            this.proptypeid[1] = this.addSig(this.info.parentinfo.type);
            this.thisref = this.conRef(9, this.info.type, string, this.info.parentinfo.type);
        }
        n = this.propcount;
        n3 = n4;
        while (n > 0) {
            rxField = (RxField)this.info.proplist.elementAt(n3 - n4);
            this.propflags[n3] = this.accflags(rxField);
            this.propnameid[n3] = this.addutf8(Rexx.tochararray(rxField.fieldname));
            this.proptypeid[n3] = this.addSig(rxField.fieldtype);
            if (rxField.fieldvalue != null) {
                attribCV = new AttribCV(rxField.fieldvalue);
                vector2 = new Vector<Attrib>(1);
                vector2.addElement(attribCV);
                this.propatts[n3] = vector2;
                this.propattlen += attribCV.size();
            }
            --n;
            ++n3;
        }
        this.propcount += n4;
        this.methcount = this.info.methlist.size();
        this.methnameid = new int[this.methcount + 1];
        this.methtypeid = new int[this.methcount + 1];
        this.methflags = new int[this.methcount + 1];
        this.methatts = new Vector[this.methcount + 1];
        this.methflags[0] = 8;
        this.methnameid[0] = this.addutf8(cinitname.toCharArray());
        this.methtypeid[0] = this.addutf8(voidsig.toCharArray());
        vector2 = new Vector(2);
        AttribEC attribEC = new AttribEC(RxType.EMPTY_TYPES);
        vector2.addElement(attribEC);
        this.methattlen += attribEC.size();
        AttribCO attribCO = new AttribCO((RxField)null);
        vector2.addElement(attribCO);
        this.methattlen += attribCO.size();
        this.methatts[0] = vector2;
        n = this.methcount;
        n3 = 1;
        while (n > 0) {
            rxField = (RxField)this.info.methlist.elementAt(n3 - 1);
            this.methflags[n3] = this.accflags(rxField);
            this.methnameid[n3] = rxField.isConstructor() ? this.addutf8(oinitname.toCharArray()) : this.addutf8(Rexx.tochararray(rxField.fieldname));
            this.methtypeid[n3] = this.addMethSig(rxField);
            vector2 = new Vector(2);
            attribEC = new AttribEC(rxField);
            vector2.addElement(attribEC);
            this.methattlen += attribEC.size();
            if (!rxField.isNative() && !rxField.isAbstract()) {
                attribCO = new AttribCO(rxField);
                vector2.addElement(attribCO);
                this.methattlen += attribCO.size();
            }
            this.methatts[n3] = vector2;
            --n;
            ++n3;
        }
        ++this.methcount;
        String string2 = this.info.localclass.classprogram.source.getName();
        this.clasatts = new Vector(1);
        AttribSF attribSF = new AttribSF(string2);
        this.clasatts.addElement(attribSF);
        this.clasattlen += attribSF.size();
        this.classlength = 24 + this.conlength + 2 * this.impclasses.length + 8 * this.propcount + this.propattlen + 8 * this.methcount + this.methattlen + this.clasattlen;
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# --- constant pool: " + this.conlength + " class: " + this.classlength + " ---");
            RexxIO.Say("#     props: " + this.propcount + " meths: " + this.methcount);
            RexxIO.Say("#     atts: " + this.propattlen + " " + this.methattlen + " " + this.clasattlen);
        }
    }

    public byte[] getBytes() {
        int n;
        int n2 = 0;
        char[] cArray = null;
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Attrib attrib = null;
        int n10 = 0;
        int n11 = 0;
        byte[] byArray = new byte[this.classlength];
        int n12 = 0;
        n12 = this.writeInt(byArray, n12, -889275714);
        n12 = this.writeShort(byArray, n12, 3);
        n12 = this.writeShort(byArray, n12, 45);
        n12 = this.writeShort(byArray, n12, this.conindex + 1);
        int n13 = this.conlist.size();
        n2 = 0;
        while (n13 > 0) {
            cArray = ((String)this.conlist.elementAt(n2)).toCharArray();
            c = cArray[0];
            n12 = this.writeByte(byArray, n12, c);
            switch (c) {
                case '\u0003': 
                case '\u0004': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': {
                    n12 = this.writeShort(byArray, n12, cArray[1]);
                    n12 = this.writeShort(byArray, n12, cArray[2]);
                    break;
                }
                case '\u0007': 
                case '\b': {
                    n12 = this.writeShort(byArray, n12, cArray[1]);
                    break;
                }
                case '\u0005': 
                case '\u0006': {
                    n12 = this.writeShort(byArray, n12, cArray[1]);
                    n12 = this.writeShort(byArray, n12, cArray[2]);
                    n12 = this.writeShort(byArray, n12, cArray[3]);
                    n12 = this.writeShort(byArray, n12, cArray[4]);
                    break;
                }
                case '\u0001': {
                    n12 = this.writeShort(byArray, n12, cArray[1]);
                    n = cArray.length - 2;
                    n3 = 2;
                    while (n > 0) {
                        n4 = cArray[n3];
                        if (n4 == 0) {
                            n12 = this.writeShort(byArray, n12, 49280);
                        } else if (n4 <= 127) {
                            n12 = this.writeByte(byArray, n12, n4);
                        } else if (n4 <= 2047) {
                            n5 = n4;
                            n6 = n5 & 0x3F | 0x80;
                            n5 = n5 / 64 & 0x1F | 0xC0;
                            n12 = this.writeByte(byArray, n12, n5);
                            n12 = this.writeByte(byArray, n12, n6);
                        } else {
                            n5 = n4;
                            n6 = n5 & 0x3F | 0x80;
                            n7 = (n5 /= 64) & 0x3F | 0x80;
                            n5 = n5 / 64 & 0xF | 0xE0;
                            n12 = this.writeByte(byArray, n12, n5);
                            n12 = this.writeByte(byArray, n12, n7);
                            n12 = this.writeByte(byArray, n12, n6);
                        }
                        --n;
                        ++n3;
                    }
                    break;
                }
                default: {
                    throw new NoOtherwiseException();
                }
            }
            --n13;
            ++n2;
        }
        n12 = this.writeShort(byArray, n12, this.accflags(this.info));
        n12 = this.writeShort(byArray, n12, this.thisclass);
        n12 = this.writeShort(byArray, n12, this.superclass);
        n12 = this.writeShort(byArray, n12, this.impclasses.length);
        n13 = this.impclasses.length;
        n3 = 0;
        while (n13 > 0) {
            n12 = this.writeShort(byArray, n12, this.impclasses[n3]);
            --n13;
            ++n3;
        }
        n12 = this.writeShort(byArray, n12, this.propcount);
        n13 = this.propcount;
        n3 = 0;
        while (n13 > 0) {
            n12 = this.writeShort(byArray, n12, this.propflags[n3]);
            n12 = this.writeShort(byArray, n12, this.propnameid[n3]);
            n12 = this.writeShort(byArray, n12, this.proptypeid[n3]);
            n8 = this.propatts[n3] == null ? 0 : this.propatts[n3].size();
            n12 = this.writeShort(byArray, n12, n8);
            n = n8;
            n9 = 0;
            while (n > 0) {
                attrib = (Attrib)this.propatts[n3].elementAt(n9);
                n12 = attrib.writeBytes(byArray, n12);
                --n;
                ++n9;
            }
            --n13;
            ++n3;
        }
        n12 = this.writeShort(byArray, n12, this.methcount);
        n13 = this.methcount;
        n3 = 0;
        while (n13 > 0) {
            n12 = this.writeShort(byArray, n12, this.methflags[n3]);
            n12 = this.writeShort(byArray, n12, this.methnameid[n3]);
            n12 = this.writeShort(byArray, n12, this.methtypeid[n3]);
            n10 = this.methatts[n3] == null ? 0 : this.methatts[n3].size();
            n12 = this.writeShort(byArray, n12, n10);
            n = n10;
            n9 = 0;
            while (n > 0) {
                attrib = (Attrib)this.methatts[n3].elementAt(n9);
                n12 = attrib.writeBytes(byArray, n12);
                --n;
                ++n9;
            }
            --n13;
            ++n3;
        }
        n11 = this.clasatts == null ? 0 : this.clasatts.size();
        n12 = this.writeShort(byArray, n12, n11);
        n13 = n11;
        n9 = 0;
        while (n13 > 0) {
            attrib = (Attrib)this.clasatts.elementAt(n9);
            n12 = attrib.writeBytes(byArray, n12);
            --n13;
            ++n9;
        }
        return byArray;
    }

    public int accflags(RxClassInfo rxClassInfo) {
        int n = 32;
        if (rxClassInfo.ispublic) {
            n |= 1;
        }
        if (rxClassInfo.isfinal) {
            n |= 0x10;
        }
        if (rxClassInfo.isinterface) {
            n |= 0x200;
        }
        if (rxClassInfo.isabstract) {
            n |= 0x400;
        }
        return n;
    }

    public int accflags(RxField rxField) {
        int n = 1;
        if (rxField.isStatic()) {
            n |= 8;
        }
        if (rxField.isAbstract()) {
            n |= 0x400;
        }
        if (rxField.isVolatile()) {
            n |= 0x40;
        }
        if (rxField.isTransient()) {
            n |= 0x80;
        }
        if (rxField.isProtected()) {
            n |= 0x20;
        }
        if (rxField.isNative()) {
            n |= 0x100;
        }
        return n;
    }

    public int writeByte(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 & 0xFF);
        return n + 1;
    }

    public int writeShort(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 / 256 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
        return n + 2;
    }

    public int writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 & 0xFF);
        n2 = (int)(((long)n2 & 0xFFFFFFFFL) / 256L);
        byArray[n + 2] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)((n2 /= 256) & 0xFF);
        byArray[n + 0] = (byte)((n2 /= 256) & 0xFF);
        return n + 4;
    }

    public int conClass(RxType rxType) {
        String string = null;
        int n = this.addSig(rxType);
        if (rxType.dimension > 0) {
            n = this.addSig(rxType);
        } else {
            string = rxType.toJavaSig();
            string = string.replace('.', '/');
            string = string.substring(1, string.length() - 1);
            n = this.addutf8(string.toCharArray());
        }
        return this.addone(7, n);
    }

    public int conRef(int n, RxType rxType, String string, RxType rxType2) {
        int n2 = this.addutf8(string.toCharArray());
        int n3 = this.addSig(rxType2);
        int n4 = this.addtwo(12, n2, n3);
        int n5 = this.conClass(rxType);
        return this.addtwo(n, n5, n4);
    }

    public int conRef(int n, RxType rxType, String string, String string2) {
        int n2 = this.addutf8(string.toCharArray());
        int n3 = this.addutf8(string2.toCharArray());
        int n4 = this.addtwo(12, n2, n3);
        int n5 = this.conClass(rxType);
        return this.addtwo(n, n5, n4);
    }

    public int conString(String string) {
        return this.addone(8, this.addutf8(string.toCharArray()));
    }

    public int conInt(int n) {
        int n2 = 3;
        return this.add4(n2, n);
    }

    public int conFloat(float f) {
        int n = 4;
        return this.add4(n, Float.floatToIntBits(f));
    }

    public int conLong(long l2) {
        int n = 5;
        return this.add8(n, l2);
    }

    public int conDouble(double d) {
        int n = 6;
        return this.add8(n, Double.doubleToLongBits(d));
    }

    private int addSig(RxType rxType) {
        String string = rxType.toJavaSig();
        string = string.replace('.', '/');
        return this.addutf8(string.toCharArray());
    }

    private int addMethSig(RxField rxField) {
        return this.addutf8(rxField.JVMsig().toCharArray());
    }

    private int addtwo(int n, int n2, int n3) {
        char[] cArray = new char[]{(char)n, (char)n2, (char)n3};
        return this.addit(String.valueOf(cArray), 5);
    }

    private int addone(int n, int n2) {
        char[] cArray = new char[]{(char)n, (char)n2};
        return this.addit(String.valueOf(cArray), 3);
    }

    private int add8(int n, long l2) {
        char[] cArray = new char[5];
        cArray[0] = (char)n;
        cArray[4] = (char)(l2 & 0xFFFFL);
        cArray[3] = (char)((l2 /= 65536L) & 0xFFFFL);
        cArray[2] = (char)((l2 /= 65536L) & 0xFFFFL);
        cArray[1] = (char)((l2 /= 65536L) & 0xFFFFL);
        int n2 = this.addit(String.valueOf(cArray), 9);
        ++this.conindex;
        return n2;
    }

    private int add4(int n, int n2) {
        char[] cArray = new char[3];
        cArray[0] = (char)n;
        cArray[2] = (char)(n2 & 0xFFFF);
        cArray[1] = (char)(n2 / 65536 & 0xFFFF);
        return this.addit(String.valueOf(cArray), 5);
    }

    int addutf8(char[] cArray) {
        int n = 0;
        char c = '\u0000';
        int n2 = 0;
        int n3 = cArray.length;
        n = 0;
        while (n3 > 0) {
            c = cArray[n];
            n2 = c == '\u0000' ? (n2 += 2) : (c <= '\u007f' ? ++n2 : (c <= '\u07ff' ? (n2 += 2) : (n2 += 3)));
            --n3;
            ++n;
        }
        char[] cArray2 = new char[2 + cArray.length];
        cArray2[0] = '\u0001';
        cArray2[1] = (char)n2;
        n3 = cArray.length;
        n = 0;
        while (n3 > 0) {
            cArray2[n + 2] = cArray[n];
            --n3;
            ++n;
        }
        return this.addit(String.valueOf(cArray2), 3 + n2);
    }

    private int addit(String string, int n) {
        Object object = this.constants.get(string);
        if (object != null) {
            return (Integer)object;
        }
        ++this.conindex;
        this.conlength += n;
        object = new Integer(this.conindex);
        this.constants.put(string, object);
        this.conlist.addElement(string);
        return this.conindex;
    }

    class AttribCO
    extends Attrib {
        private final transient String $0 = "RxProxy.nrx";
        RxTranslator rxt;
        int maxstack;
        int maxlocals;
        byte[] bytes;
        int byteslen;
        RxProxy par;

        public AttribCO(RxField rxField) {
            RxProxy rxProxy2 = RxProxy.this;
            rxProxy2.getClass();
            super("Code");
            this.$0 = RxProxy.$0;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            RxField rxField2 = null;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            RxType rxType = null;
            RxType rxType2 = null;
            String string = null;
            RxType rxType3 = null;
            int n10 = 0;
            this.par = RxProxy.this;
            this.rxt = RxProxy.this.rxt;
            if (rxField == null) {
                this.maxstack = 5;
                this.maxlocals = 5;
                this.bytes = new byte[20];
                n = 0;
                n = this.writeByte(this.bytes, n, 178);
                n2 = RxProxy.this.conRef(9, translatorType, "proxyInterpreter", interpreterType);
                n = this.writeShort(this.bytes, n, n2);
                n = this.writeByte(this.bytes, n, 89);
                n = this.writeByte(this.bytes, n, 179);
                n = this.writeShort(this.bytes, n, RxProxy.this.dollarref);
                n = this.makeIconst(this.bytes, n, RxProxy.this.info.classid);
                n = this.writeByte(this.bytes, n, 182);
                if (RxProxy.this.refPI == 0) {
                    RxProxy.this.refPI = RxProxy.this.conRef(10, interpreterType, "proxyInit", RxProxy.proxyInitsig);
                }
                n = this.writeShort(this.bytes, n, RxProxy.this.refPI);
                this.byteslen = this.writeByte(this.bytes, n, 177);
            } else {
                n3 = rxField.fieldargtypes.length;
                rxField2 = rxField.fieldspecial;
                if (rxField2 == null) {
                    n4 = 0;
                } else {
                    n5 = rxField2.fieldinfo.isdependent ? 1 : 0;
                    n4 = rxField2.fieldargtypes.length + n5;
                }
                n6 = n3;
                if (n4 > n6) {
                    n6 = n4;
                }
                this.maxstack = n6 + 7 + 1;
                n7 = 49 + n3 * 13 + n4 * 8;
                this.bytes = new byte[n7];
                n = 0;
                if (RxProxy.this.refCM == 0) {
                    RxProxy.this.refCM = RxProxy.this.conRef(10, interpreterType, "callMethod", RxProxy.callMethodsig);
                }
                n = this.makeIconst(this.bytes, n, n3);
                n = this.writeByte(this.bytes, n, 189);
                n = this.writeShort(this.bytes, n, RxProxy.this.conClass(RxType.OBJECT_TYPE));
                int n11 = n3;
                n8 = 0;
                while (n11 > 0) {
                    n = this.writeByte(this.bytes, n, 89);
                    --n11;
                    ++n8;
                }
                if (rxField.isStatic()) {
                    n9 = 0;
                } else {
                    n9 = 1;
                    if (rxField.fieldinfo.isdependent && rxField.isConstructor()) {
                        n9 = 2;
                    }
                }
                n11 = n3;
                n8 = 0;
                while (n11 > 0) {
                    n = this.makeIconst(this.bytes, n, n8);
                    rxType = rxField.fieldargtypes[n8];
                    if (rxType.isPrimitive()) {
                        n = this.writeByte(this.bytes, n, 187);
                        if (rxType.equals(RxType.LONG_TYPE)) {
                            rxType2 = longType;
                            n = this.writeShort(this.bytes, n, RxProxy.this.conClass(rxType2));
                            n = this.writeByte(this.bytes, n, 89);
                            n = this.writeByte(this.bytes, n, 22);
                            n = this.writeByte(this.bytes, n, n9);
                            ++n9;
                            string = "(J)V";
                        } else if (rxType.equals(RxType.FLOAT_TYPE)) {
                            rxType2 = floatType;
                            n = this.writeShort(this.bytes, n, RxProxy.this.conClass(rxType2));
                            n = this.writeByte(this.bytes, n, 89);
                            n = this.writeByte(this.bytes, n, 23);
                            n = this.writeByte(this.bytes, n, n9);
                            string = "(F)V";
                        } else if (rxType.equals(RxType.DOUBLE_TYPE)) {
                            rxType2 = doubleType;
                            n = this.writeShort(this.bytes, n, RxProxy.this.conClass(rxType2));
                            n = this.writeByte(this.bytes, n, 89);
                            n = this.writeByte(this.bytes, n, 24);
                            n = this.writeByte(this.bytes, n, n9);
                            ++n9;
                            string = "(D)V";
                        } else {
                            rxType2 = intType;
                            n = this.writeShort(this.bytes, n, RxProxy.this.conClass(rxType2));
                            n = this.writeByte(this.bytes, n, 89);
                            n = this.writeByte(this.bytes, n, 21);
                            n = this.writeByte(this.bytes, n, n9);
                            rxType2 = intType;
                            string = RxProxy.proxyInitsig;
                        }
                        n = this.writeByte(this.bytes, n, 183);
                        n2 = RxProxy.this.conRef(10, rxType2, RxProxy.oinitname, string);
                        n = this.writeShort(this.bytes, n, n2);
                    } else {
                        n = this.writeByte(this.bytes, n, 25);
                        n = this.writeByte(this.bytes, n, n9);
                    }
                    n = this.writeByte(this.bytes, n, 83);
                    ++n9;
                    --n11;
                    ++n8;
                }
                this.maxlocals = n9;
                if (rxField.isConstructor()) {
                    if (rxField2 == null) {
                        throw new RxQuit(this.rxt, (RxToken)null, "internal.error", Rexx.toRexx("RxProxy: tsfield null " + rxField.toString()));
                    }
                    n = this.writeByte(this.bytes, n, 42);
                    if (n4 > 0) {
                        n = this.writeByte(this.bytes, n, 92);
                        n = this.writeByte(this.bytes, n, 87);
                        n = this.writeByte(this.bytes, n, 178);
                        n = this.writeShort(this.bytes, n, RxProxy.this.dollarref);
                        n = this.writeByte(this.bytes, n, 95);
                        n = rxField.fieldinfo.isdependent ? this.writeByte(this.bytes, n, 43) : this.writeByte(this.bytes, n, 1);
                        n = this.writeByte(this.bytes, n, 95);
                        n = this.makeIconst(this.bytes, n, rxField.fieldid);
                        n = this.writeByte(this.bytes, n, 116);
                        n = this.writeByte(this.bytes, n, 95);
                        n = this.writeByte(this.bytes, n, 182);
                        if (RxProxy.this.refCM == 0) {
                            RxProxy.this.refCM = RxProxy.this.conRef(10, interpreterType, "callMethod", RxProxy.callMethodsig);
                        }
                        n = this.writeShort(this.bytes, n, RxProxy.this.refCM);
                        n = this.writeByte(this.bytes, n, 192);
                        n = this.writeShort(this.bytes, n, this.par.conClass(oArrayType));
                        n11 = n4;
                        n8 = 0;
                        while (n11 > 0) {
                            n = this.writeByte(this.bytes, n, 89);
                            n = this.makeIconst(this.bytes, n, n8);
                            n = this.writeByte(this.bytes, n, 50);
                            n = n8 < n5 ? this.makeUnwrap(this.bytes, n, rxField2.fieldinfo.parentinfo.type) : this.makeUnwrap(this.bytes, n, rxField2.fieldargtypes[n8 - n5]);
                            n = this.writeByte(this.bytes, n, 95);
                            --n11;
                            ++n8;
                        }
                        n = this.writeByte(this.bytes, n, 87);
                    }
                    n = this.writeByte(this.bytes, n, 183);
                    n2 = RxProxy.this.conRef(10, rxField2.fieldinfo.type, RxProxy.oinitname, rxField2.JVMsig());
                    n = this.writeShort(this.bytes, n, n2);
                    if (rxField.fieldinfo.isdependent) {
                        n = this.writeByte(this.bytes, n, 42);
                        n = this.writeByte(this.bytes, n, 43);
                        n = this.writeByte(this.bytes, n, 181);
                        n = this.writeShort(this.bytes, n, RxProxy.this.thisref);
                    }
                }
                n = this.writeByte(this.bytes, n, 178);
                n = this.writeShort(this.bytes, n, RxProxy.this.dollarref);
                n = this.writeByte(this.bytes, n, 95);
                n = rxField.isStatic() ? this.writeByte(this.bytes, n, 1) : this.writeByte(this.bytes, n, 42);
                n = this.writeByte(this.bytes, n, 95);
                n = this.makeIconst(this.bytes, n, rxField.fieldid);
                n = this.writeByte(this.bytes, n, 95);
                n = this.writeByte(this.bytes, n, 182);
                n = this.writeShort(this.bytes, n, RxProxy.this.refCM);
                rxType3 = rxField.fieldtype;
                if (rxField.isConstructor() || rxType3.equals(RxType.VOID_TYPE)) {
                    n10 = 177;
                } else {
                    n = this.makeUnwrap(this.bytes, n, rxType3);
                    n10 = rxType3.isPrimitive() ? (rxType3.equals(RxType.LONG_TYPE) ? 173 : (rxType3.equals(RxType.FLOAT_TYPE) ? 174 : (rxType3.equals(RxType.DOUBLE_TYPE) ? 175 : 172))) : 176;
                }
                this.byteslen = this.writeByte(this.bytes, n, n10);
            }
            this.length = 12 + this.byteslen;
        }

        public int makeIconst(byte[] byArray, int n, int n2) {
            if (n2 == 0) {
                n = this.writeByte(byArray, n, 3);
            } else if (n2 == 1) {
                n = this.writeByte(byArray, n, 4);
            } else if (n2 == 2) {
                n = this.writeByte(byArray, n, 5);
            } else if (n2 == 3) {
                n = this.writeByte(byArray, n, 6);
            } else if (n2 == 4) {
                n = this.writeByte(byArray, n, 7);
            } else if (n2 == 5) {
                n = this.writeByte(byArray, n, 8);
            } else if (n2 == -1) {
                n = this.writeByte(byArray, n, 2);
            } else if (n2 >= -128 & n2 <= 127) {
                n = this.writeByte(byArray, n, 16);
                n = this.writeByte(byArray, n, n2);
            } else if (n2 >= Short.MIN_VALUE & n2 <= Short.MAX_VALUE) {
                n = this.writeByte(byArray, n, 17);
                n = this.writeShort(byArray, n, n2);
            } else {
                n = this.writeByte(byArray, n, 19);
                n = this.writeShort(byArray, n, this.par.conInt(n2));
            }
            return n;
        }

        public int makeUnwrap(byte[] byArray, int n, RxType rxType) {
            int n2 = 0;
            if (rxType.equals(RxType.OBJECT_TYPE)) {
                return n;
            }
            n = this.writeByte(this.bytes, n, 192);
            if (!rxType.isPrimitive()) {
                n = this.writeShort(this.bytes, n, this.par.conClass(rxType));
                return n;
            }
            if (rxType.equals(RxType.LONG_TYPE)) {
                n = this.writeShort(this.bytes, n, this.par.conClass(longType));
                if (this.par.reflv == 0) {
                    this.par.reflv = this.par.conRef(10, longType, "longValue", "()J");
                }
                n2 = this.par.reflv;
            } else if (rxType.equals(RxType.FLOAT_TYPE)) {
                n = this.writeShort(this.bytes, n, this.par.conClass(floatType));
                if (this.par.reffv == 0) {
                    this.par.reffv = this.par.conRef(10, floatType, "floatValue", "()F");
                }
                n2 = this.par.reffv;
            } else if (rxType.equals(RxType.DOUBLE_TYPE)) {
                n = this.writeShort(this.bytes, n, this.par.conClass(doubleType));
                if (this.par.refdv == 0) {
                    this.par.refdv = this.par.conRef(10, doubleType, "doubleValue", "()D");
                }
                n2 = this.par.refdv;
            } else {
                n = this.writeShort(this.bytes, n, this.par.conClass(intType));
                if (this.par.refiv == 0) {
                    this.par.refiv = this.par.conRef(10, intType, "intValue", "()I");
                }
                n2 = this.par.refiv;
            }
            n = this.writeByte(this.bytes, n, 182);
            n = this.writeShort(this.bytes, n, n2);
            return n;
        }

        @Override
        public int writeBytes(byte[] byArray, int n) {
            int n2 = 0;
            n = super.writeBytes(byArray, n);
            n = this.writeShort(byArray, n, this.maxstack);
            n = this.writeShort(byArray, n, this.maxlocals);
            n = this.writeInt(byArray, n, this.byteslen);
            int n3 = this.byteslen;
            n2 = 0;
            while (n3 > 0) {
                byArray[n] = this.bytes[n2];
                ++n;
                --n3;
                ++n2;
            }
            n = this.writeShort(byArray, n, 0);
            n = this.writeShort(byArray, n, 0);
            return n;
        }
    }

    class AttribEC
    extends Attrib {
        private final transient String $0 = "RxProxy.nrx";
        int[] exids;

        public AttribEC(RxField rxField) {
            this(rxField.excepTypes());
        }

        public AttribEC(RxType[] rxTypeArray) {
            RxProxy rxProxy2 = RxProxy.this;
            rxProxy2.getClass();
            super("Exceptions");
            this.$0 = RxProxy.$0;
            int n = 0;
            this.length = 2 + 2 * rxTypeArray.length;
            this.exids = new int[rxTypeArray.length];
            int n2 = rxTypeArray.length;
            n = 0;
            while (n2 > 0) {
                this.exids[n] = RxProxy.this.conClass(rxTypeArray[n]);
                --n2;
                ++n;
            }
        }

        @Override
        public int writeBytes(byte[] byArray, int n) {
            int n2 = 0;
            n = super.writeBytes(byArray, n);
            n = this.writeShort(byArray, n, this.exids.length);
            int n3 = this.exids.length;
            n2 = 0;
            while (n3 > 0) {
                n = this.writeShort(byArray, n, this.exids[n2]);
                --n3;
                ++n2;
            }
            return n;
        }
    }

    class AttribSF
    extends Attrib {
        private final transient String $0 = "RxProxy.nrx";
        int fileid;

        public AttribSF(String string) {
            RxProxy rxProxy2 = RxProxy.this;
            rxProxy2.getClass();
            super("SourceFile");
            this.$0 = RxProxy.$0;
            this.length = 2;
            this.fileid = RxProxy.this.addutf8(string.toCharArray());
        }

        @Override
        public int writeBytes(byte[] byArray, int n) {
            n = super.writeBytes(byArray, n);
            n = this.writeShort(byArray, n, this.fileid);
            return n;
        }
    }

    class AttribCV
    extends Attrib {
        private final transient String $0 = "RxProxy.nrx";
        int valueid;

        public AttribCV(Object object) {
            RxProxy rxProxy2 = RxProxy.this;
            rxProxy2.getClass();
            super("ConstantValue");
            this.$0 = RxProxy.$0;
            this.length = 2;
            throw new RxQuit(RxProxy.this.rxt, (RxToken)null, "not.yet.implemented", Rexx.toRexx("ConstantValue"));
        }

        @Override
        public int writeBytes(byte[] byArray, int n) {
            n = super.writeBytes(byArray, n);
            n = this.writeShort(byArray, n, this.valueid);
            return n;
        }
    }

    class Attrib {
        private final transient String $0 = "RxProxy.nrx";
        int nameid;
        int length;

        public Attrib(String string) {
            this.nameid = RxProxy.this.addutf8(string.toCharArray());
        }

        public int size() {
            return this.length + 6;
        }

        public int writeBytes(byte[] byArray, int n) {
            n = this.writeShort(byArray, n, this.nameid);
            n = this.writeInt(byArray, n, this.length);
            return n;
        }

        public int writeByte(byte[] byArray, int n, int n2) {
            return RxProxy.this.writeByte(byArray, n, n2);
        }

        public int writeShort(byte[] byArray, int n, int n2) {
            return RxProxy.this.writeShort(byArray, n, n2);
        }

        public int writeInt(byte[] byArray, int n, int n2) {
            return RxProxy.this.writeInt(byArray, n, n2);
        }
    }
}

