/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import netrexx.lang.BadArgumentException;
import netrexx.lang.DivideException;
import netrexx.lang.ExponentOverflowException;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.NotCharacterException;
import netrexx.lang.NotLogicException;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxNode;
import netrexx.lang.RexxOperators;
import netrexx.lang.RexxSet;
import netrexx.lang.RexxUtil;
import netrexx.lang.RexxWords;
import netrexx.lang.StructuredList;

public class Rexx
implements RexxOperators,
Serializable,
Comparable,
Iterable,
StructuredList {
    private static final Rexx $01 = Rexx.toRexx("Bad binary");
    private static final Rexx $02 = new Rexx(0);
    private static final Rexx $03 = Rexx.toRexx("");
    private static final Rexx $04 = new Rexx('@');
    private static final Rexx $05 = Rexx.toRexx("end");
    private static final Rexx $06 = new Rexx('1');
    private static final Rexx $07 = new Rexx('0');
    private static final Rexx $08 = Rexx.toRexx("default");
    private static final Rexx $09 = Rexx.toRexx("delimiters");
    private static final Rexx $010 = Rexx.toRexx("start");
    private static final Rexx $011 = Rexx.toRexx("separator");
    private static final Rexx $012 = Rexx.toRexx("escape");
    private static final Rexx $013 = Rexx.toRexx("options");
    private static final Rexx $014 = new Rexx('\"');
    private static final Rexx $015 = new Rexx('#');
    private static final String $0 = "Rexx.nrx";
    public static final int DefaultDigits = 9;
    public static final byte DefaultForm = 0;
    public static final String Lowers = "abcdefghijklmnopqrstuvwxyz";
    public static final String Uppers = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String Digits09 = "0123456789";
    public static final char[] Hexes = "0123456789ABCDEFabcdef".toCharArray();
    static final byte ispos = 1;
    static final byte iszero = 0;
    static final byte isneg = -1;
    static final byte NotaNum = -2;
    static final int MinExp = -999999999;
    static final int MaxExp = 999999999;
    static final int MinArg = -999999999;
    static final int MaxArg = 999999999;
    private static final long serialVersionUID = 5056979525654423820L;
    char[] chars;
    byte ind;
    byte form;
    char[] mant;
    int exp;
    int dig;
    Hashtable coll;

    public Rexx(char c) {
        char[] cArray = new char[]{c};
        Rexx rexx = new Rexx(cArray, true);
        this.chars = rexx.chars;
        this.ind = rexx.ind;
        this.mant = rexx.mant;
        this.exp = rexx.exp;
        this.dig = rexx.dig;
        this.form = rexx.form;
    }

    public Rexx(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        Rexx rexx = new Rexx(cArray2, true);
        this.chars = rexx.chars;
        this.ind = rexx.ind;
        this.mant = rexx.mant;
        this.exp = rexx.exp;
        this.dig = rexx.dig;
        this.form = rexx.form;
    }

    public Rexx(String string) {
        this(string.toCharArray(), true);
    }

    public Rexx(CharSequence charSequence) {
        this(charSequence.toString());
    }

    public Rexx(String[] stringArray) {
        this(Rexx.sa2ca(stringArray), true);
    }

    public Rexx(Rexx rexx) {
        this.chars = rexx.chars;
        this.ind = rexx.ind;
        this.mant = rexx.mant;
        this.exp = rexx.exp;
        this.dig = rexx.dig;
        this.form = rexx.form;
        this.coll = null;
    }

    public Rexx(boolean bl) {
        this.exp = 0;
        this.dig = 9;
        this.form = 0;
        this.mant = new char[1];
        if (bl) {
            this.mant[0] = 49;
            this.ind = 1;
        } else {
            this.mant[0] = 48;
            this.ind = 0;
        }
        this.chars = this.mant;
    }

    public Rexx(byte by) {
        this((int)by);
    }

    public Rexx(short s) {
        this((int)s);
    }

    public Rexx(int n) {
        this.exp = 0;
        this.form = 0;
        if (n <= 9 && n >= -9) {
            this.mant = new char[1];
            if (n > 0) {
                this.mant[0] = (char)(48 + n);
                this.chars = this.mant;
                this.ind = 1;
            } else if (n == 0) {
                this.mant[0] = 48;
                this.chars = this.mant;
                this.ind = 0;
            } else {
                this.chars = new char[2];
                this.chars[0] = 45;
                this.chars[1] = (char)(48 - n);
                this.mant[0] = this.chars[1];
                this.ind = (byte)-1;
            }
            return;
        }
        if (n > 0) {
            this.ind = 1;
            this.mant = Integer.toString(n, 10).toCharArray();
            this.chars = this.mant;
            return;
        }
        this.ind = (byte)-1;
        this.chars = null;
        this.dig = 10;
        if (n == Integer.MIN_VALUE) {
            this.mant = new String("2147483648").toCharArray();
            return;
        }
        n = -n;
        this.mant = Integer.toString(n, 10).toCharArray();
    }

    public Rexx(long l) {
        this(String.valueOf(l).toCharArray(), true);
    }

    public Rexx(float f) {
        this(RexxUtil.doubleToRexx(f, 7));
    }

    public Rexx(double d) {
        this(RexxUtil.doubleToRexx(d, 16));
    }

    Rexx(char[] cArray, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        char c = '\u0000';
        this.chars = cArray;
        this.ind = (byte)-2;
        if (cArray.length == 0) {
            return;
        }
        if (cArray[0] > '9') {
            if (cArray[0] <= '\u007f') {
                return;
            }
            if (!Character.isDigit(cArray[0])) {
                return;
            }
        }
        if (!bl) {
            return;
        }
        int n4 = cArray.length;
        for (n = n4 - 1; n >= 0 && cArray[n] == ' '; --n) {
            if (--n4 != 0) continue;
            return;
        }
        int n5 = 0;
        int n6 = -1;
        int n7 = n4 - 1;
        for (n = 0; n <= n7; ++n) {
            if (cArray[n] == ' ') continue;
            if (cArray[n] == '-') {
                if (n5 != 0) {
                    return;
                }
                n5 = -1;
                continue;
            }
            if (cArray[n] != '+') {
                n6 = n;
                break;
            }
            if (n5 != 0) {
                return;
            }
            n5 = 1;
        }
        if (n6 < 0) {
            return;
        }
        boolean bl3 = false;
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        n7 = n4 - 1;
        for (n = n6; n <= n7; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') {
                n10 = n;
                ++n8;
                continue;
            }
            if (cArray[n] == '.') {
                if (n9 >= 0) {
                    return;
                }
                n9 = n - n6;
                continue;
            }
            if (cArray[n] != 'e' && cArray[n] != 'E') {
                if (!Character.isDigit(cArray[n])) {
                    return;
                }
                bl3 = true;
                n10 = n;
                ++n8;
                continue;
            }
            if (n > n4 - 3) {
                return;
            }
            if (n4 - n > 11) {
                return;
            }
            if (cArray[n + 1] == '-') {
                bl2 = true;
            } else if (cArray[n + 1] == '+') {
                bl2 = false;
            } else {
                return;
            }
            if (n4 - n - 2 > 9) {
                return;
            }
            int n11 = n4 - 1;
            for (n2 = n + 2; n2 <= n11; ++n2) {
                if (cArray[n2] < '0') {
                    return;
                }
                if (cArray[n2] > '9') {
                    if (!Character.isDigit(cArray[n2])) {
                        return;
                    }
                    n3 = Character.digit(cArray[n2], 10);
                    if (n3 < 0) {
                        return;
                    }
                } else {
                    n3 = cArray[n2] - 48;
                }
                this.exp = this.exp * 10 + n3;
            }
            if (!bl2) break;
            this.exp = -this.exp;
            break;
        }
        if (n8 == 0) {
            return;
        }
        if (n9 >= 0) {
            this.exp = this.exp + n9 - n8;
        }
        n7 = n10 - 1;
        for (n = n6; n <= n7; ++n) {
            if (cArray[n] == '.') {
                ++n6;
                continue;
            }
            if (cArray[n] == '0') {
                ++n6;
                --n8;
                continue;
            }
            if (cArray[n] <= '9' || Character.digit(cArray[n], 10) != 0) break;
            ++n6;
            --n8;
        }
        if (bl3) {
            this.mant = new char[n8];
            n2 = 0;
            n7 = n8 - 1;
            for (n = 0; n <= n7; ++n) {
                if (cArray[n6 + n] == '.') {
                    n2 = 1;
                }
                if ((c = cArray[n6 + n + n2]) <= '9') {
                    this.mant[n] = c;
                    continue;
                }
                n3 = Character.digit(c, 10);
                if (n3 < 0) {
                    return;
                }
                this.mant[n] = (char)(n3 + 48);
            }
        } else if (n8 == this.chars.length) {
            this.mant = this.chars;
        } else {
            this.mant = new char[n8];
            n2 = 0;
            n7 = n8 - 1;
            for (n = 0; n <= n7; ++n) {
                if (cArray[n6 + n] == '.') {
                    n2 = 1;
                }
                this.mant[n] = cArray[n6 + n + n2];
            }
        }
        if (this.mant[0] == '0') {
            this.ind = 0;
            this.exp = 0;
        } else {
            this.ind = n5 < 0 ? (byte)-1 : (byte)1;
        }
    }

    public Rexx() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RexxNode getnode(Rexx rexx) {
        RexxNode rexxNode;
        if (this.coll == null) {
            Rexx rexx2 = this;
            synchronized (rexx2) {
                if (this.coll == null) {
                    this.coll = new Hashtable(37, 0.67f);
                }
            }
        }
        if ((rexxNode = (RexxNode)this.coll.get(rexx)) != null && rexxNode.leaf != null) {
            return rexxNode;
        }
        rexxNode = new RexxNode(new Rexx(this));
        this.coll.put(rexx, rexxNode);
        return rexxNode;
    }

    public boolean testnode(Rexx rexx) {
        if (this.coll == null) {
            return false;
        }
        RexxNode rexxNode = (RexxNode)this.coll.get(rexx);
        if (rexxNode == null) {
            return false;
        }
        if (rexxNode.leaf == null) {
            return false;
        }
        return rexxNode.leaf != rexxNode.initleaf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration keys() {
        if (this.coll == null) {
            Rexx rexx = this;
            synchronized (rexx) {
                if (this.coll == null) {
                    this.coll = new Hashtable(37, 0.67f);
                }
            }
        }
        return this.coll.keys();
    }

    private final int intlength() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return this.chars.length;
    }

    private final int intwords() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return RexxWords.words(this.chars);
    }

    public String toString() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new String(this.chars);
    }

    public char[] toCharArray() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        char[] cArray = new char[this.chars.length];
        System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
        return cArray;
    }

    public byte[] toByteArray() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new String(this.chars).getBytes();
    }

    public char tochar() throws NotCharacterException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length != 1) {
            throw new NotCharacterException(String.valueOf(this.chars));
        }
        return this.chars[0];
    }

    public int hashCode() {
        int n = 0;
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            n = 0;
        } else {
            stringBuffer = new StringBuffer(this.chars.length);
            int n4 = n2 = this.chars.length - 1;
            for (n3 = 0; n3 <= n4; ++n3) {
                stringBuffer.append(this.chars[n3]);
            }
            string = stringBuffer.toString();
            n = string.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Rexx) {
            return this.docomparestrict(null, (Rexx)object) == 0;
        }
        if (object instanceof String) {
            return this.docomparestrict(null, new Rexx((String)object)) == 0;
        }
        if (object instanceof char[]) {
            return this.docomparestrict(null, new Rexx((char[])object)) == 0;
        }
        return false;
    }

    public char charAt(int n) {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return this.chars[n];
    }

    public static char tochar(String string) throws NotCharacterException {
        if (string.length() != 1) {
            throw new NotCharacterException(string);
        }
        return string.charAt(0);
    }

    public static char tochar(char[] cArray) throws NotCharacterException {
        if (cArray.length != 1) {
            throw new NotCharacterException(String.valueOf(cArray));
        }
        return cArray[0];
    }

    public static char[] tochararray(char c) {
        char[] cArray = new char[]{c};
        return cArray;
    }

    public static final char[] tochararray(Rexx rexx) {
        if (rexx == null) {
            return null;
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray = new char[rexx.chars.length];
        System.arraycopy(rexx.chars, 0, cArray, 0, rexx.chars.length);
        return cArray;
    }

    public static final Rexx toRexx(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return new Rexx(cArray2, true);
    }

    public static final Rexx toRexx(String string) {
        if (string == null) {
            return null;
        }
        return new Rexx(string.toCharArray(), true);
    }

    public static final String toString(Rexx rexx) {
        if (rexx == null) {
            return null;
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new String(rexx.chars);
    }

    public int significance() {
        if (this.ind == -2) {
            return 0;
        }
        return this.mant.length;
    }

    public boolean toboolean() throws NotLogicException {
        if (this.ind == 0) {
            return false;
        }
        if (this.ind == 1 && this.mant.length == 1 && this.mant[0] == '1') {
            return true;
        }
        throw new NotLogicException("Boolean must be 0 or 1.  Found: " + this.toString());
    }

    public byte tobyte() throws NumberFormatException {
        int n = this.toint();
        if (n > 127 | n < -128) {
            throw new NumberFormatException("Conversion overflow");
        }
        return (byte)n;
    }

    public short toshort() throws NumberFormatException {
        int n = this.toint();
        if (n > Short.MAX_VALUE | n < Short.MIN_VALUE) {
            throw new NumberFormatException("Conversion overflow");
        }
        return (short)n;
    }

    public int toint() throws NumberFormatException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (this.ind == 0) {
            return 0;
        }
        int n7 = this.mant.length - 1;
        if (this.exp < 0) {
            n3 = (n7 += this.exp) < 0 ? 0 : n7 + 1;
            n2 = this.mant.length - 1;
            for (n4 = n3; n4 <= n2; ++n4) {
                if (this.mant[n4] == '0') continue;
                throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Decimal part non-zero:").OpCcblank(null, this)));
            }
            if (n7 < 0) {
                return 0;
            }
            n5 = 0;
        } else {
            if (this.exp + this.mant.length > 10) {
                throw new NumberFormatException("Conversion overflow");
            }
            n5 = this.exp;
        }
        int n8 = n = 0;
        n2 = n7 + n5;
        for (n6 = 0; n6 <= n2; ++n6) {
            n *= 10;
            if (n6 <= n7) {
                n += this.mant[n6] - 48;
            }
            if (n < n8) {
                if (this.ind == -1 && n == Integer.MIN_VALUE && n6 == n7 + n5) {
                    return n;
                }
                throw new NumberFormatException("Conversion overflow");
            }
            n8 = n;
        }
        if (this.ind > 0) {
            return n;
        }
        return -n;
    }

    public long tolong() throws NumberFormatException {
        long l;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (this.ind == 0) {
            return 0L;
        }
        int n6 = this.mant.length - 1;
        if (this.exp < 0) {
            n2 = (n6 += this.exp) < 0 ? 0 : n6 + 1;
            n = this.mant.length - 1;
            for (n3 = n2; n3 <= n; ++n3) {
                if (this.mant[n3] == '0') continue;
                throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Decimal part non-zero:").OpCcblank(null, this)));
            }
            if (n6 < 0) {
                return 0L;
            }
            n4 = 0;
        } else {
            if (this.exp + this.mant.length >= 20) {
                throw new NumberFormatException("Conversion overflow");
            }
            n4 = this.exp;
        }
        long l2 = l = 0L;
        n = n6 + n4;
        for (n5 = 0; n5 <= n; ++n5) {
            l *= 10L;
            if (n5 <= n6) {
                l += (long)(this.mant[n5] - 48);
            }
            if (l < l2) {
                if (this.ind < 0 && l == Long.MIN_VALUE && n5 == n6 + n4) {
                    return l;
                }
                throw new NumberFormatException("Conversion overflow");
            }
            l2 = l;
        }
        if (this.ind > 0) {
            return l;
        }
        return -l;
    }

    public float tofloat() throws NumberFormatException {
        double d = this.todouble();
        if (d > 3.402823466E38 | d < -3.402823466E38) {
            throw new NumberFormatException("Overflow");
        }
        return (float)d;
    }

    public double todouble() throws NumberFormatException {
        double d;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (Double.isInfinite(d = Double.valueOf(new String(this.chars)).doubleValue())) {
            throw new NumberFormatException("Overflow");
        }
        return d;
    }

    char[] layoutnum() {
        return this.layout();
    }

    private char[] layout() {
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        char[] cArray = null;
        int n3 = this.exp + this.mant.length;
        if (n3 > this.dig | n3 < -5 && this.form != 2) {
            stringBuffer = new StringBuffer(this.mant.length + 15);
            if (this.ind == -1) {
                stringBuffer.append('-');
            }
            n = this.exp + this.mant.length - 1;
            if (this.form == 0) {
                stringBuffer.append(this.mant[0]);
                if (this.mant.length > 1) {
                    stringBuffer.append('.').append(this.mant, 1, this.mant.length - 1);
                }
            } else {
                n2 = n % 3;
                if (n2 < 0) {
                    n2 = 3 + n2;
                }
                n -= n2;
                if (++n2 >= this.mant.length) {
                    stringBuffer.append(this.mant, 0, this.mant.length);
                    for (int i = n2 - this.mant.length; i > 0; --i) {
                        stringBuffer.append('0');
                    }
                } else {
                    stringBuffer.append(this.mant, 0, n2).append('.').append(this.mant, n2, this.mant.length - n2);
                }
            }
            if (n != 0) {
                if (n < 0) {
                    string = "-";
                    n = -n;
                } else {
                    string = "+";
                }
                stringBuffer.append('E').append(string).append(n);
            }
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return cArray;
        }
        if (this.exp == 0) {
            if (this.ind >= 0) {
                return this.mant;
            }
            cArray = new char[this.mant.length + 1];
            cArray[0] = 45;
            System.arraycopy(this.mant, 0, cArray, 1, this.mant.length);
            return cArray;
        }
        stringBuffer = new StringBuffer(this.mant.length + this.dig + 5 + 3 + 10);
        if (this.ind == -1) {
            stringBuffer.append('-');
        }
        if (n3 < 1) {
            stringBuffer.append('0').append('.');
            for (int i = -n3; i > 0; --i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this.mant);
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return cArray;
        }
        if (n3 > this.mant.length) {
            stringBuffer.append(this.mant);
            for (int i = n3 - this.mant.length; i > 0; --i) {
                stringBuffer.append('0');
            }
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return cArray;
        }
        stringBuffer.append(this.mant, 0, n3).append('.').append(this.mant, n3, this.mant.length - n3);
        cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        return cArray;
    }

    private char padcheck() throws NotCharacterException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length != 1) {
            throw new NotCharacterException(String.valueOf(this.chars));
        }
        return this.chars[0];
    }

    private int intcheck(int n, int n2) throws BadArgumentException {
        int n3 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException("Not a number");
        }
        int n4 = this.mant.length - 1;
        if (this.exp < 0) {
            for (n3 = this.exp + 1; n3 <= 0; ++n3) {
                if (this.mant[n4] == '0') {
                    --n4;
                    continue;
                }
                throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Non-zero decimal part in").OpCcblank(null, this)));
            }
        }
        if ((n3 = this.toint()) < n) {
            throw new BadArgumentException("Argument " + n3 + " < " + n);
        }
        if (n3 > n2) {
            throw new BadArgumentException("Argument " + n3 + " > " + n2);
        }
        return n3;
    }

    private char optioncheck(String string) throws BadArgumentException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("Null option string");
        }
        char c = this.chars[0];
        char c2 = Character.toUpperCase(c);
        if (string.indexOf(c2, 0) < 0) {
            throw new BadArgumentException("Bad Option character " + String.valueOf(c) + " [" + String.valueOf(c2) + "]");
        }
        return c2;
    }

    public Rexx abbrev(Rexx rexx) {
        return this.abbrev(rexx, new Rexx(rexx.intlength()));
    }

    public Rexx abbrev(Rexx rexx, Rexx rexx2) {
        int n = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.abbrev(this.chars, rexx.chars, n));
    }

    public Rexx abs() throws NumberFormatException {
        RexxSet rexxSet = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        rexxSet = this.mant.length > 9 ? new RexxSet(this.mant.length) : (RexxSet)null;
        if (this.ind >= 0) {
            return this.OpPlus(rexxSet);
        }
        return this.OpMinus(rexxSet);
    }

    public Rexx b2d() {
        return this.b2d(new Rexx(-1));
    }

    public Rexx b2d(Rexx rexx) {
        String string = null;
        int n = 0;
        int n2 = rexx.toint();
        if (n2 == 0) {
            return new Rexx('0');
        }
        if (n2 < 0) {
            n2 = this.intlength() + 1;
        }
        string = n2 > this.intlength() ? "0" : Rexx.toString(this.right(new Rexx(n2)).left(new Rexx(1)));
        Rexx rexx2 = this.right(new Rexx(n2), Rexx.toRexx(string));
        n = n2 % 4 != 0 ? n2 + 4 - n2 % 4 : n2;
        return rexx2.right(new Rexx(n), Rexx.toRexx(string)).b2x().x2d(new Rexx(n / 4));
    }

    public Rexx b2x() {
        int n = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("No digits");
        }
        char[] cArray = new char[(this.chars.length + 3) / 4];
        int n2 = cArray.length - 1;
        int n3 = 0;
        int n4 = 1;
        for (n = this.chars.length - 1; n >= 0; --n) {
            if (this.chars[n] != '0') {
                if (this.chars[n] == '1') {
                    n3 += n4;
                } else {
                    throw new BadArgumentException(Rexx.toString($01.OpCcblank(null, this)));
                }
            }
            if (!((n4 += n4) == 16 | n == 0)) continue;
            cArray[n2] = Hexes[n3];
            --n2;
            n3 = 0;
            n4 = 1;
        }
        return new Rexx(cArray);
    }

    public Rexx centre(Rexx rexx) {
        return this.centre(rexx, Rexx.toRexx(" "));
    }

    public Rexx centre(Rexx rexx, Rexx rexx2) {
        int n = rexx.intcheck(0, 999999999);
        char c = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.centre(this.chars, n, c));
    }

    public Rexx center(Rexx rexx) {
        return this.center(rexx, Rexx.toRexx(" "));
    }

    public Rexx center(Rexx rexx, Rexx rexx2) {
        return this.centre(rexx, rexx2);
    }

    public Rexx changestr(Rexx rexx, Rexx rexx2) {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (rexx2.chars == null) {
            rexx2.chars = rexx2.layout();
        }
        return Rexx.toRexx(RexxWords.changestr(rexx.chars, this.chars, rexx2.chars));
    }

    public int compareTo(Object object) throws ClassCastException {
        Rexx rexx = new Rexx(object.toString());
        if (this.OpLt(null, rexx)) {
            return -1;
        }
        if (this.OpGt(null, rexx)) {
            return 1;
        }
        return 0;
    }

    public Rexx compare(Rexx rexx) {
        return this.compare(rexx, Rexx.toRexx(" "));
    }

    public Rexx compare(Rexx rexx, Rexx rexx2) {
        char c = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.compare(this.chars, rexx.chars, c));
    }

    public Rexx copies(Rexx rexx) throws BadArgumentException {
        int n = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        int n2 = this.chars.length;
        char[] cArray = new char[n * n2];
        int n3 = 0;
        for (int i = n; i > 0; --i) {
            System.arraycopy(this.chars, 0, cArray, n3, n2);
            n3 += n2;
        }
        return new Rexx(cArray, true);
    }

    public synchronized Rexx copyindexed(Rexx rexx) {
        return this.copyIndexed(rexx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Rexx copyIndexed(Rexx rexx) {
        Enumeration enumeration = null;
        Rexx rexx2 = null;
        RexxNode rexxNode = null;
        if (rexx.coll == null) {
            return this;
        }
        Hashtable hashtable = rexx.coll;
        synchronized (hashtable) {
            enumeration = rexx.coll.keys();
            while (enumeration.hasMoreElements()) {
                rexx2 = (Rexx)enumeration.nextElement();
                rexxNode = (RexxNode)rexx.coll.get(rexx2);
                if (rexxNode.leaf == null || rexxNode.leaf == rexxNode.initleaf) continue;
                this.getnode((Rexx)rexx2).leaf = rexxNode.leaf;
            }
        }
        return this;
    }

    public Rexx countstr(Rexx rexx) {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.countstr(rexx.chars, this.chars));
    }

    public Rexx c2d() {
        return new Rexx((int)this.padcheck());
    }

    public Rexx c2x() {
        int n = this.padcheck();
        char[] cArray = "0000".toCharArray();
        cArray[3] = Hexes[n % 16];
        if ((n /= 16) == 0) {
            return new Rexx(cArray).right(new Rexx(1));
        }
        cArray[2] = Hexes[n % 16];
        if ((n /= 16) == 0) {
            return new Rexx(cArray).right(new Rexx(2));
        }
        cArray[1] = Hexes[n % 16];
        if ((n /= 16) == 0) {
            return new Rexx(cArray).right(new Rexx(3));
        }
        cArray[0] = Hexes[n % 16];
        return new Rexx(cArray);
    }

    public Rexx datatype(Rexx rexx) throws BadArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        RexxSet rexxSet = null;
        char c = rexx.optioncheck("ABDLMNSUWX");
        if (this.intlength() == 0) {
            n = 0;
        } else if (c == 'A') {
            n = this.verify(Rexx.toRexx("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789")).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'B') {
            n = this.verify(Rexx.toRexx("01")).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'D') {
            n = this.verify(Rexx.toRexx(Digits09)).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'L') {
            n = this.verify(Rexx.toRexx(Lowers)).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'M') {
            n = this.verify(Rexx.toRexx("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'N') {
            n = this.ind != -2 ? 1 : 0;
        } else if (c == 'S') {
            n = 0;
            if (!Character.isJavaIdentifierStart(this.left(new Rexx(1)).tochar())) {
                return new Rexx(0);
            }
            int n4 = n2 = this.chars.length;
            for (n3 = 2; n3 <= n4; ++n3) {
                if (Character.isJavaIdentifierPart(this.substr(new Rexx(n3), new Rexx(1)).tochar())) continue;
                return new Rexx(0);
            }
            n = 1;
        } else if (c == 'U') {
            n = this.verify(Rexx.toRexx(Uppers)).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'W') {
            if (this.ind == -2) {
                n = 0;
            } else {
                rexxSet = this.mant.length > 9 ? new RexxSet(this.mant.length) : (RexxSet)null;
                n = this.OpDiv(rexxSet, new Rexx('1')).pos(new Rexx('.')).OpEqS(null, $02) ? 1 : 0;
            }
        } else if (c == 'X') {
            n = this.verify(Rexx.toRexx(Hexes)).OpEqS(null, $02) ? 1 : 0;
        } else {
            throw new NoOtherwiseException();
        }
        return new Rexx(n);
    }

    public Rexx delstr(Rexx rexx) throws BadArgumentException {
        return this.delstr(rexx, new Rexx(this.intlength()));
    }

    public Rexx delstr(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = rexx.intcheck(1, 999999999);
        int n2 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.delstr(this.chars, n, n2));
    }

    public Rexx delword(Rexx rexx) throws BadArgumentException {
        return this.delword(rexx, new Rexx(this.intwords()));
    }

    public Rexx delword(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = rexx.intcheck(1, 999999999);
        int n2 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.delword(this.chars, n, n2));
    }

    public Rexx d2b() {
        return this.d2b(Rexx.toRexx("zip"));
    }

    public Rexx d2b(Rexx rexx) {
        int n = 0;
        int n2 = 0;
        if (rexx.OpEqS(null, Rexx.toRexx("0"))) {
            return Rexx.toRexx("");
        }
        n = rexx.OpEqS(null, Rexx.toRexx("zip")) ? this.d2x().length().toint() * 4 : rexx.toint();
        n2 = n % 4 != 0 ? n + 4 - n % 4 : n;
        if (rexx.OpEqS(null, Rexx.toRexx("zip"))) {
            if (this.d2x(new Rexx(n2 / 4)).x2b().strip(new Rexx('l'), new Rexx('0')).OpEqS(null, $03)) {
                return new Rexx('0');
            }
            return this.d2x(new Rexx(n2 / 4)).x2b().strip(new Rexx('l'), new Rexx('0'));
        }
        return this.d2x(new Rexx(n2 / 4)).x2b().right(new Rexx(n));
    }

    public Rexx d2c() {
        int n = this.toint();
        if (n < 0 | n > 65535) {
            throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Encoding bad").OpCcblank(null, this)));
        }
        return new Rexx((char)n);
    }

    public Rexx d2x(Rexx rexx) throws BadArgumentException, NumberFormatException {
        int n = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.d2x(this, n));
    }

    public Rexx d2x() throws BadArgumentException, NumberFormatException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.d2x(this, -1));
    }

    public Rexx exists(Rexx rexx) {
        return new Rexx(this.testnode(rexx));
    }

    public Rexx format() throws BadArgumentException, NumberFormatException {
        return this.format(null, null, null, null, null);
    }

    public Rexx format(Rexx rexx) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, null, null, null, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, rexx2, null, null, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, rexx2, rexx3, null, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, rexx2, rexx3, rexx4, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4, Rexx rexx5) throws BadArgumentException, NumberFormatException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        n = rexx == null ? -1 : rexx.intcheck(1, 999999999);
        n2 = rexx2 == null ? -1 : rexx2.intcheck(0, 999999999);
        n3 = rexx3 == null ? -1 : rexx3.intcheck(1, 999999999);
        n4 = rexx4 == null ? -1 : rexx4.intcheck(0, 999999999);
        string = rexx5 == null ? "S" : String.valueOf(rexx5.optioncheck("SE"));
        return new Rexx(RexxUtil.format(this, n, n2, n3, n4, Rexx.tochar(string)), true);
    }

    public Rexx insert(Rexx rexx) throws BadArgumentException {
        return this.insert(rexx, new Rexx(0), new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx insert(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        return this.insert(rexx, rexx2, new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx insert(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException {
        return this.insert(rexx, rexx2, rexx3, Rexx.toRexx(" "));
    }

    public Rexx insert(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) throws BadArgumentException {
        int n = rexx2.intcheck(0, 999999999);
        int n2 = rexx3.intcheck(0, 999999999);
        char c = rexx4.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.insert(this.chars, rexx.chars, n, n2, c), true);
    }

    public Rexx lastpos(Rexx rexx) throws BadArgumentException {
        int n = this.intlength();
        if (n == 0) {
            n = 1;
        }
        return this.lastpos(rexx, new Rexx(n));
    }

    public Rexx lastpos(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = rexx2.intcheck(1, 999999999) - 1;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (n4 >= this.chars.length) {
            n4 = this.chars.length - 1;
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if ((n = rexx.chars.length) == 0) {
            return new Rexx(0);
        }
        block0: for (n2 = n4 = n4 - n + 1; n2 >= 0; --n2) {
            int n5 = n - 1;
            for (n3 = 0; n3 <= n5; ++n3) {
                if (rexx.chars[n3] != this.chars[n2 + n3]) continue block0;
            }
            return new Rexx(n2 + 1);
        }
        return new Rexx(0);
    }

    public Rexx left(Rexx rexx) {
        return this.left(rexx, Rexx.toRexx(" "));
    }

    public Rexx left(Rexx rexx, Rexx rexx2) {
        return this.substr(new Rexx(1), rexx, rexx2);
    }

    public Rexx length() {
        return new Rexx(this.intlength());
    }

    public Rexx lower() throws BadArgumentException {
        return this.lower(new Rexx(1), this.length());
    }

    public Rexx lower(Rexx rexx) throws BadArgumentException {
        return this.lower(rexx, this.length());
    }

    public Rexx lower(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = rexx.intcheck(1, 999999999) - 1;
        int n4 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length) == 0) {
            return new Rexx("");
        }
        char[] cArray = new char[n];
        if (n4 < n | n3 > 0) {
            System.arraycopy(this.chars, 0, cArray, 0, n);
        }
        int n5 = n - 1;
        int n6 = n4;
        for (n2 = n3; n2 <= n5 && n6 > 0; --n6, ++n2) {
            cArray[n2] = Character.toLowerCase(this.chars[n2]);
        }
        return new Rexx(cArray, true);
    }

    public Rexx max(Rexx rexx) throws NumberFormatException {
        Rexx rexx2 = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        int n = 9;
        if (this.mant.length > n) {
            n = this.mant.length;
        }
        if (rexx.mant.length > n) {
            n = rexx.mant.length;
        }
        rexx2 = this.docompare(new RexxSet(n), rexx) < 0 ? rexx : this;
        n = 9;
        if (rexx2.mant.length > n) {
            n = rexx2.mant.length;
        }
        return rexx2.OpPlus(new RexxSet(n));
    }

    public Rexx min(Rexx rexx) throws NumberFormatException {
        Rexx rexx2 = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        int n = 9;
        if (this.mant.length > n) {
            n = this.mant.length;
        }
        if (rexx.mant.length > n) {
            n = rexx.mant.length;
        }
        rexx2 = this.docompare(new RexxSet(n), rexx) > 0 ? rexx : this;
        n = 9;
        if (rexx2.mant.length > n) {
            n = rexx2.mant.length;
        }
        return rexx2.OpPlus(new RexxSet(n));
    }

    public Rexx overlay(Rexx rexx) throws BadArgumentException {
        return this.overlay(rexx, new Rexx(1), new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx overlay(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        return this.overlay(rexx, rexx2, new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx overlay(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException {
        return this.overlay(rexx, rexx2, rexx3, Rexx.toRexx(" "));
    }

    public Rexx overlay(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) throws BadArgumentException {
        int n = rexx2.intcheck(1, 999999999);
        int n2 = rexx3.intcheck(0, 999999999);
        char c = rexx4.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.overlay(this.chars, rexx.chars, n, n2, c), true);
    }

    public Rexx pos(Rexx rexx) throws BadArgumentException {
        return this.pos(rexx, new Rexx(1));
    }

    public Rexx pos(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = rexx2.intcheck(1, 999999999) - 1;
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (rexx.chars.length == 0) {
            return new Rexx(0);
        }
        if (this.chars == null) {
            this.chars = this.layout();
        }
        int n4 = this.chars.length - rexx.chars.length;
        block0: for (n = n3; n <= n4; ++n) {
            int n5 = rexx.chars.length - 1;
            for (n2 = 0; n2 <= n5; ++n2) {
                if (rexx.chars[n2] != this.chars[n + n2]) continue block0;
            }
            return new Rexx(n + 1);
        }
        return new Rexx(0);
    }

    public Rexx reverse() {
        int n;
        int n2 = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length) == 0) {
            return new Rexx("");
        }
        char[] cArray = new char[n];
        int n3 = n - 1;
        for (n2 = 0; n2 <= n3; ++n2) {
            cArray[n2] = this.chars[--n];
        }
        return new Rexx(cArray, true);
    }

    public Rexx right(Rexx rexx) throws NotCharacterException, BadArgumentException {
        return this.right(rexx, Rexx.toRexx(" "));
    }

    public Rexx right(Rexx rexx, Rexx rexx2) throws NotCharacterException, BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length - n3) >= 0) {
            return this.substr(new Rexx(n + 1));
        }
        char c = rexx2.padcheck();
        char[] cArray = new char[n3];
        int n4 = -n - 1;
        for (n2 = 0; n2 <= n4; ++n2) {
            cArray[n2] = c;
        }
        System.arraycopy(this.chars, 0, cArray, n2, cArray.length - n2);
        return new Rexx(cArray, true);
    }

    public Rexx sequence(Rexx rexx) throws BadArgumentException, NotCharacterException {
        char c;
        int n = 0;
        char c2 = this.padcheck();
        char c3 = rexx.padcheck();
        int n2 = c3 - (c = c2) + 1;
        if (n2 <= 0) {
            throw new BadArgumentException("final<start");
        }
        char[] cArray = new char[n2];
        int n3 = n2 - 1;
        for (n = 0; n <= n3; ++n) {
            cArray[n] = (char)(n + c);
        }
        return new Rexx(cArray, true);
    }

    public Rexx sign() throws NumberFormatException {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        return new Rexx(this.ind);
    }

    public Rexx soundex() {
        int n = 0;
        Rexx rexx = null;
        int n2 = 0;
        Rexx rexx2 = null;
        Rexx rexx3 = this.upper();
        String string = "AEIOUYHWBFPVCGJKQSXZDTLMNR";
        String string2 = "@@@@@@**111122222222334556";
        Rexx rexx4 = new Rexx("");
        int n3 = this.intlength();
        n = 1;
        while (n3 > 0) {
            rexx = rexx3.substr(new Rexx(n), new Rexx(1));
            if (rexx.datatype(new Rexx('M')).toboolean()) {
                rexx4 = rexx4.OpCc(null, rexx);
            }
            --n3;
            ++n;
        }
        Rexx rexx5 = rexx4.strip().left(new Rexx(1));
        rexx4 = rexx4.translate(Rexx.toRexx(string2), Rexx.toRexx(string));
        Rexx rexx6 = rexx5.translate(Rexx.toRexx(string2), Rexx.toRexx(string));
        n3 = rexx4.length().toint();
        for (n2 = 2; n2 <= n3; ++n2) {
            rexx2 = rexx4.substr(new Rexx(n2), new Rexx(1));
            if (new Rexx(rexx2.OpNotEqS(null, rexx6)).OpAnd(null, rexx2.datatype(new Rexx('W')))) {
                rexx5 = rexx5.OpCc(null, rexx2);
                rexx6 = rexx2;
                continue;
            }
            if (!rexx2.OpEqS(null, $04)) continue;
            rexx6 = rexx2;
        }
        return rexx5.left(new Rexx(4), new Rexx(0));
    }

    public Rexx space() {
        return this.space(new Rexx(1), Rexx.toRexx(" "));
    }

    public Rexx space(Rexx rexx) {
        return this.space(rexx, Rexx.toRexx(" "));
    }

    public Rexx space(Rexx rexx, Rexx rexx2) {
        int n = rexx.intcheck(0, 999999999);
        char c = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.space(this.chars, n, c));
    }

    public Rexx strip() throws BadArgumentException {
        return this.strip(Rexx.toRexx("B"), Rexx.toRexx(" "));
    }

    public Rexx strip(Rexx rexx) throws BadArgumentException {
        return this.strip(rexx, Rexx.toRexx(" "));
    }

    public Rexx strip(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = 0;
        int n2 = 0;
        char c = rexx.optioncheck("BLT");
        char c2 = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            return new Rexx("");
        }
        if (c == 'T') {
            n = 0;
        } else {
            int n3 = this.chars.length - 1;
            for (n = 0; n <= n3 && this.chars[n] == c2; ++n) {
            }
            if (n == this.chars.length) {
                return new Rexx("");
            }
        }
        if (c == 'L') {
            n2 = this.chars.length - 1;
        } else {
            for (n2 = this.chars.length - 1; n2 >= 0 && this.chars[n2] == c2; --n2) {
            }
            if (n2 < 0) {
                return new Rexx("");
            }
        }
        if (n == 0 && n2 == this.chars.length - 1) {
            return new Rexx(this);
        }
        int n4 = n2 - n + 1;
        char[] cArray = new char[n4];
        System.arraycopy(this.chars, n, cArray, 0, n4);
        return new Rexx(cArray, true);
    }

    public Rexx substr(Rexx rexx) throws NotCharacterException, BadArgumentException {
        return this.substr(rexx, new Rexx(this.intlength() + 1 - rexx.toint()).max(new Rexx(0)), Rexx.toRexx(" "));
    }

    public Rexx substr(Rexx rexx, Rexx rexx2) throws NotCharacterException, BadArgumentException {
        return this.substr(rexx, rexx2, Rexx.toRexx(" "));
    }

    public Rexx substr(Rexx rexx, Rexx rexx2, Rexx rexx3) throws NotCharacterException, BadArgumentException {
        int n = 0;
        int n2 = rexx.intcheck(1, 999999999) - 1;
        int n3 = rexx2.intcheck(0, 999999999);
        char c = rexx3.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        int n4 = this.chars.length;
        char[] cArray = new char[n3];
        if (n2 + n3 <= n4) {
            System.arraycopy(this.chars, n2, cArray, 0, n3);
        } else {
            if (n2 < n4) {
                System.arraycopy(this.chars, n2, cArray, 0, n4 - n2);
            } else {
                n2 = n4;
            }
            int n5 = n3 - 1;
            for (n = n4 - n2; n <= n5; ++n) {
                cArray[n] = c;
            }
        }
        return new Rexx(cArray, true);
    }

    public Rexx subword(Rexx rexx) {
        return this.subword(rexx, this.length());
    }

    public Rexx subword(Rexx rexx, Rexx rexx2) {
        int n = rexx.intcheck(1, 999999999);
        int n2 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.subword(this.chars, n, n2));
    }

    public Rexx translate(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        return this.translate(rexx, rexx2, Rexx.toRexx(" "));
    }

    public Rexx translate(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException {
        char c = rexx3.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (rexx2.chars == null) {
            rexx2.chars = rexx2.layout();
        }
        return Rexx.toRexx(RexxUtil.translate(this.chars, rexx.chars, rexx2.chars, c));
    }

    public Rexx trunc() throws BadArgumentException, NumberFormatException {
        return this.trunc(new Rexx(0));
    }

    public Rexx trunc(Rexx rexx) throws BadArgumentException, NumberFormatException {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        int n = rexx.intcheck(0, 999999999);
        return new Rexx(RexxUtil.trunc(this, n));
    }

    public Rexx upper() throws BadArgumentException {
        return this.upper(new Rexx(1), this.length());
    }

    public Rexx upper(Rexx rexx) throws BadArgumentException {
        return this.upper(rexx, this.length());
    }

    public Rexx upper(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = rexx.intcheck(1, 999999999) - 1;
        int n4 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length) == 0) {
            return new Rexx("");
        }
        char[] cArray = new char[n];
        if (n4 < n | n3 > 0) {
            System.arraycopy(this.chars, 0, cArray, 0, n);
        }
        int n5 = n - 1;
        int n6 = n4;
        for (n2 = n3; n2 <= n5 && n6 > 0; --n6, ++n2) {
            cArray[n2] = Character.toUpperCase(this.chars[n2]);
        }
        return new Rexx(cArray, true);
    }

    public Rexx verify(Rexx rexx) {
        return this.verify(rexx, Rexx.toRexx("N"), new Rexx(1));
    }

    public Rexx verify(Rexx rexx, Rexx rexx2) {
        return this.verify(rexx, rexx2, new Rexx(1));
    }

    public Rexx verify(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        char c = rexx2.optioncheck("NM");
        int n = rexx3.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (c == 'N') {
            return new Rexx(RexxWords.verifyn(this.chars, rexx.chars, n));
        }
        return new Rexx(RexxWords.verifym(this.chars, rexx.chars, n));
    }

    public Rexx word(Rexx rexx) {
        return this.subword(rexx, new Rexx(1));
    }

    public Rexx wordindex(Rexx rexx) {
        int n = rexx.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new Rexx(RexxWords.wordindex(this.chars, n));
    }

    public Rexx wordlength(Rexx rexx) {
        int n = rexx.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new Rexx(RexxWords.wordlength(this.chars, n));
    }

    public Rexx wordpos(Rexx rexx) {
        return this.wordpos(rexx, new Rexx(1));
    }

    public Rexx wordpos(Rexx rexx, Rexx rexx2) {
        int n = rexx2.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.wordpos(rexx.chars, this.chars, n));
    }

    public Rexx words() {
        return new Rexx(this.intwords());
    }

    public Rexx x2b() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("No digits");
        }
        return new Rexx(RexxUtil.x2b(this));
    }

    public Rexx x2c() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("No digits");
        }
        return new Rexx(RexxUtil.x2c(this));
    }

    public Rexx x2d(Rexx rexx) throws BadArgumentException {
        int n = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.x2d(this, n));
    }

    public Rexx x2d() throws BadArgumentException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.x2d(this, -1));
    }

    @Override
    public Rexx OpCc(RexxSet rexxSet, Rexx rexx) {
        return this.concat(rexxSet, rexx, 0);
    }

    @Override
    public Rexx OpCcblank(RexxSet rexxSet, Rexx rexx) {
        return this.concat(rexxSet, rexx, 1);
    }

    @Override
    public boolean OpEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) == 0;
    }

    @Override
    public boolean OpNotEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) != 0;
    }

    @Override
    public boolean OpLt(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) < 0;
    }

    @Override
    public boolean OpGt(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) > 0;
    }

    @Override
    public boolean OpLtEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) <= 0;
    }

    @Override
    public boolean OpGtEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) >= 0;
    }

    @Override
    public boolean OpEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) == 0;
    }

    @Override
    public boolean OpNotEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) != 0;
    }

    @Override
    public boolean OpLtS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) < 0;
    }

    @Override
    public boolean OpGtS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) > 0;
    }

    @Override
    public boolean OpLtEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) <= 0;
    }

    @Override
    public boolean OpGtEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) >= 0;
    }

    @Override
    public boolean OpOr(RexxSet rexxSet, Rexx rexx) {
        return this.toboolean() | rexx.toboolean();
    }

    @Override
    public boolean OpAnd(RexxSet rexxSet, Rexx rexx) {
        return this.toboolean() & rexx.toboolean();
    }

    @Override
    public boolean OpXor(RexxSet rexxSet, Rexx rexx) {
        return this.toboolean() ^ rexx.toboolean();
    }

    @Override
    public boolean OpNot(RexxSet rexxSet) {
        return !this.toboolean();
    }

    @Override
    public Rexx OpMinus(RexxSet rexxSet) {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        Rexx rexx = new Rexx(this);
        rexx.ind = -rexx.ind;
        rexx.chars = null;
        if (rexxSet == null) {
            rexx.dig = 9;
            rexx.form = 0;
        } else {
            rexx.dig = rexxSet.digits;
            rexx.form = rexxSet.form;
        }
        return rexx.finish(rexx.dig, false);
    }

    @Override
    public Rexx OpPlus(RexxSet rexxSet) {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        Rexx rexx = new Rexx(this);
        rexx.chars = null;
        if (rexxSet == null) {
            rexx.dig = 9;
            rexx.form = 0;
        } else {
            rexx.dig = rexxSet.digits;
            rexx.form = rexxSet.form;
        }
        return rexx.finish(rexx.dig, false);
    }

    @Override
    public Rexx OpSub(RexxSet rexxSet, Rexx rexx) {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        Rexx rexx2 = new Rexx(rexx);
        rexx2.ind = -rexx2.ind;
        return this.OpAdd(rexxSet, rexx2);
    }

    @Override
    public Rexx OpAdd(RexxSet rexxSet, Rexx rexx) {
        int n;
        int n2 = 0;
        byte by = 0;
        Rexx rexx2 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char[] cArray3 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        char[] cArray4 = null;
        Rexx rexx3 = this;
        if (rexx3.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx3.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        if (rexxSet == null) {
            n2 = 9;
            by = 0;
        } else {
            n2 = rexxSet.digits;
            by = rexxSet.form;
        }
        if (rexx3.ind == 0) {
            rexx2 = new Rexx(rexx);
            rexx2.chars = null;
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        if (rexx.ind == 0) {
            rexx2 = new Rexx(rexx3);
            rexx2.chars = null;
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        if (rexx3.mant.length > n2 + 1) {
            rexx3 = new Rexx(rexx3);
            rexx3.cut(n2);
        }
        if (rexx.mant.length > n2 + 1) {
            rexx = new Rexx(rexx);
            rexx.cut(n2);
        }
        rexx2 = new Rexx();
        rexx2.dig = n2;
        rexx2.form = by;
        if (rexx3.exp == rexx.exp) {
            cArray = rexx3.mant;
            cArray2 = rexx.mant;
            rexx2.exp = rexx3.exp;
        } else if (rexx3.exp > rexx.exp) {
            n3 = rexx3.mant.length + rexx3.exp - rexx.exp;
            if (n3 > rexx.mant.length + n2 + 1) {
                rexx2.mant = rexx3.mant;
                rexx2.exp = rexx3.exp;
                rexx2.ind = rexx3.ind;
                if (rexx2.mant.length < n2) {
                    rexx2.mant = new char[n2];
                    System.arraycopy(rexx3.mant, 0, rexx2.mant, 0, rexx3.mant.length);
                    int n12 = n2 - 1;
                    for (n4 = rexx3.mant.length; n4 <= n12; ++n4) {
                        rexx2.mant[n4] = 48;
                    }
                    rexx2.exp -= n2 - rexx3.mant.length;
                }
                return rexx2.finish(n2, false);
            }
            rexx2.exp = rexx.exp;
            if (n3 > n2 + 1) {
                n5 = n3 - n2 - 1;
                cArray2 = new char[rexx.mant.length - n5];
                System.arraycopy(rexx.mant, 0, cArray2, 0, cArray2.length);
                rexx2.exp += n5;
                n3 = n2 + 1;
            } else {
                cArray2 = rexx.mant;
            }
            if (n3 > rexx3.mant.length) {
                cArray = new char[n3];
                System.arraycopy(rexx3.mant, 0, cArray, 0, rexx3.mant.length);
                n = n3 - 1;
                for (n4 = rexx3.mant.length; n4 <= n; ++n4) {
                    cArray[n4] = 48;
                }
            } else {
                cArray = rexx3.mant;
            }
        } else {
            n3 = rexx.mant.length + rexx.exp - rexx3.exp;
            if (n3 > rexx3.mant.length + n2 + 1) {
                rexx2.mant = rexx.mant;
                rexx2.exp = rexx.exp;
                rexx2.ind = rexx.ind;
                if (rexx2.mant.length < n2) {
                    rexx2.mant = new char[n2];
                    System.arraycopy(rexx.mant, 0, rexx2.mant, 0, rexx.mant.length);
                    int n13 = n2 - 1;
                    for (n4 = rexx.mant.length; n4 <= n13; ++n4) {
                        rexx2.mant[n4] = 48;
                    }
                    rexx2.exp -= n2 - rexx.mant.length;
                }
                return rexx2.finish(n2, false);
            }
            rexx2.exp = rexx3.exp;
            if (n3 > n2 + 1) {
                n5 = n3 - n2 - 1;
                cArray = new char[rexx3.mant.length - n5];
                System.arraycopy(rexx3.mant, 0, cArray, 0, cArray.length);
                rexx2.exp += n5;
                n3 = n2 + 1;
            } else {
                cArray = rexx3.mant;
            }
            if (n3 > rexx.mant.length) {
                cArray2 = new char[n3];
                System.arraycopy(rexx.mant, 0, cArray2, 0, rexx.mant.length);
                n = n3 - 1;
                for (n4 = rexx.mant.length; n4 <= n; ++n4) {
                    cArray2[n4] = 48;
                }
            } else {
                cArray2 = rexx.mant;
            }
        }
        if (rexx3.ind == rexx.ind) {
            rexx2.mant = Rexx.charaddsub(cArray, cArray2, 1);
            rexx2.ind = rexx3.ind;
            return rexx2.finish(n2, false);
        }
        rexx2.ind = rexx3.ind;
        if (cArray.length <= cArray2.length) {
            if (cArray.length < cArray2.length) {
                cArray3 = cArray;
                cArray = cArray2;
                cArray2 = cArray3;
                rexx2.ind = -rexx2.ind;
            } else {
                n6 = 0;
                n7 = 0;
                n8 = cArray.length - 1;
                n9 = cArray2.length - 1;
                while (true) {
                    if (n6 <= n8) {
                        n10 = cArray[n6];
                    } else {
                        if (n7 > n9) {
                            rexx2.mant = new char[1];
                            rexx2.mant[0] = 48;
                            rexx2.ind = 0;
                            rexx2.exp = 0;
                            return rexx2;
                        }
                        n10 = 48;
                    }
                    n11 = n7 <= n9 ? cArray2[n7] : 48;
                    if (n10 != n11) {
                        if (n10 >= n11) break;
                        cArray3 = cArray;
                        cArray = cArray2;
                        cArray2 = cArray3;
                        rexx2.ind = -rexx2.ind;
                        break;
                    }
                    ++n6;
                    ++n7;
                }
            }
        }
        rexx2.mant = Rexx.charaddsub(cArray, cArray2, -1);
        if (rexx2.mant.length > n2) {
            rexx2.round(n2);
        }
        if (rexx2.mant[0] == '0') {
            n = rexx2.mant.length;
            for (n4 = 1; n4 <= n; ++n4) {
                if (n4 == rexx2.mant.length) {
                    rexx2.mant = new char[1];
                    rexx2.mant[0] = 48;
                    rexx2.ind = 0;
                    rexx2.exp = 0;
                    return rexx2;
                }
                if (rexx2.mant[n4] == '0') continue;
                cArray4 = new char[rexx2.mant.length - n4];
                System.arraycopy(rexx2.mant, n4, cArray4, 0, rexx2.mant.length - n4);
                rexx2.mant = cArray4;
                break;
            }
        }
        return rexx2;
    }

    @Override
    public Rexx OpMult(RexxSet rexxSet, Rexx rexx) {
        int n = 0;
        byte by = 0;
        char[] cArray = null;
        char[] cArray2 = null;
        int n2 = 0;
        int n3 = 0;
        char[] cArray3 = null;
        Rexx rexx2 = this;
        if (rexx2.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx2.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        if (rexxSet == null) {
            n = 9;
            by = 0;
        } else {
            n = rexxSet.digits;
            by = rexxSet.form;
        }
        if (rexx2.mant.length > n + 1) {
            rexx2 = new Rexx(rexx2);
            rexx2.cut(n);
        }
        if (rexx.mant.length > n + 1) {
            rexx = new Rexx(rexx);
            rexx.cut(n);
        }
        Rexx rexx3 = new Rexx();
        rexx3.dig = n;
        rexx3.form = by;
        rexx3.ind = (byte)(rexx2.ind * rexx.ind);
        rexx3.exp = rexx2.exp + rexx.exp;
        if (rexx2.mant.length < rexx.mant.length) {
            cArray = rexx2.mant;
            cArray2 = rexx.mant;
        } else {
            cArray = rexx.mant;
            cArray2 = rexx2.mant;
        }
        char[] cArray4 = new char[]{'0'};
        for (n2 = cArray.length - 1; n2 >= 0; --n2) {
            n3 = cArray[n2] - 48;
            if (n3 > 0) {
                cArray4 = Rexx.charaddsub(cArray4, cArray2, n3);
            }
            if (n2 == 0) break;
            cArray3 = new char[cArray2.length + 1];
            System.arraycopy(cArray2, 0, cArray3, 0, cArray2.length);
            cArray3[cArray2.length] = 48;
            cArray2 = cArray3;
        }
        rexx3.mant = cArray4;
        return rexx3.finish(n, false);
    }

    @Override
    public Rexx OpDiv(RexxSet rexxSet, Rexx rexx) {
        return this.dodivide('D', rexxSet, rexx);
    }

    @Override
    public Rexx OpDivI(RexxSet rexxSet, Rexx rexx) {
        return this.dodivide('I', rexxSet, rexx);
    }

    @Override
    public Rexx OpRem(RexxSet rexxSet, Rexx rexx) {
        return this.dodivide('R', rexxSet, rexx);
    }

    @Override
    public Rexx OpPow(RexxSet rexxSet, Rexx rexx) {
        int n = 0;
        int n2 = 0;
        RexxSet rexxSet2 = null;
        int n3 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        n = rexxSet == null ? 9 : rexxSet.digits;
        if (rexx.mant.length > n) {
            rexx = new Rexx(rexx);
            rexx.round(n);
        }
        if (rexx.mant.length + rexx.exp > n) {
            throw new BadArgumentException("Too many digits: " + rexx.toString());
        }
        int n4 = rexx.intcheck(-999999999, 999999999);
        Rexx rexx2 = this;
        if (rexx2.mant.length > n + 1) {
            rexx2 = new Rexx(rexx2);
            rexx2.cut(n);
        }
        Rexx rexx3 = new Rexx(1);
        n2 = rexx.exp == 0 ? rexx.mant.length : new Rexx(n4).length().toint();
        rexxSet2 = rexxSet == null ? new RexxSet(9 + n2 + 1) : new RexxSet(rexxSet.digits + n2 + 1, rexxSet.form);
        Rexx rexx4 = rexx3;
        if (n4 == 0) {
            return rexx4;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        boolean bl = false;
        n3 = 1;
        while (true) {
            if ((n4 += n4) < 0) {
                bl = true;
                rexx4 = rexx4.OpMult(rexxSet2, rexx2);
            }
            if (n3 == 31) break;
            if (bl) {
                rexx4 = rexx4.OpMult(rexxSet2, rexx4);
            }
            ++n3;
        }
        if (rexx.ind < 0) {
            rexx4 = rexx3.OpDiv(rexxSet2, rexx4);
        }
        return rexx4.OpDiv(rexxSet, rexx3);
    }

    private final Rexx dodivide(char c, RexxSet rexxSet, Rexx rexx) throws NumberFormatException, DivideException {
        int n;
        int n2 = 0;
        byte by = 0;
        Rexx rexx2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        if (rexx.ind == 0) {
            throw new DivideException("Divide by 0");
        }
        if (rexxSet == null) {
            n2 = 9;
            by = 0;
        } else {
            n2 = rexxSet.digits;
            by = rexxSet.form;
        }
        Rexx rexx3 = this;
        if (rexx3.ind == 0) {
            return new Rexx(0);
        }
        if (rexx3.mant.length > n2 + 1) {
            rexx3 = new Rexx(rexx3);
            rexx3.cut(n2);
        }
        if (rexx.mant.length > n2 + 1) {
            rexx = new Rexx(rexx);
            rexx.cut(n2);
        }
        if ((n = rexx3.exp - rexx.exp + rexx3.mant.length - rexx.mant.length) < 0 && c != 'D') {
            if (c == 'I') {
                return new Rexx(0);
            }
            rexx2 = new Rexx(rexx3);
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        rexx2 = new Rexx();
        rexx2.ind = (byte)(rexx3.ind * rexx.ind);
        rexx2.exp = n;
        rexx2.dig = n2;
        rexx2.form = by;
        rexx2.mant = new char[n2 + 1];
        int n9 = n2 + n2 + 1;
        char[] cArray5 = new char[n9];
        System.arraycopy(rexx3.mant, 0, cArray5, 0, rexx3.mant.length);
        int n10 = n9 - 1;
        for (n3 = rexx3.mant.length; n3 <= n10; ++n3) {
            cArray5[n3] = 48;
        }
        char[] cArray6 = new char[n9];
        System.arraycopy(rexx.mant, 0, cArray6, 0, rexx.mant.length);
        n10 = n9 - 1;
        for (n3 = rexx.mant.length; n3 <= n10; ++n3) {
            cArray6[n3] = 48;
        }
        int n11 = (cArray6[0] - 48) * 10 + cArray6[1] - 48 + 1;
        int n12 = 0;
        block2: while (true) {
            n4 = 0;
            block3: while (cArray5.length >= cArray6.length) {
                if (cArray5.length == cArray6.length) {
                    block31: {
                        n10 = cArray5.length - 1;
                        for (n3 = 0; n3 <= n10; ++n3) {
                            if (cArray5[n3] < cArray6[n3]) break block3;
                            if (cArray5[n3] <= cArray6[n3]) {
                                continue;
                            }
                            break block31;
                        }
                        if (c != 'R') {
                            rexx2.mant[n12] = (char)(++n4 + 48);
                            ++n12;
                            break block2;
                        }
                    }
                    n5 = cArray5[0] - 48;
                } else {
                    n5 = (cArray5[0] - 48) * 10;
                    if (cArray5.length > 1) {
                        n5 = n5 + cArray5[1] - 48;
                    }
                }
                n6 = n5 * 10 / n11;
                if (n6 == 0) {
                    n6 = 1;
                }
                n4 += n6;
                if ((cArray5 = Rexx.charaddsub(cArray5, cArray6, -n6))[0] != '0') continue;
                n7 = cArray5.length;
                n10 = n7 - 2;
                for (n8 = 0; n8 <= n10 && cArray5[n8] == '0'; ++n8) {
                    --n7;
                }
                cArray = new char[n7];
                System.arraycopy(cArray5, n8, cArray, 0, n7);
                cArray5 = cArray;
            }
            if (n12 != 0 | n4 != 0) {
                rexx2.mant[n12] = (char)(n4 + 48);
                if (++n12 == n2 + 1 || cArray5[0] == '0') break;
            }
            if (c != 'D' && rexx2.exp <= 0) break;
            --rexx2.exp;
            cArray2 = new char[cArray6.length - 1];
            System.arraycopy(cArray6, 0, cArray2, 0, cArray6.length - 1);
            cArray6 = cArray2;
        }
        if (c == 'I' | c == 'R' && n12 + rexx2.exp > n2) {
            throw new DivideException("Integer overflow");
        }
        if (c != 'R') {
            if (n12 == 0) {
                return new Rexx(0);
            }
            if (n12 == rexx2.mant.length) {
                rexx2.round(n2);
                n12 = n2;
            }
            cArray3 = new char[n12];
            System.arraycopy(rexx2.mant, 0, cArray3, 0, n12);
            rexx2.mant = cArray3;
            return rexx2.finish(n2, true);
        }
        if (n12 == 0) {
            rexx2 = new Rexx(rexx3);
            rexx2.chars = null;
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        if (cArray5[0] == '0') {
            return new Rexx(0);
        }
        rexx2.ind = rexx3.ind;
        int n13 = n2 + n2 + 1 - rexx3.mant.length;
        rexx2.exp = rexx2.exp - n13 + rexx3.exp;
        n7 = cArray5.length;
        for (n3 = n7 - 1; n3 >= 1 && rexx2.exp < rexx3.exp & rexx2.exp < rexx.exp && cArray5[n3] == '0'; --n3) {
            --n7;
            ++rexx2.exp;
        }
        if (n7 < cArray5.length) {
            cArray4 = new char[n7];
            System.arraycopy(cArray5, 0, cArray4, 0, n7);
            cArray5 = cArray4;
        }
        rexx2.mant = cArray5;
        return rexx2.finish(n2, false);
    }

    private void cut(int n) {
        int n2 = this.mant.length - n - 1;
        if (n2 <= 0) {
            return;
        }
        this.exp += n2;
        char[] cArray = new char[n + 1];
        System.arraycopy(this.mant, 0, cArray, 0, n + 1);
        this.mant = cArray;
        this.chars = null;
    }

    private void round(int n) {
        char[] cArray = null;
        int n2 = this.mant.length - n;
        if (n2 <= 0) {
            return;
        }
        this.exp += n2;
        if (n2 > 1) {
            cArray = new char[n + 1];
            System.arraycopy(this.mant, 0, cArray, 0, n + 1);
        } else {
            cArray = this.mant;
        }
        char[] cArray2 = new char[]{'5'};
        char[] cArray3 = Rexx.charaddsub(cArray, cArray2, 1);
        if (cArray3.length > n + 1) {
            ++this.exp;
        }
        char[] cArray4 = new char[n];
        System.arraycopy(cArray3, 0, cArray4, 0, n);
        this.mant = cArray4;
        this.chars = null;
    }

    private static char[] charaddsub(char[] cArray, char[] cArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray2.length - 1;
        int n5 = cArray.length - 1;
        int n6 = n5;
        if (n4 > n6) {
            n6 = n4;
        }
        char[] cArray3 = new char[n6 + 1];
        int n7 = 0;
        for (n2 = n6; n2 >= 0; --n2) {
            n3 = n7;
            if (n5 >= 0) {
                n3 = n3 + cArray[n5] - 48;
                --n5;
            }
            if (n4 >= 0) {
                n3 += (cArray2[n4] - 48) * n;
                --n4;
            }
            if (n3 < 0) {
                n7 = (n3 += 100) / 10 - 10;
                cArray3[n2] = (char)(n3 % 10 + 48);
                continue;
            }
            if (n3 > 9) {
                n7 = n3 / 10;
                cArray3[n2] = (char)(n3 % 10 + 48);
                continue;
            }
            n7 = 0;
            cArray3[n2] = (char)(n3 + 48);
        }
        if (n7 == 0) {
            return cArray3;
        }
        char[] cArray4 = new char[n6 + 2];
        cArray4[0] = (char)(n7 + 48);
        System.arraycopy(cArray3, 0, cArray4, 1, n6 + 1);
        return cArray4;
    }

    private Rexx concat(RexxSet rexxSet, Rexx rexx, int n) {
        int n2 = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray = new char[this.chars.length + rexx.chars.length + n];
        System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
        if (n > 0) {
            int n3 = this.chars.length + n - 1;
            for (n2 = this.chars.length; n2 <= n3; ++n2) {
                cArray[n2] = 32;
            }
        }
        System.arraycopy(rexx.chars, 0, cArray, this.chars.length + n, rexx.chars.length);
        return new Rexx(cArray, true);
    }

    private static char[] sa2ca(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = stringArray.length - 1;
        if (n3 < 0) {
            return new char[0];
        }
        int n4 = n3;
        int n5 = n3;
        for (n = 0; n <= n5; ++n) {
            n4 += stringArray[n].length();
        }
        char[] cArray = new char[n4];
        int n6 = 0;
        n5 = n3;
        for (n = 0; n <= n5; ++n) {
            n2 = stringArray[n].length();
            stringArray[n].getChars(0, n2, cArray, n6);
            if (n == n3) break;
            n6 = n6 + n2 + 1;
            cArray[n6 - 1] = 32;
        }
        return cArray;
    }

    private final int docompare(RexxSet rexxSet, Rexx rexx) {
        int n;
        int n2 = 0;
        int n3 = 0;
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        char c = '\u0000';
        char c2 = '\u0000';
        if (this.ind != -2 && rexx.ind != -2) {
            if (this.ind == rexx.ind & this.exp == rexx.exp) {
                n2 = this.mant.length;
                if (n2 < rexx.mant.length) {
                    return -this.ind;
                }
                if (n2 > rexx.mant.length) {
                    return this.ind;
                }
                this.dig = 9;
                if (rexxSet != null) {
                    this.dig = rexxSet.digits;
                }
                if (n2 <= this.dig) {
                    int n4 = n2 - 1;
                    for (n3 = 0; n3 <= n4; ++n3) {
                        if (this.mant[n3] < rexx.mant[n3]) {
                            return -this.ind;
                        }
                        if (this.mant[n3] <= rexx.mant[n3]) continue;
                        return this.ind;
                    }
                    return 0;
                }
            } else {
                if (this.ind < rexx.ind) {
                    return -1;
                }
                if (this.ind > rexx.ind) {
                    return 1;
                }
            }
            rexx2 = new Rexx(rexx);
            rexx2.ind = -rexx2.ind;
            rexx3 = this.OpAdd(rexxSet, rexx2);
            return rexx3.ind;
        }
        if (this.chars == null) {
            this.chars = this.layout();
        }
        char[] cArray = this.chars;
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray2 = rexx.chars;
        int n5 = 0;
        int n6 = 0;
        int n7 = cArray2.length - 1;
        for (n = cArray.length - 1; n >= 0 && cArray[n] == ' '; --n) {
        }
        while (n7 >= 0 && cArray2[n7] == ' ') {
            --n7;
        }
        int n8 = n;
        for (n5 = 0; n5 <= n8 && cArray[n5] == ' '; ++n5) {
        }
        n8 = n7;
        for (n6 = 0; n6 <= n8 && cArray2[n6] == ' '; ++n6) {
        }
        while (true) {
            if ((c2 = n6 <= n7 ? cArray2[n6] : (char)' ') == (c = n5 <= n ? cArray[n5] : (char)' ')) {
                if (c2 == ' ' && n5 > n && n6 > n7) break;
                ++n5;
                ++n6;
                continue;
            }
            c = Character.toLowerCase(c);
            if ((c2 = Character.toLowerCase(c2)) != c) {
                if (c < c2) {
                    return -1;
                }
                return 1;
            }
            ++n5;
            ++n6;
        }
        return 0;
    }

    private final int docomparestrict(RexxSet rexxSet, Rexx rexx) {
        char c = '\u0000';
        char c2 = '\u0000';
        if (this.chars == null) {
            this.chars = this.layout();
        }
        char[] cArray = this.chars;
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray2 = rexx.chars;
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = cArray2.length - 1;
        while (true) {
            if (n <= n3) {
                c = cArray[n];
            } else {
                if (n2 > n4) break;
                c = '\u0000';
            }
            c2 = n2 <= n4 ? cArray2[n2] : (char)'\u0000';
            if (c2 != c) {
                if (c < c2) {
                    return -1;
                }
                return 1;
            }
            ++n;
            ++n2;
        }
        return 0;
    }

    private final Rexx finish(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = null;
        int n4 = 0;
        int n5 = 0;
        if (this.mant.length > n) {
            this.round(n);
        }
        if (bl) {
            n2 = this.mant.length;
            for (n3 = n2 - 1; n3 >= 1 && this.mant[n3] == '0'; --n3) {
                --n2;
                ++this.exp;
            }
            if (n2 < this.mant.length) {
                cArray = new char[n2];
                System.arraycopy(this.mant, 0, cArray, 0, n2);
                this.mant = cArray;
            }
        }
        int n6 = this.mant.length - 1;
        for (n3 = 0; n3 <= n6; ++n3) {
            block10: {
                block11: {
                    if (this.mant[n3] == '0') continue;
                    n4 = this.exp + this.mant.length - 1;
                    if (!(n4 < -999999999 | n4 > 999999999)) break block10;
                    if (this.form != 1) break block11;
                    n5 = n4 % 3;
                    if (n5 < 0) {
                        n5 = 3 + n5;
                    }
                    if ((n4 -= n5) >= -999999999 && n4 <= -999999999) break block10;
                }
                throw new ExponentOverflowException(String.valueOf(n4));
            }
            return this;
        }
        if (this.mant.length == 1 && this.ind == 0 && this.exp == 0) {
            return this;
        }
        return new Rexx(0);
    }

    @Override
    public Rexx islist() {
        if (this.exists(Rexx.toRexx("sl-elements")).OpNot(null) || this.exists(Rexx.toRexx("sl-rules")).OpNot(null)) {
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    @Override
    public Rexx elementcount() {
        if (this.islist().OpNot(null)) {
            throw new Error("cannot count elements in a non-list");
        }
        Rexx rexx = this;
        return rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf;
    }

    public Rexx index(Rexx rexx) {
        return this.index(rexx, new Rexx(1));
    }

    @Override
    public Rexx index(Rexx rexx, Rexx rexx2) {
        int n = 0;
        if (this.islist().OpNot(null)) {
            throw new Error("cannot locate elements in a non-list");
        }
        Rexx rexx3 = this;
        int n2 = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        for (n = rexx2.toint(); n <= n2; ++n) {
            if (!rexx3.getnode((Rexx)new Rexx((int)n)).leaf.OpEqS(null, rexx)) continue;
            return new Rexx(n);
        }
        return new Rexx(0);
    }

    @Override
    public Rexx getelement(Rexx rexx) {
        if (this.islist().OpNot(null)) {
            throw new Error("cannot get element from a non-list");
        }
        int n = rexx.toint();
        Rexx rexx2 = this;
        int n2 = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n2 == 0 || n < 1 || n > n2) {
            throw new IndexOutOfBoundsException(Rexx.toString(rexx));
        }
        return rexx2.getnode((Rexx)rexx).leaf;
    }

    @Override
    public Rexx insertelement(Rexx rexx, Rexx rexx2) {
        Rexx rexx3 = null;
        int n = 0;
        Rexx rexx4 = null;
        if (rexx2 == null) {
            throw new NullPointerException("structured list add element");
        }
        if (this.islist().OpNot(null)) {
            throw new Error("cannot add element to a non-list");
        }
        Rexx rexx5 = new Rexx(this).copyindexed(this);
        int n2 = rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        int n3 = rexx.toint();
        if (n3 < 1 || n3 > n2 + 1) {
            throw new IndexOutOfBoundsException(Rexx.toString(rexx));
        }
        rexx3 = rexx2.islist().toboolean() ? rexx2 : rexx2.buildlist(rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf);
        this.metamap(rexx3, new Rexx(0), new Rexx(1));
        Rexx rexx6 = new Rexx(rexx3.head()).copyIndexed(rexx3.head());
        for (n = n3; n <= n2 + 1; ++n) {
            rexx4 = rexx5.getnode((Rexx)new Rexx((int)n)).leaf;
            this.metamap(rexx5, new Rexx(0), new Rexx(n));
            rexx5.getnode((Rexx)new Rexx((int)n)).leaf = rexx6;
            this.metamap(rexx5, new Rexx(n));
            rexx6 = rexx4;
        }
        rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(n2 + 1);
        Rexx rexx7 = Rexx.reconstructlist(rexx5);
        return new Rexx(rexx7).copyIndexed(rexx5);
    }

    @Override
    public Rexx replaceanelement(Rexx rexx, Rexx rexx2) {
        return this.replaceelement(rexx, rexx2);
    }

    @Override
    public Rexx replaceelement(Rexx rexx, Rexx rexx2) {
        Rexx rexx3 = null;
        if (this.islist().OpNot(null)) {
            throw new Error("cannot replace element in a non-list");
        }
        if (rexx.datatype(Rexx.toRexx("Whole number")).OpNot(null)) {
            throw new Error("index is not a valid number");
        }
        int n = rexx.toint();
        Rexx rexx4 = this;
        int n2 = rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n2 == 0 || n < 1 || n > n2) {
            throw new IndexOutOfBoundsException(Rexx.toString(rexx));
        }
        Rexx rexx5 = new Rexx(this).copyindexed(this);
        rexx3 = rexx2.islist().toboolean() ? rexx2 : rexx2.buildlist(rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf).head();
        this.metamap(rexx5, new Rexx(0), new Rexx(n));
        rexx5.getnode((Rexx)new Rexx((int)n)).leaf = rexx3;
        this.metamap(rexx5, new Rexx(n));
        Rexx rexx6 = Rexx.reconstructlist(rexx5);
        return new Rexx(rexx6).copyIndexed(rexx5);
    }

    @Override
    public Rexx deleteanelement(Rexx rexx) {
        return this.deleteelement(rexx);
    }

    @Override
    public Rexx deleteelement(Rexx rexx) {
        int n = 0;
        if (this.islist().OpNot(null)) {
            throw new Error("cannot remove element from a non-list");
        }
        int n2 = rexx.toint();
        Rexx rexx2 = this;
        int n3 = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n3 == 0 || n2 < 1 || n2 > n3) {
            throw new IndexOutOfBoundsException(Rexx.toString(rexx));
        }
        this.metamap(rexx2, new Rexx(0), new Rexx(n2));
        for (n = n2; n < n3; ++n) {
            rexx2.getnode((Rexx)new Rexx((int)n)).leaf = rexx2.getnode((Rexx)new Rexx((int)(n + 1))).leaf;
            this.metamap(rexx2, new Rexx(n), new Rexx(n + 1));
        }
        this.metamap(rexx2, new Rexx(0), new Rexx(n3));
        rexx2.getnode((Rexx)new Rexx((int)n3)).leaf = null;
        rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(n3 - 1);
        Rexx rexx3 = Rexx.reconstructlist(rexx2);
        return new Rexx(rexx3).copyIndexed(rexx2);
    }

    public Rexx sublist(Rexx rexx) {
        return this.sublist(rexx, Rexx.toRexx("end"));
    }

    @Override
    public Rexx sublist(Rexx rexx, Rexx rexx2) {
        int n = 0;
        if (this.islist().OpNot(null)) {
            throw new Error("cannot sublist a non-list");
        }
        Rexx rexx3 = this;
        int n2 = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (rexx2.OpEqS(null, $05)) {
            rexx2 = new Rexx(n2);
        }
        if (rexx.toint() < 0) {
            rexx = new Rexx(n2 + 1 + rexx.toint());
        }
        if (rexx2.toint() < 0) {
            rexx2 = new Rexx(n2 + 1 + rexx2.toint());
        }
        if (rexx.toint() < 1 || rexx2.toint() > n2 || rexx.toint() > rexx2.toint()) {
            throw new IndexOutOfBoundsException(Rexx.toString(rexx.OpCcblank(null, rexx2)));
        }
        Rexx rexx4 = new Rexx();
        rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf;
        int n3 = 0;
        for (n = rexx.toint(); n <= rexx2.toint(); ++n) {
            rexx4.getnode((Rexx)new Rexx((int)(++n3))).leaf = rexx3.getnode((Rexx)new Rexx((int)n)).leaf;
            this.metamap(rexx4, new Rexx(n3));
        }
        rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(n - rexx.toint());
        Rexx rexx5 = Rexx.reconstructlist(rexx4);
        return new Rexx(rexx5).copyIndexed(rexx4);
    }

    @Override
    public Rexx join(StructuredList structuredList) {
        int n;
        Rexx rexx = null;
        int n2 = 0;
        Rexx rexx2 = (Rexx)structuredList;
        if (this.exists(Rexx.toRexx("sl-elements")).OpNot(null)) {
            rexx = new Rexx(this);
            rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx("1");
            rexx.getnode((Rexx)new Rexx((byte)1)).leaf = this;
            if (rexx2.exists(Rexx.toRexx("sl-rules")).toboolean()) {
                rexx.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf;
            }
            return rexx.join(rexx2);
        }
        if (rexx2.exists(Rexx.toRexx("sl-elements")).OpNot(null)) {
            rexx = new Rexx(rexx2);
            rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx("1");
            rexx.getnode((Rexx)new Rexx((byte)1)).leaf = new Rexx(rexx2);
            return this.join(rexx);
        }
        Rexx rexx3 = this;
        int n3 = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        String string = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"separator")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.toString();
        Rexx rexx4 = new Rexx();
        rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf;
        Rexx rexx5 = Rexx.toRexx("");
        int n4 = n3;
        n2 = 1;
        while (n4 > 0) {
            rexx4.getnode((Rexx)new Rexx((int)n2)).leaf = rexx3.getnode((Rexx)new Rexx((int)n2)).leaf;
            rexx5 = n2 == 1 ? Rexx.toRexx(rexx3.getnode((Rexx)new Rexx((int)n2)).leaf.toString()) : rexx5.OpCc(null, Rexx.toRexx(string)).OpCc(null, rexx3.getnode((Rexx)new Rexx((int)n2)).leaf);
            --n4;
            ++n2;
        }
        n4 = n = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        n2 = 1;
        while (n4 > 0) {
            rexx4.getnode((Rexx)new Rexx((int)(n3 + n2))).leaf = new Rexx(rexx2.getnode((Rexx)new Rexx((int)n2)).leaf).copyIndexed(rexx2.getnode((Rexx)new Rexx((int)n2)).leaf);
            rexx5 = rexx5.OpCc(null, Rexx.toRexx(string)).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n2)).leaf);
            --n4;
            ++n2;
        }
        rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint() + rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint());
        rexx5 = Rexx.reconstructlist(rexx4);
        Rexx rexx6 = new Rexx(rexx5).copyIndexed(rexx4);
        return rexx6;
    }

    public Rexx elementname() {
        Rexx rexx = this;
        if (rexx.exists(Rexx.toRexx("sl-elementname")).toboolean()) {
            return rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf;
        }
        return Rexx.toRexx("");
    }

    public Rexx elementvalue() {
        Rexx rexx = this;
        if (rexx.exists(Rexx.toRexx("sl-elementvalue")).toboolean()) {
            return rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf;
        }
        return rexx;
    }

    public Rexx rules() {
        Rexx rexx = this;
        if (rexx.exists(Rexx.toRexx("sl-rules")).toboolean()) {
            return rexx.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf;
        }
        return Rexx.toRexx("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rexx flatlist() {
        Rexx rexx = null;
        Rexx rexx2 = null;
        int n = 0;
        Rexx rexx3 = new Rexx(this).copyindexed(this);
        int n2 = 0;
        Vector vector = new Vector(100, 0);
        Rexx rexx4 = rexx3;
        synchronized (rexx4) {
            Enumeration enumeration = rexx3.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
                if (!rexx3.testnode((Rexx)vector.elementAt(n2))) {
                    vector.removeElementAt(n2);
                    continue;
                }
                ++n2;
            }
        }
        while (--n2 >= 0) {
            rexx = (Rexx)vector.elementAt(n2);
            if (rexx.datatype(Rexx.toRexx("whole number")).toboolean() && rexx.toint() > 0) {
                rexx2 = rexx3.getnode((Rexx)rexx).leaf.flatlist();
                rexx3.getnode((Rexx)rexx).leaf = new Rexx(rexx2).copyindexed(rexx2);
                continue;
            }
            rexx3.getnode((Rexx)rexx).leaf = null;
        }
        Rexx rexx5 = new Rexx(rexx3);
        n = 1;
        while (rexx3.exists(new Rexx(n)).toboolean()) {
            rexx5.getnode((Rexx)new Rexx((int)n)).leaf = rexx3.getnode((Rexx)new Rexx((int)n)).leaf;
            ++n;
        }
        return rexx5;
    }

    public Rexx first() {
        return this.head();
    }

    public Rexx head() {
        Rexx rexx = this;
        if (rexx.exists(Rexx.toRexx("sl-elements")).toboolean() && rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint() > 0) {
            return new Rexx(rexx.getnode((Rexx)new Rexx((byte)1)).leaf).copyIndexed(rexx.getnode((Rexx)new Rexx((byte)1)).leaf);
        }
        return rexx;
    }

    public Rexx append(Rexx rexx) {
        if (this.islist().OpNot(null)) {
            throw new Error("cannot add element to a non-list");
        }
        Rexx rexx2 = this;
        int n = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        return this.insertelement(new Rexx(n + 1), rexx);
    }

    public Rexx count(Rexx rexx) {
        if (this.islist().OpNot(null)) {
            throw new Error("cannot count elements in a non-list");
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = this.index(rexx, new Rexx(n2 + 1)).toint()) >= 1) {
            ++n;
        }
        return new Rexx(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rexx minval() {
        Rexx rexx = null;
        int n = 0;
        Rexx rexx2 = this;
        Rexx rexx3 = null;
        if (rexx2.isIndexed().OpNot(null)) {
            return rexx3;
        }
        if (this.islist().OpNot(null)) {
            int n2 = 0;
            Vector vector = new Vector(100, 0);
            Rexx rexx4 = rexx2;
            synchronized (rexx4) {
                Enumeration enumeration = rexx2.keys();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                    if (!rexx2.testnode((Rexx)vector.elementAt(n2))) {
                        vector.removeElementAt(n2);
                        continue;
                    }
                    ++n2;
                }
            }
            while (--n2 >= 0) {
                rexx = (Rexx)vector.elementAt(n2);
                if (rexx2.getnode((Rexx)rexx).leaf.datatype(new Rexx('N')).OpNot(null)) continue;
                if (rexx3 == null) {
                    rexx3 = rexx2.getnode((Rexx)rexx).leaf;
                    continue;
                }
                rexx3 = rexx3.min(rexx2.getnode((Rexx)rexx).leaf);
            }
            return rexx3;
        }
        int n3 = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n3 == 0) {
            return rexx3;
        }
        rexx3 = rexx2.getnode((Rexx)new Rexx((byte)1)).leaf;
        for (n = 2; n <= n3; ++n) {
            rexx3 = rexx3.min(rexx2.getnode((Rexx)new Rexx((int)n)).leaf);
        }
        return rexx3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rexx maxval() {
        Rexx rexx = null;
        int n = 0;
        Rexx rexx2 = this;
        Rexx rexx3 = null;
        if (rexx2.isIndexed().OpNot(null)) {
            return rexx3;
        }
        if (this.islist().OpNot(null)) {
            int n2 = 0;
            Vector vector = new Vector(100, 0);
            Rexx rexx4 = rexx2;
            synchronized (rexx4) {
                Enumeration enumeration = rexx2.keys();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                    if (!rexx2.testnode((Rexx)vector.elementAt(n2))) {
                        vector.removeElementAt(n2);
                        continue;
                    }
                    ++n2;
                }
            }
            while (--n2 >= 0) {
                rexx = (Rexx)vector.elementAt(n2);
                if (rexx2.getnode((Rexx)rexx).leaf.datatype(new Rexx('N')).OpNot(null)) continue;
                if (rexx3 == null) {
                    rexx3 = rexx2.getnode((Rexx)rexx).leaf;
                    continue;
                }
                rexx3 = rexx3.max(rexx2.getnode((Rexx)rexx).leaf);
            }
            return rexx3;
        }
        int n3 = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n3 == 0) {
            return rexx3;
        }
        rexx3 = rexx2.getnode((Rexx)new Rexx((byte)1)).leaf;
        for (n = 2; n <= n3; ++n) {
            rexx3 = rexx3.max(rexx2.getnode((Rexx)new Rexx((int)n)).leaf);
        }
        return rexx3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rexx sum() {
        Rexx rexx = null;
        int n = 0;
        Rexx rexx2 = this;
        int n2 = 0;
        if (rexx2.isIndexed().OpNot(null)) {
            return new Rexx(n2);
        }
        if (this.islist().OpNot(null)) {
            int n3 = 0;
            Vector vector = new Vector(100, 0);
            Rexx rexx3 = rexx2;
            synchronized (rexx3) {
                Enumeration enumeration = rexx2.keys();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                    if (!rexx2.testnode((Rexx)vector.elementAt(n3))) {
                        vector.removeElementAt(n3);
                        continue;
                    }
                    ++n3;
                }
            }
            while (--n3 >= 0) {
                rexx = (Rexx)vector.elementAt(n3);
                if (rexx2.getnode((Rexx)rexx).leaf.datatype(new Rexx('N')).OpNot(null)) continue;
                n2 += rexx2.getnode((Rexx)rexx).leaf.toint();
            }
            return new Rexx(n2);
        }
        int n4 = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n4 == 0) {
            return new Rexx(n2);
        }
        for (n = 1; n <= n4; ++n) {
            n2 += rexx2.getnode((Rexx)new Rexx((int)n)).leaf.toint();
        }
        return new Rexx(n2);
    }

    public Rexx reverselist() {
        int n;
        int n2 = 0;
        Rexx rexx = null;
        if (this.islist().OpNot(null)) {
            throw new Error("cannot reverse a non-list");
        }
        Rexx rexx2 = new Rexx(this).copyindexed(this);
        int n3 = n = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        for (n2 = 1; n2 < n3; --n3, ++n2) {
            rexx = rexx2.getnode((Rexx)new Rexx((int)n2)).leaf;
            this.metamap(rexx2, new Rexx(0), new Rexx(n2));
            rexx2.getnode((Rexx)new Rexx((int)n2)).leaf = rexx2.getnode((Rexx)new Rexx((int)n3)).leaf;
            this.metamap(rexx2, new Rexx(n2), new Rexx(n3));
            rexx2.getnode((Rexx)new Rexx((int)n3)).leaf = rexx;
            this.metamap(rexx2, new Rexx(n3));
        }
        Rexx rexx3 = Rexx.reconstructlist(rexx2);
        return new Rexx(rexx3).copyIndexed(rexx2);
    }

    public Rexx rest() {
        return this.tail();
    }

    public Rexx tail() {
        int n = 0;
        if (this.exists(Rexx.toRexx("sl-elements")).OpNot(null)) {
            return this;
        }
        Rexx rexx = this;
        int n2 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        if (n2 < 2) {
            return new Rexx();
        }
        Rexx rexx2 = new Rexx(this);
        rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(new Rexx(n2 - 1));
        rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf;
        int n3 = n2;
        for (n = 2; n <= n3; ++n) {
            rexx2.getnode((Rexx)new Rexx((int)(n - 1))).leaf = rexx.getnode((Rexx)new Rexx((int)n)).leaf;
            this.metamap(rexx2, new Rexx(n - 1));
        }
        Rexx rexx3 = Rexx.reconstructlist(rexx2);
        return new Rexx(rexx3).copyIndexed(rexx2);
    }

    @Override
    public List getJavaList() {
        return new RexxList(this);
    }

    public void dumplist() {
        Rexx.dumplist(this);
    }

    public static void dumplist(Rexx rexx) {
        Rexx.dumplist(rexx, "", "", "");
    }

    public static void dumplist(Rexx rexx, String string) {
        Rexx.dumplist(rexx, string, "", "");
    }

    public static void dumplist(Rexx rexx, String string, String string2) {
        Rexx.dumplist(rexx, string, string2, "");
    }

    public static void dumplist(Rexx rexx, String string, String string2, String string3) {
        int n = 0;
        RexxIO.Say(Rexx.toRexx(string2 + " " + string + " -->").OpCcblank(null, rexx));
        RexxIO.Say(Rexx.toRexx(string2 + " " + string + " " + string3 + "   element name=").OpCc(null, rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf));
        RexxIO.Say(Rexx.toRexx(string2 + " " + string + " " + string3 + "   element value=").OpCc(null, rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf));
        if (rexx.exists(Rexx.toRexx("sl-elements")).toboolean()) {
            RexxIO.Say(Rexx.toRexx(string2 + " elements=").OpCc(null, rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf));
            int n2 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
            for (n = 1; n <= n2; ++n) {
                Rexx.dumplist(rexx.getnode((Rexx)new Rexx((int)n)).leaf, String.valueOf(n), string2 + " --*", "==>");
            }
        }
    }

    public void dumpvar() {
        Rexx.dumpvar(this);
    }

    public static void dumpvar(Rexx rexx) {
        Rexx.dumpvar(rexx, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpvar(Rexx rexx, String string) {
        Rexx rexx2 = null;
        RexxIO.Say(Rexx.toRexx(string).OpCcblank(null, rexx));
        int n = 0;
        Vector vector = new Vector(100, 0);
        Rexx rexx3 = rexx;
        synchronized (rexx3) {
            Enumeration enumeration = rexx.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
                if (!rexx.testnode((Rexx)vector.elementAt(n))) {
                    vector.removeElementAt(n);
                    continue;
                }
                ++n;
            }
        }
        while (--n >= 0) {
            rexx2 = (Rexx)vector.elementAt(n);
            RexxIO.Say(Rexx.toRexx("=" + string).OpCcblank(null, rexx2));
            Rexx.dumpvar(rexx.getnode((Rexx)rexx2).leaf, "==> " + string);
        }
    }

    public static Rexx reconstructlist(Rexx rexx) {
        return Rexx.reconstructlist(rexx, Rexx.toRexx(""), new Rexx(0));
    }

    public static Rexx reconstructlist(Rexx rexx, Rexx rexx2) {
        return Rexx.reconstructlist(rexx, rexx2, new Rexx(0));
    }

    public static Rexx reconstructlist(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        Rexx rexx6 = null;
        Rexx rexx7 = null;
        Rexx rexx8 = null;
        Rexx rexx9 = null;
        Rexx rexx10 = null;
        Rexx rexx11 = null;
        String string = null;
        int n = 0;
        Rexx rexx12 = null;
        Rexx rexx13 = null;
        if (rexx2.OpEqS(null, $03)) {
            if (rexx.exists(Rexx.toRexx("sl-rules")).toboolean()) {
                rexx4 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf;
            }
        } else {
            rexx4 = rexx2.exists(Rexx.toRexx("sl-elements")).OpNot(null) ? Rexx.getrules(rexx2) : rexx2;
        }
        Rexx rexx14 = Rexx.getflags(rexx4);
        rexx5 = rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.exists(Rexx.toRexx("separator")).toboolean() ? rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"separator")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf : Rexx.toRexx("");
        rexx6 = rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.exists(Rexx.toRexx("start")).toboolean() ? rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"start")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf : Rexx.toRexx("");
        rexx7 = rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.exists(Rexx.toRexx("end")).toboolean() ? rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"end")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf : Rexx.toRexx("");
        rexx8 = rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.exists(Rexx.toRexx("escape")).toboolean() ? rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf : Rexx.toRexx("");
        if (rexx.exists(Rexx.toRexx("sl-elementname")).toboolean()) {
            if (rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.exists(rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).toboolean()) {
                return rexx;
            }
            rexx9 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf;
            if (rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.exists(Rexx.toRexx("sl-wrapper")).toboolean()) {
                rexx9 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-wrapper")).leaf.OpCc(null, rexx9).OpCc(null, rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-wrapper")).leaf);
            }
        } else {
            rexx9 = Rexx.toRexx("");
        }
        rexx10 = rexx.exists(Rexx.toRexx("sl-namesep")).toboolean() ? rexx.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf : Rexx.toRexx("");
        if (rexx.exists(Rexx.toRexx("sl-elements")).OpNot(null)) {
            rexx11 = new Rexx(rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf);
            if (rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.exists(Rexx.toRexx("sl-wrapper")).toboolean()) {
                rexx11 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-wrapper")).leaf.OpCc(null, rexx11).OpCc(null, rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-wrapper")).leaf);
            }
            if (rexx8.OpEqS(null, $03)) {
                return rexx9.OpCc(null, rexx10).OpCc(null, rexx11);
            }
            string = "no";
            if (rexx11.pos(rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf).toint() != 0) {
                rexx11 = rexx14.substr(new Rexx(5), new Rexx(1)).toint() == 1 ? rexx11.changestr(rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.OpCc(null, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf)) : rexx11.changestr(rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.OpCc(null, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf));
                string = "yes";
            }
            int n2 = rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
            for (n = 1; n <= n2; ++n) {
                if (!rexx11.pos(rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf).OpNotEqS(null, $02)) continue;
                if (rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.OpNotEqS(null, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf) && rexx14.substr(new Rexx(5), new Rexx(1)).toint() == 1) {
                    rexx11 = rexx11.changestr(rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.OpCc(null, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf));
                }
                string = "yes";
            }
            if (string.equals("yes") && rexx14.substr(new Rexx(5), new Rexx(1)).toint() == 0) {
                rexx11 = rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.OpCc(null, rexx11).OpCc(null, rexx4.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf.getnode((Rexx)new Rexx((byte)1)).leaf);
            }
            return rexx9.OpCc(null, rexx10).OpCc(null, rexx11);
        }
        if (rexx9.OpNotEqS(null, $03) && rexx9.OpNotEqS(null, rexx)) {
            rexx9 = rexx9.OpCc(null, rexx10);
        }
        if (rexx.exists(Rexx.toRexx("sl-start")).toboolean()) {
            rexx6 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-start")).leaf;
        }
        if (rexx.exists(Rexx.toRexx("sl-end")).toboolean()) {
            rexx7 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-end")).leaf;
        }
        Rexx rexx15 = Rexx.toRexx("");
        if (rexx.exists(Rexx.toRexx("sl-elements")).toboolean()) {
            if (rexx14.substr(new Rexx(7), new Rexx(1)).OpEqS(null, $06)) {
                rexx5 = Rexx.toRexx("");
            }
            if (rexx3.toboolean() && rexx14.substr(new Rexx(7), new Rexx(1)).OpEqS(null, $07)) {
                rexx15 = rexx6;
            }
            int n3 = rexx.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
            for (n = 1; n <= n3; ++n) {
                rexx12 = Rexx.reconstructlist(rexx.getnode((Rexx)new Rexx((int)n)).leaf, rexx4, new Rexx(1));
                rexx13 = Rexx.delimiterinfo(rexx12, rexx4);
                rexx15 = rexx13.OpEqS(null, $03) || rexx13.length().OpNotEqS(null, rexx12.length()) ? rexx15.OpCc(null, rexx12).OpCc(null, rexx5) : rexx15.OpCc(null, rexx12);
            }
            if (rexx15.length().toint() > rexx5.length().toint() && rexx15.right(rexx5.length()).OpEqS(null, rexx5)) {
                rexx15 = rexx15.substr(new Rexx(1), new Rexx(rexx15.length().toint() - rexx5.length().toint()));
            }
            if (rexx3.toboolean() && rexx14.substr(new Rexx(7), new Rexx(1)).OpEqS(null, $07)) {
                rexx15 = rexx15.OpCc(null, rexx7);
            }
        }
        return rexx9.OpCc(null, rexx15);
    }

    public static Rexx getrules() {
        return Rexx.getrules(Rexx.toRexx("default"));
    }

    public static Rexx getrules(Rexx rexx) {
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        Rexx rexx6 = null;
        Rexx rexx7 = null;
        Rexx rexx8 = null;
        Rexx rexx9 = null;
        int n = 0;
        int n2 = 0;
        if (rexx.OpEqS(null, $08)) {
            rexx2 = Rexx.toRexx("(");
            rexx2.getnode((Rexx)new Rexx((byte)1)).leaf = new Rexx('(');
            rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(1);
            rexx3 = Rexx.toRexx(")");
            rexx3.getnode((Rexx)new Rexx((byte)1)).leaf = new Rexx(')');
            rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(1);
            rexx4 = Rexx.toRexx(" ");
            rexx4.getnode((Rexx)new Rexx((byte)1)).leaf = new Rexx(' ');
            rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(1);
            rexx5 = Rexx.toRexx("\"");
            rexx5.getnode((Rexx)new Rexx((byte)1)).leaf = new Rexx('\"');
            rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(1);
            rexx6 = rexx2.OpCc(null, rexx3).OpCc(null, rexx4).OpCc(null, rexx5);
            rexx6.getnode((Rexx)new Rexx((byte)1)).leaf = rexx2;
            rexx6.getnode((Rexx)Rexx.toRexx((String)"start")).leaf = rexx2;
            rexx6.getnode((Rexx)new Rexx((byte)1)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = Rexx.toRexx("start");
            rexx6.getnode((Rexx)new Rexx((byte)2)).leaf = rexx3;
            rexx6.getnode((Rexx)Rexx.toRexx((String)"end")).leaf = rexx3;
            rexx6.getnode((Rexx)new Rexx((byte)2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = Rexx.toRexx("end");
            rexx6.getnode((Rexx)new Rexx((byte)3)).leaf = rexx4;
            rexx6.getnode((Rexx)Rexx.toRexx((String)"separator")).leaf = rexx4;
            rexx6.getnode((Rexx)new Rexx((byte)3)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = Rexx.toRexx("separator");
            rexx6.getnode((Rexx)new Rexx((byte)4)).leaf = rexx5;
            rexx6.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf = rexx5;
            rexx6.getnode((Rexx)new Rexx((byte)4)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = Rexx.toRexx("escape");
            rexx6.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(4);
            rexx7 = Rexx.toRexx("Ruleset");
            rexx7.getnode((Rexx)new Rexx((byte)1)).leaf = rexx6;
            rexx7.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf = rexx6;
            rexx7.getnode((Rexx)new Rexx((byte)1)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = Rexx.toRexx("delimiters");
            rexx7.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(1);
            return rexx7;
        }
        Rexx rexx10 = Rexx.toRexx("");
        rexx10.getnode((Rexx)Rexx.toRexx((String)"WORDLIST")).leaf = Rexx.toRexx("delimiters(separator(\" \") escape(\"\"\"\")) options(escape-is-quoted-string)");
        rexx10.getnode((Rexx)Rexx.toRexx((String)"CSV")).leaf = Rexx.toRexx("delimiters(separator(,) escape(\"\"\"\")) options(escape-is-quoted-string)");
        rexx10.getnode((Rexx)Rexx.toRexx((String)"TSV")).leaf = Rexx.toRexx("delimiters(separator(\"\t\")");
        rexx10.getnode((Rexx)Rexx.toRexx((String)"XML")).leaf = Rexx.toRexx("delimiters(start(\"<\") end(\">\") separator(\" \") meta(\"/\") nameseparator(\"=\")) options(\"explicit attribute names\")");
        rexx10.getnode((Rexx)Rexx.toRexx((String)"JSON")).leaf = Rexx.toRexx("delimiters(start(\"{\") end(\"}\") start(\"[\") end(\"]\") escape(\\) separator(\",\") nameseparator(\":\")) options(\"explicit attribute names\" \"single character escape\" \"remove enclosing quotes\" \"Strip leading and trailing whitespace\")");
        rexx10.getnode((Rexx)Rexx.toRexx((String)"PYTHON")).leaf = Rexx.toRexx("delimiters(start(\"{\") end(\"}\") start(\"[\") end(\"]\") start(\"(\") end(\")\") escape(\"'\") escape(\"\"\"\") separator(\",\") nameseparator(\":\")) options(\"explicit attribute names\" \"escape is quoted string\" \"Strip leading and trailing whitespace\")");
        if (rexx10.exists(Rexx.toRexx(rexx.toString())).toboolean()) {
            rexx8 = new Rexx(rexx10.getnode((Rexx)rexx).leaf).buildlist();
        } else {
            rexx9 = rexx.substr(new Rexx(1), new Rexx(rexx.pos(new Rexx('(')).toint() - 1));
            if (Rexx.toRexx("delimiters").abbrev(rexx9).OpNot(null) & Rexx.toRexx("options").abbrev(rexx9).OpNot(null)) {
                throw new Error("invalid ruleset");
            }
            rexx8 = new Rexx(rexx).buildlist();
        }
        int n3 = rexx8.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        for (n = 1; n <= n3; ++n) {
            if (Rexx.toRexx("delimiters").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(1)).toboolean()) {
                if (rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, $09)) {
                    rexx8.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf;
                }
                int n4 = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
                for (n2 = 1; n2 <= n4; ++n2) {
                    if (Rexx.toRexx("start").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(2)).toboolean() && rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, $010)) {
                        rexx8.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"start")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf;
                    }
                    if (Rexx.toRexx("end").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(2)).toboolean() && rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, $05)) {
                        rexx8.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"end")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf;
                    }
                    if (Rexx.toRexx("separator").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(2)).toboolean() && rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, $011)) {
                        rexx8.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"separator")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf;
                    }
                    if (Rexx.toRexx("escape").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(2)).toboolean() && rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, $012)) {
                        rexx8.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"escape")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf;
                    }
                    if (!Rexx.toRexx("nameseparator").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(1)).toboolean() || !rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, Rexx.toRexx("nameseparator"))) continue;
                    rexx8.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf.getnode((Rexx)Rexx.toRexx((String)"nameseparator")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((int)n2)).leaf;
                }
            }
            if (!Rexx.toRexx("options").abbrev(rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(1)).toboolean() || !rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.OpNotEqS(null, $013)) continue;
            rexx8.getnode((Rexx)Rexx.toRexx((String)"options")).leaf = rexx8.getnode((Rexx)new Rexx((int)n)).leaf;
        }
        return rexx8;
    }

    public static Rexx getdelims(Rexx rexx) {
        int n = 0;
        String string = "\u0000\u0000\u0000\u0000\u0000";
        if (rexx.exists(Rexx.toRexx("delimiters")).OpNot(null)) {
            return Rexx.toRexx(string);
        }
        Rexx rexx2 = rexx.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf;
        string = "";
        int n2 = rexx2.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        for (n = 1; n <= n2; ++n) {
            string = Rexx.toRexx("start").abbrev(rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower().changestr(new Rexx('-'), new Rexx(' '))).toboolean() ? Rexx.toString(Rexx.toRexx(string).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.left(new Rexx(1)))) : (Rexx.toRexx("end").abbrev(rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower().changestr(new Rexx('-'), new Rexx(' '))).toboolean() ? Rexx.toString(Rexx.toRexx(string).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.left(new Rexx(1)))) : (Rexx.toRexx("separator").abbrev(rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower().changestr(new Rexx('-'), new Rexx(' '))).toboolean() ? Rexx.toString(Rexx.toRexx(string).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.left(new Rexx(1)))) : (Rexx.toRexx("escape").abbrev(rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower().changestr(new Rexx('-'), new Rexx(' '))).toboolean() ? Rexx.toString(Rexx.toRexx(string).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.left(new Rexx(1)))) : (Rexx.toRexx("nameseparator").abbrev(rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower().changestr(new Rexx('-'), new Rexx(' '))).toboolean() ? Rexx.toString(Rexx.toRexx(string).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.left(new Rexx(1)))) : Rexx.toString(Rexx.toRexx(string).OpCc(null, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)new Rexx((byte)1)).leaf.left(new Rexx(1))))))));
        }
        return Rexx.toRexx(string);
    }

    public static Rexx delimiterinfo(Rexx rexx, Rexx rexx2) {
        int n = 0;
        Rexx rexx3 = null;
        int n2 = 0;
        int n3 = rexx.length().toint();
        Rexx rexx4 = rexx2.getnode((Rexx)Rexx.toRexx((String)"delimiters")).leaf;
        Rexx rexx5 = Rexx.toRexx("");
        int n4 = rexx4.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        for (n = 1; n <= n4; ++n) {
            rexx3 = rexx4.getnode((Rexx)new Rexx((int)n)).leaf;
            n2 = rexx3.getnode((Rexx)new Rexx((byte)1)).leaf.length().toint();
            if (n2 > n3 || !rexx.left(new Rexx(n2)).OpEqS(null, rexx3.getnode((Rexx)new Rexx((byte)1)).leaf)) continue;
            rexx5 = rexx3.getnode((Rexx)new Rexx((byte)1)).leaf;
            rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf;
            break;
        }
        return rexx5;
    }

    public static Rexx getflags(Rexx rexx) {
        int n = 0;
        Rexx rexx2 = Rexx.toRexx("000000000");
        if (rexx.exists(Rexx.toRexx("options")).OpNot(null)) {
            return rexx2;
        }
        Rexx rexx3 = rexx.getnode((Rexx)Rexx.toRexx((String)"options")).leaf;
        int n2 = rexx3.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf.toint();
        for (n = 1; n <= n2; ++n) {
            if (Rexx.toRexx("separators follow sublists").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(1));
                continue;
            }
            if (Rexx.toRexx("sublists are separators").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(1));
                continue;
            }
            if (Rexx.toRexx("adjacent separators reduce to one").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(2));
                continue;
            }
            if (Rexx.toRexx("produce empty elements for adjacent separators").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(2));
                continue;
            }
            if (Rexx.toRexx("translate escape sequences").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(3)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(3));
                continue;
            }
            if (Rexx.toRexx("do not translate escape sequences").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(3));
                continue;
            }
            if (Rexx.toRexx("whitespace is translated to blank").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(1)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(4));
                continue;
            }
            if (Rexx.toRexx("treat whitespace as text").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(3)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(4));
                continue;
            }
            if (Rexx.toRexx("escape is quoted string").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(5));
                continue;
            }
            if (Rexx.toRexx("single character escape").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(5));
                continue;
            }
            if (Rexx.toRexx("attribute names are implicit").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(6));
                continue;
            }
            if (Rexx.toRexx("explicit attribute names").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(6));
                continue;
            }
            if (Rexx.toRexx("delimiters are implicit").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(7));
                continue;
            }
            if (Rexx.toRexx("tokens are delimiters").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(7));
                continue;
            }
            if (Rexx.toRexx("keep leading and trailing whitespace").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(1)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(8));
                continue;
            }
            if (Rexx.toRexx("strip leading and trailing whitespace").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(8));
                continue;
            }
            if (Rexx.toRexx("enclosing quotes are data").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(1)).toboolean()) {
                rexx2 = rexx2.overlay(Rexx.toRexx("0"), new Rexx(9));
                continue;
            }
            if (!Rexx.toRexx("remove enclosing quotes").abbrev(rexx3.getnode((Rexx)new Rexx((int)n)).leaf.lower().changestr(new Rexx('-'), new Rexx(' ')), new Rexx(2)).toboolean()) continue;
            rexx2 = rexx2.overlay(Rexx.toRexx("1"), new Rexx(9));
        }
        return rexx2;
    }

    public Rexx buildlist() {
        return this.buildlist(Rexx.toRexx("default"), Rexx.toRexx("1"));
    }

    @Override
    public Rexx buildlist(Rexx rexx) {
        return this.buildlist(rexx, Rexx.toRexx("1"));
    }

    public Rexx buildlist(Rexx rexx, Rexx rexx2) {
        Rexx rexx3 = null;
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        Rexx rexx6 = null;
        int n = 0;
        int n2 = 0;
        Rexx rexx7 = null;
        int n3 = 0;
        Rexx rexx8 = null;
        Rexx rexx9 = null;
        int n4 = 0;
        Rexx rexx10 = null;
        Rexx rexx11 = null;
        int n5 = 0;
        Rexx rexx12 = null;
        Rexx rexx13 = null;
        int n6 = 0;
        int n7 = rexx2.toint();
        rexx3 = rexx.exists(Rexx.toRexx("sl-elements")).OpNot(null) ? Rexx.getrules(rexx) : rexx;
        Rexx rexx14 = Rexx.getdelims(rexx3);
        Rexx rexx15 = Rexx.getflags(rexx3);
        Rexx rexx16 = rexx15.left(new Rexx(9)).changestr(new Rexx(' '), new Rexx('0'));
        rexx4 = rexx16.substr(new Rexx(4), new Rexx(1)).toint() == 0 ? new Rexx(this.translate(new Rexx(' '), Rexx.toRexx("\t\n\r\f\u000b"))) : new Rexx(this);
        Rexx rexx17 = rexx4;
        rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(n7 - 1);
        rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-rules")).leaf = new Rexx(rexx3).copyindexed(rexx3);
        Rexx rexx18 = new Rexx("");
        Rexx rexx19 = Rexx.toRexx("");
        Rexx rexx20 = new Rexx("");
        Rexx rexx21 = new Rexx("");
        int n8 = 1;
        if (n7 > 1 && rexx16.substr(new Rexx(7), new Rexx(1)).toint() == 1) {
            rexx5 = Rexx.delimiterinfo(rexx17, rexx3);
            rexx6 = rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower();
            rexx17.getnode((Rexx)new Rexx((int)n8)).leaf = new Rexx(rexx5);
            rexx17.getnode((Rexx)new Rexx((int)n8)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx6;
            rexx17.getnode((Rexx)rexx17.getnode((Rexx)new Rexx((int)n8)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).leaf = rexx17.getnode((Rexx)new Rexx((int)n8)).leaf;
            n8 = 2;
        }
        n = n8;
        while (n7 <= rexx17.length().toint()) {
            n2 = rexx17.substr(new Rexx(n7)).verify(rexx14, Rexx.toRexx("match")).toint();
            rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx("");
            if (n2 == 0) {
                rexx7 = rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1 ? new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7))).strip()) : new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7))));
                if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                    rexx20 = new Rexx(rexx20.strip());
                }
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx7));
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = new Rexx(rexx7);
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                this.metamap(rexx17, new Rexx(n));
                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + rexx17.substr(new Rexx(n7)).length().toint());
                break;
            }
            rexx5 = Rexx.delimiterinfo(rexx17.substr(new Rexx(n7 + n2 - 1)), rexx3);
            rexx6 = rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower();
            n3 = rexx5.length().toint();
            if (rexx6.OpEqS(null, $03)) {
                --n;
            } else if (Rexx.toRexx("escape").abbrev(rexx6, new Rexx(2)).toboolean()) {
                if (rexx16.substr(new Rexx(5), new Rexx(1)).toint() == 0) {
                    if (rexx19.OpEqS(null, $03)) {
                        rexx19 = rexx5;
                    } else if (rexx19.OpEqS(null, rexx5)) {
                        if (rexx17.substr(new Rexx(n7 + n2 + n3 - 1)).length().toint() >= n3) {
                            if (rexx5.OpEqS(null, rexx17.substr(new Rexx(n7 + n2 + n3 - 1), new Rexx(n3)))) {
                                n2 += n3;
                            } else {
                                rexx19 = Rexx.toRexx("");
                            }
                        } else {
                            rexx19 = Rexx.toRexx("");
                        }
                    }
                    rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
                    rexx18 = rexx16.substr(new Rexx(3), new Rexx(1)).toint() == 1 ? new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 + n3 - 1)))) : new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))));
                }
                if (rexx16.substr(new Rexx(5), new Rexx(1)).toint() == 1) {
                    if (rexx16.substr(new Rexx(3), new Rexx(1)).toint() == 1) {
                        rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + (n2 += n3));
                        rexx18 = new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2))));
                    } else {
                        rexx18 = new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))).OpCc(null, rexx17.substr(new Rexx(n7 + n2 + n3 - 1), new Rexx(1))));
                        rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
                        rexx8 = rexx17.substr(new Rexx(1), new Rexx(n7 + n2 - 2)).OpCc(null, rexx17.substr(new Rexx(n7 + n2 + n3 - 1)));
                        rexx17 = new Rexx(rexx8).copyIndexed(rexx17);
                    }
                }
                --n;
            } else if (rexx19.OpNotEqS(null, $03)) {
                rexx18 = new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 + n3 - 1))));
                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
                --n;
            } else if (Rexx.toRexx("start").abbrev(rexx6, new Rexx(2)).toboolean()) {
                if (rexx16.substr(new Rexx(6), new Rexx(1)).toint() == 1 && rexx18.OpNotEqS(null, $03)) {
                    rexx7 = rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1 ? new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))).strip()) : new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))));
                    if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                        rexx20 = new Rexx(rexx20.strip());
                    }
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx7));
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = new Rexx(rexx7);
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                    this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                    this.metamap(rexx17, new Rexx(n));
                    rexx20 = new Rexx("");
                    rexx21 = new Rexx("");
                    rexx18 = new Rexx("");
                    rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 - 1);
                    ++n;
                    n7 = n7 + n2 - 1;
                    n2 = 1;
                }
                rexx9 = new Rexx(rexx17.substr(new Rexx(n7 + n2 - 1))).buildlist(rexx3, new Rexx(n3 + 1));
                rexx9.getnode((Rexx)Rexx.toRexx((String)"sl-start")).leaf = rexx5;
                if (rexx20.OpEqS(null, $03)) {
                    rexx20 = new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))));
                }
                if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                    rexx20 = new Rexx(rexx20.strip());
                }
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx9)).copyIndexed(rexx9);
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = rexx9;
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                this.metamap(rexx17, new Rexx(n));
                rexx20 = new Rexx("");
                rexx21 = new Rexx("");
                rexx18 = new Rexx("");
                n2 = n2 + rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() - 1;
                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2);
                if (n7 + n2 <= rexx17.length().toint()) {
                    if (rexx16.left(new Rexx(1)).toint() == 0) {
                        n4 = rexx17.substr(new Rexx(n7 + n2)).verify(rexx14, Rexx.toRexx("match")).toint();
                        if (n4 == 0) break;
                        rexx5 = Rexx.delimiterinfo(rexx17.substr(new Rexx(n7 + n2 + n4 - 1)), rexx3);
                        rexx6 = rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower();
                        n3 = rexx5.length().toint();
                        rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n4 + n3 - 1);
                        if (Rexx.toRexx("end").abbrev(rexx6, new Rexx(2)).toboolean()) {
                            if (rexx16.substr(new Rexx(7), new Rexx(1)).toint() == 1) {
                                rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx5);
                                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx6;
                                rexx17.getnode((Rexx)rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).leaf = rexx17.getnode((Rexx)new Rexx((int)n)).leaf;
                                ++n;
                            }
                            rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-end")).leaf = rexx5;
                            break;
                        }
                        n2 = n2 + n4 + n3 - 1;
                        if (Rexx.toRexx("separator").abbrev(rexx6, new Rexx(2)).toboolean() && rexx16.substr(new Rexx(2), new Rexx(1)).toint() == 0) {
                            n4 = rexx17.substr(new Rexx(n7 + n2)).verify(rexx5, Rexx.toRexx("nomatch")).toint();
                            if (n4 == 0) break;
                            n2 = n2 + n4 - 1;
                            rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n4 - 1);
                            rexx5 = Rexx.delimiterinfo(rexx17.substr(new Rexx(n7 + n2)), rexx3);
                            rexx6 = rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower();
                            if (Rexx.toRexx("end").abbrev(rexx5.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower(), new Rexx(2)).toboolean()) {
                                if (rexx16.substr(new Rexx(7), new Rexx(1)).toint() == 1) {
                                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx5);
                                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx6;
                                    rexx17.getnode((Rexx)rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).leaf = rexx17.getnode((Rexx)new Rexx((int)n)).leaf;
                                    ++n;
                                }
                                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + rexx5.length().toint());
                                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-end")).leaf = rexx5;
                                break;
                            }
                        }
                    } else {
                        rexx10 = Rexx.delimiterinfo(rexx17.substr(new Rexx(n7 + n2 + n3 - 1)), rexx3);
                        rexx11 = rexx10.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower();
                        n5 = rexx10.length().toint();
                        if (Rexx.toRexx("separator").abbrev(rexx11, new Rexx(2)).toboolean()) {
                            n2 += rexx10.length().toint();
                            rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n5);
                        } else if (Rexx.toRexx("end").abbrev(rexx6, new Rexx(2)).toboolean()) {
                            rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n5);
                            rexx12 = Rexx.delimiterinfo(rexx17.substr(new Rexx(n7 + (n2 += n5) + n3 - 1)), rexx3);
                            rexx13 = rexx12.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.lower();
                            n6 = rexx12.length().toint();
                            if (!Rexx.toRexx("separator").abbrev(rexx13, new Rexx(2)).toboolean()) break;
                            n2 += n6;
                            rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n6);
                            break;
                        }
                        n2 = n2 + n3 - 1;
                    }
                }
            } else if (Rexx.toRexx("nameseparator").abbrev(rexx6, new Rexx(1)).toboolean()) {
                if (rexx16.substr(new Rexx(6), new Rexx(1)).toint() == 1) {
                    rexx20 = new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))));
                    rexx21 = new Rexx(rexx5);
                    rexx18 = new Rexx("");
                    n2 = n2 + n3 - 1;
                } else {
                    rexx18 = new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 + n3 - 1))));
                }
                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
                --n;
            } else if (Rexx.toRexx("separator").abbrev(rexx6, new Rexx(2)).toboolean()) {
                rexx7 = rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1 ? new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))).strip()) : new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))));
                if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                    rexx20 = new Rexx(rexx20.strip());
                }
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx7));
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = new Rexx(rexx7);
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                this.metamap(rexx17, new Rexx(n));
                rexx20 = new Rexx("");
                rexx21 = new Rexx("");
                rexx18 = new Rexx("");
                if (rexx16.substr(new Rexx(7), new Rexx(1)).toint() == 1) {
                    rexx17.getnode((Rexx)new Rexx((int)(++n))).leaf = new Rexx(rexx5);
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx6;
                    rexx17.getnode((Rexx)rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).leaf = rexx17.getnode((Rexx)new Rexx((int)n)).leaf;
                }
                if (rexx16.substr(new Rexx(2), new Rexx(1)).toint() == 0) {
                    n4 = rexx17.substr(new Rexx(n7 + n2)).verify(rexx5, Rexx.toRexx("nomatch")).toint();
                    if (n4 == 0) break;
                    n2 = n2 + n4 - 1;
                }
                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
            } else {
                if (Rexx.toRexx("end").abbrev(rexx6, new Rexx(2)).toboolean()) {
                    rexx7 = rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1 ? new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))).strip()) : new Rexx(rexx18.OpCc(null, rexx17.substr(new Rexx(n7), new Rexx(n2 - 1))));
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx7));
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = new Rexx(rexx7);
                    if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                        rexx20 = new Rexx(rexx20.strip());
                    }
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                    this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                    this.metamap(rexx17, new Rexx(n));
                    rexx20 = new Rexx("");
                    rexx21 = new Rexx("");
                    rexx18 = new Rexx("");
                    rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
                    if (rexx16.substr(new Rexx(7), new Rexx(1)).toint() == 1) {
                        rexx17.getnode((Rexx)new Rexx((int)(++n))).leaf = new Rexx(rexx5);
                        rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx6;
                        rexx17.getnode((Rexx)rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).leaf = rexx17.getnode((Rexx)new Rexx((int)n)).leaf;
                    }
                    rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-end")).leaf = rexx5;
                    break;
                }
                if (rexx18.OpNotEqS(null, $03)) {
                    if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                        rexx18 = new Rexx(rexx18.strip());
                    }
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx18));
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = new Rexx(rexx18);
                    if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                        rexx20 = new Rexx(rexx20.strip());
                    }
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                    rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                    this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                    this.metamap(rexx17, new Rexx(n));
                    ++n;
                    rexx20 = new Rexx("");
                    rexx21 = new Rexx("");
                    rexx18 = new Rexx("");
                }
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx5);
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx6;
                rexx17.getnode((Rexx)rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).leaf = rexx17.getnode((Rexx)new Rexx((int)n)).leaf;
                rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf = new Rexx(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf.toint() + n2 + n3 - 1);
            }
            n7 = n7 + n2 + n3 - 1;
            if (n7 > rexx17.length().toint()) {
                if (!rexx18.OpNotEqS(null, $03)) break;
                if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                    rexx18 = new Rexx(rexx18.strip());
                }
                rexx17.getnode((Rexx)new Rexx((int)(++n))).leaf = new Rexx(rexx20.OpCc(null, rexx21).OpCc(null, rexx18));
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = new Rexx(rexx18);
                if (rexx16.substr(new Rexx(8), new Rexx(1)).toint() == 1) {
                    rexx20 = new Rexx(rexx20.strip());
                }
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx20;
                rexx17.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-namesep")).leaf = rexx21;
                this.checkextraquotes(rexx17, new Rexx(n), rexx16);
                this.metamap(rexx17, new Rexx(n));
                break;
            }
            ++n;
        }
        rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-elements")).leaf = new Rexx(n);
        Rexx rexx22 = new Rexx(rexx17.left(rexx17.getnode((Rexx)Rexx.toRexx((String)"sl-count")).leaf)).copyIndexed(rexx17);
        return rexx22;
    }

    public void checkextraquotes(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        Rexx rexx4 = null;
        if (rexx3.substr(new Rexx(9), new Rexx(1)).toint() == 1) {
            rexx4 = rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.length();
            if (rexx4.toint() > 2 && rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.substr(new Rexx(1), new Rexx(1)).OpEqS(null, $014) && rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.substr(rexx4, new Rexx(1)).OpEqS(null, $014)) {
                rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf = rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.substr(new Rexx(2), new Rexx(rexx4.toint() - 2));
                rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-wrapper")).leaf = new Rexx('\"');
            }
            if ((rexx4 = rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.length()).toint() > 2 && rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.substr(new Rexx(1), new Rexx(1)).OpEqS(null, $014) && rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.substr(rexx4, new Rexx(1)).OpEqS(null, $014)) {
                rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf = rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.substr(new Rexx(2), new Rexx(rexx4.toint() - 2));
                rexx.getnode((Rexx)rexx2).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-wrapper")).leaf = new Rexx('\"');
            }
        }
    }

    public void metamap(Rexx rexx, Rexx rexx2) {
        this.metamap(rexx, rexx2, Rexx.toRexx("0"));
    }

    public void metamap(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        Rexx rexx6 = null;
        Rexx rexx7 = null;
        int n = rexx2.toint();
        int n2 = rexx3.toint();
        String string = "w";
        Rexx rexx8 = rexx;
        if (n2 != 0) {
            rexx4 = rexx8.getnode((Rexx)new Rexx((int)n2)).leaf;
            if (rexx4.datatype(Rexx.toRexx(string)).toboolean()) {
                rexx4 = new Rexx($015.OpCc(null, rexx4));
            }
            if ((rexx5 = rexx8.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).datatype(Rexx.toRexx(string)).toboolean()) {
                rexx5 = new Rexx($015.OpCc(null, rexx5));
            }
            if ((rexx6 = rexx8.getnode((Rexx)new Rexx((int)n2)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf).datatype(Rexx.toRexx(string)).toboolean()) {
                rexx6 = new Rexx($015.OpCc(null, rexx6));
            }
            if (rexx5.OpNotEqS(null, $03)) {
                rexx8.getnode((Rexx)rexx5).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.getnode((Rexx)new Rexx((int)n2)).leaf = null;
                rexx8.getnode((Rexx)rexx5).leaf = rexx8.getnode((Rexx)rexx5).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.isindexed().toboolean() ? new Rexx(rexx8.getnode((Rexx)rexx8.getnode((Rexx)rexx5).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.minval()).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf).copyindexed(rexx8.getnode((Rexx)rexx5).leaf) : (Rexx)null;
            }
            if (rexx6.OpNotEqS(null, rexx4)) {
                rexx8.getnode((Rexx)rexx6).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.getnode((Rexx)new Rexx((int)n2)).leaf = null;
                rexx8.getnode((Rexx)rexx6).leaf = rexx8.getnode((Rexx)rexx6).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.isindexed().toboolean() ? new Rexx(rexx8.getnode((Rexx)rexx6).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.minval()).copyindexed(rexx8.getnode((Rexx)rexx6).leaf) : (Rexx)null;
            }
            rexx8.getnode((Rexx)rexx4).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.getnode((Rexx)new Rexx((int)n2)).leaf = null;
            rexx8.getnode((Rexx)rexx4).leaf = rexx8.getnode((Rexx)rexx4).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.isindexed().toboolean() ? new Rexx(rexx8.getnode((Rexx)rexx4).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.minval()).copyindexed(rexx8.getnode((Rexx)rexx4).leaf) : (Rexx)null;
        }
        if (n != 0) {
            rexx4 = rexx8.getnode((Rexx)new Rexx((int)n)).leaf;
            if (rexx4.datatype(Rexx.toRexx(string)).toboolean()) {
                rexx4 = new Rexx($015.OpCc(null, rexx4));
            }
            if ((rexx5 = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementname")).leaf).datatype(Rexx.toRexx(string)).toboolean()) {
                rexx5 = new Rexx($015.OpCc(null, rexx5));
            }
            if ((rexx6 = rexx8.getnode((Rexx)new Rexx((int)n)).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf).datatype(Rexx.toRexx(string)).toboolean()) {
                rexx6 = new Rexx($015.OpCc(null, rexx6));
            }
            if (rexx8.exists(rexx4).OpNot(null)) {
                rexx8.getnode((Rexx)rexx4).leaf = new Rexx(rexx2);
            }
            if (rexx8.getnode((Rexx)rexx4).leaf.exists(Rexx.toRexx("chain")).OpNot(null)) {
                rexx8.getnode((Rexx)rexx4).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf = Rexx.toRexx("chain");
            }
            rexx8.getnode((Rexx)rexx4).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx2);
            rexx7 = rexx8.getnode((Rexx)rexx4).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.minval();
            if (rexx8.getnode((Rexx)rexx4).leaf.OpNotEqS(null, rexx7)) {
                rexx8.getnode((Rexx)rexx4).leaf = new Rexx(rexx7).copyindexed(rexx8.getnode((Rexx)rexx4).leaf);
            }
            if (rexx6.OpNotEqS(null, rexx4)) {
                if (rexx8.exists(rexx6).OpNot(null)) {
                    rexx8.getnode((Rexx)rexx6).leaf = new Rexx(rexx2);
                }
                if (rexx8.getnode((Rexx)rexx6).leaf.exists(Rexx.toRexx("chain")).OpNot(null)) {
                    rexx8.getnode((Rexx)rexx6).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf = Rexx.toRexx("chain");
                }
                rexx8.getnode((Rexx)rexx6).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx2);
                rexx7 = rexx8.getnode((Rexx)rexx6).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.minval();
                if (rexx8.getnode((Rexx)rexx6).leaf.OpNotEqS(null, rexx7)) {
                    rexx8.getnode((Rexx)rexx6).leaf = new Rexx(rexx7).copyindexed(rexx8.getnode((Rexx)rexx6).leaf);
                }
            }
            if (rexx5.OpNotEqS(null, $03)) {
                if (rexx8.exists(rexx5).OpNot(null)) {
                    rexx8.getnode((Rexx)rexx5).leaf = rexx6;
                }
                if (rexx8.getnode((Rexx)rexx5).leaf.exists(Rexx.toRexx("chain")).OpNot(null)) {
                    rexx8.getnode((Rexx)rexx5).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf = Rexx.toRexx("chain");
                }
                rexx8.getnode((Rexx)rexx5).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.getnode((Rexx)new Rexx((int)n)).leaf = new Rexx(rexx2);
                rexx7 = rexx8.getnode((Rexx)rexx5).leaf.getnode((Rexx)Rexx.toRexx((String)"chain")).leaf.minval();
                if (rexx8.getnode((Rexx)rexx5).leaf.OpNotEqS(null, rexx8.getnode((Rexx)rexx7).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf)) {
                    rexx8.getnode((Rexx)rexx5).leaf = new Rexx(rexx8.getnode((Rexx)rexx7).leaf.getnode((Rexx)Rexx.toRexx((String)"sl-elementvalue")).leaf).copyindexed(rexx8.getnode((Rexx)rexx5).leaf);
                }
            }
        }
    }

    public Rexx buildmap(Object object, Object object2) {
        return this.buildMap(object, object2);
    }

    public Rexx buildMap(Object object, Object object2) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        if (object == null) {
            objectArray = null;
        } else if (object.getClass().isArray()) {
            objectArray = object.getClass().getComponentType().isPrimitive() ? Rexx.wrap(object) : (Object[])object;
        } else if (object instanceof List) {
            objectArray = ((List)object).toArray();
        } else {
            throw new BadArgumentException();
        }
        if (object2 == null) {
            objectArray2 = null;
        } else if (object2.getClass().isArray()) {
            objectArray2 = object2.getClass().getComponentType().isPrimitive() ? Rexx.wrap(object2) : (Object[])object2;
        } else if (object2 instanceof List) {
            objectArray2 = ((List)object2).toArray();
        } else {
            throw new BadArgumentException();
        }
        return this.setRexxMap(objectArray, objectArray2, this);
    }

    public Rexx setRexxMap(Object[] objectArray, Object[] objectArray2, Rexx rexx) {
        int n = 0;
        int n2 = 0;
        if (objectArray != null && objectArray2 != null && objectArray.length != objectArray2.length) {
            throw new BadArgumentException();
        }
        n = objectArray == null ? (objectArray2 == null ? 0 : objectArray2.length) : objectArray.length;
        int n3 = n;
        n2 = 0;
        while (n3 > 0) {
            if (objectArray == null) {
                rexx.put((Object)new Rexx(n2 + 1), objectArray2[n2].toString());
            } else if (objectArray2 == null) {
                rexx.put((Object)objectArray[n2].toString(), new Rexx(n2 + 1));
            } else {
                rexx.put((Object)objectArray[n2].toString(), objectArray2[n2].toString());
            }
            --n3;
            ++n2;
        }
        return rexx;
    }

    public static Object[] wrap(Object object) {
        int n = 0;
        Object object2 = null;
        Object[] objectArray = null;
        int n2 = Array.getLength(object);
        n = 0;
        while (n2 > 0) {
            object2 = Array.get(object, n);
            if (objectArray == null) {
                objectArray = (Object[])Array.newInstance(object2.getClass(), Array.getLength(object));
            }
            objectArray[n] = object2;
            --n2;
            ++n;
        }
        return objectArray;
    }

    public synchronized RxMap toMap() {
        return new RxMap(this);
    }

    public synchronized Rexx isindexed() {
        return this.isIndexed();
    }

    public synchronized Rexx isIndexed() {
        if (this.size(1) == 0) {
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    public synchronized int size() {
        return this.size(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int size(int n) {
        int n2 = 0;
        Enumeration enumeration = null;
        Rexx rexx = null;
        RexxNode rexxNode = null;
        if (this.coll == null) {
            return 0;
        }
        Hashtable hashtable = this.coll;
        synchronized (hashtable) {
            n2 = 0;
            enumeration = this.coll.keys();
            while (enumeration.hasMoreElements()) {
                rexx = (Rexx)enumeration.nextElement();
                rexxNode = (RexxNode)this.coll.get(rexx);
                if (rexxNode.leaf == null || rexxNode.leaf == rexxNode.initleaf) continue;
                ++n2;
                if (!new Rexx(n).toboolean()) continue;
                return 1;
            }
        }
        return n2;
    }

    public Rexx(Map map) {
        this("");
        this.putAll(map);
    }

    public void clear() {
        this.coll = null;
    }

    public boolean containsKey(Object object) {
        return this.testnode(new Rexx(object.toString()));
    }

    public boolean containsValue(Object object) {
        Rexx rexx = null;
        Rexx rexx2 = null;
        Rexx rexx3 = new Rexx(object.toString());
        if (this.coll == null) {
            return false;
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            rexx = (Rexx)enumeration.nextElement();
            rexx2 = this.getnode((Rexx)rexx).leaf;
            if (rexx2 == null || !rexx2.OpEqS(null, rexx3)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return new EntrySet(this);
    }

    public Object get(Object object) {
        if (this.testnode(new Rexx(object.toString()))) {
            return this.getnode((Rexx)new Rexx((String)object.toString())).leaf;
        }
        return null;
    }

    public boolean isEmpty() {
        if (this.coll == null) {
            return true;
        }
        return this.size(1) == 0;
    }

    public Set keySet() {
        return new KeySet(this);
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.get(new Rexx(object.toString()));
        this.getnode((Rexx)new Rexx((String)object.toString())).leaf = new Rexx(object2.toString());
        return object3;
    }

    public Object put(Object object, Rexx rexx) {
        Object object2 = this.get(new Rexx(object.toString()));
        this.getnode((Rexx)new Rexx((String)object.toString())).leaf = rexx;
        return object2;
    }

    public void putAll(Map map) {
        Map.Entry entry2 = null;
        if (map == null) {
            throw new NullPointerException();
        }
        Set set = map.entrySet();
        for (Map.Entry entry2 : set) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    public void putAll(Rexx rexx) {
        if (rexx == null) {
            throw new NullPointerException();
        }
        this.copyIndexed(rexx);
    }

    public Object remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = this.get(new Rexx(object.toString()));
        this.getnode((Rexx)new Rexx((String)object.toString())).leaf = null;
        return object2;
    }

    public Collection values() {
        return new ValueCollection(this);
    }

    public Iterator iterator() {
        return new BaseIterator(this);
    }

    static class RxMap
    extends Rexx
    implements Map {
        private final transient String $0 = "Rexx.nrx";

        public RxMap(Rexx rexx) {
            super(rexx);
            this.coll = rexx.coll;
        }
    }

    static class RexxList
    extends AbstractList {
        private final transient String $0 = "Rexx.nrx";
        public StructuredList currentlist;

        public RexxList(StructuredList structuredList) {
            this.currentlist = structuredList;
        }

        @Override
        public void add(int n, Object object) {
            if (object == null) {
                throw new NullPointerException("structured list add element");
            }
            if (this.currentlist.islist().OpNot(null)) {
                throw new Error("cannot add element to a non-list");
            }
            int n2 = this.currentlist.elementcount().toint();
            if (n < 0 || n > n2) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            this.currentlist = this.currentlist.insertelement(new Rexx(n + 1), new Rexx(object.toString()));
        }

        @Override
        public Object get(int n) {
            if (n < 0 || n > this.currentlist.elementcount().toint() - 1) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            StructuredList structuredList = this.currentlist.getelement(new Rexx(n + 1));
            return structuredList;
        }

        @Override
        public Object set(int n, Object object) {
            if (object == null) {
                throw new NullPointerException("structured list add element");
            }
            if (this.currentlist.islist().OpNot(null)) {
                throw new Error("cannot add element to a non-list");
            }
            int n2 = this.currentlist.elementcount().toint();
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            Object object2 = this.get(n);
            this.currentlist = this.currentlist.replaceelement(new Rexx(n + 1), new Rexx(object.toString()));
            return object2;
        }

        @Override
        public Object remove(int n) {
            if (this.currentlist.islist().OpNot(null)) {
                throw new Error("cannot remove element from a non-list");
            }
            int n2 = this.currentlist.elementcount().toint();
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            Object object = this.get(n);
            this.currentlist = this.currentlist.deleteelement(new Rexx(n + 1));
            return object;
        }

        @Override
        public int size() {
            if (this.currentlist.islist().OpNot(null)) {
                return 0;
            }
            int n = this.currentlist.elementcount().toint();
            return n;
        }
    }

    static class ValueIterator
    extends BaseIterator {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base2;

        public ValueIterator(Rexx rexx) {
            super(rexx);
            this.base2 = rexx;
        }

        @Override
        public Object next() {
            Rexx rexx = null;
            if (this.nxt != null || this.hasNext()) {
                rexx = this.nxt;
                this.nxt = null;
                return this.base2.getnode((Rexx)rexx).leaf;
            }
            throw new NoSuchElementException();
        }
    }

    static class ValueCollection
    extends AbstractCollection {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base;

        public ValueCollection(Rexx rexx) {
            this.base = rexx;
        }

        @Override
        public void clear() {
            this.base.clear();
        }

        @Override
        public int size() {
            return this.base.size();
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator(this.base);
        }
    }

    static class MapEntry
    implements Map.Entry {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base;
        protected Rexx key;

        public MapEntry(Rexx rexx, Rexx rexx2) {
            this.base = rexx;
            this.key = rexx2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.base.getnode((Rexx)this.key).leaf;
        }

        public Object setValue(Object object) {
            RexxNode rexxNode = this.base.getnode(this.key);
            Rexx rexx = rexxNode.leaf;
            rexxNode.leaf = new Rexx(object.toString());
            return rexx;
        }

        public Object setValue(Rexx rexx) {
            RexxNode rexxNode = this.base.getnode(this.key);
            Rexx rexx2 = rexxNode.leaf;
            rexxNode.leaf = rexx;
            return rexx2;
        }
    }

    static class EntrySetIterator
    extends BaseIterator {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base2;

        public EntrySetIterator(Rexx rexx) {
            super(rexx);
            this.base2 = rexx;
        }

        @Override
        public Object next() {
            Rexx rexx = null;
            if (this.nxt != null || this.hasNext()) {
                rexx = this.nxt;
                this.nxt = null;
                return new MapEntry(this.base2, rexx);
            }
            throw new NoSuchElementException();
        }
    }

    static class EntrySet
    extends KeySet {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base2;

        public EntrySet(Rexx rexx) {
            super(rexx);
            this.base2 = rexx;
        }

        @Override
        public void clear() {
            this.base2.clear();
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry = (Map.Entry)object;
            Object object2 = this.base2.get(entry.getKey());
            if (object2 == null) {
                return false;
            }
            return object2.equals(entry.getValue());
        }

        @Override
        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains((Map.Entry)iterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator iterator() {
            return new EntrySetIterator(this.base);
        }

        @Override
        public boolean remove(Object object) {
            if (!this.contains(object)) {
                return false;
            }
            super.remove((Rexx)((Map.Entry)object).getKey());
            return true;
        }

        @Override
        public boolean removeAll(Collection collection) {
            Map.Entry entry = null;
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                if (!this.contains(entry)) continue;
                this.remove(entry);
                n = 1;
            }
            return new Rexx(n).toboolean();
        }

        @Override
        public boolean retainAll(Collection collection) {
            Map.Entry entry = null;
            Iterator iterator = this.base2.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                if (collection.contains(entry)) continue;
                this.base2.getnode((Rexx)((Rexx)entry.getKey())).leaf = null;
                bl = true;
            }
            return bl;
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            int n = 0;
            if (objectArray == null) {
                throw new NullPointerException();
            }
            int n2 = this.base2.size();
            if (n2 > objectArray.length) {
                objectArray = new Map.Entry[n2];
            }
            Iterator iterator = this.base2.iterator();
            int n3 = n2;
            n = 0;
            while (n3 > 0 && iterator.hasNext()) {
                objectArray[n] = iterator.next();
                --n3;
                ++n;
            }
            return objectArray;
        }
    }

    static class KeySet
    implements Set {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base;

        public KeySet(Rexx rexx) {
            this.base = rexx;
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.base.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.base.containsKey(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.base.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object object) {
            return this.base.equals(object);
        }

        @Override
        public boolean isEmpty() {
            if (this.base.coll == null) {
                return true;
            }
            return this.base.size(1) == 0;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.base);
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.base.get((Rexx)object);
            this.base.getnode((Rexx)((Rexx)object)).leaf = null;
            return object2 != null;
        }

        @Override
        public boolean removeAll(Collection collection) {
            Object var4_2 = null;
            Iterator iterator = collection.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                var4_2 = iterator.next();
                if (!this.base.containsKey(var4_2)) continue;
                this.base.getnode((Rexx)((Rexx)var4_2)).leaf = null;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection collection) {
            Object var4_2 = null;
            Iterator iterator = this.base.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                var4_2 = iterator.next();
                if (collection.contains(var4_2)) continue;
                this.base.getnode((Rexx)((Rexx)var4_2)).leaf = null;
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return this.base.size();
        }

        @Override
        public Object[] toArray() {
            int n = 0;
            int n2 = this.base.size();
            Object[] objectArray = new Object[n2];
            Iterator iterator = this.base.iterator();
            int n3 = n2;
            n = 0;
            while (n3 > 0 && iterator.hasNext()) {
                objectArray[n] = iterator.next();
                --n3;
                ++n;
            }
            return objectArray;
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            int n = 0;
            if (objectArray == null) {
                throw new NullPointerException();
            }
            int n2 = this.base.size();
            if (n2 > objectArray.length) {
                objectArray = new Rexx[n2];
            }
            Iterator iterator = this.base.iterator();
            int n3 = n2;
            n = 0;
            while (n3 > 0 && iterator.hasNext()) {
                objectArray[n] = iterator.next();
                --n3;
                ++n;
            }
            return objectArray;
        }
    }

    static class BaseIterator
    implements Iterator {
        private final transient String $0 = "Rexx.nrx";
        protected Rexx base;
        protected Enumeration e;
        protected Rexx nxt = null;
        protected Rexx last = null;

        public BaseIterator(Rexx rexx) {
            this.base = rexx;
            this.e = this.base.coll == null ? (Enumeration)null : this.base.coll.keys();
        }

        @Override
        public boolean hasNext() {
            RexxNode rexxNode = null;
            if (this.nxt != null) {
                return true;
            }
            if (this.e == null) {
                return false;
            }
            while (this.e.hasMoreElements()) {
                this.nxt = (Rexx)this.e.nextElement();
                rexxNode = this.base.getnode(this.nxt);
                if (rexxNode.leaf == null || rexxNode.leaf == rexxNode.initleaf) continue;
                return true;
            }
            this.nxt = null;
            return false;
        }

        public Object next() {
            if (this.nxt != null || this.hasNext()) {
                this.last = this.nxt;
                this.nxt = null;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.base.getnode((Rexx)this.last).leaf = null;
            this.last = null;
        }
    }
}

