/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxSet;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxConvert;
import org.netrexx.process.RxConverter;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxError;
import org.netrexx.process.RxExpr;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;

public class NrNumeric
implements RxClauseParser {
    private static final Rexx $01 = new Rexx('\"');
    private static final Rexx $02 = Rexx.toRexx("=new");
    private static final Rexx $03 = new Rexx('(');
    private static final Rexx $04 = Rexx.toRexx(");");
    private static final Rexx $05 = Rexx.toRexx(");}");
    private static final Rexx $06 = new Rexx('.');
    private static final String $0 = "NrNumeric.nrx";
    private RxTranslator rxt;
    private RxParser parser;
    private RxCursor pcursor;
    private RxToken[] tokens;
    private boolean form;
    private Rexx setprop;
    private RxCode code;
    private RxExpr expr;
    private RxConvert conv;
    private RexxSet numset;

    public NrNumeric(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.parser = this.rxt.program.parser;
        this.pcursor = this.parser.cursor;
        this.tokens = this.pcursor.curclause.tokens;
        if (this.rxt.program.flag.diag) {
            RexxIO.Say("# Numeric cons  " + this.toString());
        }
        if (this.pcursor.curclass != null && this.pcursor.curclass.classinfo.isinterface) {
            throw new RxError(this.rxt, this.tokens[0], "not.allowed.in.interface");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(int n) {
        int n2 = 0;
        Rexx rexx = null;
        int n3 = 0;
        RxToken rxToken = null;
        boolean bl = false;
        if (n == 0) {
            throw new RxQuit(this.rxt, this.tokens[0], "internal.error", Rexx.toRexx("NrNumeric"), new Rexx(n));
        }
        if (this.rxt.program.flag.diag) {
            RexxIO.Say("# Numeric pass" + n + " " + this.toString());
        }
        if (n == 1) {
            return;
        }
        char c = this.tokens[1].type;
        char c2 = this.tokens[2].type;
        if (c == ';') {
            n2 = 1;
        } else if (c != 'B') {
            n2 = 1;
        } else if (c2 != 'S') {
            n2 = 2;
        } else if (this.parser.iskey(this.tokens[2].value, "DIGITS")) {
            n2 = 0;
            this.form = false;
            this.setprop = Rexx.toRexx("setDigits");
        } else if (this.parser.iskey(this.tokens[2].value, "FORM")) {
            n2 = 0;
            this.form = true;
            this.setprop = Rexx.toRexx("setForm");
        } else {
            n2 = 2;
        }
        if (n2 > 0) {
            throw new RxError(this.rxt, this.tokens[n2], "digits.or.form.expected");
        }
        RxConverter rxConverter = this.rxt.converter;
        char c3 = this.tokens[3].type;
        if (c3 == ';') {
            if (this.form) {
                this.code = new RxCode('L', RxType.STRING_TYPE, null);
                rexx = new RexxSet().formword();
                this.code.javacode = $01.OpCc(null, rexx).OpCc(null, $01);
                this.code.value = rexx.toString();
            } else {
                this.code = new RxCode('L', RxType.INT_TYPE, null);
                this.code.javacode = new Rexx(9);
                this.code.value = new Integer(9);
            }
            this.code.constant = true;
        } else {
            n3 = c3 == 'B' ? 4 : 3;
            if (this.form) {
                this.code = new RxCode('L', RxType.STRING_TYPE, null);
                if (this.tokens[n3].type != 'S') {
                    n2 = n3;
                } else if (this.parser.iskey(this.tokens[n3].value, "SCIENTIFIC")) {
                    n2 = 0;
                    rexx = Rexx.toRexx("scientific");
                    this.code.javacode = $01.OpCc(null, rexx).OpCc(null, $01);
                    this.code.value = rexx.toString();
                } else if (this.parser.iskey(this.tokens[n3].value, "ENGINEERING")) {
                    n2 = 0;
                    rexx = Rexx.toRexx("engineering");
                    this.code.javacode = $01.OpCc(null, rexx).OpCc(null, $01);
                    this.code.value = rexx.toString();
                } else {
                    n2 = n3;
                }
                if (n2 > 0) {
                    throw new RxError(this.rxt, this.tokens[n2], "scientific.or.engineering.expected");
                }
                rxToken = this.tokens[n3 + 1];
                if (rxToken.type != ';') {
                    throw new RxError(this.rxt, rxToken, "junk.on.end");
                }
                this.code.constant = true;
            } else {
                try {
                    bl = this.pcursor.curstatic;
                    if (this.pcursor.curmethod == null) {
                        this.pcursor.curstatic = true;
                    }
                    rxConverter = this.rxt.converter;
                    this.code = this.rxt.eparser.parseexpr(this.pcursor, false, n3, null, null);
                    this.expr = new RxExpr(this.rxt, this.pcursor, 11, this.code);
                    if (this.code.type.equals(RxType.INT_TYPE)) {
                        this.conv = null;
                    } else {
                        this.conv = rxConverter.assigncost(this.pcursor, RxType.INT_TYPE, this.code.type);
                        if (this.conv.cost > this.rxt.program.flag.maxassign) {
                            throw new RxError(this.rxt, this.tokens[n3], "digits.needs.int.type", this.rxt.program.babel.typeString(this.code.type));
                        }
                    }
                    this.expr.type = RxType.INT_TYPE;
                    this.expr.conv = this.conv;
                }
                finally {
                    this.pcursor.curstatic = bl;
                }
            }
        }
    }

    @Override
    public String[] getAssigns() {
        return null;
    }

    @Override
    public void generate() {
        RxCode rxCode = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        rxCode = this.expr == null ? this.code.copy() : this.expr.code.copy();
        this.rxt.converter.torexx(this.pcursor, rxCode, rxCode.constant);
        if (this.parser.level < 2) {
            ++this.pcursor.curclass.uniques;
            string = "$" + this.pcursor.curclass.uniques;
            string2 = this.pcursor.curclass.classinfo.parents == 0 ? "private static final" : (this.pcursor.curclass.classinfo.isinterface ? "private final" : "private transient final");
            string3 = this.pcursor.curclass.classset;
            string4 = string3.equals("null") ? "" : string3;
            this.rxt.program.streamer.out(Rexx.toRexx(string2).OpCcblank(null, RxType.REXXSET_CLASS).OpCcblank(null, Rexx.toRexx(string)).OpCc(null, $02).OpCcblank(null, RxType.REXXSET_CLASS).OpCc(null, $03).OpCc(null, Rexx.toRexx(string4)).OpCc(null, $04));
            this.pcursor.curclass.classset = string;
            string5 = this.pcursor.curclass.classinfo.parents == 0 ? "static" : "";
            this.rxt.program.streamer.out(Rexx.toRexx(string5 + "{" + this.pcursor.curclass.classset + ".").OpCc(null, this.setprop).OpCc(null, $03).OpCc(null, rxCode.javacode).OpCc(null, $05));
            return;
        }
        this.rxt.program.streamer.out(this.pcursor.curmethod.methodset.OpCc(null, $06).OpCc(null, this.setprop).OpCc(null, $03).OpCc(null, rxCode.javacode).OpCc(null, $04));
    }

    @Override
    public void interpret(RxCursor rxCursor) {
        if (rxCursor.curprogram.flag.diag) {
            RexxIO.Say("# Numeric exec  " + this.toString());
        }
        if (rxCursor.curmethod == null) {
            if (rxCursor.curstatic) {
                rxCursor.curnumer = rxCursor.curnumer == null ? new RexxSet() : new RexxSet(rxCursor.curnumer);
                this.numupdate(rxCursor);
                rxCursor.curclass.classrunnumer = this.numset = rxCursor.curnumer;
            } else {
                rxCursor.curnumer = this.numset;
            }
            return;
        }
        this.numupdate(rxCursor);
    }

    public void numupdate(RxCursor rxCursor) {
        if (this.form) {
            rxCursor.curnumer.setForm(Rexx.toRexx((String)this.code.value));
        } else {
            if (this.expr != null) {
                this.code = this.expr.evaluate(rxCursor);
            }
            rxCursor.curnumer.setDigits(new Rexx((Integer)this.code.value));
        }
    }
}

