//-------------------------------------------------------------------------------
// FILE: Spinbut3.cpp
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "spinbut3.h"

//-------------------------------------------------------------------------------
// VARIABLES
//-------------------------------------------------------------------------------
PSZ     achValues[] = {"-0.01        ","0.00         ","0.01         "};
PFNWP   pfnwOldProc;
//-------------------------------------------------------------------------------
// Prototypes
//-------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg  (HWND, ULONG ,MPARAM, MPARAM);
MRESULT EXPENTRY CalcSpin (HWND, ULONG ,MPARAM, MPARAM);
//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate spinbuttons. By using a dialog
// none of the usual window control has to be included.
//-------------------------------------------------------------------------------
void main(void)
     {
     HAB  hab;
     HMQ  hmq;

     hab = WinInitialize(0);
     hmq = WinCreateMsgQueue(hab,0);

     WinDlgBox(HWND_DESKTOP,
               HWND_DESKTOP,
               SpinDlg,
               NULLHANDLE,
               SPINDLG,
               0);

     WinDestroyMsgQueue(hmq);
     WinTerminate(hab);
     }

//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg(HWND hwndDlg, ULONG ulMsg, MPARAM mpParm1, MPARAM mpParm2)
     {
     switch (ulMsg)
          {
          case WM_INITDLG:
               {
               // Subclass the spinbutton with ClacSpin
               pfnwOldProc = WinSubclassWindow(WinWindowFromID(hwndDlg, SPINBUT1), CalcSpin);
               // Spinbut1 to predefined
               WinSendDlgItemMsg(hwndDlg, SPINBUT1, SPBM_SETARRAY, MPFROMP (achValues), MPFROMSHORT (3));
               // Make middle one current
               WinSendDlgItemMsg(hwndDlg, SPINBUT1, SPBM_SETCURRENTVALUE, MPFROMLONG (1), MPFROMLONG (0));
               }
          }
     return WinDefDlgProc(hwndDlg, ulMsg, mpParm1, mpParm2);
     }

//---------------------------------------------------------------------------------
// Subclass for spinbutton
//---------------------------------------------------------------------------------
MRESULT EXPENTRY CalcSpin(HWND hwndDlg, ULONG ulMsg, MPARAM mpParm1, MPARAM mpParm2)
     {
     if (ulMsg == SPBM_SPINUP || ulMsg == SPBM_SPINDOWN)
          {
          float  flSpinValue, factor;
          char   chSpinValue[12];

          WinQueryWindowText(WinQueryWindow(hwndDlg,QW_TOP),12,chSpinValue);
          flSpinValue = atof(chSpinValue);
          //-----------------------------------------------------------------------
          // Set the multiplication factor
          //-----------------------------------------------------------------------
          if (fabs(flSpinValue) < 1)
               factor = 0.01;
          else
               factor = (float) ceil(fabs(flSpinValue/50));

          sprintf(achValues[0],"%.*f", 2, flSpinValue + -factor);
          sprintf(achValues[1],"%.*f", 2, flSpinValue + 0);
          sprintf(achValues[2],"%.*f", 2, flSpinValue + factor);

          //-----------------------------------------------------------------------
          // Set the new array for the spinbutton and make the middle item the
          // cuurent one so the user can go up or down.
          //-----------------------------------------------------------------------
          pfnwOldProc(hwndDlg, SPBM_SETARRAY, MPFROMP (achValues), MPFROMSHORT(3));
          pfnwOldProc(hwndDlg, SPBM_SETCURRENTVALUE, (MPARAM)1, (MPARAM)0);
          }
     return pfnwOldProc(hwndDlg, ulMsg, mpParm1, mpParm2);
     }

