#ifndef rmxcomms_h
#define rmxcomms_h
/***************************************************************************
 *
 * MODULE:	RMX Communications API
 * SOURCE:	$Source$
 * OVERVIEW:	This file declares the low level communications
 *              functions of RMX. 
 *
 * Copyright (c) 1995 Johan Wikman
 *
 * $Log$
 *
 ***************************************************************************** 
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * THERE IS NO WARRANTY FOR THIS SOFTWARE, TO THE EXTENT PERMITTED BY
 * APPLICABLE LAW. THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
 * IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 
 *
 *****************************************************************************/

#include <stdlib.h>
#ifdef __OS2__
#    include <os2def.h>
#    ifndef RMXENTRY
#        define RMXENTRY APIENTRY
#    endif
#    ifndef PCBYTE_TYPEDEFED
         typedef const BYTE* PCBYTE;
#        define PCBYTE_TYPEDEFED
#    endif 

#    ifdef __BCPLUSPLUS__
#        define DLL_PREAMBLE extern int _multidll = 0
         extern "C" ULONG _dllmain(ULONG, HMODULE);
#        define DLLMAIN _dllmain
#    else
#        error Please specify DLL_PREAMBLE and DLLMAIN in a suitable way \
               for your compiler and add a proper ifdef here.
#    endif 
#else
#    error RMXCOMMS cannot yet be used with any other environment than OS2.
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 *
 * ORDINALS
 *
 * The following ordinals MUST be used when the functions are exported.
 *
 *****************************************************************************/

#define ORD_RMXCLOSE           1
#define ORD_RMXCONNECT         2
#define ORD_RMXCREATE          3
#define ORD_RMXCREATEUNIQUE    4
#define ORD_RMXDISCONNECT      5
#define ORD_RMXGETSERVICENAME  6
#define ORD_RMXOPEN            7
#define ORD_RMXREAD            8
#define ORD_RMXWRITE           9


/*****************************************************************************
 *
 * RETURN TYPES
 *
 * In addition to the normal OS/2 error codes some of the functions
 * may return the following codes.
 * 
 *****************************************************************************/

#define RMXERR_GENERAL		10000
#define RMXERR_ENLARGE_BUFFER   10001
#define RMXERR_UNKNOWN_SERVICE  10002


/*****************************************************************************
 *
 * PROTOTYPES
 * 
 * Some of the following functions deal with someting of type HCONNECTION. 
 * This is a void* that the API may internally decide what it actually
 * means. RMX will never do anything with the value itself, except
 * pass it around.
 *
 *****************************************************************************/

typedef void* HCONNECTION; 


ULONG RMXENTRY RmxClose          (HCONNECTION hConn);
ULONG RMXENTRY RmxConnect        (HCONNECTION hConn);
ULONG RMXENTRY RmxDisConnect     (HCONNECTION hConn);
ULONG RMXENTRY RmxGetServiceName (PCSZ   pcszService, 
				  ULONG* pulSize, 
				  PSZ    pszName);

#ifdef __cplusplus
ULONG RMXENTRY RmxCreate         (PCSZ pcszName, HCONNECTION* phConn);
#else
ULONG RMXENTRY RmxCreate         (PSZ pszName, HCONNECTION* phConn);
#endif

ULONG RMXENTRY RmxCreateUnique   (ULONG*       pulSize, 
				  PSZ          pszUniqueName,
				  HCONNECTION* phConn);

#ifdef __cplusplus
ULONG RMXENTRY RmxOpen           (PCSZ         pcszHost, 
				  PCSZ         pcszPort, 
				  HCONNECTION* phConn);
#else
ULONG RMXENTRY RmxOpen           (PSZ          pszHost, 
				  PSZ          pszPort, 
				  HCONNECTION* phConn);
#endif

ULONG RMXENTRY RmxRead           (HCONNECTION hConn, 
				  PBYTE       pbBuffer, 
				  ULONG       ulSize,
				  ULONG*      pulBytesRead);

#ifdef __cplusplus
ULONG RMXENTRY RmxWrite          (HCONNECTION hConn, 
				  PCBYTE      pcbBuffer, 
				  ULONG       ulBytesToWrite);
#else
ULONG RMXENTRY RmxWrite          (HCONNECTION hConn, 
				  PBYTE       pbBuffer, 
				  ULONG       ulBytesToWrite);
#endif

#ifdef __cplusplus
}
#endif
#endif
