{===============================} Unit Format; {=============================}

{================================} Interface {===============================}
Uses DOS;
Type
     PDBT_Type   = ^DBT_Type;
     DBT_Type    = Record
       Reserv1   : Array [0..2] of Byte;
       SizeCode  : Byte;
       LastSect  : Byte;
       Reserv2   : Array [5..7] of Byte;
       FillChar  : Char;
       Reserv3   : Word;
     End;

     F_Buf       = Record
       Track     : Byte;
       Head      : Byte;
       Sect      : Byte;
       Size      : Byte;
     End;
{
  +0      3  abJmpCode    JMP opcode to start of boot code
  +3      8  abOem        e.g., "MSDOS6.0" or "IBM  4.0"
  +0bH     2  wSectSize    bytes per sector (usually 512; 200H)
  +0dH     1  bClustSects  sectors per allocation unit (cluster)
  +0eH     2  wResSects    boot and reserved sectors
  +10H     1  bFatCnt      number of File Allocation Tables.  See FAT.
  +11H     2  wRootEntries max number of 32-byte DirEntryRecs in root
  +13H     2  wTotSects    total number of sectors in media
                           0000H means >32 MB, so use lBigTotSects
 +15H      1  bMedia       media descriptor (same as 1st byte in FAT)
 +16H      2  wFatSects    number of sectors in one FAT
 +18H      2  wSectsPerTrk sectors per track
   +0      3  abJmpCode    JMP opcode to start of boot code
   +3      8  abOem        e.g., "MSDOS6.0" or "IBM  4.0"
  +0bH     2  wSectSize    bytes per sector (usually 512; 200H)
  +0dH     1  bClustSects  sectors per allocation unit (cluster)
  +0eH     2  wResSects    boot and reserved sectors
  +10H     1  bFatCnt      number of File Allocation Tables.  See FAT.
  +11H     2  wRootEntries max number of 32-byte DirEntryRecs in root
  +13H     2  wTotSects    total number of sectors in media
                           0000H means >32 MB, so use lBigTotSects
 +15H      1  bMedia       media descriptor (same as 1st byte in FAT)
 +16H      2  wFatSects    number of sectors in one FAT
 +18H      2  wSectsPerTrk sectors per track
 +1aH      2  wHeads       number of read/write heads
 +1cH      4  lHidSects    hidden sectors (ignore hiword in pre-DOS 4.0)
 +20H      4  lBigTotSects 32-bit TotSects in volume (partitions > 32M)

 +24H      1  bDrvNo       80H=first hard disk (used internally by DOS)
 +25H      1  res1         (reserved)
 +26H      1  bExtBootSig  Extended boot record signature (always 29H)
 +27H      4  lSerNo       Volume Serial Number (based on when formatted)
 +2bH     11  abVolLabel   Volume Label (11-character, blank padded)
 +36H      8  abFileSysID  contains 'FAT12   ' or 'FAT16   ')
          62               length of formatted portion of BootSectorRec

 +3eH      ?  abBootCode   code and data that performs disk bootstrap
+2ffH                      end of boot sector

}
     PBoot       = ^Boot_l;
     Boot_l      = Record
     sectors_clust :byte;
     res_boot      :word;
     fat_count     :byte;
     root_entryes  :word;
     total_sectors :word;
     media_id      :byte;
     fat_sectors   :word;
     spt           :word;
     heads         :word;
     hidden_sectors:longint;
     large_total_s :longint;
     drivenum      :byte;
     res           :byte;
     exit_magic    :byte;
     serial        :longint;
     vollab        :array[1..11] of char;
     fat_id        :array[1..8]  of char;
     End;
const
LoaderBoot : array [1..512] of byte =
(235,60,144,72,111,114,105,122,111,110,116,0,2,1,1,0,2,224,
0,64,11,240,9,0,18,0,2,0,0,0,0,0,0,0,0,
0,0,1,41,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,70,65,84,49,50,32,32,32,250,252,51,192,142,208,188,
 0,124,142,192,190,155,125,232,31,1,187,120,0,54,197,55,30,
 86,191,43,124,185,11,0,243,164,6,31,198,69,254,15,198,69,
 249,22,137,71,2,199,7,43,124,251,205,19,114,51,185,2,0,
 186,0,1,187,0,5,184,1,2,205,19,114,35,38,131,127,26,
 2,117,28,38,129,63,73,79,116,41,38,129,63,73,66,116,34,
 38,129,63,68,82,116,27,38,129,63,72,66,116,20,190,33,125,
 232,192,0,42,228,205,22,143,6,120,0,143,6,122,0,205,25,
 128,127,11,4,116,230,190,92,125,232,166,0,190,44,0,183,7,
 185,16,0,182,1,83,180,14,50,255,176,46,205,16,91,161,24,
 124,42,193,64,59,240,119,2,139,198,80,180,2,205,19,88,114,
 184,50,228,43,240,118,20,2,248,2,248,177,1,254,198,58,54,
 26,124,114,206,254,197,182,0,235,200,190,103,125,232,94,0,138,
 46,21,124,178,0,187,33,0,184,0,0,234,0,0,112,0,13,
 10,73,110,118,97,108,105,100,32,32,115,121,115,116,101,109,32,
 32,100,105,115,107,13,10,13,10,80,114,101,115,115,32,97,110,
 121,32,107,101,121,32,116,111,32,32,99,111,110,116,105,110,117,
 101,46,46,46,13,10,0,13,10,76,111,97,100,105,110,103,32,
 0,32,79,107,46,13,10,0,80,83,172,60,0,116,9,180,14,
 187,7,0,205,16,235,242,91,88,195,63,63,63,63,63,63,63,
 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
 63,63,13,10,40,99,41,32,67,111,112,121,114,105,103,104,116,
 32,98,121,32,72,111,114,105,122,111,110,116,32,67,111,114,112,
 46,13,10,32,32,32,87,114,105,116,116,101,110,32,98,121,32,
 68,105,109,97,32,90,97,104,97,114,111,118,44,13,10,76,105,
 116,108,101,32,99,104,97,110,103,101,115,32,45,32,83,101,114,
 103,101,105,32,78,97,105,100,101,110,111,118,46,13,10,0,85,
 170);
Var
   Old           : PDBT_Type;
   DBT           : PDBT_Type;
   R             : Registers;
   BF            : Array [0..22] of F_Buf;
   DSK           : Byte;

Procedure InitFormat(Disk: Byte; NS: Word; FChar: Char);

Procedure FormatTrack(Trk: Byte);

Procedure DoneFormat;

function WriteBoot(spt:word;spc:word;sectors:word; fat_size:byte; root_size:word; media:byte ; vol:string):boolean;
{=============================} Implementation {=============================}

Procedure InitFormat(Disk: Byte; NS: Word; FChar: Char);
Begin
     Old := Ptr(MemW[0:$1E*4+2], MemW[0:$1E*4]);
     New(DBT);
     DBT^ := Old^;
     SetIntVec($1E,DBT);
     DBT^.LastSect := NS;
     DBT^.FillChar := FChar;
     DBT^.SizeCode := 2;
     DSK := Disk;
End;

Procedure FormatTrack(Trk: Byte);
Var
   I    : Byte;
   J    : Byte;
Begin
     For I := 0 to 1 do
         Begin
              For J := 1 to DBT^.LastSect do with BF[J] do
                  Begin
                       Track := Trk;
                       Sect  := J;
                       Head  := I;
                       Size  := DBT^.SizeCode;
                  End;
              R.AH := 5;
              R.AL := DBT^.LastSect;
              R.CH := Trk;
              R.CL := 1;
              R.DH := I;
              R.DL := DSK;
              R.ES := Seg(BF);
              R.BX := Ofs(BF);
              Intr($13,R);
         End;
End;

Procedure DoneFormat;
Begin
     SetIntVec($1E,Old);
End;

function WriteBoot(spt:word;spc:word;sectors:word; fat_size:byte; root_size:word; media:byte ; vol:string):boolean;
var
p:pointer;
pb:Pboot;
retrn:boolean;
begin
p:=@LoaderBoot;
Pb:=Ptr(Seg(p^),Ofs(p^)+$0d);
Pb^.serial:=MemL[$40:$6C];
Pb^.fat_sectors:=fat_size;
Pb^.total_sectors:=sectors;
Pb^.media_id:=media;
Pb^.sectors_clust:=spc;
Pb^.root_entryes:=root_size;
Pb^.drivenum:=Dsk;
Pb^.spt:=spt;
Move(vol[1],pb^.vollab,11);
retrn:=false;
asm
        mov  dl,Dsk
        push es
        les  bx,p
        mov  cx,1
        sub  dh,dh
        mov  ax,301h
        int  13h
        jnc  @not_err
        mov  retrn,1
@not_err:pop es
end;
WriteBoot:=retrn;
end;
END.