;;; LOADER FOR Horizont Present Commander
;;; (C) Horizont Corp.

.MODEL Tiny
.CODE
.STARTUP
.286
start:          call    search_comspec
		mov     es,ds:[2ch]
		xor     ax,ax                   ; Zero register
		mov     di,ax
		cld                             ; Clear direction
loc_1:          scasb                           ; Scan es:[di] for al
		jnz     loc_1                   ; Jump if not zero
		cmp     al,es:[di]
		jne     loc_1                   ; Jump if not equal
		add     di,3
		mov     si,80h
		xchg    di,si
		push    es
		pop     ds
		push    cs
		pop     es
		mov     cx,40h
		rep     movsw
		sub     ax,ax
		mov     ds,ax
		mov     es,ax
		mov     di,0BEh*4
		mov     ax,offset int_vector
		stosw
		mov     ax,cs
		stosw
		cli
		mov     ss,ax
		mov     sp,100h
		sti
		mov     es,ax
		mov     ah,4ah
		;mov     bx,prog_size
		;shr     bx,4
		;inc     bx
		mov     bx,40h
		int     21h
		mov     ah,48h
		mov     bx,0ffffh
		int     21h
		mov     ah,48h
		;mov     bx,01000h
		int     21h
		jnc     mem_ok
		int     20h
mem_ok:         mov     es,ax
		mov     cs:prog_seg,ax
		push    cs
		pop     ds
		sub     si,si
		mov     di,si
		mov     cx,128
		rep     movsw
		jmp     ok_block
run_it:         mov  dx,cs:prog_seg
		mov  es,dx
		mov  ds,dx
		cli
		mov  ss,ax
		mov  sp,0ffffh
		sti
		push cs
		pop  ds
		xor  si,si
		mov  di,si
		mov  cx,128
		rep  movsw
		push es
		pop  ds
		push es
		mov  ax,100h
		push ax
		retf
int_vector:     mov ax,cs
		mov ss,ax
		mov sp,100h
		mov es,ax
		mov di,offset cmdstore
		mov cl,ds:[si]
		inc cl
		sub ch,ch
		rep movsb
		;inc byte ptr cs:[280h]
		mov al,0dh
		stosb
		push cs
		pop  ds
		sti
		mov ah,49h
		;push cs:prog_seg
		;pop es
		mov di,cs:prog_seg
		mov es,di
		int 21h
		mov ax,cs
		mov es,ax
		mov ah,4ah
		mov bx,40h
		int 21h
		mov ax,cs
		mov cmd_seg,ax
		mov dx,cs:[2ch]
		mov envp_seg,dx
		mov cs:fcb1_seg,ax
		mov cs:fcb2_seg,ax
		mov ds,dx
		mov dx,cs:prog_spec
		mov bx,offset exec_block
		mov cs:old_ss,ss
		mov cs:old_sp,sp
		mov ax,4B00h
		int 21h
		jc  Fail3
		mov ss,cs:old_ss
		mov sp,cs:old_sp
		push cs
		pop  ds
		mov  ah,48h
		mov  bx,0ffffh
		int  21h
		mov  ah,48h
		int  21h
		jnc  ok_mem
failed:         mov  dx,offset Error_Mem
		jmp  short f_out
fail2:          mov  dx,offset Error_Dsk
		jmp  short f_out
fail3:          ;;mov  dx,cs:prog_spec
		;;mov  ds,cs:[2ch]
		;;mov  ah,9
		;;int  21h
		;;push cs
		;;pop  ds
		mov  dx,offset Error_Cmd
f_out:
		mov  ah,9
		int  21h
		mov  dx,offset Error_Msg
		mov  ah,9
		int  21h
		int  20h

ok_mem:         mov  es,ax
		mov  cs:prog_seg,ax
ok_block:       ;mov  es,ax
		;mov  cs:prog_seg,ax
		push ds
		push cs
		pop  ds
		mov  dx,80h
		mov  ax,3D00h
		int  21h
		jc   fail2
		pop  ds
		xchg ax,bx
		mov  ax,4200h
		mov  cx,0
		mov  dx,offset prog_size
		int  21h
		mov  ah,3Fh
		mov  dx,100h
		mov  cx,0f000h
		push ds
		;push cs:prog_seg
		;pop  ds
		mov  di,cs:prog_seg
		mov  ds,di
		int  21h
		pop  ds
		mov  ah,3Eh
		int  21h
		jmp  run_it
; $ *
search_comspec:
		mov es,cs:[2ch]
		xor di,di
		push cs
		pop  ds
loop_search:    push di
		mov  si,offset comspec
		mov  cx,8
		cld
		repe cmpsb
		je   s_found
		pop  di
		cmp  word ptr es:[di],0000h
		je   fatal_s
		inc  di
		jmp  loop_search
s_found:        pop  di
		add  di,8
		mov  cs:prog_spec,di
		retn
fatal_s:        jmp fail3
exec_block:
envp_seg        dw ?
cmd_offset      dw offset cmdstore
cmd_seg         dw ?
fcb1_offset     dw 5ch
fcb1_seg        dw ?
fcb2_offset     dw 6ch
fcb2_seg        dw ?
comspec         db 'COMSPEC='
;prog_spec       db 'C:\COMMAND.COM',0
prog_spec       dw 0
file_spec       dw ?
file_seg        dw ?
cmdstore        db 16 dup('   STACK');128 dup(?)
old_sp          dw ?
old_ss          dw ?
prog_seg        dw ?
Error_Mem       db 7,'! Memory$'
Error_Dsk       db 7,'! Disk$'
Error_Cmd       db 7,'! COMMAND.COM$'
Error_Msg       db ' Error',13,10,'$'
prog_size       EQU ($-100h)
END
