{
> Could someone please post some code on using a quick
> sort to sort an array of strings?

   I can do even better than that. I can give you some code on a general qsort
routine that works like in C (if you're familiar with that). I. e. you can sort
any type of arrays, if only you supply the correct compare function. Here
goes...
}

unit QSort;
{*********************************************************
 *                     QSORT.PAS                         *
 *           C-like QuickSort implementation             *
 *     Written 931118 by Bjrn Felten @ 2:203/208        *
 *           After an idea by Pontus Rydin               *
 *********************************************************}
interface
type CompFunc = function(Item1, Item2 : word) : integer;

procedure QuickSort(
    var Data;
{An array. Must be [0..Count-1] and not [1..Count] or anything else! }
    Count,
{Number of elements in the array}
    Size    : word;
{Size in bytes of a single element -- e.g. 2 for integers or words,
4 for longints, 256 for strings and so on }
    Compare : CompFunc);
{The function that decides which element is "greater" or "less". Must
return an integer that's < 0 if the first element is less, 0 if they're
equal and > 0 if the first element is greater. A simple Compare for
words can look like this:

 function WordCompare(Item1, Item2: word): integer;
 begin
     WordCompare := MyArray[Item1] - MyArray[Item2]
 end;

NB. It's not the =indices= that shall be compared, it's the elements that
the supplied indices points to! Very important to remember!
Also note that the array may be sorted in descending order just by
means of a simple swap of Item1 and Item2 in the example.}

implementation
procedure QuickSort;

  procedure Swap(Item1, Item2 : word);
  var  P1, P2 : P_filrec;
  begin
  P1:=PP.F_ptr;P2:=P1;
Inc(p1,item1*sizeof(filrec));
Inc(p2,item2*sizeof(filrec));
     if Item1 <> Item2 then begin
filesort.filename:=P1^.filename;
filesort.filesize:=P1^.filesize;
filesort.filedttm:=P1^.filedttm;
filesort.fileattr:=P1^.fileattr;
P1^.filename:=P2^.filename;
P1^.filesize:=P2^.filesize;
P1^.filedttm:=P2^.filedttm;
P1^.fileattr:=P2^.fileattr;
P2^.filename:=filesort.filename;
P2^.filesize:=filesort.filesize;
P2^.filedttm:=filesort.filedttm;
P2^.fileattr:=filesort.fileattr;
end;
  end;
  function cmprd(item1,item2:word):integer;
  var
  begin
  P1:=PP.F_ptr;P2:=p1;
  Inc(p1,item1*sizeof(filrec));
  Inc(p2,item2*sizeof(filrec));
  if ((P2^.fileattr and 16)=16) and (P1^.filename<>'..') then cmprd:=-1
  else cmprd:=1;
  end;
  function cmpr1(item1,item2:word):integer;
  var
    var  P1, P2 : P_filrec;
  begin
      P1:=PP.F_ptr;P2:=P1;
Inc(p1,item1*sizeof(filrec));
Inc(p2,item2*sizeof(filrec));
fs1:=Ptr^.filename;
fs2:=Px^.filename;
If Sort_Ext then begin
Rotate(fs1);
Rotate(fs2);
end;
  if (Fs1<Fs2) and (P1^.fileattr and 16=P2^.fileattr and 16)
  and (P2^.filename<>'..') then cmpr1:=-1
  else cmpr1:=1;
  end;

  procedure Sort(Left, Right: integer);
  var  i, j, x, y : integer;
  begin
     i := Left; j := Right; x := (Left+Right) div 2;
     repeat
        while compare(i, x) < 0 do inc(i);
        while compare(x, j) < 0 do dec(j);
        if i <= j then
        begin
           swap(i, j); inc(i); dec(j)
        end
     until i > j;
     if Left < j then Sort(Left, j);
     if i < Right then Sort(i, Right)
  end;

begin Sort(0, Count) end;

end. { of unit }

