/*
 * this program is a quick and dirty hack
 * for matrix calculations
 *
 * It is written supplementary for GammaSun OS/2
 *
 * send bugs and wishes to R.Alt@rz.tu-bs.de
 * or Reinhard Alt
 *    Cyriaksring 3
 *    38118 Braunschweig
 *    Germany
 */

#include <stdio.h>
#include <stdlib.h>

#include "global.h"
#include "makematrix.h"
#include "matrixio.h"


int main( int argc, char *argv[] )
{
    long double **left, **right, **result;
    long        dim, skip, flip, l, z, s;
    int         mode, operator, c;

    enum { FALSE, TRUE };
    enum { ADD, SUB, MUL };

    if ( argc < 8 )
    {
        fprintf( stderr, "operate by ReAlSoft Reinhard Alt (R.Alt@rz.tu-bs.de)\n"
                         "        multiply, adds and subtracts matrices in several\n"
                         "        data formats\n\n"
                         "Syntax: operate dimension <conversion type>\n"
                         "        <result matrix> = <left matrix> operator <right matrix>\n"
                         "        {[-flip], [-skip x]} \n"
                         "possible conversion types are:\n"
                         "  -hepro            trigonal matrices in ASCII for HEPRO\n"
                         "  -bintri8          binary trigonal matrix - 8 Bytes\n"
                         "  -binsquare4       binary square matrix - 4 Bytes\n"
                         "  -math             Mathematica(Tm) matrix\n"
                         "[-flip]           flip rows and columns\n"
                         "[-skip x]         skip x Bytes Header\n"
                         "possible operators are:\n"
                         "   + add\n"
                         "   - subtract\n"
                         "   x multiply   no * because of problems with Unix Shells\n\n"
                         "X-ampel: operate 128 -math result.asc = left.math x right.math\n" );
        return 1;
    }
    else
       fprintf( stdout, "converting program to ASCII matrices by ReAlSoft\n" );

    sscanf( argv[1], "%li", &dim );

    if ( strstr( argv[2], "-hepro" ) )
        mode = HEPRO;
    else
    if ( strstr( argv[2], "-bintri8" ) )
        mode = BINTRI8;
    else
    if ( strstr( argv[2], "-binsquare4" ) )
        mode = BINSQUARE4;
    else
    if ( strstr( argv[2], "-math" ) )
        mode = MATHMATRIX;
    else
    {
        fprintf( stderr, "this conversion type is not allowed!\n" );
        exit( 1 );
    }

    if ( strstr( argv[6], "+" ) )
        operator = ADD;
    else
    if ( strstr( argv[6], "-" ) )
        operator = SUB;
    else
    if ( strstr( argv[6], "x" ) )
        operator = MUL;
    else
    {
        fprintf( stderr, "this operator is not allowed!\n" );
        exit( 1 );
    }

    flip = FALSE;
    skip = 0;
    for ( l=8; l<argc; l++ )
        if ( strstr( argv[l], "-flip" ) )
            flip = TRUE;
        else
        if ( strstr( argv[l], "-skip" ) )
        {
            if ( l+1 < argc )
            {
                sscanf( argv[l+1], "%li", &skip );
                l++;
            }
            else
            {
                fprintf( stderr, "if you use skip enter an additional argument\n" );
                exit( 1 );
            }
        }
        else
        {
            fprintf( stderr, "what do you mean with %s?\n", argv[l] );
            exit( 1 );
        }

    /*** start reading matrices ***/

    left = readmatrix( argv[5], dim, mode, skip );
    right = readmatrix( argv[7], dim, mode, skip );
    result = makematrix( dim );

    for ( z=0; z<dim; z++ )
        for ( s=0; s<dim; s++ )
            switch ( operator ){
            case ADD:
                result[z][s] = left[z][s] + right[z][s];
                break;

            case SUB:
                result[z][s] = left[z][s] - right[z][s];
                break;
 
            case MUL:
                result[z][s] = 0;
                for ( l=0; l<dim; l++ )
                    result[z][s] += left[z][l] + right[l][s];
                break;
            }
 
    writematrix( result, dim, argv[3], flip );
}

