#include <stdio.h>
#include <stdlib.h>

#include "global.h"
#include "vectorio.h"
#include "makevector.h"

long double *readvector( char *filename, long dim, int mode, long skip )
{
    FILE        *fid;
    long double *vector, dummy;
    long        z, max, l;
    float       f;
    double      d;

    if ( (fid = fopen( filename, "rb" ) ) == NULL )
    {
        fprintf( stderr, "can't open input file %s\n", filename );
        exit( 1);
    }

    vector = makevector( dim );

    if ( fseek( fid, skip, SEEK_SET ) )
        fprintf( stderr, "seek error\n" );
    else
        fprintf( stderr, "%li Bytes skipped\n", skip );

    switch ( mode ) {
    case BINVECT8:
        for ( z=0; z<dim; z++ )
            if ( fread( &(vector[z]), sizeof( long double ), 1, fid ) == 0)
            {
                fprintf( stderr, "structure error in element %li\n", z );
                exit(1);
            }
        break;

    case BINVECT4:
        for ( z=0; z < dim; z++ )
        {
            if ( fread( &f, sizeof( float ), 1, fid ) == 0 )
            {
                fprintf( stderr, "structure error in element %li\n", z );
                exit(1);
            }
            vector[z] = ( long double)f;
        }
        break;

    case LONGVECT:
        for ( z=0; z < dim; z++ )
        {
            if ( fread( &l, sizeof( long ), 1, fid ) == 0 )
            {
                fprintf( stderr, "structure error in element %li\n", z );
                exit(1);
            }
            vector[z] = ( long double)l;
        }
        break;

    case MATHVECT:
        for ( z=0; z < dim; z++ )
        {
            if ( feof( fid ) )
            {
                fprintf( stderr, "structure error in element %li\n", z+1 );
                exit(1);
            }
            if ( fscanf( fid, "%Le", &vector[z] ) == 0 )
            {
                fseek( fid, 1, SEEK_CUR );
                --z;
            }
            if ( feof( fid ) )
                break;
        }
        break;

    case TARGET:
        for ( z=0; z<dim; z++ )
            if ( fscanf( fid, "%le", &(vector[z]) ) == 0)
            {
                fprintf( stderr, "structure error in element %li\n", z );
                exit(1);
            }
        break;
    }

    fclose( fid );

    return vector;
}


void writevector( long double* vector, long dim, char *filename, int flip )
{
    FILE    *fid;
    long    z, s;

    if ( (fid = fopen( filename, "wb" ) ) == NULL )
    {
        fprintf( stderr, "can't open output file %s\n", filename );
        exit( 1 );
    }

    for ( z=0; z<dim; z++ )
    {
        fprintf( fid, "%li %.19Le\n", z+1, vector[z] );
    }
    fprintf( fid,"\n" );

    fclose( fid );
}

