/** DIGEST.C Copyright (c) 2005 Axel Meiss                                 **/
/** may be distributed freely as long as copyright notice is preserved     **/
/** It is provided "as is" without express or implied warranty of any kind **/



#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define OS2
#define INCL_DOSMODULEMGR


#include <os2.h>


#include "file.h"



void main (int argc, char *argv[])
{
  long l_FileSize;
  unsigned long ulFileHandle;
  unsigned long ulErrorCode;
  unsigned char filebuffer[4096];
  unsigned char dllname[16];
  unsigned char output[4096];

  APIRET rc;
  HMODULE hModule;


  int (*digestinit)(void);
  int (*digestupdate)(unsigned char *buffer, unsigned long ulSize);
  int (*digestresult)(unsigned char *buffer);


  char *pszFileName;

  if(argc < 3)
  {
    printf("Usage: %s <method> <file> ", argv[0]);
    exit(1);
  }
  memset(dllname,0,sizeof(dllname));
  dllname[0] = 'D';
  strncat(dllname + 1,argv[1],7);
  strcat(dllname,".DLL");
  strupr(dllname);

  pszFileName = argv[2];


  rc = DosLoadModule(output,
                     sizeof(output),
                     dllname,
                     &hModule);

  if(rc != 0)
  {
    fprintf(stderr,"DLL %s error number = %ld\n",dllname, rc);
    fprintf(stderr,"type \"help SYSnnnn\" where nnnn is the error number");
    exit(2);
  }

  rc = DosQueryProcAddr(hModule,
                        0UL,
                        "DIGESTINIT",
                        (PFN *) &digestinit);

  if(rc != 0)
  {
    fprintf(stderr,"DLL Entry error number = %ld\n", rc);
    fprintf(stderr,"type \"help SYSnnnn\" where nnnn is the error number");
    (void) DosFreeModule(hModule);
    exit(2);
  }

  rc = DosQueryProcAddr(hModule,
                        0UL,
                        "DIGESTUPDATE",
                        (PFN *) &digestupdate);

  if(rc != 0)
  {
    fprintf(stderr,"DLL Entry error number = %ld\n", rc);
    fprintf(stderr,"type \"help SYSnnnn\" where nnnn is the error number");
    (void) DosFreeModule(hModule);
    exit(2);
  }


  rc = DosQueryProcAddr(hModule,
                        0UL,
                        "DIGESTRESULT",
                        (PFN *) &digestresult);

  if(rc != 0)
  {
    fprintf(stderr,"DLL Entry error number = %ld\n", rc);
    fprintf(stderr,"type \"help SYSnnnn\" where nnnn is the error number");
    (void) DosFreeModule(hModule);
    exit(2);
  }



  if((ulFileHandle = LFileOpen(pszFileName)) != 0)
  {

    (*digestinit)();

    while((l_FileSize =
           LFileRead(filebuffer,sizeof(filebuffer),ulFileHandle))
           == sizeof(filebuffer))
    {
      (*digestupdate)(filebuffer,sizeof(filebuffer));
    }

    if((ulErrorCode = LGetLastFileError()) == 0)
    {
      (*digestupdate)(filebuffer,l_FileSize);
      (*digestresult)(output);

      printf("%s", output);
      printf(" %s\n",pszFileName);

    }
    else
    {
      fprintf(stderr,"File error: %ld\n", ulErrorCode);
      fprintf(stderr,"type \"help SYSnnnn\" where nnnn is the error number");
    }

    LFileClose(ulFileHandle);
  }
  else
  {
    ulErrorCode = LGetLastFileError();
    fprintf(stderr,"File error: %ld\n", ulErrorCode);
    fprintf(stderr,"type \"help SYSnnnn\" where nnnn is the error number");


  }

  DosFreeModule(hModule);

  exit(0);
}
