#include <memory.h>   
#include <stdio.h>   
#include <string.h>   
#include <chain.h>   
#include <udp.h>
#include <pipe.h>
#include <snmp.h>
#include <sys.h>
#include <mibrqs.h>
#include <config.h>
#include "agent.h"


#define AGENT_BUFFER_SIZE       1500
#define AGENT_COMMUNITY_SIZE    255
#define AGENT_LIST_SIZE         32



static BOOLEAN      RcveUdp(UDP_DESCR *descr, CHAIN *chain, UDP_HDR *udpHdr, IP_HDR *ipHdr);
static BOOLEAN      RcvePipe(PIPE_DESCR *descr, USHORT pipe, BYTE *data, WORD length);
static BOOLEAN      Request(BYTE *rqs, WORD rqsLen, BYTE **rsp, WORD* rspLen);
static AGENT_COMM   *CommFind(BYTE *comm, WORD commLen);

AGENT_STAT agentStat;


UDP_DESCR agentUdp =
{
    RcveUdp,
    161,
    UDP_ADDR_ANY,
    UDP_PORT_ANY,
    UDP_ADDR_ANY,
    0
};

PIPE_DESCR agentPipe =
{
    RcvePipe,
    0
};




AGENT_COMM *agentCommList = 0;


BOOLEAN AgentInit(void)
{
    BYTE            name[255];
    BYTE            *p;
    USHORT          n;
    DWORD           addr;
    AGENT_COMM      *comm;
    AGENT_HOST      *host;
    WORD            i,j;
    static BOOLEAN  init = FALSE;
    
    if (!init)
    {
        i = 1;
        sprintf(name, "agent.community.%d", i);
        while (ConfigGetBytes(name, &p, &n))
        {
            comm = DnpapMalloc(sizeof(AGENT_COMM));
            if (comm!=0)
            {
                memcpy(comm->comm, p, n);
                comm->commLen   = n;
                comm->hostList  = 0;
                comm->next      = agentCommList;
                agentCommList   = comm;

                j = 1;
                sprintf(name, "agent.host.%d.%d", i, j);
                while (ConfigGetIPAddr(name, &addr))
                {
                    host = DnpapMalloc(sizeof(AGENT_HOST));
                    if (host!=0)
                    {
                        host->addr      = addr;
                        host->next      = comm->hostList;
                        comm->hostList  = host;
                    }

                    j++;
                    sprintf(name, "agent.host.%d.%d", i, j);
                }
            }
            
            i++;
            sprintf(name, "agent.community.%d", i);
        }
        
        
        if (UdpRegister(&agentUdp))
        {
            init = PipeRegister(&agentPipe);
        }
    }

    return init;
}


AGENT_STAT *AgentStatistics(void)
{
    return &agentStat;
}


BOOLEAN AgentSendTrap (BYTE *comm, WORD commLen, WORD gen,
                       WORD spec, SNMP_OBJECT *list, WORD listLen)
{
    BYTE            buffer[AGENT_BUFFER_SIZE];
    BYTE            *trapBuffer;
    WORD            trapLen;
    SNMP_PDU        pdu;
    UDP_HDR         udpHdr;
    IP_HDR          ipHdr;
    CHAIN           new;
    AGENT_COMM      *descr;
    AGENT_HOST      *host;
    DWORD           addr;
    BOOLEAN         success = FALSE;
    SNMP_OBJECT      object = {SNMP_PDU_GET, {1,3,6,1,2,1,1,2,0}, 9};

    if (MibRequest("public", 6, &object)==SNMP_NOERROR)
    {
    
        pdu.Type            = SNMP_PDU_TRAP;
        pdu.Trap.General    = gen;
        pdu.Trap.Specific   = spec;
        pdu.Trap.Time       = SysTime();
        pdu.Trap.IdLen      = object.SyntaxLen;
        memcpy(pdu.Trap.Id, object.Syntax.BufInt,
            object.SyntaxLen * sizeof(object.Syntax.BufInt[0]));

        descr=CommFind(comm, commLen);
        if (descr!=0)
        {
            success = TRUE;
            for (host=descr->hostList; host!=0; host=host->next)
            {
                addr = IpRouteFindSrc(host->addr);
                
                pdu.Trap.IpAddress = IpH2NDWord(addr);
                
                udpHdr.src  = UDP_PORT_ANY;
                udpHdr.dst  = 162;

                ipHdr.dst   = host->addr;
                ipHdr.src   = addr;
                ipHdr.iol   = 0;
                ipHdr.tos   = 0;
                
                trapBuffer  = buffer;
                trapLen     = sizeof(buffer);
                if (SnmpEnc(&trapBuffer,
                    &trapLen,
                    &pdu,
                    comm,
                    commLen,
                    list,
                    listLen))
                {
                    ChainAlloc(&new, buffer, sizeof(buffer),
                                            trapLen, trapBuffer-buffer, 0);
                    success = success && UdpSend(&new, &udpHdr, &ipHdr);
                }
            }
        }
    }
    return success;
}

static BOOLEAN RcveUdp(UDP_DESCR *descr, CHAIN *chain, UDP_HDR *udpHdr, IP_HDR *ipHdr)
{
    WORD    port;
    DWORD   addr;
    BYTE    buffer[AGENT_BUFFER_SIZE];
    CHAIN   new;
    BYTE    *rqsBuffer;
    WORD    rqsLen;
    CHAIN   *rqsChain;
    BYTE    *rspBuffer;
    WORD    rspLen;
    CHAIN   *rspChain;
    BOOLEAN success = FALSE;
    

    rqsChain    = chain;
    rqsLen      = ChainLength(rqsChain);
    rqsBuffer   = ChainPop(&rqsChain, rqsLen);

    if (rqsBuffer!=0)
    {
        rspChain    = &new;
        rspBuffer   = buffer;
        rspLen      = sizeof(buffer);

        if (Request(rqsBuffer, rqsLen, &rspBuffer, &rspLen))
        {
            ChainAlloc(rspChain, buffer, sizeof(buffer),
                                    rspLen, rspBuffer-buffer, 0);
            
            port        = udpHdr->src;
            udpHdr->src = udpHdr->dst;
            udpHdr->dst = port;

            addr        = ipHdr->src;
            ipHdr->src  = ipHdr->dst;
            ipHdr->dst  = addr;

            success = UdpSend(rspChain, udpHdr, ipHdr);

        }
        if (rqsChain != chain)
            ChainFree(rqsChain);
    }
    
    
    if (success)
        agentStat.datagrams++;
    else
        agentStat.errors++;

    return success;
}

static BOOLEAN RcvePipe(PIPE_DESCR *descr, USHORT pipe, BYTE *data, WORD length)
{
    BYTE    buffer[AGENT_BUFFER_SIZE];
    BYTE    *rspBuffer;
    WORD    rspLen;
    BOOLEAN success = FALSE;

    rspBuffer = buffer;
    rspLen    = sizeof(buffer);

    if (Request(data, length, &rspBuffer, &rspLen))
    {
        success = PipeSend(pipe, rspBuffer, rspLen);
    }
    
    if (success)
        agentStat.datagrams++;
    else
        agentStat.errors++;

    return success;
}




BOOLEAN Request(BYTE *rqsBuffer, WORD rqsLen,
                    BYTE **rspBuffer, WORD* rspLen)
{
    
    SNMP_PDU    pdu;
    BYTE        comm[AGENT_COMMUNITY_SIZE];
    WORD        commLen;
    SNMP_OBJECT list[AGENT_LIST_SIZE];
    WORD        listLen;
    BOOLEAN     success;
    WORD        status,index;

    success = FALSE;
    if (SnmpDec(rqsBuffer,
                rqsLen,
                &pdu,
                comm,
                AGENT_COMMUNITY_SIZE,
                &commLen,
                list,
                AGENT_LIST_SIZE,
                &listLen))
    {
        if (pdu.Type == SNMP_PDU_GET ||
            pdu.Type == SNMP_PDU_NEXT ||
            pdu.Type == SNMP_PDU_SET)
        {
            status = SNMP_NOERROR;
            for (index = 0;
                 index < listLen && status == SNMP_NOERROR;
                 index++)
            {
                list[index].Request = pdu.Type;
                status = MibRequest(comm, commLen, list + index);
            }
            
            if (status == SNMP_NOERROR)
            {
                pdu.Request.ErrorStatus = SNMP_NOERROR;
                pdu.Request.ErrorIndex  = 0;
            }
            else
            {
                pdu.Request.ErrorStatus = status;
                pdu.Request.ErrorIndex  = index;
            }
            
            pdu.Type = SNMP_PDU_RESPONSE;
            
            if (SnmpEnc(rspBuffer,
                        rspLen,
                        &pdu,
                        comm,
                        commLen,
                        list,
                        listLen))
            {
                success = TRUE;
            }
        }
    }
    else
    {
        if (snmpErrStatus == SNMP_TOOBIG)
        {
            pdu.Type                = SNMP_PDU_RESPONSE;
            pdu.Request.ErrorStatus = SNMP_TOOBIG;
            pdu.Request.ErrorIndex  = 0;
            
            if (SnmpEnc(rspBuffer,
                        rspLen,
                        &pdu,
                        comm,
                        commLen,
                        0,
                        0))
            {
                success = TRUE;
            }
        }
    }
    return success;
}





static AGENT_COMM *CommFind(BYTE *comm, WORD commLen)
{
    AGENT_COMM *p;

    for (p=agentCommList; p!=0; p=p->next)
    {
        if (p->commLen == commLen &&
            memcmp(p->comm, comm, commLen)==0)
            break;
    }
    return p;
}
