#ifndef _HOSTC_H
#define _HOSTC_H


#include <dnpap.h>
#include <snmp.h>

#include "hash.h"

/*  hostx.h exposes the HOST structure  */
#include "hostx.h"


typedef struct _HOST_CONTROL
{
    LONG            Index;
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    LONG            TableSize;
    ULONG           LastDeleteTime;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;
    
    MAC_COLL        Coll;
    MAC_IFACE       *Iface;
    
    HashTable	    *Table;
    
    HOST	        *LexList;
    
    HOST	        *TimeList;
    HOST	        *TimeLast;
    HOST	        **TimeTable;
    BOOLEAN			TimeListUpdated;
    
    HOST            *LRUList;
    HOST            *LRULast;
    
} HOST_CONTROL;


BOOLEAN HostConfigInit(VOID);

BOOLEAN HostCInit(HOST_CONTROL *hostcontrol);
BOOLEAN HostCStart(HOST_CONTROL *hostcontrol);
BOOLEAN HostCStop(HOST_CONTROL *hostcontrol);

HOST* HostHashSearch(HOST_CONTROL *hostcontrol, HOST *host, WORD len);
HOST* HostHashSearch2(HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen);
HOST* HostTimeSearch(HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen);
LONG  HostSearchCreationOrder(HOST_CONTROL *hostcontrol, HOST *host);


#endif

