/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       matrix_m.c
**     SYSTEM   NAME:       matrix
**     ORIGINAL AUTHOR(S):  Richard Kooijman
**     VERSION  NUMBER:     0.99
**     CREATION DATE:       1992/9/25
**
** DESCRIPTION: matrix group of the RMON MIB
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/


#include <dnpap.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <message.h>
#include <mibsup.h>
#include <mac.h>

#include "matrix_d.h"
#include "matrix_e.h"
#include "matrix_c.h"
#include "matrix.h"


#define CONTROLINDEXSIZE   1
#define SRCDSTINDEXSIZE   13


static MIB_LOCAL    *MatrixControlInstance = NULL;


static BOOLEAN RmonNext(SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, SRCDST **elem, BOOLEAN SDorder);
static SRCDST *SrcDstGetFirstNext(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first, BOOLEAN SDorder);



BOOLEAN MatrixMInit(VOID)
{
    MessageConfig(MATRIX_ERROR, "Matrix");
    return MatrixConfigInit();
}


BOOLEAN RmonNext(SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, SRCDST **elem, BOOLEAN SDorder)
{
BOOLEAN first = FALSE;

    if (*local == NULL || indexsize < 1)
        return FALSE;

    if (obj->IdLen < idlen + indexsize)
    {
        switch (indexsize)
        {
        case SRCDSTINDEXSIZE:
            while (*local != NULL && (*elem = SrcDstGetFirstNext((MATRIX_CONTROL*)(*local)->Data, obj, idlen, first, SDorder)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + SRCDSTINDEXSIZE;
            break;
        case CONTROLINDEXSIZE:
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    else
    {
        switch (indexsize)
        {            
        case SRCDSTINDEXSIZE:
            while (*local != NULL && (*elem = SrcDstGetFirstNext((MATRIX_CONTROL*)(*local)->Data, obj, idlen, first, SDorder)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + SRCDSTINDEXSIZE;
            break;
        case CONTROLINDEXSIZE:
            *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    return FALSE;
}


SRCDST *SrcDstGetFirstNext(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first, BOOLEAN SDorder)
{
BYTE srcdst[2*HOST_SZEADDR];
SRCDST *p;
INT i, len;

    if (matrixcontrol->TableSize == 0)
        return NULL;

    if (first == TRUE)
        if (SDorder == TRUE)
        {
            p = matrixcontrol->SrcDstList;
            for (i = 0; i < 2*HOST_SZEADDR; i++)
                obj->Id[idlen+1+i] = (LONG)p->SrcDst[i];
            return p;
        }
        else
        {
            p = matrixcontrol->DstSrcList;
            for (i = 0; i < HOST_SZEADDR; i++)
            {
                obj->Id[idlen+1+i] = (LONG)p->SrcDst[HOST_SZEADDR+i];
                obj->Id[idlen+1+HOST_SZEADDR+i] = (LONG)p->SrcDst[i];
            }
            return p;
        }

    len = obj->IdLen-idlen-1;
    if (len < 0)
        len = 0;

    /*  fill in srcdst in both orders: SDorder or reverse  */
    for (i = 0; i < len; i++)
        srcdst[i] = (BYTE)obj->Id[idlen+1+i];

    p = MatrixHashSearch(matrixcontrol, srcdst, len, SDorder);

    if (len == 2*HOST_SZEADDR && p != NULL)
        if (SDorder == TRUE)
            p = p->SrcDstNext;
        else
            p = p->DstSrcNext;

    if (p != NULL)
    {
        if (SDorder == TRUE)
        {
            for (i = 0; i < 2*HOST_SZEADDR; i++)
                obj->Id[idlen+1+i] = (LONG)p->SrcDst[i];
        }
        else
        {
            for (i = 0; i < HOST_SZEADDR; i++)
            {
                obj->Id[idlen+1+i] = (LONG)p->SrcDst[HOST_SZEADDR+i];
                obj->Id[idlen+1+HOST_SZEADDR+i] = (LONG)p->SrcDst[i];
            }
        }
        obj->IdLen = idlen + SRCDSTINDEXSIZE;
    }
    return p;
}


WORD MatrixControlIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixControlDataSource(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;
MAC_IFACE    *iface;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {           
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        memcpy(obj->Syntax.BufInt, data->Source, data->SourceLen*sizeof(data->Source[0]));
        obj->SyntaxLen = data->SourceLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (MATRIX_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (data->SourceLen != obj->SyntaxLen ||
            memcmp(data->Source, obj->Syntax.BufInt, (data->SourceLen-1)*sizeof(data->Source[0])) != 0)
            return SNMP_BADVALUE;
        if ((iface = MacIfaceGet((WORD) obj->Syntax.BufInt[obj->SyntaxLen-1])) == NULL)
            return SNMP_BADVALUE;
        memcpy(data->Source, obj->Syntax.BufInt, obj->SyntaxLen*sizeof(data->Source[0]));
        data->SourceLen = obj->SyntaxLen;
        data->Iface = iface;
        return SNMP_NOERROR;
    }
}


WORD MatrixControlTableSize(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngInt = data->TableSize;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixControlLastDeleteTime(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngUns = data->LastDeleteTime;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixControlOwner(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        memcpy (obj->Syntax.BufChr, data->Owner, data->OwnerLen);
        obj->SyntaxLen = data->OwnerLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (MATRIX_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        memcpy (data->Owner, obj->Syntax.BufChr, obj->SyntaxLen);
        data->OwnerLen = obj->SyntaxLen;
        return SNMP_NOERROR;
    }
}


WORD MatrixControlStatus(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE);

    switch (obj->Request)
    {
    case SNMP_PDU_GET:
        if (local == NULL)
        {
            obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
        {
            obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        if (local == NULL)
        {
            switch (obj->Syntax.LngInt)
            {
            case SNMP_CREATEREQUEST:
                if ((local = MibInsert(obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
                    return SNMP_GENERROR;
                if ((local->Data = DnpapMalloc(sizeof(MATRIX_CONTROL))) == NULL)
                    return SNMP_GENERROR;
                data = (MATRIX_CONTROL*) local->Data;
                memset(data, 0, sizeof(MATRIX_CONTROL));
                if (MatrixCInit(data) == TRUE)
                {
                    data->Status = SNMP_UNDERCREATION;
                    DnpapMessage(DMC_MESSAGE, MATRIX_CREATE, "matrix: collector %ld created", local->Index);
                    return SNMP_NOERROR;
                }
                DnpapFree(local->Data);
                MibRemove (obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE);
                return SNMP_GENERROR;
            default:
                return SNMP_NOSUCHNAME;
            }
        }
        data = (MATRIX_CONTROL*) local->Data;
        switch (data->Status)
        {
        case SNMP_UNDERCREATION:
            switch (obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                if (MatrixCStart(data) == TRUE)
                {
                    data->Status = SNMP_VALID;
                    DnpapMessage(DMC_MESSAGE, MATRIX_START, "matrix: collector %ld active", local->Index);
                    return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            case SNMP_INVALID:
                if (MatrixCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, MATRIX_DESTROY, "matrix: collector %ld destroyed", local->Index);
                    if (MibRemove (obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        case SNMP_VALID:
            switch (obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                return SNMP_NOERROR;
            case SNMP_INVALID:
                if (MatrixCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, MATRIX_DESTROY, "matrix: collector %ld destroyed", local->Index);
                    if (MibRemove (obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        }
    }
}


WORD MatrixSDSourceAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->SrcDst, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixSDDestAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->SrcDst+HOST_SZEADDR, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixSDIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixSDPkts(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Pkts;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixSDOctets(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Octets;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixSDErrors(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Errors;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixDSSourceAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->SrcDst, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixDSDestAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->SrcDst+HOST_SZEADDR, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixDSIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixDSPkts(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Pkts;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixDSOctets(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Octets;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD MatrixDSErrors(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
SRCDST     *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = MatrixHashSearch2(local->Data, obj, idlen, FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Errors;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


