#include <dnpap.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <message.h>
#include <mibsup.h>
#include <mac.h>

#include "dhoste.h"
#include "dhostc.h"
#include "dhost.h"


#define CONTROLINDEXSIZE   		1
#define HOSTINDEXSIZE      		7
#define TIMEINDEXSIZE      		2
#define HOSTBUCKETINDEXSIZE     8
#define TIMEBUCKETINDEXSIZE     3


static MIB_LOCAL    *HostControlInstance = NULL;


static BOOLEAN RmonNext (SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, DNPAP_HOST **elem);

static DNPAP_HOST* HostGetFirstNext(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first);
static DNPAP_HOST* HostBucketGetFirstNext(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first);
static DNPAP_HOST* HostTimeBucketGetFirstNext(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first);



BOOLEAN DnpapHostMInit(VOID)
{
    MessageConfig(DNPAP_HOST_ERROR, "DnpapHost");
    return DnpapHostConfigInit();
}


BOOLEAN RmonNext (SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, DNPAP_HOST **elem)
{
BOOLEAN first = FALSE;

    if (*local == NULL || indexsize < 1)
        return FALSE;

    if (obj->IdLen < idlen + indexsize)
    {
        switch (indexsize)
        {
        case HOSTBUCKETINDEXSIZE:
            while (*local != NULL && (*elem = HostBucketGetFirstNext((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + HOSTBUCKETINDEXSIZE;
        	break;
        case HOSTINDEXSIZE:
            while (*local != NULL && (*elem = HostGetFirstNext((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + HOSTINDEXSIZE;
            break;
        case TIMEBUCKETINDEXSIZE:
            while (*local != NULL && (*elem = HostTimeBucketGetFirstNext((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + TIMEBUCKETINDEXSIZE;
        	break;
        case TIMEINDEXSIZE:
            while (*local != NULL && ((DNPAP_HOST_CONTROL*)(*local)->Data)->TableSize == 0)
                *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->Id[idlen+1] = 1;
            obj->IdLen = idlen + TIMEINDEXSIZE;
            *elem = DnpapHostTimeSearch((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen);
            break;
        case CONTROLINDEXSIZE:
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    else
    {
        switch (indexsize)
        {            
        case HOSTBUCKETINDEXSIZE:
            while (*local != NULL && (*elem = HostBucketGetFirstNext((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + HOSTBUCKETINDEXSIZE;
        	break;
        case HOSTINDEXSIZE:
            while (*local != NULL && (*elem = HostGetFirstNext((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + HOSTINDEXSIZE;
            break;
        case TIMEBUCKETINDEXSIZE:
            while (*local != NULL && (*elem = HostTimeBucketGetFirstNext((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + TIMEBUCKETINDEXSIZE;
        	break;
        case TIMEINDEXSIZE:
            if (obj->Id[idlen+1] < ((DNPAP_HOST_CONTROL*)(*local)->Data)->TableSize)
            {
                obj->Id[idlen] = (*local)->Index;
                obj->Id[idlen+1]++;
                obj->IdLen = idlen + TIMEINDEXSIZE;
            	*elem = DnpapHostTimeSearch((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen);
                break;
            }
            *local = (*local)->Next;
            while (*local != NULL && ((DNPAP_HOST_CONTROL*)(*local)->Data)->TableSize == 0)
                *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->Id[idlen+1] = 1;
            obj->IdLen = idlen + TIMEINDEXSIZE;
            *elem = DnpapHostTimeSearch((DNPAP_HOST_CONTROL*)(*local)->Data, obj, idlen);
            break;
        case CONTROLINDEXSIZE:
            *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    return FALSE;
}


DNPAP_HOST *HostGetFirstNext(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first)
{
DNPAP_HOST host, *p;
INT i, len;

    if (hostcontrol->TableSize == 0)
        return NULL;

    if (first == TRUE)
    {          
        p = hostcontrol->LexList;
        for (i = 0; i < HOST_SZEADDR; i++)
            obj->Id[idlen+1+i] = (LONG)p->Address[i];
        obj->IdLen = idlen + HOSTINDEXSIZE;
        return p;
    }

    len = obj->IdLen-idlen-1;
    if (len < 0)
        len = 0;

    for (i = 0; i < len; i++)
        host.Address[i] = (BYTE)obj->Id[idlen+1+i];

    p = DnpapHostHashSearch(hostcontrol, &host, len);

    if (len == HOST_SZEADDR && p != NULL)
        p = p->LexNext;

    if (p != NULL)
    {
        for (i = 0; i < HOST_SZEADDR; i++)
            obj->Id[idlen+1+i] = (LONG)p->Address[i];
        obj->IdLen = idlen + HOSTINDEXSIZE;
    }
    return p;
}


DNPAP_HOST* HostBucketGetFirstNext(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first)
{
DNPAP_HOST host, *p;
INT i, len;

    if (hostcontrol->TableSize == 0)
        return NULL;

    if (first == TRUE)
    {          
        p = hostcontrol->LexList;
        for (i = 0; i < HOST_SZEADDR; i++)
            obj->Id[idlen+1+i] = (LONG)p->Address[i];
        obj->Id[idlen+1+HOST_SZEADDR+1] = 1;
        obj->IdLen = idlen + HOSTBUCKETINDEXSIZE;
        return p;
    }

    len = obj->IdLen-idlen-2;
    if (len < 0)
        len = 0;
                                            
    for (i = 0; i < len; i++)
        host.Address[i] = (BYTE)obj->Id[idlen+1+i];

    p = DnpapHostHashSearch(hostcontrol, &host, len);
                      
    if (p != NULL)
    {
        if (len == HOST_SZEADDR)
        {
            if (obj->Id[idlen+HOST_SZEADDR+1] < hostcontrol->NrBuckets)
                obj->Id[idlen+HOST_SZEADDR+1]++;
            else                                
            {
                if ((p = p->LexNext) != NULL)
                    obj->Id[idlen+HOST_SZEADDR+1] = 1;
            }
        }
        else
            obj->Id[idlen+HOST_SZEADDR+1] = 1;
    }

    if (p != NULL)
    {
        for (i = 0; i < HOST_SZEADDR; i++)
            obj->Id[idlen+1+i] = (LONG)p->Address[i];
        obj->IdLen = idlen + HOSTINDEXSIZE;
    }
    return p;
}


DNPAP_HOST* HostTimeBucketGetFirstNext(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first)
{
INT len;

    if (hostcontrol->TableSize == 0)
        return NULL;

    if (first == TRUE)
    {          
        obj->Id[idlen+1] = 1;
        obj->Id[idlen+1+1] = 1;
        obj->IdLen = idlen + TIMEBUCKETINDEXSIZE;
        return DnpapHostTimeSearch(hostcontrol, obj, idlen);
    }

    len = obj->IdLen-idlen;

    switch (len)
    {
    case 0:
        obj->Id[idlen+1] = 1;
        obj->Id[idlen+1+1] = 1;
        break;
    case 1:
        if (obj->Id[idlen+1] < hostcontrol->TableSize)
            obj->Id[idlen+1]++;
        else
            return NULL;    
        obj->Id[idlen+1+1] = 1;
        break;
    case 2:
        if (obj->Id[idlen+1+1] < hostcontrol->NrBuckets)
            obj->Id[idlen+1+1]++;                      
        else
        {
            if (obj->Id[idlen+1] < hostcontrol->TableSize)
                obj->Id[idlen+1]++;
            else
                return NULL;    
            obj->Id[idlen+1+1] = 1;
        }
        break;
    }         
    
    obj->IdLen = idlen + TIMEBUCKETINDEXSIZE;
    return DnpapHostTimeSearch(hostcontrol, obj, idlen);
}


WORD DnpapHostControlIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlDataSource (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;
MAC_IFACE    *iface;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {           
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        memcpy (Obj->Syntax.BufInt, data->Source, data->SourceLen * sizeof (LONG));
        Obj->SyntaxLen = data->SourceLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (data->SourceLen != Obj->SyntaxLen ||
            memcmp(data->Source, Obj->Syntax.BufInt, (data->SourceLen-1) * sizeof (LONG)))
            return SNMP_BADVALUE;
        if ((iface = MacIfaceGet((WORD) Obj->Syntax.BufInt[Obj->SyntaxLen-1])) == NULL)
            return SNMP_BADVALUE;
        memcpy (data->Source, Obj->Syntax.BufInt, Obj->SyntaxLen * sizeof (LONG));
        data->SourceLen = Obj->SyntaxLen;
        data->Iface = iface;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlTableSize (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->TableSize;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlLastDeleteTime (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngUns = data->LastDeleteTime;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlAcceptType (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->AcceptType;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (Obj->Syntax.LngInt != 1 && Obj->Syntax.LngInt != 2)
            return SNMP_BADVALUE;
        data->AcceptType = Obj->Syntax.LngInt;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlMatches (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
        case SNMP_PDU_NEXT:
            if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
                return SNMP_NOSUCHNAME;
        case SNMP_PDU_GET:
            data = (DNPAP_HOST_CONTROL*) local->Data;
            Obj->Syntax.LngInt = data->Matches;
            return SNMP_NOERROR;
        case SNMP_PDU_SET:
            return SNMP_READONLY;
    }
}


WORD DnpapHostControlNrBuckets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->NrBuckets;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (Obj->Syntax.LngInt < 1)
            return SNMP_BADVALUE;
        data->NrBuckets = Obj->Syntax.LngInt;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlInterval (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->Interval;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (Obj->Syntax.LngInt < 1)
            return SNMP_BADVALUE;
        data->Interval = Obj->Syntax.LngInt;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlOwner (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        memcpy (Obj->Syntax.BufChr, data->Owner, data->OwnerLen);
        Obj->SyntaxLen = data->OwnerLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        memcpy (data->Owner, Obj->Syntax.BufChr, Obj->SyntaxLen);
        data->OwnerLen = Obj->SyntaxLen;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostControlStatus (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_HOST_CONTROL *data;

    local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE);

    switch (Obj->Request)
    {
    case SNMP_PDU_GET:
        if (local == NULL)
        {
            Obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
        {
            Obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (DNPAP_HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        if (local == NULL)
        {
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_CREATEREQUEST:
                if ((local = MibInsert(Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
                    return SNMP_GENERROR;
                if ((local->Data = DnpapMalloc(sizeof(DNPAP_HOST_CONTROL))) == NULL)
                    return SNMP_GENERROR;
                data = (DNPAP_HOST_CONTROL*) local->Data;
                if (DnpapHostCInit(data) == TRUE)
                {
                    data->Index = local->Index;
                    data->Status = SNMP_UNDERCREATION;
                    DnpapMessage(DMC_MESSAGE, DHOST_CREATE, "dhost: collector %ld created", local->Index);
                    return SNMP_NOERROR;
                }
                DnpapFree(local->Data);
                MibRemove (Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE);
                return SNMP_GENERROR;
            default:
                return SNMP_NOSUCHNAME;
            }
        }
        data = (DNPAP_HOST_CONTROL*) local->Data;
        switch (data->Status)
        {
        case SNMP_UNDERCREATION:
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                if (DnpapHostCStart(data) == TRUE)
                {
                    data->Status = SNMP_VALID;
                    DnpapMessage(DMC_MESSAGE, DHOST_START, "dhost: collector %ld active", local->Index);
                    return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            case SNMP_INVALID:
                if (DnpapHostCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, DHOST_DESTROY, "dhost: collector %ld destroyed", local->Index);
                    if (MibRemove (Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        case SNMP_VALID:
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                return SNMP_NOERROR;
            case SNMP_INVALID:
                if (DnpapHostCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, DHOST_DESTROY, "dhost: collector %ld destroyed", local->Index);
                    if (MibRemove (Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        }
    }
}


WORD DnpapHostAddress (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (Obj->Syntax.BufChr, data->Address, Obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    }
}


WORD DnpapHostCreationOrder (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngInt = DnpapHostSearchCreationOrder(local->Data, data);
        return SNMP_NOERROR;
    }
}


WORD DnpapHostIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InOctets;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutOctets;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutErrors (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutErrors;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutBroadcastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBroadcastPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutMulticastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutMulticastPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInTCPPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InTCPPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutTCPPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutTCPPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInOtherPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InOtherPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutOtherPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutOtherPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts64 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket1Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts65to127 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket2Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts128to255 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket3Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts256to511 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket4Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts512to1023 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket5Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostInPkts1024to1518 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket6Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts64 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket1Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts65to127 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket2Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts128to255 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket3Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts256to511 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket4Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts512to1023 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket5Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostOutPkts1024to1518 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket6Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostIATPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTBUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTBUCKETINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->IATBuckets[Obj->Id[IdLen+HOST_SZEADDR+1]-1];
        return SNMP_NOERROR;
    }
}


WORD DnpapHostISTPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTBUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTBUCKETINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->ISTBuckets[Obj->Id[IdLen+HOST_SZEADDR+1]-1];
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeAddress (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (Obj->Syntax.BufChr, data->Address, Obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeCreationOrder (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngInt = Obj->Id[IdLen+1];
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InOctets;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutOctets;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutErrors (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutErrors;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutBroadcastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBroadcastPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutMulticastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutMulticastPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInTCPPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InTCPPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutTCPPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutTCPPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInOtherPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InOtherPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutOtherPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutOtherPkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts64 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket1Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts65to127 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket2Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts128to255 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket3Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts256to511 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket4Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts512to1023 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket5Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeInPkts1024to1518 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InBucket6Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts64 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket1Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts65to127 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket2Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts128to255 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket3Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts256to511 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket4Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts512to1023 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket5Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeOutPkts1024to1518 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBucket6Pkts;
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeIATPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEBUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEBUCKETINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->IATBuckets[Obj->Id[IdLen+HOST_SZEADDR+1]-1];
        return SNMP_NOERROR;
    }
}


WORD DnpapHostTimeISTPkts(SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
DNPAP_HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEBUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEBUCKETINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DnpapHostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->ISTBuckets[Obj->Id[IdLen+HOST_SZEADDR+1]-1];
        return SNMP_NOERROR;
    }
}

