#ifndef PROTOCOL_H
#define PROTOCOL_H


#include <dnpap.h>
#include <snmp.h>

#define PROT_TYPE          0

#define PROT_PKTUNKNOWN    0
#define PROT_PKTBEHOLDER   1
#define PROT_PKTETHERNET   2
#define PROT_PKTIP         3
#define PROT_PKTTCP        4
#define PROT_PKTUDP        5
#define PROT_PKTICMP       6
#define PROT_PKTARP        7
#define PROT_PKTRARP       8
#define PROT_PKTDNS        9


typedef union   _PROT_FRAME PROT_FRAME;
typedef struct  _PROT_PKT   PROT_PKT;



struct _PROT_PKT
{
    BYTE            *Ptr;
    PROT_FRAME      *Frame;
    PROT_PKT        *Child;
    WORD            DataLen;
    WORD            ChildProt;
};


typedef struct _PROT_OBJ
{
    WORD            Level;
    LONG            Id[SNMP_SIZE_OBJECTID];
    BYTE            *ProtStr;
    BYTE            *FieldStr;
    WORD            Type;
    SNMP_SYNTAX      Syntax;
    WORD            SyntaxLen;
} PROT_OBJ;

typedef struct _PROT_PTR
{
    BYTE            *Name;
    BOOLEAN         (*Header) (PROT_PKT *Pkt);
    BOOLEAN         (*Field) (PROT_PKT *Pkt, PROT_OBJ *Obj);
    BOOLEAN         (*Print) (PROT_OBJ *Obj, BYTE **StrPtr);
    BYTE            **String;
    WORD            StringLen;
} PROT_PTR;


typedef struct _PROT_BEHOLDER
{
    WORD        Type;                       /*  1 : SNMP_GAUGE */
    WORD        IfIndex;                    /*  2 : SNMP_GAUGE */
    LONG        ID;                         /*  3 : ID */
    WORD        Size;                       /*  4 : SNMP_GAUGE */    
    WORD        Len;                        /*  5 : SNMP_GAUGE */    
    LWORD       Time;                       /*  6 : SNMP_TIMETICKS */
    BYTE FAR    *Data;                      /*  7 : SNMP_NULL */
} PROT_BEHOLDER;                                

typedef struct _PROT_ETHERNET
{
    BYTE        *DstAdr;                    /*  1  : SNMP_OCTETSTR */
    BYTE        *SrcAdr;                    /*  2  : SNMP_OCTETSTR */
    BYTE        *Type;                      /*  3  : SNMP_GAUGE */
    BYTE FAR    *Data;                      /*  4  : SNMP_NULL */
} PROT_ETHERNET;

typedef struct _PROT_IP
{
    BYTE        *Vers;                      /*  1  : SNMP_GAUGE */
    BYTE        *HLen;                      /*  2  : SNMP_GAUGE */
    BYTE        *Service;                   /*  3  : SNMP_GAUGE */
    BYTE        *TLen;                      /*  4  : SNMP_GAUGE */
    BYTE        *ID;                        /*  5  : SNMP_GAUGE */
    BYTE        *Flags;                     /*  6  : SNMP_GAUGE */
    BYTE        *Fragment;                  /*  7  : SNMP_GAUGE */
    BYTE        *Time;                      /*  8  : SNMP_TIMETICKS */
    BYTE        *Type;                      /*  9  : SNMP_GAUGE */
    BYTE        *ChkSum;                    /*  10 : SNMP_GAUGE */
    BYTE        *IPSrc;                     /*  11 : SNMP_IPADDR */
    BYTE        *IPDst;                     /*  12 : SNMP_IPADDR */
    BYTE        *IPOption;                  /*  13 : SNMP_OCTETSTR */
    BYTE FAR    *Data;                      /*  14 : SNMP_NULL */
} PROT_IP;

typedef struct _PROT_ARP
{
    BYTE        *Hardw;                     /*  1  : SNMP_GAUGE */
    BYTE        *Type;                      /*  2  : SNMP_GAUGE */
    BYTE        *HLen;                      /*  3  : SNMP_GAUGE */
    BYTE        *PLen;                      /*  4  : SNMP_GAUGE */
    BYTE        *Operation;                 /*  5  : SNMP_GAUGE */
    BYTE        *HwSender;                  /*  6  : SNMP_OCTETSTR */
    BYTE        *ProtSender;                /*  7  : SNMP_OCTETSTR */
    BYTE        *HwTarget;                  /*  8  : SNMP_OCTETSTR */
    BYTE        *ProtTarget;                /*  9  : SNMP_OCTETSTR */
    BYTE FAR    *Data;                      /*  10 : SNMP_NULL */
} PROT_ARP;                                         

typedef struct _PROT_UDP
{
    BYTE        *SrcPort;                   /*  1  : SNMP_GAUGE */
    BYTE        *DstPort;                   /*  2  : SNMP_GAUGE */
    BYTE        *MLen;                      /*  3  : SNMP_GAUGE */
    BYTE        *ChkSum;                    /*  4  : SNMP_GAUGE */
    BYTE FAR    *Data;                      /*  5  : SNMP_NULL */
} PROT_UDP;

typedef struct _PROT_TCP
{
    BYTE        *SrcPort;                   /*  1  : SNMP_GAUGE */
    BYTE        *DstPort;                   /*  2  : SNMP_GAUGE */
    BYTE        *SeqNr;                     /*  3  : SNMP_GAUGE */
    BYTE        *AckNr;                     /*  4  : SNMP_GAUGE */
    BYTE        *HLen;                      /*  5  : SNMP_GAUGE */
    BYTE        *Reserved;                  /*  6  : SNMP_GAUGE */
    BYTE        *Code;                      /*  7  : SNMP_GAUGE */
    BYTE        *Window;                    /*  8  : SNMP_GAUGE */
    BYTE        *ChkSum;                    /*  9  : SNMP_GAUGE */
    BYTE        *UrgePtr;                   /*  10 : SNMP_GAUGE */
    BYTE        *Option;                    /*  11 : SNMP_OCTETSTR */
    BYTE FAR    *Data;                      /*  12 : SNMP_NULL */
} PROT_TCP;

typedef struct _PROT_ICMP
{
    BYTE        *Type;                      /*  1  : SNMP_GAUGE */
    BYTE        *Code;                      /*  2  : SNMP_GAUGE */
    BYTE        *ChkSum;                    /*  3  : SNMP_GAUGE */
    BYTE FAR    *Data;                      /*  4  : SNMP_NULL */
} PROT_ICMP;

typedef struct _PROT_DNS
{
    BYTE        *ID;                        /*  1  : SNMP_GAUGE */
    BYTE        *Parameter;                 /*  2  : SNMP_GAUGE */
    BYTE        *NroQuest;                  /*  3  : SNMP_GAUGE */
    BYTE        *NroAnsw;                   /*  4  : SNMP_GAUGE */
    BYTE        *NroAuth;                   /*  5  : SNMP_GAUGE */
    BYTE        *NroAdd;                    /*  6  : SNMP_GAUGE */
    BYTE        *Entry;                     /*  7,8,9,10  : variable */
    BYTE FAR    *Data;                      /* 11  : SNMP_NULL */
} PROT_DNS;

union _PROT_FRAME
{
    PROT_BEHOLDER    Beholder;
    PROT_ETHERNET    Ethernet;
    PROT_IP          Ip;
    PROT_TCP         Tcp;
    PROT_UDP         Udp;
    PROT_ICMP        Icmp;
    PROT_ARP         Arp;
    PROT_DNS         Dns;
};


#define PROT_NETWORD(Word, BytePtr)                     \
    (Word) = (LWORD) (BytePtr)[0];                      \
    (Word) <<= 8;                                       \
    (Word) |= (LWORD) (BytePtr)[1];

#define PROT_NETLWORD(LWord, BytePtr)                   \
    (LWord) = (LWORD) (BytePtr)[0];                     \
    (LWord) <<= 24;                                     \
    (LWord) |= (LWORD) (BytePtr)[1];                    \
    (LWord) <<= 16;                                     \
    (LWord) = (LWORD) (BytePtr)[2];                     \
    (LWord) <<= 8;                                      \
    (LWord) |= (LWORD) (BytePtr)[3];


BOOLEAN ProtInit(VOID);
VOID    ProtFree (PROT_PKT *Pkt);
VOID    ProtExit(VOID);
BOOLEAN ProtFrame (PROT_PKT *Pkt, BYTE *frame, USHORT size,
            USHORT length, ULONG time, USHORT type, USHORT index);
BOOLEAN ProtFile (PROT_PKT *Pkt, BYTE FAR *PktPtr);
BOOLEAN ProtGetField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtStringNr (PROT_OBJ *Obj);
BOOLEAN ProtPrint (PROT_OBJ *Obj, BYTE **StrPtr);


#endif
