#ifndef _IP_H_
#define _IP_H_

#include <dnpap.h>
#include <chain.h>
#include <mac.h>
#include <arp.h>



#define IP_PROT_ICMP    1
#define IP_PROT_GGP     3
#define IP_PROT_TCP     6
#define IP_PROT_EGP     8
#define IP_PROT_IGP     9
#define IP_PROT_CHAOS   16
#define IP_PROT_UDP     17
#define IP_PROT_TP4     29


#define IP_ADDR_THIS    0L


#define IP_TOS_PREC_MASK		    0x07
#define IP_TOS_PREC_ROUTINE	      	0x00
#define IP_TOS_PREC_PRIORITY		0x01
#define IP_TOS_PREC_IMMEDIATE		0x02
#define IP_TOS_PREC_FLASH		    0x03
#define IP_TOS_PREC_FLASH_OVERIDE	0x04
#define IP_TOS_PREC_CRITIC		    0x05
#define IP_TOS_PREC_CTRL		    0x06
#define IP_TOS_PREC_CTRL_NETWORK	0x07

#define	IP_TOS_LOW_DELAY		    0x08
#define	IP_TOS_HIGH_TROUGHPUT		0x10
#define	IP_TOS_HIGH_RELIABILITY 	0x20

#define IP_FLAG_RESERVED            0x04
#define IP_FLAG_DONT_FRAGMENT       0x02
#define IP_FLAG_MORE_FRAGMENTS      0x01


#define IP_OPTION_END               0x00
#define IP_OPTION_NOP               0x01
#define IP_OPTION_SECURITY          0x02
#define IP_OPTION_ROUTE_LOOSE       0x03
#define IP_OPTION_ROUTE_RECORD      0x07
#define IP_OPTION_STREAM            0x08
#define IP_OPTION_ROUTE_STRICT      0x09
#define IP_OPTION_TIME_STAMP        0x44

#define IP_OPTION_COPY              0x80



typedef struct  _IP_PROT            IP_PROT;
typedef struct  _IP_HDR             IP_HDR;
typedef struct  _IP_IFACE           IP_IFACE;


struct _IP_PROT
{
	BOOLEAN (*Rcve)(CHAIN *chain, IP_HDR *ipHdr);
    BYTE    prot;
    IP_PROT *next;
};


struct _IP_HDR
{
    BYTE        ver;
    WORD        ihl;
    BYTE	    tos;
    WORD        length;
	WORD	    id;
	BYTE	    flags;
    WORD        offset;
    BYTE        ttl;
    BYTE        prot;
    WORD        check;
    DWORD       src;
    DWORD       dst;
    WORD        iol;
    BYTE        *options;
};



struct _IP_IFACE
{
    MAC_IFACE       *iface;
    DWORD           addr;
    DWORD           mask;
    BOOLEAN         up;
    DWORD           addrNet;
    DWORD           addrBroadcast;
    ARP_DESCR       *arp;
    IP_IFACE        *next;
};


BOOLEAN     IpInit(void);



WORD        IpH2NWord(WORD w);
WORD        IpN2HWord(WORD w);
DWORD       IpH2NDWord(DWORD d);
DWORD       IpN2HDWord(DWORD d);
WORD        IpHdrCheck(CHAIN *chain, WORD length);

BOOLEAN     IpIfaceRegister(IP_IFACE *iface);
void        IpIfaceRemove(IP_IFACE *iface);
void        IpIfaceSwitch(IP_IFACE *iface, BOOLEAN up);



BOOLEAN     IpRouteAdd( DWORD           addr,
                        DWORD           mask,
                        DWORD           addrNextHop,
                        MAC_IFACE       *iface,
                        WORD            metric);
DWORD       IpRouteFindSrc(DWORD dst);


BOOLEAN     IpProtRegister(IP_PROT *prot);
void        IpProtRemove(IP_PROT *prot);


BOOLEAN     IpSend(CHAIN *chain, IP_HDR *ipHdr);

#endif
