#include <dnpap.h>
#include <memory.h>
#include <string.h>
#include <agent.h>
#include <mibsup.h>
#include <mibrqs.h>

#include "register.h"


static BYTE message[SNMP_SIZE_BUFCHR] = "";
static WORD msglen = 0;

static SNMP_OBJECT list[] =
{
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,1,0}, 9},
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,2,0}, 9},
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,3,0}, 9},
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,4,0}, 9},
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,5,0}, 9},
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,6,0}, 9},
    {SNMP_PDU_GET, {1,3,6,1,2,1,1,7,0}, 9},
    {SNMP_PDU_GET, {BTNG_MIB,4,1,0}, BTNG_MIBLEN+3}
};

static WORD listlen = sizeof(list)/sizeof(list[0]);

static BYTE community[SNMP_SIZE_COMM] = "dnpap";
static WORD commlen = 5;



BOOLEAN RegisterInit(VOID)
{
    return TRUE;
}


WORD RegisterBeholderMessage(SNMP_OBJECT *obj, WORD idlen)
{
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
    case SNMP_PDU_GET:
        memcpy(obj->Syntax.BufChr, message, obj->SyntaxLen = msglen);
        break;
    case SNMP_PDU_SET:
        memcpy(message, obj->Syntax.BufChr, msglen = obj->SyntaxLen);
        break;
    }
    return SNMP_NOERROR;
}


WORD RegisterBeholder(SNMP_OBJECT *obj, WORD idlen)
{
WORD i;

    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
    case SNMP_PDU_GET:
        memcpy(obj->Syntax.BufChr, community, obj->SyntaxLen = commlen);
        break;
    case SNMP_PDU_SET:
        for (i = 0; i < listlen; i++)
            if (MibRequest(REQUESTCOMMUNITY, strlen(REQUESTCOMMUNITY), &list[i]) != SNMP_NOERROR)
                return SNMP_GENERROR;
        if (obj->SyntaxLen > 0)
            memcpy(community, obj->Syntax.BufChr, commlen = obj->SyntaxLen);
	    if (AgentSendTrap(community, commlen, REGISTERCODE, REGISTERSPECIFIC, list, listlen) == FALSE)
            DnpapMessage(DMC_WARNING, REGISTER_TRAPFAIL, "register: trap send failed");
        break;
    }
    return SNMP_NOERROR;
}
