#ifndef _HASH_H
#define _HASH_H


#include <dnpap.h>


#define MAX_HASH_SIZE           16384
#define MAX_BUCKET_SIZE         4096


typedef  UINT  HashKey;

typedef  HashKey (*HashFunction)(BYTE*, UINT, UINT);


typedef struct BucketEntry_
{
   BYTE  *Key;
   UINT   KeySize;
   VOID  *Contents;

   struct BucketEntry_  *Prev;
   struct BucketEntry_  *Next;

} BucketEntry;


typedef struct
{
   UINT          Size;
   UINT          Occupied;
   UINT          Total;
   HashFunction  HashFunc;
   BucketEntry **Table;

} HashTable;



HashTable  *NewHash(UINT size, HashFunction hf);
VOID        DelHash(HashTable *ht);

VOID       *HashAdd(HashTable *ht, BYTE *key, UINT n, VOID *data);
VOID       *HashRemove(HashTable *ht, BYTE *key, UINT n);
VOID       *HashSearch(HashTable *ht, BYTE *key, UINT n);


#endif
