/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  
**     VERSION  NUMBER:     
**     CREATION DATE:       
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision: 1.1 $
** AUTHOR:   $Author: etstjan $
** DATE:     $Date: 1992/08/03 19:25:32 $
** LOG:      $Log: test.c,v $
** Revision 1.1  1992/08/03  19:25:32  etstjan
** Initial revision
**
*************************************************************************/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <dnpap.h>

#include "maxmem.h"


#define NRBLOCKS    100


void main(int argc, char *argv[])
{
    LONG i, count;
    VOID *p,*q;
    BYTE *t;
    VOID *r[NRBLOCKS];

	/* test the Memory functions */

    ConfigInit(argc, argv);
    ConfigLoad();

    MemoryInit(0, 0);

	DnpapMessage(DMC_MESSAGE,0,"starting Tester\n");

    DnpapMessage(DMC_MESSAGE,3,"MemoryGetAvail: %ld\n", MemoryGetAvail());
    DnpapMessage(DMC_MESSAGE,4,"MemoryGetMaxChunk: %ld\n", MemoryGetMaxChunk());
    DnpapMessage(DMC_MESSAGE,5,"MemoryGetUsed: %ld\n", MemoryGetMaxMemory()-MemoryGetAvail());

	DnpapMessage(DMC_MESSAGE,1,"allocating 4 bytes\n");
    p=DnpapMalloc(4);
	DnpapMessage(DMC_MESSAGE,1,"releasing 4 bytes\n");
    DnpapFree(p);

	DnpapMessage(DMC_MESSAGE,1,"allocating 16 bytes\n");
    t=DnpapMalloc(16);
	DnpapMessage(DMC_MESSAGE,1,"filling 17 bytes\n");
    for (i=0;i<17;i++)
        t[i] = 15;
	DnpapMessage(DMC_MESSAGE,1,"releasing 16 bytes\n");
    DnpapFree(t);

	DnpapMessage(DMC_MESSAGE,1,"allocating 16 bytes\n");
    t=DnpapMalloc(16);
	DnpapMessage(DMC_MESSAGE,1,"filling byte -1\n");
    t[-1] = 15;
	DnpapMessage(DMC_MESSAGE,1,"releasing 16 bytes\n");
    DnpapFree(t);

	DnpapMessage(DMC_MESSAGE,1,"allocating 2000 bytes\n");
    p=DnpapMalloc(2000);
	DnpapMessage(DMC_MESSAGE,2,"allocating 20000 bytes\n");
    q=DnpapMalloc(20000);

    for (i = 0; i < NRBLOCKS; i++)
        r[i] = NULL;

    count = 0;
    for (i = 0; i < NRBLOCKS; i++)
    {
        r[i] = DnpapMalloc(1000);
        if (!r[i])
        {
            if (p)
            {
                DnpapFree(p);
                p=NULL;
            }
            else
            if (q)
            {
                DnpapFree(q);
                q=NULL;
            }
            else
            {
                DnpapMessage(DMC_MESSAGE,6,"Number of blocks allocated: %d\n", count);
                break;
            }
        }
        else
            count++;
    }

    DnpapMessage(DMC_MESSAGE,6,"Number of blocks allocated: %d\n", count);

    for (i = 0; i < NRBLOCKS; i++)
    {
        DnpapFree(r[i]);
        r[i] = NULL;
    }

    for (count = 0; count < 100000; count++)
    {
        i = rand() % NRBLOCKS;
        if (r[i] == NULL)
            r[i] = DnpapMalloc(53);
        else
        {
            if ((rand() % 10) > 5)
                r[i] = DnpapRealloc(r[i], 1053);
            else
            {
                DnpapFree(r[i]);
                r[i] = NULL;
            }
        }
    }

    for (i = 0; i < NRBLOCKS; i++)
    {
        DnpapFree(r[i]);
        r[i] = NULL;
    }

    DnpapMessage(DMC_MESSAGE,3,"MemoryGetAvail: %ld\n", MemoryGetAvail());
    DnpapMessage(DMC_MESSAGE,4,"MemoryGetMaxChunk: %ld\n", MemoryGetMaxChunk());
    DnpapMessage(DMC_MESSAGE,5,"MemoryGetUsed: %ld\n", MemoryGetMaxMemory()-MemoryGetAvail());

	DnpapExit(0);					
}
