!include ..\..\include\standard.mak

SYS     = timer
SYSLIB  = dnpap

all: obj 

install: all $(INCDIR)\$(SYS).h $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj;

obj: $(SYS).obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c $(SYS2).c
    $(MAN) -R:API  $(SYS).c > $(SYS).man

$(SYS).obj: $(SYS).c $(SYS).h

test.exe: test.obj $(SYS).obj $(SYS).h
    $(LINK) test.obj dnpap.lib
    markexe windowcompat test.exe
