!include ..\include\standard.mak

SYS     = mgmt
SYSLIB  = mgmt

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj pipe.obj udp.obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj -+pipe.obj -+udp.obj;

obj: $(SYS).obj pipe.obj udp.obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c pipe.c udp.c
    $(MAN) -R:API  $(SYS).c pipe.c udp.c > $(SYS).man

test.exe: test.obj test.ini
	$(LINK) test.obj dnpap.lib
	markexe windowcompat test.exe
