#include <malloc.h>
#include <memory.h>
#include <dnpap.h>
#include "list.h"


LIST_DESC *ListCreate(USHORT listSize, USHORT elemSize, USHORT keySize)
{
    USHORT n;
    LIST_DESC *list;

    if ((list=malloc(sizeof(LIST_DESC)))==0)
        return 0;
    n=listSize*sizeof(LIST_ELEM *);
    if ((list->array=malloc(n))==0)
        return 0;
    memset(list->array,0,n);
    list->listSize=listSize;
    list->elemSize=elemSize;
    list->keySize=keySize;
    list->first=(LIST_DESC *)0;
    return list;

}

BYTE *ListFind(LIST_DESC *list, BYTE *key, USHORT hash, BOOLEAN create, BOOLEAN *new)
{
    LIST_ELEM *p, **q;

    hash %= list->listSize;
    p=list->array[hash];
    while(p!=0)
    {
        if (memcmp(key,p->key,list->keySize)==0)
        {
            *new=FALSE;
            return p->key;
        }
        p = p->nextHash;
    }
    if (create)
    {
        *new=TRUE;
        p=malloc(list->elemSize+sizeof(LIST_ELEM)-1);
        if (p==0)
            return 0;
        memcpy(p->key,key,list->keySize);
        p->nextHash=list->array[hash];
        list->array[hash]=p;
        for(q=&list->first;(*q)!=(LIST_DESC *)0;q=&(*q)->next)
        {
            if(memcmp(key,(*q)->key,list->keySize)<0)
                break;
        }
        p->next=*q;
        *q=p;
        return p->key;
    }
    return 0;
}

VOID ListDestroy(LIST_DESC *list)
{
    free(list->array);
    free(list);
}


BYTE *ListFirst(LIST_DESC *list)
{
    list->current=list->first;
    return ((list->current!=0)?list->current->key:0);
}

BYTE *ListNext(LIST_DESC *list)
{
    list->current=list->current->next;
    return ((list->current!=0)?list->current->key:0);
}
