#include <stddef.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protARPString[] =
{
    "HARDWARE_TYPE",      
    "PROTOCOL_TYPE",  
    "HLEN",           
    "PLEN",          
    "OPERATION",      
    "SENDER_HARDWARE",
    "SENDER_PROTOCOL",
    "TARGET_HARDWARE",
    "TARGET_PROTOCOL"
};

static WORD HPLen;
 
BOOLEAN ProtARPHeader (PROT_PKT *Pkt)
{
    if (Pkt->DataLen < 8)
        return (FALSE);

    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_ARP))) == NULL)
        return (FALSE);
    Pkt->Frame->Arp.Hardw = Pkt->Ptr;
    Pkt->Frame->Arp.Type = Pkt->Ptr + 2;
    Pkt->Frame->Arp.HLen = Pkt->Ptr + 4;
    Pkt->Frame->Arp.PLen = Pkt->Ptr + 5;

    HPLen = 2*(*(Pkt->Frame->Arp.HLen)) + 2*(*(Pkt->Frame->Arp.PLen) + 8);
    if (Pkt->DataLen < HPLen)
        return FALSE;
    
    Pkt->Frame->Arp.Operation = Pkt->Ptr + 6;
    Pkt->Frame->Arp.HwSender = Pkt->Ptr + 8;
    Pkt->Frame->Arp.ProtSender = Pkt->Ptr + 8 + *(Pkt->Frame->Arp.HLen);
    Pkt->Frame->Arp.HwTarget = Pkt->Ptr + 8;
    Pkt->Frame->Arp.HwTarget += *(Pkt->Frame->Arp.HLen) + *(Pkt->Frame->Arp.PLen);
    Pkt->Frame->Arp.ProtTarget = Pkt->Ptr + 8;
    Pkt->Frame->Arp.ProtTarget += 2*(*(Pkt->Frame->Arp.HLen)) + *(Pkt->Frame->Arp.PLen);
    Pkt->Frame->Arp.Data = Pkt->Ptr + 8;
    Pkt->Frame->Arp.Data += 2*(*(Pkt->Frame->Arp.HLen)) + 2*(*(Pkt->Frame->Arp.PLen));

    Pkt->ChildProt = PROT_PKTUNKNOWN;
    return TRUE;
}

BOOLEAN ProtARPField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = Pkt->ChildProt;
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTARP || Obj->Id[0] == PROT_PKTRARP)
    {
        switch (Obj->Id[1])
        {
           case 1:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Arp.Hardw)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Arp.Type)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Arp.HLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 4:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Arp.PLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 5:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Arp.Operation)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 6:
                Obj->Type = SNMP_OCTETSTR;
                Obj->SyntaxLen  = (WORD) (*(Pkt->Frame->Arp.HLen));
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Arp.HwSender, Obj->SyntaxLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 7:
                Obj->Type = SNMP_OCTETSTR;
                Obj->SyntaxLen  = (WORD) (*(Pkt->Frame->Arp.PLen));
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Arp.ProtSender, Obj->SyntaxLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 8:
                Obj->Type = SNMP_OCTETSTR;
                Obj->SyntaxLen  = (WORD) (*(Pkt->Frame->Arp.HLen));
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Arp.HwTarget, Obj->SyntaxLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 9:
                Obj->Type = SNMP_OCTETSTR;
                Obj->SyntaxLen  = (WORD) (*(Pkt->Frame->Arp.PLen));
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Arp.ProtTarget, Obj->SyntaxLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 10:
                Obj->Type = SNMP_NULL;
                if (Pkt->DataLen <= HPLen)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - HPLen;
                Obj->SyntaxLen = 0;
                Obj->Syntax.Ptr = Pkt->Frame->Tcp.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            default:
                return (FALSE);
        }
    }
    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Arp.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - HPLen;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtARPPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    WORD Ind;
    BYTE Char[4];

    switch (Obj->Id[1])
    {
        
        case 1:                                     /* Hardw */
        case 5:                                     /* Operation */
            sprintf(protocolString, "%4lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 2:                                     /* Protocol */
            sprintf(protocolString, "%04lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 3:                                     /* HLen */
        case 4:                                     /* PLen */
            sprintf(protocolString, "%2lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 6:                                     /* Hw Sender */
        case 8:                                     /* Hw Target */
            *protocolString = '\0';
            for (Ind = 0; Ind < Obj->SyntaxLen; Ind++)
            {
                sprintf(Char, "%02x",Obj->Syntax.BufChr[Ind]);
                strcat(protocolString, Char);
                if (Ind < Obj->SyntaxLen-1)
                    strcat(protocolString, ":");
            }
            *StrPtr = protocolString;
            return (TRUE);
        case 7:                                     /* Prot Sender */
        case 9:                                     /* Prot Target */
            *protocolString ='\0';
            for (Ind = 0; Ind < Obj->SyntaxLen; Ind++)
            {
                sprintf(Char, "%u",Obj->Syntax.BufChr[Ind]);
                strcat(protocolString, Char);
                if (Ind < Obj->SyntaxLen-1)
                    strcat(protocolString, ".");
            }
            *StrPtr = protocolString;
            return (TRUE);
        default:
            return (FALSE);
    }
}
