#include <stddef.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protICMPString[] =
{
    "TYPE",    
    "CODE",    
    "CHECKSUM"
};

BOOLEAN ProtICMPHeader (PROT_PKT *Pkt)
{
    if (Pkt->DataLen < 4)
        return FALSE;
    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_ICMP))) == NULL)
        return (FALSE);
    Pkt->Frame->Icmp.Type = Pkt->Ptr;
    Pkt->Frame->Icmp.Code = Pkt->Ptr + 1;
    Pkt->Frame->Icmp.ChkSum = Pkt->Ptr + 2;
    Pkt->Frame->Icmp.Data = Pkt->Ptr + 4;
    
    Pkt->ChildProt = PROT_PKTUNKNOWN;
    return (TRUE);

}

BOOLEAN ProtICMPField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = (LWORD) Pkt->ChildProt;
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTICMP)
    {
        switch (Obj->Id[1])
        {
            case 1:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Icmp.Type);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Icmp.Code);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Icmp.ChkSum)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 4:
                Obj->Type = SNMP_NULL;           /* only total field */
                if (Pkt->DataLen <= 4)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - 4;
                Obj->Syntax.Ptr = Pkt->Frame->Icmp.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            default:
                return (FALSE);
        }
    }

    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Icmp.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - 4;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtICMPPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    switch (Obj->Id[1])
    {
        case 1:                             /* Type */
        case 2:                             /* Code */
            sprintf(protocolString, "%2lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 3:                             /* ChkSum */
            sprintf(protocolString, "%04lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        default:
            return (FALSE);
    }
}

