#ifndef PROTOCOL_H
#define PROTOCOL_H

#include <dnpap.h>
#include <mac.h>
#include <snmp.h>

typedef struct _PROT_OBJ
{
    WORD            Level;
    LONG            Id[SNMP_SIZE_OBJECTID];
    BYTE            *ProtStr;
    BYTE            *FieldStr;
    WORD            Type;
    SNMP_SYNTAX     Syntax;
    WORD            SyntaxLen;
} PROT_OBJ;

typedef union   _PROT_FRAME *PROT_FRAME;
typedef struct  _PROT_PKT   PROT_PKT;

struct _PROT_PKT
{
    BYTE            *Ptr;
    PROT_FRAME      Frame;
    PROT_PKT        *Child;
    WORD            DataLen;
    WORD            ChildProt;
};

typedef struct _PROT_PTR
{
    BYTE            *Name;
    BOOLEAN         (*Header) (PROT_PKT *Pkt);
    BOOLEAN         (*Field) (PROT_PKT *Pkt, PROT_OBJ *Obj);
    BOOLEAN         (*Print) (PROT_OBJ *Obj, BYTE **StrPtr);
    BYTE            **String;
    WORD            StringLen;
} PROT_PTR;

#define PROT_NETWORD(Word, BytePtr)                     \
    (Word) = (LWORD) (BytePtr)[0];                      \
    (Word) <<= 8;                                       \
    (Word) |= (LWORD) (BytePtr)[1];

#define PROT_NETLWORD(LWord, BytePtr)                   \
    (LWord) = (LWORD) (BytePtr)[0];                     \
    (LWord) <<= 24;                                     \
    (LWord) |= (LWORD) (BytePtr)[1];                    \
    (LWord) <<= 16;                                     \
    (LWord) = (LWORD) (BytePtr)[2];                     \
    (LWord) <<= 8;                                      \
    (LWord) |= (LWORD) (BytePtr)[3];

VOID    ProtFree (PROT_PKT *Pkt);
BOOLEAN ProtStringNr (PROT_OBJ *Obj);
BOOLEAN ProtPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtFrame (PROT_PKT *Pkt, MAC_FRAME FAR *FrmPtr);
BOOLEAN ProtFile (PROT_PKT *Pkt, BYTE FAR *PktPtr);
BOOLEAN ProtGetField (PROT_PKT *Pkt, PROT_OBJ *Obj);

#endif

