/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipexcep.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Module with Exception Handling Functions
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#define INCL_DOSMISC
#include "vipinc.h"

PRIVAT PFN oldDivByZero;
PRIVAT PFN oldOutOfB;
PRIVAT PFN oldOverflow;
PRIVAT CONST char *exceptionTitle="Exception raised!";

PRIVAT void DivideByZero(void);
PRIVAT void OutOfBounds(void);
PRIVAT void Overflow(void);

#ifdef OS2EMX
#define VECTOR_DIVIDE_BY_ZERO 0x0000
#define VECTOR_OVERFLOW       0x0004
#define VECTOR_OUT_OF_BOUNDS  0x0005
#endif

PRIVAT void DivideByZero(void)
{
    VipMessageBox(exceptionTitle,
        "Program tried to divide a number by zero! "
        "Program will be aborted. ");
    oldDivByZero();
}


PRIVAT void OutOfBounds(void)
{   /* VECTOR_OUTOFBOUNDS      Out of bounds */
    VipMessageBox(exceptionTitle,
        "Math produced an 'out of bounds' result. Program will be aborted!");
    oldOutOfB();
}

PRIVAT void Overflow(void)
{
    VipMessageBox(exceptionTitle,
        "Math produced an overflow! Program will be aborted.");
    oldOverflow();
}

/**************************************************************
** NAME:        VipInitExceptions                         
** SYNOPSIS:    void VipInitExceptions(void)
** DESCRIPTION: Capture all exceptions and displays
**              message box.  This exception handling is not
**              bullet proof but it provides some information
**              on divideByZero, outOfBounds and overFlow
**              exceptions for debugging purposes.
** RETURNS:     void
**************************************************************/
EXPORT void VipInitExceptions(void)
{
    DosSetVec(VECTOR_DIVIDE_BY_ZERO ,(PFN)DivideByZero,&oldDivByZero);
    DosSetVec(VECTOR_OUTOFBOUNDS    ,(PFN)OutOfBounds,&oldOutOfB);
    DosSetVec(VECTOR_OVERFLOW       ,(PFN)Overflow, &oldOverflow);
}


