/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipinc.h
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       92/05/15
**
** DESCRIPTION: Internal Include file for the vip library.
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision$
** AUTHOR:   $Author$
** DATE:     $Date$
** LOG:      $Log$
*************************************************************************/
#ifndef _VIP_LIBRARY
#define _VIP_LIBRARY

#if !defined OS2 && !defined UNIX
#error You must define OS2 or UNIX!!
#endif

typedef struct _vipinfo VIPINFO;
typedef struct _vipfont VIPFONT;
typedef struct _vipkeys VIPKEYS;
typedef struct _viptimer VIPTIMER;
typedef struct _vipimage VIPIMAGE;

# define VipCookie 0xabbababeL
# define hidden
# define VipFree(p) DnpapFree(p)

/* These macros perform all kinds of tests on a window object */
/* The global BOOLEAN assert determines if extensive testing */
/* must be done */

# define NULLTEST(wip,x)     {if(!wip){VipNullError();x;}}

# define VIPTEST(wip,x)      {NULLTEST(wip,x); \
                             if(assert && (wip->magic!=VipCookie))\
                             {VipVipError();x;}}

# define TYPETEST(wip,t,x)   {NULLTEST(wip,x); \
                             if(assert && (wip->magic!=VipCookie))\
                                {VipVipError();x;}\
                             if(assert && !(wip->type&t))\
                                {VipTypeError();x;}}

# ifdef X11
#  ifdef sun 
#   define _WCHAR_T 
#  endif 
#  include <stdio.h> 
#  include <signal.h> 
#  include <stdarg.h> 
#  include <X11/Xlib.h> 
#  include <X11/Xutil.h> 
#  include <X11/Xos.h> 
#  include <X11/Xatom.h> 
#  include <X11/keysym.h> 
#  include <dnpap.h> 
#  include <config.h> 
#  include <message.h> 
   
extern Display *display;
extern int screen;
extern XFontStruct *font_info;

    struct _vipinfo {
        WINDOWT win;
        GC gc;
        int x,y,w,h;
		int flags;
        int type;
        VIPINFO *next;
        VIPINFO *parent;
        VIPINFO *sibling;
        VIPINFO *child;
        LONG (*handler) __((VIPINFO *wip, XEvent *ep));
        BOOLEAN (*adjust)  __((VIPINFO *wip, SWP *pswp));
        void (*update)  __((VIPINFO *wip, BOOLEAN flag));
        void (*destroy) __((VIPINFO *wip));
        void *data;        /* Data to be used by the different window objects */
    };

# define V_RAISED 		 0x0001

# define BLACK BlackPixel(display,screen)
# define WHITE WhitePixel(display,screen)

LONG  VipSimpleHandler(VIPINFO *wip, XEvent *ep);
void  VipSimpleUpdate(VIPINFO *wip, BOOLEAN all);
void  VipSimpleDestroy(VIPINFO *wip);
#endif


#ifdef OS2    
# define INCL_PM
# include <os2.h>
# include <process.h>
# include <stdlib.h>     
# include <stdio.h>
# include <stdarg.h>
# include <limits.h>
# include <string.h>
# include <dnpap.h>
# include <config.h> 
# include <message.h> 

#ifdef _OS2EMX_H
#define OS2EMX
#define FS   fl     /*JvO*/
#define FATTR_FONTUSE_NOMIX 0x0002
#define FATTR_FONTUSE_OUTLINE 0x0004
#define FATTR_FONTUSE_TRANSFORMABLE 0x0008
#else               /*JvO*/
#define FS   fs     /*JvO*/
#endif

typedef BOOLEAN (*VIP_CALLKEYS)   (VIPINFO  *wip, VOID *p, int value);
typedef void (*VIP_CALLBACK)(VIPINFO *wip, VOID *p, int value);
typedef void (*VIP_BUTTCALL)(VIPINFO *wip, VOID *p, BOOLEAN pressed);
typedef void (*VIP_MENUCALL)(VIPINFO *wip, VOID *p, int active);
typedef void (*VIP_SCROLLCALL)(VIPINFO *wip, VOID *p, int pos);
typedef void (*VIP_TIMEOUT)(VIPTIMER *wip, VOID *p);

# define UM_MENU_END (WM_USER+1)
# define UM_SCALE    (WM_USER+2)

#include "vipdata.h"
    
    struct _viptimer
    {
        VIPTIMER *next;
        ULONG msecs;
        ULONG alarm;
        VIP_TIMEOUT callback;
        VOID *arg;
    };

    struct _vipimage
    {
        VIPIMAGE *next;
        USHORT depth;
        LONG cx, cy;
        BYTE *data;
    };

    struct _vipfont
    {
        CONST char *face;     /* Name of font */
        SHORT     size;     /* size of font */
        SHORT     pitch;    /* Used size */
        SHORT     attr;     /* Attribute flag: bold, italic */
        SHORT     lcid;     /* Used id to create it */
        LONG      match;    /* Match ID to find font fast */
        LONG      refCount; /* Reference counting */
    };

    struct _vipinfo {
        VIPINFO *   next;
        VIPINFO *   parent;
        VIPINFO *   sibling;
        HWND        win;
        HWND        frame;
        VIPINFO *   child;
        LONG (*handler) (VIPINFO *wip, USHORT msg, MPARAM mp1, MPARAM mp2);
        BOOLEAN (*adjust) (VIPINFO *wip, SWP *pswp);
        void (*update)  (VIPINFO *wip, HPS hps, BOOLEAN flag);
        void (*destroy) (VIPINFO *wip);
        LONG        x,y,w,h;
        LONG        cx, cy;
		int         flags;
        int         type;
        LONG        colors[VIP_WCCLRS];
        VIPFONT *   font;
        char *      title;
        int         border; 
        int         btype;
        VIP_CALLBACK callback;
        VOID *       pointer;
        int          active;
        VIP_CALLBACK aboutFun;
        VIP_CALLKEYS keyHandler;
        VOID *       keyArg;
        VIPKEYS     *localKeys;
        VIPKEYS     *looseKeys;
        VIPKEYS     *globalKeys;
        struct _dialdata   *dialdata;
        struct _textdata   *textdata;
        struct _graphdata  *graphdata;
        struct _scrolldata *scrolldata;
        struct _framedata  *framedata;
        LONG magic;
    };

void    VipInitKeys(void);
LONG    VipSimpleHandler  (VIPINFO *wip, USHORT msg, MPARAM mp1, MPARAM mp2);
void    VipSimpleUpdate   (VIPINFO *wip, HPS hps, BOOLEAN all);
void    VipSimpleDestroy  (VIPINFO *wip);
VOID   *VipMalloc         (ULONG size);
void    VipString         (char **p, CONST char *str);
void    VipFree           (VOID *p);
void    VipError          (LONG ec, CONST char *msg);
void    VipBorder         (VIPINFO *wip, HPS hps);
void    VipPullMouseMoves (VOID);
void    VipDrawBorder     (VIPINFO *wip, RECTL *rect, HPS hps, int type, int width);
void    VipTypeError      (void);
void    VipNullError      (void);
void    VipVipError       (void);
void    VipSizeWindow     (VIPINFO *wip, LONG sx, LONG sy);
void    VipMoveWindow     (VIPINFO *wip, LONG sx, LONG sy);

void    VipUseFont        (HPS hps, VIPFONT *fp);
void    VipReleaseFont    (HPS hps, VIPFONT *fp);


void    VipInitFonts      (void);
VOID    VipFontInfo       (HPS hps);

void VipAdjustChild(VIPINFO *wip, LONG w, LONG h, LONG x, LONG y);

# define MOVE(a,b) {pp.x=(a);pp.y=(b);GpiMove(hps,&pp);}
# define LINE(a,b) {pp.x=(a);pp.y=(b);GpiLine(hps,&pp);}
# define BOX(a,b)  {pp.x=(a);pp.y=(b);GpiBox(hps,DRO_OUTLINE,&pp,0,0);}
# define BLOCK(a,b)  {pp.x=(a);pp.y=(b);GpiBox(hps,DRO_FILL,&pp,0,0);}
#undef SHORT1FROMMP
#undef SHORT2FROMMP
#define SHORT1FROMMP(mp) ((SHORT)(ULONG)(mp))
#define SHORT2FROMMP(mp) ((SHORT)((ULONG)mp >> 16))

#  include "viptest.h"

# define VIP_COLORS 16

IMPORT BOOLEAN assert;

# define F_VIPFRAME   0x01
# define F_KEYLOOSE   0x02
# define F_KEYFOCUS   0x04
# define F_REDRAW     0x08
# define F_ACTIVE     0x10
# define F_ICONIZED   0x20
# define QREDRAW(wip) (wip->flags&F_REDRAW)
# define SREDRAW(wip) (wip->flags|=F_REDRAW)
# define RREDRAW(wip) (wip->flags&=~F_REDRAW)

#endif /*OS2*/

#include "vip.h"

#endif /*_VIP_LIBRARY*/

