/**********************************************************************
** MODULE INFORMATION*
**********************
**      FILE     NAME:       viptrans.c
**      SYSTEM   NAME:       VIP
**      ORIGINAL AUTHOR(S):  Alfred Kayser
**      VERSION  NUMBER:     1.0
**      CREATION DATE:       91/09/16
**
** DESCRIPTION: FileDevice for VIP 
**              This module doesn't export any functions, but it
**              defines one TRANSDEVICE structures, which can be passed
**              to the TransInit and TransAddDevice functions.
***********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision:  $
** AUTHOR:   $Author:  $
** DATE:     $Date:  $
** LOG:      $Log: $
**
**********************************************************************/
#define LIBRARY
#include "vipinc.h"

PRIVAT void *VipDevOpen    __((CONST char *));
PRIVAT void  VipDevPut     __((void *, CONST char *));
PRIVAT void  VipDevFlush   __((void *));
PRIVAT void  VipDevClose   __((void *));

EXPORT TRANSDEVICE messageVipDev = { "VIP", VipDevOpen, VipDevPut, VipDevFlush, VipDevClose };

IMPORT HAB vipHab;
IMPORT HMQ vipHmq;
/*--------------------- Private Parts ----------------------------*/
PRIVAT void *
VipDevOpen(CONST char *name)
{
    int len=strlen(name)+1;
    char *title=DnpapMalloc(len);
    memcpy(title,name,len);
    return title;
}


PRIVAT void 
VipDevPut(void *name, CONST char *str)
{                   
    if (!vipHab) vipHab = WinInitialize(0);
    if (!vipHmq && vipHab) vipHmq = WinCreateMsgQueue(vipHab, 0);
    if (vipHmq) VipMessageBox((char*)name, str);
}


PRIVAT void
VipDevFlush(void *fp)
{
}

PRIVAT void
VipDevClose(void *fp)
{
}



